/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.MultipleRuntimeResponsePolicy;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.core.property.ResponseProperty;
import java.util.Enumeration;
import java.util.Vector;

public class TriggerBehavior
extends Behavior {
    public ResponseProperty triggerResponse = new ResponseProperty((Element)this, "triggerResponse", null);
    public final ObjectProperty multipleRuntimeResponsePolicy = new ObjectProperty(this, "multipleRuntimeResponsePolicy", MultipleRuntimeResponsePolicy.ENQUEUE_MULTIPLE, MultipleRuntimeResponsePolicy.class);
    private Vector m_runtimeResponses = new Vector();
    private Response.RuntimeResponse[] m_runtimeResponseArray = null;

    private Response.RuntimeResponse[] getRuntimeResponseArray() {
        if (this.m_runtimeResponseArray == null) {
            this.m_runtimeResponseArray = new Response.RuntimeResponse[this.m_runtimeResponses.size()];
            this.m_runtimeResponses.copyInto(this.m_runtimeResponseArray);
        }
        return this.m_runtimeResponseArray;
    }

    public void trigger(double time) {
        if (this.m_runtimeResponses.size() > 0 && this.multipleRuntimeResponsePolicy.getValue() == MultipleRuntimeResponsePolicy.IGNORE_MULTIPLE) {
            return;
        }
        Response response = this.triggerResponse.getResponseValue();
        if (response != null) {
            Response.RuntimeResponse runtimeResponse = response.manufactureRuntimeResponse();
            this.m_runtimeResponses.addElement(runtimeResponse);
            this.m_runtimeResponseArray = null;
        }
    }

    public void trigger() {
        this.trigger((double)System.currentTimeMillis() * 0.001);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalSchedule(double time, double dt) {
        Response.RuntimeResponse[] rra;
        MultipleRuntimeResponsePolicy mrrp = (MultipleRuntimeResponsePolicy)this.multipleRuntimeResponsePolicy.getValue();
        Response.RuntimeResponse[] runtimeResponseArray = rra = this.getRuntimeResponseArray();
        int n = 0;
        int n2 = runtimeResponseArray.length;
        while (n < n2) {
            Response.RuntimeResponse runtimeResponse = runtimeResponseArray[n];
            if (!runtimeResponse.isActive()) {
                runtimeResponse.prologue(time);
            }
            runtimeResponse.update(time);
            double timeRemaining = runtimeResponse.getTimeRemaining(time);
            if (timeRemaining <= 0.0) {
                runtimeResponse.epilogue(time);
                runtimeResponse.HACK_markForRemoval();
            } else if (mrrp != MultipleRuntimeResponsePolicy.INTERLEAVE_MULTIPLE) break;
            ++n;
        }
        if (this.m_runtimeResponses.size() > 0) {
            Vector vector = this.m_runtimeResponses;
            synchronized (vector) {
                Enumeration enu = this.m_runtimeResponses.elements();
                while (enu.hasMoreElements()) {
                    Response.RuntimeResponse runtimeResponse = (Response.RuntimeResponse)enu.nextElement();
                    if (!runtimeResponse.HACK_isMarkedForRemoval()) continue;
                    this.m_runtimeResponses.removeElement(runtimeResponse);
                    this.m_runtimeResponseArray = null;
                }
            }
        }
    }

    public void stopAllRuntimeResponses(double time) {
        Response.RuntimeResponse[] rra;
        Response.RuntimeResponse[] runtimeResponseArray = rra = this.getRuntimeResponseArray();
        int n = 0;
        int n2 = runtimeResponseArray.length;
        while (n < n2) {
            Response.RuntimeResponse runtimeResponse = runtimeResponseArray[n];
            runtimeResponse.stop(time);
            ++n;
        }
        this.m_runtimeResponses.removeAllElements();
        this.m_runtimeResponseArray = null;
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_runtimeResponses.removeAllElements();
        this.m_runtimeResponseArray = null;
    }

    public void setTriggerResponse(ResponseProperty triggerResponse) {
        this.triggerResponse = triggerResponse;
    }
}

