/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.MouseButtonIsPressedBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.question.PickQuestion;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class MouseButtonClickBehavior
extends TriggerBehavior
implements MouseListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{MouseButtonIsPressedBehavior.class};
    public final IntegerProperty requiredModifierMask = new IntegerProperty(this, "requiredModifierMask", new Integer(0));
    public final IntegerProperty excludedModifierMask = new IntegerProperty(this, "excludedModifierMask", new Integer(0));
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    public final TransformableProperty onWhat = new TransformableProperty((Element)this, "onWhat", null);
    private RenderTarget[] m_renderTargets = null;
    private MouseEvent m_pressedEvent = null;
    public long m_clickTimeThreshold = 300L;
    public int m_clickDistanceThresholdSquared = 100;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureAnyNecessaryDetails() {
        if (this.details.size() == 2) {
            PickQuestion what = new PickQuestion();
            what.name.set("what");
            what.setParent(this);
            this.details.add(what);
        }
        int i = 0;
        while (i < this.details.size()) {
            Object o = this.details.get(i);
            if (o instanceof PickQuestion) {
                ((PickQuestion)o).name.set("what");
            }
            ++i;
        }
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable x = new Variable();
        x.name.set("x");
        x.setParent(this);
        x.valueClass.set(Number.class);
        this.details.add(x);
        Variable y = new Variable();
        y.name.set("y");
        y.setParent(this);
        y.valueClass.set(Number.class);
        this.details.add(y);
        this.manufactureAnyNecessaryDetails();
    }

    private boolean checkModifierMask(InputEvent e) {
        int modifiers = e.getModifiers();
        Integer requiredModifierMaskValue = (Integer)this.requiredModifierMask.getValue();
        Integer excludedModifierMaskValue = (Integer)this.excludedModifierMask.getValue();
        int required = 0;
        if (requiredModifierMaskValue != null) {
            required = requiredModifierMaskValue;
        }
        int excluded = 0;
        if (excludedModifierMaskValue != null) {
            excluded = excludedModifierMaskValue;
        }
        return (modifiers & required) == required && (modifiers & excluded) == 0;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.m_pressedEvent = mouseEvent;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int dx = mouseEvent.getX() - this.m_pressedEvent.getX();
        int dy = mouseEvent.getY() - this.m_pressedEvent.getY();
        long dt = mouseEvent.getWhen() - this.m_pressedEvent.getWhen();
        if (dt < this.m_clickTimeThreshold && dx * dx + dy * dy < this.m_clickDistanceThresholdSquared && this.isEnabled.booleanValue() && this.checkModifierMask(mouseEvent)) {
            Transformable transformable = this.onWhat.getTransformableValue();
        }
    }

    protected void started(World world, double time) {
        super.started(world, time);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.addMouseListener(this);
            ++n;
        }
    }

    protected void stopped(World world, double time) {
        super.stopped(world, time);
        RenderTarget[] renderTargetArray = this.m_renderTargets;
        int n = 0;
        int n2 = renderTargetArray.length;
        while (n < n2) {
            RenderTarget target = renderTargetArray[n];
            target.removeMouseListener(this);
            ++n;
        }
        this.m_renderTargets = null;
    }
}

