/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotSimpleBehavior;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Scheduler;

public class OneShotUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected Object context;
    protected Response redoResponse;
    protected Response undoResponse;
    protected OneShotSimpleBehavior oneShotBehavior;
    protected Scheduler scheduler;

    public OneShotUndoableRedoable(Response redoResponse, Response undoResponse, OneShotSimpleBehavior oneShotBehavior, Scheduler scheduler) {
        this.redoResponse = redoResponse;
        this.undoResponse = undoResponse;
        this.oneShotBehavior = oneShotBehavior;
        this.scheduler = scheduler;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void undo() {
        this.oneShotBehavior.stopRunningResponse(AuthoringToolResources.getCurrentTime());
        this.oneShotBehavior.setResponse(this.undoResponse);
        this.oneShotBehavior.start(this.scheduler);
    }

    public void redo() {
        this.oneShotBehavior.stopRunningResponse(AuthoringToolResources.getCurrentTime());
        this.oneShotBehavior.setResponse(this.redoResponse);
        this.oneShotBehavior.start(this.scheduler);
    }

    public Object getAffectedObject() {
        return this;
    }

    public Object getContext() {
        return this.context;
    }

    public Response getRedoResponse() {
        return this.redoResponse;
    }

    public Response getUndoResponse() {
        return this.undoResponse;
    }

    public OneShotSimpleBehavior getOneShotBehavior() {
        return this.oneShotBehavior;
    }
}

