/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.util.Criterion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementUsageGraph
extends JPanel {
    protected Element root;
    protected Criterion elementCriterion;
    protected Criterion acceptAllCriterion = new Criterion(){

        public boolean accept(Object o) {
            return true;
        }
    };
    protected ClassNameComparator classNameComparator = new ClassNameComparator();
    protected float saturation = 0.5f;
    protected float brightness = 0.9f;
    protected HashMap classCountMap = new HashMap();
    protected GridBagConstraints labelConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
    protected GridBagConstraints barConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 8, 0), 0, 12);
    protected Random random = new Random();

    public ElementUsageGraph() {
        this.setBackground(Color.white);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public Element getRoot() {
        return this.root;
    }

    public void setElementCriterion(Criterion elementCriterion) {
        this.elementCriterion = elementCriterion;
    }

    public Criterion getElementCriterion() {
        return this.elementCriterion;
    }

    public void refresh() {
        Criterion criterion;
        this.classCountMap.clear();
        this.removeAll();
        int gridy = 0;
        Criterion criterion2 = criterion = this.elementCriterion != null ? this.elementCriterion : this.acceptAllCriterion;
        if (this.root != null) {
            Element[] elements;
            int maxCount = 0;
            Element[] elementArray = elements = this.root.search(criterion);
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Element element = elementArray[n];
                Class<?> c = element.getClass();
                if (this.classCountMap.containsKey(c)) {
                    Integer count = (Integer)this.classCountMap.get(c);
                    this.classCountMap.put(c, new Integer(count + 1));
                    maxCount = Math.max(maxCount, count + 1);
                } else {
                    this.classCountMap.put(c, new Integer(1));
                    maxCount = Math.max(maxCount, 1);
                }
                ++n;
            }
            JLabel totalLabel = new JLabel("Total: " + elements.length);
            this.barConstraints.gridy = gridy++;
            this.add((Component)totalLabel, this.barConstraints);
            ArrayList classList = new ArrayList(this.classCountMap.keySet());
            Collections.sort(classList, this.classNameComparator);
            for (Class c : classList) {
                String name = c.getName();
                name = name.substring(name.lastIndexOf(46) + 1);
                int count = (Integer)this.classCountMap.get(c);
                double portion = (double)count / (double)maxCount;
                this.random.setSeed(name.hashCode());
                Color color = Color.getHSBColor(this.random.nextFloat(), this.saturation, this.brightness);
                JLabel label = new JLabel(String.valueOf(name) + ": " + count);
                this.labelConstraints.gridy = gridy++;
                this.add((Component)label, this.labelConstraints);
                HorizontalBar bar = new HorizontalBar(portion, color);
                this.barConstraints.gridy = gridy++;
                this.add((Component)bar, this.barConstraints);
            }
        }
        this.revalidate();
        this.repaint();
    }

    protected class HorizontalBar
    extends JPanel {
        protected double portion;
        protected Color color;

        public HorizontalBar(double portion, Color color) {
            this.portion = portion;
            this.color = color;
            this.setOpaque(false);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.color);
            Dimension size = this.getSize();
            int width = size.width - 1;
            if (width > 2) {
                width = (int)Math.round(((double)width - 1.0) * this.portion);
            }
        }
    }

    protected class ClassNameComparator
    implements Comparator {
        protected ClassNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof Class && o2 instanceof Class) {
                String name1 = ((Class)o1).getName();
                name1 = name1.substring(name1.lastIndexOf(46) + 1);
                String name2 = ((Class)o2).getName();
                name2 = name2.substring(name2.lastIndexOf(46) + 1);
                return name1.compareTo(name2);
            }
            return 0;
        }
    }
}

