/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementTreeCellRenderer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;

public class ElementTreeCellEditor
extends ElementTreeCellRenderer
implements TreeCellEditor {
    protected JTextField textField;
    protected HashSet cellEditorListeners;
    protected Element element;
    protected long lastClickTime;
    protected long editDelay = 500L;

    protected synchronized void initializeIfNecessary() {
        if (this.textField == null) {
            this.textField = new JTextField();
            this.cellEditorListeners = new HashSet();
            this.elementPanel.remove(this.elementLabel);
            this.elementPanel.add((Component)this.textField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
            this.textField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    ElementTreeCellEditor.this.stopCellEditing();
                }
            });
            this.textField.addKeyListener(new KeyAdapter(){

                public void keyPressed(KeyEvent ev) {
                    if (ev.getKeyCode() == 27) {
                        ElementTreeCellEditor.this.cancelCellEditing();
                    }
                }
            });
            this.textField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent ev) {
                    if (!ev.isTemporary()) {
                        ElementTreeCellEditor.this.stopCellEditing();
                    }
                }
            });
            this.dndPanel.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent ev) {
                    ElementTreeCellEditor.this.stopCellEditing();
                }
            });
        }
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row) {
        this.initializeIfNecessary();
        if (value instanceof Element) {
            this.element = (Element)value;
            this.iconLabel.setIcon(AuthoringToolResources.getIconForValue(this.element));
            this.textField.setText(this.element.name.getStringValue());
        } else {
            AuthoringTool.showErrorDialog("Error: not an Element: " + value, null);
        }
        return this;
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this.initializeIfNecessary();
        this.cellEditorListeners.add(listener);
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this.initializeIfNecessary();
        this.cellEditorListeners.remove(listener);
    }

    public void cancelCellEditing() {
        this.initializeIfNecessary();
        this.textField.setText(this.element.name.getStringValue());
        this.fireCellEditingCancelled();
    }

    public boolean stopCellEditing() {
        this.initializeIfNecessary();
        try {
            this.element.name.set(this.textField.getText());
            this.fireCellEditingStopped();
            return true;
        }
        catch (IllegalNameValueException e) {
            DialogManager.showMessageDialog(e.getMessage(), "Error setting name", 0);
            return false;
        }
    }

    public Object getCellEditorValue() {
        this.initializeIfNecessary();
        return this.textField.getText();
    }

    public synchronized boolean isCellEditable(EventObject ev) {
        boolean isSelected = false;
        if (ev instanceof MouseEvent && ev.getSource() instanceof JTree) {
            MouseEvent mev = (MouseEvent)ev;
            JTree tree = (JTree)ev.getSource();
            int row = tree.getRowForLocation(mev.getX(), mev.getY());
            isSelected = tree.isRowSelected(row);
        }
        if (ev instanceof MouseEvent) {
            long time = System.currentTimeMillis();
            MouseEvent mev = (MouseEvent)ev;
            if (SwingUtilities.isLeftMouseButton(mev)) {
                if (mev.getClickCount() > 2) {
                    return true;
                }
                if (isSelected && time - this.lastClickTime > this.editDelay) {
                    return true;
                }
            }
            this.lastClickTime = time;
        } else if (ev == null) {
            return true;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject ev) {
        return true;
    }

    protected void fireCellEditingCancelled() {
        this.initializeIfNecessary();
        ChangeEvent ev = new ChangeEvent(this);
        Iterator iter = this.cellEditorListeners.iterator();
        while (iter.hasNext()) {
            ((CellEditorListener)iter.next()).editingCanceled(ev);
        }
    }

    protected void fireCellEditingStopped() {
        this.initializeIfNecessary();
        ChangeEvent ev = new ChangeEvent(this);
        Iterator iter = this.cellEditorListeners.iterator();
        while (iter.hasNext()) {
            ((CellEditorListener)iter.next()).editingStopped(ev);
        }
    }
}

