/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultScheduler
implements Runnable {
    private double simFPS = 0.0;
    private int simFrameCount = 0;
    private long simDT = 0L;
    private long simLastTime = 0L;
    private Set doOnceRunnables = new HashSet();
    private Set eachFrameRunnables = new HashSet();
    private Set eachFrameRunnablesMarkedForRemoval = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEachFrameRunnable(Runnable eachFrameRunnable) {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            return this.eachFrameRunnables.add(eachFrameRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEachFrameRunnable(Runnable eachFrameRunnable) {
        Set set = this.eachFrameRunnablesMarkedForRemoval;
        synchronized (set) {
            return this.eachFrameRunnablesMarkedForRemoval.add(eachFrameRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] getEachFrameRunnables() {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            Runnable[] runnables = new Runnable[this.eachFrameRunnables.size()];
            int i = 0;
            Iterator iter = this.eachFrameRunnables.iterator();
            while (iter.hasNext()) {
                runnables[i++] = (Runnable)iter.next();
            }
            return runnables;
        }
    }

    public void run() {
        this.simulateOnce();
    }

    private synchronized void simulateOnce() {
        Iterator iter = this.doOnceRunnables.iterator();
        while (iter.hasNext()) {
            Runnable runnable = (Runnable)iter.next();
            try {
                runnable.run();
            }
            catch (Throwable t) {
                System.err.println("Error during simulation:");
                t.printStackTrace();
            }
            iter.remove();
        }
        iter = this.eachFrameRunnablesMarkedForRemoval.iterator();
        while (iter.hasNext()) {
            this.eachFrameRunnables.remove(iter.next());
        }
        this.eachFrameRunnablesMarkedForRemoval.clear();
        for (Runnable runnable : this.eachFrameRunnables) {
            try {
                runnable.run();
            }
            catch (Throwable t) {
                System.err.println("Error during simulation:");
                t.printStackTrace();
            }
        }
        long time = System.currentTimeMillis();
        this.simDT += time - this.simLastTime;
        this.simLastTime = time;
        ++this.simFrameCount;
        if (this.simFrameCount == 5 || this.simDT > 500L) {
            this.simFPS = (double)this.simFrameCount / ((double)this.simDT * 0.001);
            this.simFrameCount = 0;
            this.simDT = 0L;
        }
    }

    public double getSimulationFPS() {
        return this.simFPS;
    }
}

