/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.AlicePopupMenu;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.PopupMenuUI;

public class AliceMenu
extends JMenu
implements Accessible,
MenuElement {
    private static final String uiClassID = "MenuUI";
    private AlicePopupMenu popupMenu;
    private ChangeListener menuChangeListener = null;
    private MenuEvent menuEvent = null;
    private int delay;
    private boolean receivedKeyPressed;

    public AliceMenu() {
        this("");
    }

    public AliceMenu(String s) {
        super(s);
    }

    public void updateUI() {
        this.setUI((MenuItemUI)UIManager.getUI(this));
        if (this.popupMenu != null) {
            this.popupMenu.setUI((PopupMenuUI)UIManager.getUI(this.popupMenu));
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(ButtonModel newModel) {
        ButtonModel oldModel = this.getModel();
        super.setModel(newModel);
        if (oldModel != null && this.menuChangeListener != null) {
            oldModel.removeChangeListener(this.menuChangeListener);
            this.menuChangeListener = null;
        }
        this.model = newModel;
        if (newModel != null) {
            this.menuChangeListener = this.createMenuChangeListener();
            newModel.addChangeListener(this.menuChangeListener);
        }
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setSelected(boolean b) {
        ButtonModel model = this.getModel();
        boolean oldValue = model.isSelected();
        if (this.accessibleContext != null && oldValue != b) {
            if (b) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
            } else {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
            }
        }
        if (b != model.isSelected()) {
            this.getModel().setSelected(b);
        }
    }

    public boolean isPopupMenuVisible() {
        this.ensurePopupMenuCreated();
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean b) {
        if (!this.isEnabled()) {
            return;
        }
        boolean isVisible = this.isPopupMenuVisible();
        if (b != isVisible) {
            this.ensurePopupMenuCreated();
            if (b && this.isShowing()) {
                Point p = this.getPopupMenuOrigin();
                this.getPopupMenu().show(this, p.x, p.y);
            } else {
                this.getPopupMenu().setVisible(false);
            }
        }
    }

    protected Point getPopupMenuOrigin() {
        int x = 0;
        int y = 0;
        JPopupMenu pm = this.getPopupMenu();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.height -= 28;
        Dimension s = this.getSize();
        Dimension pmSize = pm.getSize();
        if (pmSize.width == 0) {
            pmSize = pm.getPreferredSize();
        }
        Point position = this.getLocationOnScreen();
        Container parent = this.getParent();
        if (parent instanceof JPopupMenu) {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + s.width + pmSize.width < screenSize.width ? s.width : 0 - pmSize.width) : (position.x < pmSize.width ? s.width : 0 - pmSize.width);
            y = position.y + pmSize.height < screenSize.height ? 0 : s.height - pmSize.height;
        } else {
            x = this.getComponentOrientation().isLeftToRight() ? (position.x + pmSize.width < screenSize.width ? 0 : s.width - pmSize.width) : (position.x + s.width < pmSize.width ? 0 : s.width - pmSize.width);
            y = position.y + s.height + pmSize.height < screenSize.height ? s.height : 0 - pmSize.height;
        }
        return new Point(x, y);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int d) {
        if (d < 0) {
            throw new IllegalArgumentException("Delay must be a positive integer");
        }
        this.delay = d;
    }

    private void ensurePopupMenuCreated() {
        if (this.popupMenu == null) {
            this.popupMenu = new AlicePopupMenu();
            this.popupMenu.setInvoker(this);
            this.popupListener = this.createWinListener(this.popupMenu);
            this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                public void popupMenuCanceled(PopupMenuEvent e) {
                    AliceMenu.this.fireMenuCanceled();
                }
            });
        }
    }

    public void setMenuLocation(int x, int y) {
        if (this.popupMenu != null) {
            this.popupMenu.setLocation(x, y);
        }
    }

    public JMenuItem add(JMenuItem menuItem) {
        AccessibleContext ac = menuItem.getAccessibleContext();
        ac.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        return this.popupMenu.add(menuItem);
    }

    public Component add(Component c) {
        AccessibleContext ac;
        if (c instanceof JComponent && (ac = ((JComponent)c).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c);
        return c;
    }

    public Component add(Component c, int index) {
        AccessibleContext ac;
        if (c instanceof JComponent && (ac = ((JComponent)c).getAccessibleContext()) != null) {
            ac.setAccessibleParent(this);
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.add(c, index);
        return c;
    }

    public JMenuItem add(String s) {
        return this.add(new JMenuItem(s));
    }

    public JMenuItem add(Action a) {
        JMenuItem mi = this.createActionComponent(a);
        mi.setAction(a);
        this.add(mi);
        return mi;
    }

    protected JMenuItem createActionComponent(Action a) {
        JMenuItem mi = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon")){

            protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
                PropertyChangeListener pcl = AliceMenu.this.createActionChangeListener(this);
                if (pcl == null) {
                    pcl = super.createActionPropertyChangeListener(a);
                }
                return pcl;
            }
        };
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        return mi;
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    public void addSeparator() {
        this.ensurePopupMenuCreated();
        this.popupMenu.addSeparator();
    }

    public void insert(String s, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JMenuItem(s), pos);
    }

    public JMenuItem insert(JMenuItem mi, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        AccessibleContext ac = mi.getAccessibleContext();
        ac.setAccessibleParent(this);
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    public JMenuItem insert(Action a, int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        JMenuItem mi = new JMenuItem((String)a.getValue("Name"), (Icon)a.getValue("SmallIcon"));
        mi.setHorizontalTextPosition(4);
        mi.setVerticalTextPosition(0);
        mi.setEnabled(a.isEnabled());
        mi.setAction(a);
        this.popupMenu.insert(mi, pos);
        return mi;
    }

    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        this.ensurePopupMenuCreated();
        this.popupMenu.insert(new JPopupMenu.Separator(), index);
    }

    public JMenuItem getItem(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        Component c = this.getMenuComponent(pos);
        if (c instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)c;
            return mi;
        }
        return null;
    }

    public int getItemCount() {
        return this.getMenuComponentCount();
    }

    public boolean isTearOff() {
        throw new Error("boolean isTearOff() {} not yet implemented");
    }

    public void remove(JMenuItem item) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(item);
        }
    }

    public void remove(int pos) {
        if (pos < 0) {
            throw new IllegalArgumentException("index less than zero.");
        }
        if (pos > this.getItemCount()) {
            throw new IllegalArgumentException("index greater than the number of items.");
        }
        if (this.popupMenu != null) {
            this.popupMenu.remove(pos);
        }
    }

    public void remove(Component c) {
        if (this.popupMenu != null) {
            this.popupMenu.remove(c);
        }
    }

    public void removeAll() {
        if (this.popupMenu != null) {
            this.popupMenu.removeAll();
        }
    }

    public int getMenuComponentCount() {
        int componentCount = 0;
        if (this.popupMenu != null) {
            componentCount = this.popupMenu.getComponentCount();
        }
        return componentCount;
    }

    public Component getMenuComponent(int n) {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponent(n);
        }
        return null;
    }

    public Component[] getMenuComponents() {
        if (this.popupMenu != null) {
            return this.popupMenu.getComponents();
        }
        return new Component[0];
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component c) {
        JPopupMenu comp;
        if (c == this) {
            return true;
        }
        if (c instanceof JPopupMenu && (comp = (JPopupMenu)c) == this.getPopupMenu()) {
            return true;
        }
        int ncomponents = this.getMenuComponentCount();
        Component[] component = this.getMenuComponents();
        int i = 0;
        while (i < ncomponents) {
            AliceMenu subMenu;
            Component comp2 = component[i];
            if (comp2 == c) {
                return true;
            }
            if (comp2 instanceof AliceMenu && (subMenu = (AliceMenu)comp2).isMenuComponent(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public JPopupMenu getPopupMenu() {
        this.ensurePopupMenuCreated();
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener l) {
        this.listenerList.add(MenuListener.class, l);
    }

    public void removeMenuListener(MenuListener l) {
        this.listenerList.remove(MenuListener.class, l);
    }

    protected void fireMenuSelected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuSelected(this.menuEvent);
            }
            i -= 2;
        }
    }

    protected void fireMenuDeselected() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuDeselected(this.menuEvent);
            }
            i -= 2;
        }
    }

    protected void fireMenuCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == MenuListener.class) {
                if (listeners[i + 1] == null) {
                    throw new Error(String.valueOf(this.getText()) + " has a NULL Listener!! " + i);
                }
                if (this.menuEvent == null) {
                    this.menuEvent = new MenuEvent(this);
                }
                ((MenuListener)listeners[i + 1]).menuCanceled(this.menuEvent);
            }
            i -= 2;
        }
    }

    private ChangeListener createMenuChangeListener() {
        return new MenuChangeListener();
    }

    protected JMenu.WinListener createWinListener(JPopupMenu p) {
        return new JMenu.WinListener(this, p);
    }

    public void menuSelectionChanged(boolean isIncluded) {
        this.setSelected(isIncluded);
    }

    public MenuElement[] getSubElements() {
        if (this.popupMenu == null) {
            return new MenuElement[0];
        }
        MenuElement[] result = new MenuElement[]{this.popupMenu};
        return result;
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keyStroke) {
        throw new Error("setAccelerator() is not defined for AliceMenu.  Use setMnemonic() instead.");
    }

    protected void processFocusEvent(FocusEvent e) {
        switch (e.getID()) {
            case 1005: {
                this.receivedKeyPressed = false;
                break;
            }
        }
        super.processFocusEvent(e);
    }

    protected void processKeyEvent(KeyEvent e) {
        boolean createMenuEvent = false;
        switch (e.getID()) {
            case 401: {
                if (this.isSelected()) {
                    this.receivedKeyPressed = true;
                    createMenuEvent = true;
                    break;
                }
                this.receivedKeyPressed = false;
                break;
            }
            case 402: {
                if (!this.receivedKeyPressed) break;
                this.receivedKeyPressed = false;
                createMenuEvent = true;
                break;
            }
            default: {
                createMenuEvent = this.receivedKeyPressed;
            }
        }
        if (createMenuEvent) {
            MenuSelectionManager.defaultManager().processKeyEvent(e);
        }
        if (e.isConsumed()) {
            return;
        }
        if (this.isSelected() && (e.getKeyCode() == 9 || e.getKeyChar() == '\t')) {
            if ((Boolean)UIManager.get("Menu.consumesTabs") == Boolean.TRUE) {
                e.consume();
                return;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
        }
        super.processKeyEvent(e);
    }

    public void doClick(int pressTime) {
        MenuElement[] me = this.buildMenuElementArray(this);
        MenuSelectionManager.defaultManager().setSelectedPath(me);
    }

    private MenuElement[] buildMenuElementArray(AliceMenu leaf) {
        Vector<JComponent> elements = new Vector<JComponent>();
        Component current = leaf.getPopupMenu();
        while (true) {
            if (current instanceof JPopupMenu) {
                JPopupMenu pop = current;
                elements.insertElementAt(pop, 0);
                current = pop.getInvoker();
                continue;
            }
            if (current instanceof AliceMenu) {
                AliceMenu menu = (AliceMenu)current;
                elements.insertElementAt(menu, 0);
                current = menu.getParent();
                continue;
            }
            if (current instanceof JMenuBar) break;
        }
        JMenuBar bar = (JMenuBar)current;
        elements.insertElementAt(bar, 0);
        Object[] me = new MenuElement[elements.size()];
        elements.copyInto(me);
        return me;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected String paramString() {
        return super.paramString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu();
        }
        return this.accessibleContext;
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.setTarget(mi);
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            } else if (e.getPropertyName().equals("SmallIcon")) {
                Icon icon = (Icon)e.getNewValue();
                this.menuItem.setIcon(icon);
                this.menuItem.invalidate();
                this.menuItem.repaint();
            }
        }

        public void setTarget(JMenuItem b) {
            this.menuItem = b;
        }
    }

    class MenuChangeListener
    implements ChangeListener,
    Serializable {
        boolean isSelected = false;

        MenuChangeListener() {
        }

        public void stateChanged(ChangeEvent e) {
            ButtonModel model = (ButtonModel)e.getSource();
            boolean modelSelected = model.isSelected();
            if (modelSelected != this.isSelected) {
                if (modelSelected) {
                    AliceMenu.this.fireMenuSelected();
                } else {
                    AliceMenu.this.fireMenuDeselected();
                }
                this.isSelected = modelSelected;
            }
        }
    }

    protected class AccessibleJMenu
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener,
    AccessibleSelection {
        public AccessibleJMenu() {
            super(AliceMenu.this);
            AliceMenu.this.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent e) {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public int getAccessibleChildrenCount() {
            Component[] children = AliceMenu.this.getMenuComponents();
            int count = 0;
            Component[] componentArray = children;
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component element = componentArray[n];
                if (element instanceof Accessible) {
                    ++count;
                }
                ++n;
            }
            return count;
        }

        public Accessible getAccessibleChild(int i) {
            Component[] children = AliceMenu.this.getMenuComponents();
            int count = 0;
            Component[] componentArray = children;
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component element = componentArray[n];
                if (element instanceof Accessible) {
                    if (count == i) {
                        if (element instanceof JComponent) {
                            AccessibleContext ac = ((Accessible)((Object)element)).getAccessibleContext();
                            ac.setAccessibleParent(AliceMenu.this);
                        }
                        return (Accessible)((Object)element);
                    }
                    ++count;
                }
                ++n;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                int i = 0;
                while (i < me.length) {
                    if (me[i] == AliceMenu.this && i + 1 < me.length) {
                        return 1;
                    }
                    ++i;
                }
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return null;
            }
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                int j = 0;
                while (j < me.length) {
                    if (me[j] == AliceMenu.this) {
                        while (++j < me.length) {
                            if (!(me[j] instanceof JMenuItem)) continue;
                            return (Accessible)((Object)me[j]);
                        }
                    }
                    ++j;
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int i) {
            MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
            if (me != null) {
                JMenuItem mi = AliceMenu.this.getItem(i);
                MenuElement[] menuElementArray = me;
                int n = 0;
                int n2 = menuElementArray.length;
                while (n < n2) {
                    MenuElement element = menuElementArray[n];
                    if (element == mi) {
                        return true;
                    }
                    ++n;
                }
            }
            return false;
        }

        public void addAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem mi = AliceMenu.this.getItem(i);
            if (mi != null) {
                if (mi instanceof AliceMenu) {
                    MenuElement[] me = AliceMenu.this.buildMenuElementArray((AliceMenu)mi);
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                } else {
                    mi.doClick();
                    MenuSelectionManager.defaultManager().setSelectedPath(null);
                }
            }
        }

        public void removeAccessibleSelection(int i) {
            if (i < 0 || i >= AliceMenu.this.getItemCount()) {
                return;
            }
            JMenuItem mi = AliceMenu.this.getItem(i);
            if (mi != null && mi instanceof AliceMenu && ((AliceMenu)mi).isSelected()) {
                MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
                MenuElement[] me = new MenuElement[old.length - 2];
                int j = 0;
                while (j < old.length - 2) {
                    me[j] = old[j];
                    ++j;
                }
                MenuSelectionManager.defaultManager().setSelectedPath(me);
            }
        }

        public void clearAccessibleSelection() {
            MenuElement[] old = MenuSelectionManager.defaultManager().getSelectedPath();
            if (old != null) {
                int j = 0;
                while (j < old.length) {
                    if (old[j] == AliceMenu.this) {
                        MenuElement[] me = new MenuElement[j + 1];
                        System.arraycopy(old, 0, me, 0, j);
                        me[j] = AliceMenu.this.getPopupMenu();
                        MenuSelectionManager.defaultManager().setSelectedPath(me);
                    }
                    ++j;
                }
            }
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

