/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CommonMathQuestionsTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.MainCompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.MainCompositeResponsePanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.MainParallelResponsePanel;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.MainSequentialResponsePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.ResponsePrototype;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.response.Comment;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.alice.core.response.Print;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.Wait;
import edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ResponseEditor
extends CompositeElementEditor {
    public final String editorName = "Response Editor";
    protected DnDGroupingPanel doIfTruePrototype;
    protected DnDGroupingPanel loopPrototype;
    protected JComponent waitPrototype;
    protected DnDGroupingPanel sequentialLoopPrototype;
    protected DnDGroupingPanel loopIfTruePrototype;
    protected DnDGroupingPanel commentPrototype;
    protected JComponent printPrototype;
    protected DnDGroupingPanel mathPrototype;

    public void setObject(UserDefinedResponse toEdit) {
        this.clearAllListening();
        this.elementBeingEdited = toEdit;
        this.updateGui();
    }

    protected Color getEditorColor() {
        return AuthoringToolResources.getColor("userDefinedResponseEditor");
    }

    protected MainCompositeElementPanel createElementTree(Element selected) {
        if (selected instanceof CompositeResponse) {
            MainCompositeResponsePanel toReturn = null;
            if (selected instanceof DoInOrder) {
                toReturn = new MainSequentialResponsePanel();
                toReturn.set(selected, this.authoringTool);
            } else if (selected instanceof DoTogether) {
                toReturn = new MainParallelResponsePanel();
                toReturn.set(selected, this.authoringTool);
            }
            return toReturn;
        }
        return null;
    }

    protected void initPrototypes() {
        String doIfTrueString = AuthoringToolResources.getReprForValue(IfElseInOrder.class);
        String loopString = AuthoringToolResources.getReprForValue(LoopNInOrder.class);
        String loopIfTrueString = AuthoringToolResources.getReprForValue(WhileLoopInOrder.class);
        String sequentialLoopString = AuthoringToolResources.getReprForValue(ForEachInOrder.class);
        String commentString = AuthoringToolResources.getReprForValue(Comment.class);
        String mathString = AuthoringToolResources.getReprForValue("+ - * /");
        Color COUNT_LOOP_COLOR = AuthoringToolResources.getColor("LoopNInOrder");
        Color DO_IF_COLOR = AuthoringToolResources.getColor("IfElseInOrder");
        Color SEQUENTIAL_LOOP_COLOR = AuthoringToolResources.getColor("ForEachInOrder");
        Color COMMENT_COLOR = AuthoringToolResources.getColor("Comment");
        Color COMMENT_FOREGROUND = AuthoringToolResources.getColor("commentForeground");
        Color DO_WHILE_COLOR = AuthoringToolResources.getColor("WhileLoopInOrder");
        Color MATH_COLOR = AuthoringToolResources.getColor("question");
        this.doIfTruePrototype = new DnDGroupingPanel();
        this.doIfTruePrototype.setBackground(DO_IF_COLOR);
        JLabel DITLabel = new JLabel(doIfTrueString);
        this.doIfTruePrototype.add((Component)DITLabel, "Center");
        String[] DITdesired = new String[]{"condition"};
        this.doIfTruePrototype.setTransferable(new ResponsePrototypeReferenceTransferable(new ResponsePrototype(IfElseInOrder.class, null, DITdesired)));
        this.doIfTruePrototype.addDragSourceComponent(DITLabel);
        String[] CLdesired = new String[]{"end"};
        this.loopPrototype = new DnDGroupingPanel();
        this.loopPrototype.setBackground(COUNT_LOOP_COLOR);
        JLabel LLabel = new JLabel(loopString);
        this.loopPrototype.add((Component)LLabel, "Center");
        this.loopPrototype.setTransferable(new ResponsePrototypeReferenceTransferable(new ResponsePrototype(LoopNInOrder.class, null, CLdesired)));
        this.loopPrototype.addDragSourceComponent(LLabel);
        String[] LITdesired = new String[]{"condition"};
        this.loopIfTruePrototype = new DnDGroupingPanel();
        this.loopIfTruePrototype.setBackground(DO_WHILE_COLOR);
        JLabel LITLabel = new JLabel(loopIfTrueString);
        this.loopIfTruePrototype.add((Component)LITLabel, "Center");
        this.loopIfTruePrototype.setTransferable(new ResponsePrototypeReferenceTransferable(new ResponsePrototype(WhileLoopInOrder.class, null, LITdesired)));
        this.loopIfTruePrototype.addDragSourceComponent(LITLabel);
        String[] SLdesired = new String[]{"list"};
        this.sequentialLoopPrototype = new DnDGroupingPanel();
        this.sequentialLoopPrototype.setBackground(SEQUENTIAL_LOOP_COLOR);
        JLabel SLLabel = new JLabel(sequentialLoopString);
        this.sequentialLoopPrototype.add((Component)SLLabel, "Center");
        this.sequentialLoopPrototype.setTransferable(new ResponsePrototypeReferenceTransferable(new ResponsePrototype(ForEachInOrder.class, null, SLdesired)));
        this.sequentialLoopPrototype.addDragSourceComponent(SLLabel);
        String[] Wdesired = new String[]{"duration"};
        this.waitPrototype = GUIFactory.getGUI(new ResponsePrototype(Wait.class, null, Wdesired));
        StringObjectPair[] Cknown = new StringObjectPair[]{new StringObjectPair("text", "No comment")};
        this.commentPrototype = new DnDGroupingPanel();
        this.commentPrototype.setBackground(COMMENT_COLOR);
        JLabel commentLabel = new JLabel(commentString);
        commentLabel.setForeground(COMMENT_FOREGROUND);
        this.commentPrototype.add((Component)commentLabel, "Center");
        this.commentPrototype.setTransferable(new ResponsePrototypeReferenceTransferable(new ResponsePrototype(Comment.class, Cknown, null)));
        this.commentPrototype.addDragSourceComponent(commentLabel);
        this.printPrototype = GUIFactory.getGUI(new ResponsePrototype(Print.class, null, null));
        this.mathPrototype = new DnDGroupingPanel();
        this.mathPrototype.setBackground(MATH_COLOR);
        JLabel mathLabel = new JLabel(mathString);
        int fontSize = 12;
        mathLabel.setFont(new Font("Monospaced", 1, (int)(12.0 * ((double)fontSize / 12.0))));
        this.mathPrototype.add((Component)mathLabel, "Center");
        this.mathPrototype.setTransferable(new CommonMathQuestionsTransferable());
        this.mathPrototype.addDragSourceComponent(mathLabel);
    }

    protected void addPrototypes(Container prototypeContainer) {
        prototypeContainer.add(this.doIfTruePrototype);
        prototypeContainer.add(this.loopPrototype);
        prototypeContainer.add(this.loopIfTruePrototype);
        prototypeContainer.add(this.sequentialLoopPrototype);
        prototypeContainer.add(Box.createHorizontalStrut(10));
        prototypeContainer.add(this.waitPrototype);
        prototypeContainer.add(this.printPrototype);
        prototypeContainer.add(this.commentPrototype);
        Component buttonGlue = Box.createHorizontalGlue();
        prototypeContainer.add(buttonGlue);
    }
}

