/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.progress.ProgressPane;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;

public class StoreElementProgressPane
extends ProgressPane {
    private Element m_element;
    private File m_file;
    private Dictionary m_filnameToByteArrayMap;
    private boolean m_wasSuccessful = false;

    public StoreElementProgressPane(String title, String preDescription) {
        super(title, preDescription);
    }

    public boolean wasSuccessful() {
        return this.m_wasSuccessful;
    }

    protected void construct() throws ProgressCancelException {
        this.m_wasSuccessful = false;
        try {
            this.m_element.store(this.m_file, (ProgressObserver)this, this.m_filnameToByteArrayMap);
            this.m_wasSuccessful = true;
        }
        catch (ProgressCancelException pce) {
            throw pce;
        }
        catch (Throwable t) {
            StringBuffer sb = new StringBuffer();
            sb.append("An error has occurred while attempting to save your world.\n");
            sb.append("This is a critical situation that needs to be dealt with immediately.\n\n");
            if (t instanceof IOException) {
                sb.append("This may be the result of not having enough space on the target drive.\n");
                sb.append("If possible,\n    attempt to save your world to a different drive, or\n    free up some space and \"Save As\" to a different file.\n\n");
                sb.append("NOTE: If unsuccessful, please");
            } else {
                sb.append("NOTE: Please");
            }
            sb.append(" check for a directory co-located with \nyour world named \"Backups of <YourWorldNameHere>\" which \nshould contain previously saved versions of your world.\n");
            sb.append("\nWe at the Alice Team apologize for any work you have lost and \nimplore you to PLEASE SUBMIT THIS BUG REPORT.\n");
            sb.append("Attaching your world along with recounting any steps you performed \nsince your last successful save would be incredibly valuable to us.\n");
            sb.append("\nPlease accept our sincerest apologies.  The Alice Team.");
            AuthoringTool.showSaveErrorDialog(sb.toString(), t);
        }
    }

    public void setElement(Element element) {
        this.m_element = element;
    }

    public void setFile(File file) {
        this.m_file = file;
    }

    public void setFilnameToByteArrayMap(Dictionary filnameToByteArrayMap) {
        this.m_filnameToByteArrayMap = filnameToByteArrayMap;
    }
}

