/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.datatransfer;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class CopyFactoryTransferable
implements Transferable {
    public static DataFlavor copyFactoryFlavor = AuthoringToolResources.getReferenceFlavorForClass(CopyFactory.class);
    protected CopyFactory copyFactory;
    protected DataFlavor myFlavor;
    protected DataFlavor[] flavors;

    public CopyFactoryTransferable(CopyFactory copyFactory) {
        this.copyFactory = copyFactory;
        try {
            this.myFlavor = AuthoringToolResources.getReferenceFlavorForClass(CopyFactory.class);
            this.myFlavor.setHumanPresentableName("copyFactoryTransferable(" + copyFactory.getValueClass().getName() + ")");
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog(e.getMessage(), e);
        }
        this.flavors = new DataFlavor[2];
        this.flavors[0] = this.myFlavor;
        this.flavors[1] = DataFlavor.stringFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] dataFlavorArray = this.flavors;
        int n = 0;
        int n2 = dataFlavorArray.length;
        while (n < n2) {
            DataFlavor flavor2 = dataFlavorArray[n];
            if (flavor.equals(flavor2)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.getRepresentationClass().equals(CopyFactory.class)) {
            return this.copyFactory;
        }
        if (flavor.equals(DataFlavor.stringFlavor)) {
            return this.copyFactory.toString();
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

