/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.util.IndexedTriangleArrayCounter;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

public class StatusBar
extends JPanel
implements AuthoringToolStateListener {
    Border border1;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JPanel worldStatsPanel = new JPanel();
    JLabel worldStatsLabel = new JLabel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel objectCountLabel = new JLabel();
    JLabel faceCountLabel = new JLabel();
    Component filler1;
    Border border2;

    public StatusBar(AuthoringTool authoringTool) {
        this.jbInit();
        authoringTool.addAuthoringToolStateListener(this);
    }

    public void worldLoaded(AuthoringToolStateChangedEvent ev) {
        this.updateWorldStats(ev.getWorld());
    }

    public void worldUnLoaded(AuthoringToolStateChangedEvent ev) {
        this.updateWorldStats(null);
    }

    public void stateChanging(AuthoringToolStateChangedEvent ev) {
    }

    public void worldLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldUnLoading(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarting(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopping(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPausing(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaving(AuthoringToolStateChangedEvent ev) {
    }

    public void stateChanged(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStarted(AuthoringToolStateChangedEvent ev) {
    }

    public void worldStopped(AuthoringToolStateChangedEvent ev) {
    }

    public void worldPaused(AuthoringToolStateChangedEvent ev) {
    }

    public void worldSaved(AuthoringToolStateChangedEvent ev) {
    }

    private void updateWorldStats(World world) {
        if (world != null) {
            IndexedTriangleArrayCounter itaCounter = new IndexedTriangleArrayCounter();
            world.visit(itaCounter, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
        } else {
            this.objectCountLabel.setText("object count: 0");
            this.faceCountLabel.setText("face count: 0");
        }
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.filler1 = Box.createGlue();
        this.border2 = BorderFactory.createBevelBorder(1, Color.white, Color.white, new Color(142, 142, 142), new Color(99, 99, 99));
        this.setBackground(new Color(204, 204, 204));
        this.setBorder(this.border1);
        this.setLayout(this.gridBagLayout1);
        this.worldStatsLabel.setText("Statistics:");
        this.worldStatsPanel.setLayout(this.gridBagLayout2);
        this.objectCountLabel.setBackground(new Color(0, 204, 0));
        this.objectCountLabel.setForeground(Color.black);
        this.objectCountLabel.setOpaque(true);
        this.objectCountLabel.setHorizontalAlignment(0);
        this.objectCountLabel.setHorizontalTextPosition(0);
        this.objectCountLabel.setText("object count:");
        this.faceCountLabel.setBackground(new Color(0, 204, 0));
        this.faceCountLabel.setForeground(Color.black);
        this.faceCountLabel.setOpaque(true);
        this.faceCountLabel.setHorizontalAlignment(0);
        this.faceCountLabel.setHorizontalTextPosition(0);
        this.faceCountLabel.setText("face count:");
        this.worldStatsPanel.setBorder(this.border2);
        this.add((Component)this.worldStatsPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 4));
        this.worldStatsPanel.add((Component)this.worldStatsLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 6), 0, 0));
        this.worldStatsPanel.add((Component)this.objectCountLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 10, 0));
        this.worldStatsPanel.add((Component)this.faceCountLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 6), 10, 0));
        this.worldStatsPanel.add(this.filler1, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }
}

