/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.util;

import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.event.ScheduleEvent;
import edu.cmu.cs.stage3.alice.core.event.ScheduleListener;

public class OneShot
implements ScheduleListener {
    private Response m_response;
    private Response.RuntimeResponse m_runtimeResponse;
    private Scheduler m_scheduler;

    public Response getResponse() {
        return this.m_response;
    }

    public void setResponse(Response response) {
        this.m_response = response;
    }

    public void stopRunningResponse(double time) {
        if (this.m_runtimeResponse != null) {
            this.m_runtimeResponse.stop(time);
            this.m_runtimeResponse = null;
        }
    }

    public void scheduled(ScheduleEvent scheduleEvent) {
        boolean done;
        double t = scheduleEvent.getTime();
        if (this.m_response == null) {
            done = true;
        } else {
            if (this.m_runtimeResponse == null) {
                this.m_runtimeResponse = this.m_response.manufactureRuntimeResponse();
                this.m_runtimeResponse.prologue(t);
            }
            this.m_runtimeResponse.update(t);
            double timeRemaining = this.m_runtimeResponse.getTimeRemaining(t);
            boolean bl = done = timeRemaining <= 0.0;
            if (done) {
                this.m_runtimeResponse.epilogue(t);
                this.m_runtimeResponse = null;
            }
        }
        if (done && this.m_scheduler != null) {
            this.m_scheduler.removeScheduleListener(this);
        }
    }

    public void start(Scheduler scheduler) {
        this.m_scheduler = scheduler;
        this.m_scheduler.addScheduleListener(this);
    }
}

