/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.reference;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceResolver;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.util.Criterion;

public class DefaultReferenceResolver
implements ReferenceResolver {
    private Element m_internalRoot;
    private Element m_externalRoot;

    public DefaultReferenceResolver(Element internalRoot, Element externalRoot) {
        this.m_internalRoot = internalRoot;
        this.m_externalRoot = externalRoot;
    }

    public Element getInternalRoot() {
        return this.m_internalRoot;
    }

    public void setInternalRoot(Element internalRoot) {
        this.m_internalRoot = internalRoot;
    }

    public Element getExternalRoot() {
        return this.m_externalRoot;
    }

    public void setExternalRoot(Element externalRoot) {
        this.m_externalRoot = externalRoot;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element resolveReference(Criterion criterion) throws UnresolvableReferenceException {
        if (!(criterion instanceof ElementKeyedCriterion)) throw new UnresolvableReferenceException(criterion, "must be ElementKeyedCriterion");
        String key = ((ElementKeyedCriterion)criterion).getKey();
        Element resolved = null;
        if (criterion instanceof InternalReferenceKeyedCriterion) {
            resolved = this.m_internalRoot.getDescendantKeyedIgnoreCase(key);
        } else if (criterion instanceof ExternalReferenceKeyedCriterion) {
            if (this.m_externalRoot == null) throw new UnresolvableReferenceException(criterion, "external root is null");
            resolved = this.m_externalRoot.getDescendantKeyedIgnoreCase(key);
        } else {
            Element root = this.m_externalRoot != null ? this.m_externalRoot : this.m_internalRoot;
            int index = key.indexOf(46);
            String trimmedKey = index == -1 ? "" : key.substring(index + 1);
            resolved = root.getDescendantKeyedIgnoreCase(trimmedKey);
        }
        if (resolved == null) throw new UnresolvableReferenceException(criterion, "internal root: " + this.m_internalRoot + " external root: " + this.m_externalRoot);
        return resolved;
    }
}

