/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.event.MessageEvent;
import edu.cmu.cs.stage3.alice.core.event.MessageListener;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.alice.scripting.Interpreter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class World
extends ReferenceFrame {
    private static boolean HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
    private Vector m_capsulePropertyValuePairs = new Vector();
    private Hashtable m_capsuleElements = new Hashtable();
    private Interpreter m_interpreter;
    private Vector m_messageListeners = new Vector();
    private MessageListener[] m_messageListenerArray = null;
    private Sandbox m_currentSandbox = null;
    private Clock m_clock = null;
    private boolean m_isRunning = false;

    static {
        try {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = Boolean.getBoolean("alice.isPropetryListeningDisabledWhileWorldIsRunning");
        }
        catch (Throwable t) {
            HACK_s_isPropetryListeningDisabledWhileWorldIsRunning = false;
        }
    }

    public Clock getClock() {
        return this.m_clock;
    }

    public void setClock(Clock clock) {
        this.m_clock = clock;
    }

    private Interpreter getInterpreter() {
        return this.m_interpreter;
    }

    public Code compile(Object source, CompileType compileType) {
        return this.getInterpreter().compile(source, compileType);
    }

    public Object eval(Code code) {
        return this.getInterpreter().eval(code);
    }

    public void exec(Code code) {
        this.getInterpreter().exec(code);
    }

    protected void internalRelease(int pass) {
    }

    protected void nameValueChanged(String value) {
    }

    protected void propertyChanged(Property property, Object value) {
    }

    public void sendMessage(Element source, String message, Transformable fromWho, Transformable toWhom, long when) {
        MessageEvent messageEvent = new MessageEvent(source, message, fromWho, toWhom, when);
        int i = 0;
        while (i < this.m_messageListeners.size()) {
            MessageListener messageListener = (MessageListener)this.m_messageListeners.elementAt(i);
            messageListener.messageSent(messageEvent);
            ++i;
        }
    }

    public void addMessageListener(MessageListener messageListener) {
        this.m_messageListeners.addElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public void removeMessageListener(MessageListener messageListener) {
        this.m_messageListeners.removeElement(messageListener);
        this.m_messageListenerArray = null;
    }

    public MessageListener[] getMessageListeners() {
        if (this.m_messageListenerArray == null) {
            this.m_messageListenerArray = new MessageListener[this.m_messageListeners.size()];
            this.m_messageListeners.copyInto(this.m_messageListenerArray);
        }
        return this.m_messageListenerArray;
    }

    public void preserve() {
        Element[] elements;
        this.m_capsulePropertyValuePairs.clear();
        this.m_capsuleElements.clear();
        Element[] elementArray = elements = this.getDescendants();
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Property[] properties;
            Element element = elementArray[n];
            this.m_capsuleElements.put(element, Boolean.TRUE);
            Property[] propertyArray = properties = element.getProperties();
            int n3 = 0;
            int n4 = propertyArray.length;
            while (n3 < n4) {
                Property property = propertyArray[n3];
                Object[] tuple = new Object[]{property, property.get()};
                this.m_capsulePropertyValuePairs.addElement(tuple);
                ++n3;
            }
            ++n;
        }
    }

    public void restore() {
        Element element;
        Element[] elements;
        Enumeration preserves = this.m_capsulePropertyValuePairs.elements();
        while (preserves.hasMoreElements()) {
            Object[] tuple = (Object[])preserves.nextElement();
            Property property = (Property)tuple[0];
            Object value = tuple[1];
            property.set(value);
        }
        Element[] elementArray = elements = this.getDescendants();
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            element = elementArray[n];
            if (this.m_capsuleElements.get(element) == null) {
                element.removeFromParent();
            }
            ++n;
        }
        elementArray = elements;
        n = 0;
        n2 = elementArray.length;
        while (n < n2) {
            element = elementArray[n];
            if (this.m_capsuleElements.get(element) == null) {
                element.release();
            }
            ++n;
        }
    }

    public Sandbox getCurrentSandbox() {
        return this.m_currentSandbox;
    }

    public boolean isRunning() {
        return this.m_isRunning;
    }

    public void start() {
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_disableListening();
        }
        this.started(this, this.m_clock.getTime());
        this.m_isRunning = true;
    }

    public void schedule() {
        this.m_currentSandbox = this;
        this.scheduleBehaviors(this.m_clock.getTime());
        this.m_currentSandbox = null;
    }

    public void stop() {
        this.m_isRunning = false;
        this.stopped(this, this.m_clock.getTime());
        if (HACK_s_isPropetryListeningDisabledWhileWorldIsRunning) {
            Property.HACK_enableListening();
        }
    }
}

