/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import java.util.Vector;

public abstract class Sandbox
extends Element {
    public final ElementArrayProperty responses = new ElementArrayProperty((Element)this, "responses", null, Response[].class);
    public final ElementArrayProperty behaviors = new ElementArrayProperty((Element)this, "behaviors", null, Behavior[].class);
    public final ElementArrayProperty variables = new ElementArrayProperty((Element)this, "variables", null, Variable[].class);
    public final ElementArrayProperty questions = new ElementArrayProperty((Element)this, "questions", null, Question[].class);
    private Behavior m_currentBehavior = null;

    public Expression lookup(String key) {
        if (this.m_currentBehavior != null) {
            Variable expression = this.m_currentBehavior.stackLookup(key);
            if (expression != null) {
                return expression;
            }
            return this.m_currentBehavior.detailLookup(key);
        }
        return null;
    }

    public Behavior getCurrentBehavior() {
        return this.m_currentBehavior;
    }

    protected void scheduleBehaviors(double t) {
        int i = 0;
        while (i < this.behaviors.size()) {
            Behavior behaviorI;
            this.m_currentBehavior = behaviorI = (Behavior)this.behaviors.get(i);
            behaviorI.preSchedule(t);
            behaviorI.schedule(t);
            behaviorI.postSchedule(t);
            this.m_currentBehavior = null;
            ++i;
        }
    }

    protected void internalFindAccessibleExpressions(Class cls, Vector v) {
        int i = 0;
        while (i < this.variables.size()) {
            this.internalAddExpressionIfAssignableTo((Expression)this.variables.get(i), cls, v);
            ++i;
        }
        i = 0;
        while (i < this.questions.size()) {
            this.internalAddExpressionIfAssignableTo((Expression)this.questions.get(i), cls, v);
            ++i;
        }
        super.internalFindAccessibleExpressions(cls, v);
    }
}

