/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceResolver;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class AppletWorldLoader {
    public static final String _CDATA = "_CDATA_";
    public static final String _CDATA_INIT = "_CDATA_INIT";
    public static final String _CDATA_END = "_CDATA_END";
    public static final String FIRST_CDATA_INIT = "1_CDATA_INIT";
    public static final String FIRST_CDATA_END = "1_CDATA_END";

    private static Element loadElement(String xmlString, Vector referencesToBeResolved) throws Exception {
        if (xmlString == null || xmlString.length() < 2) {
            return null;
        }
        xmlString = xmlString.replaceAll("\\<!\\[CDATA\\[", "");
        xmlString = xmlString.replaceAll("]]>", "");
        xmlString = xmlString.replaceAll(FIRST_CDATA_INIT, "<![CDATA[");
        xmlString = xmlString.replaceAll(FIRST_CDATA_END, "]]>");
        int i = 2;
        while (i < 20) {
            xmlString = xmlString.replaceAll(String.valueOf(i) + _CDATA, String.valueOf(i - 1) + _CDATA);
            ++i;
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(xmlString));
        Document document = db.parse(is);
        org.w3c.dom.Element elementNode = document.getDocumentElement();
        elementNode.normalize();
        String classname = elementNode.getAttribute("class");
        String nameValue = elementNode.getAttribute("name");
        Class<?> cls = Class.forName(classname);
        Element element = (Element)cls.newInstance();
        if (nameValue.length() > 0) {
            element.name.set(nameValue);
        }
        NodeList childNodeList = elementNode.getElementsByTagName("child");
        int i2 = 0;
        while (i2 < childNodeList.getLength()) {
            String childString;
            Element child;
            org.w3c.dom.Element childNode = (org.w3c.dom.Element)childNodeList.item(i2);
            if (childNode.getChildNodes() != null && childNode.getChildNodes().item(0) != null && (child = AppletWorldLoader.loadElement(childString = childNode.getChildNodes().item(0).getNodeValue(), referencesToBeResolved)) != null) {
                String childName = child.name.getStringValue();
                if (childName != null && element.getChildNamed(childName) != null) {
                    child = null;
                    System.err.println(element + " already has child named " + childName + ".  skipping.");
                }
                if (child != null) {
                    element.addChild(child);
                }
            }
            ++i2;
        }
        NodeList propertyNodeList = elementNode.getElementsByTagName("property");
        int i3 = 0;
        while (i3 < propertyNodeList.getLength()) {
            org.w3c.dom.Element propertyNode = (org.w3c.dom.Element)propertyNodeList.item(i3);
            String propertyName = propertyNode.getAttribute("name").trim();
            Property property = element.getPropertyNamed(propertyName);
            if (property != null) {
                property.decode(propertyNode, referencesToBeResolved);
            }
            ++i3;
        }
        return element;
    }

    public static Element loadWorld(String xmlString) throws Exception {
        xmlString = AppletWorldLoader.colocaAspas(xmlString);
        Vector referencesToBeResolved = new Vector();
        Vector<PropertyReference> referencesLeftUnresolved = new Vector<PropertyReference>();
        Element element = null;
        try {
            element = AppletWorldLoader.loadElement(xmlString, referencesToBeResolved);
            DefaultReferenceResolver referenceResolver = new DefaultReferenceResolver(element, element);
            Enumeration enu = referencesToBeResolved.elements();
            while (enu.hasMoreElements()) {
                PropertyReference propertyReference = (PropertyReference)enu.nextElement();
                try {
                    propertyReference.resolve(referenceResolver);
                }
                catch (UnresolvableReferenceException ure) {
                    referencesLeftUnresolved.add(propertyReference);
                }
                catch (Throwable t) {
                    System.err.println(propertyReference);
                    t.printStackTrace();
                }
            }
        }
        catch (ParserConfigurationException referenceResolver) {
            // empty catch block
        }
        if (referencesLeftUnresolved.size() == 0) {
            if (element != null) {
                element.loadCompleted();
            }
            return element;
        }
        Object[] propertyReferences = new PropertyReference[referencesLeftUnresolved.size()];
        referencesLeftUnresolved.copyInto(propertyReferences);
        throw new Exception();
    }

    private static String colocaAspas(String worldString) {
        String result = worldString.replaceAll("_ASP1_", "'");
        result = result.replaceAll("_ASP2_", "\"");
        return result;
    }
}

