/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.util.StringTypePair;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TypeChooser
extends JPanel {
    private Class type;
    private ButtonGroup buttonGroup;
    private HashMap typeMap = new HashMap();
    private HashSet changeListeners = new HashSet();
    private JRadioButton numberButton = new JRadioButton("Number");
    private JRadioButton booleanButton = new JRadioButton("Boolean");
    private JRadioButton objectButton = new JRadioButton("Object");
    private JRadioButton otherButton = new JRadioButton("Other...");
    private JComboBox otherCombo = new JComboBox();
    private CheckForValidityCallback okButtonCallback;

    public TypeChooser(CheckForValidityCallback okButtonCallback) {
        StringTypePair[] defaultVariableTypes;
        this.otherCombo.setEditable(true);
        this.okButtonCallback = okButtonCallback;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        this.add((Component)this.numberButton, gbc);
        this.add((Component)this.booleanButton, gbc);
        this.add((Component)this.objectButton, gbc);
        this.add((Component)this.otherButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.add((Component)this.otherCombo, gbc);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.numberButton);
        this.buttonGroup.add(this.booleanButton);
        this.buttonGroup.add(this.objectButton);
        this.buttonGroup.add(this.otherButton);
        ActionListener radioListener = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == TypeChooser.this.numberButton) {
                    TypeChooser.this.type = Number.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.numberButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.booleanButton) {
                    TypeChooser.this.type = Boolean.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.booleanButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.objectButton) {
                    TypeChooser.this.type = Model.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.objectButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.otherButton) {
                    TypeChooser.this.otherCombo.setEnabled(true);
                    TypeChooser.this.parseOtherType();
                }
            }
        };
        this.numberButton.addActionListener(radioListener);
        this.booleanButton.addActionListener(radioListener);
        this.objectButton.addActionListener(radioListener);
        this.otherButton.addActionListener(radioListener);
        StringTypePair[] stringTypePairArray = defaultVariableTypes = new StringTypePair[]{new StringTypePair("String", String.class)};
        int n = 0;
        int n2 = stringTypePairArray.length;
        while (n < n2) {
            StringTypePair defaultVariableType = stringTypePairArray[n];
            this.typeMap.put(defaultVariableType.getString().trim(), defaultVariableType.getType());
            this.otherCombo.addItem(defaultVariableType.getString());
            ++n;
        }
        ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }

            public void insertUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }

            public void removeUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }
        });
        this.numberButton.setSelected(true);
        this.type = Number.class;
        this.otherCombo.setEnabled(false);
    }

    protected void parseOtherType() {
        String typeString = ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getText().trim();
        Class<?> newType = (Class<?>)this.typeMap.get(typeString);
        if (newType == null) {
            try {
                newType = Class.forName(typeString);
            }
            catch (ClassNotFoundException e) {
                newType = null;
            }
        }
        if (newType == null) {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.red);
        } else {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.black);
        }
        if (this.type != newType) {
            this.type = newType;
            this.fireStateChanged(this.otherCombo);
        }
        this.checkTypeValidity();
    }

    private void checkTypeValidity() {
        this.okButtonCallback.setValidity(this, this.type != null);
    }

    public Class getType() {
        return this.type;
    }

    public void addCurrentTypeToList() {
        String typeString;
        if (this.otherButton.isSelected() && this.type != null && !this.typeMap.containsKey(typeString = ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getText().trim())) {
            this.otherCombo.addItem(typeString);
            this.typeMap.put(typeString, this.type);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireStateChanged(Object source) {
        ChangeEvent ev = new ChangeEvent(source);
        Iterator iter = this.changeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(ev);
        }
    }
}

