/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class StyledStreamTextPane
extends JTextPane {
    public Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
    public Style stdOutStyle;
    public Style stdErrStyle;
    DefaultStyledDocument document = new DefaultStyledDocument();
    Position endPosition;
    StyleStream defaultStream;
    protected final MouseListener mouseListener = new CustomMouseAdapter(){

        protected void popupResponse(MouseEvent e) {
            JPopupMenu popup = this.createPopup();
            popup.show(e.getComponent(), e.getX(), e.getY());
            PopupMenuUtilities.ensurePopupIsOnScreen(popup);
        }

        private JPopupMenu createPopup() {
            Runnable clearAllRunnable = new Runnable(){

                public void run() {
                    StyledStreamTextPane.this.setText("");
                }
            };
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            structure.add(new StringObjectPair("Clear All", clearAllRunnable));
            return PopupMenuUtilities.makePopupMenu(structure);
        }
    };

    public StyledStreamTextPane() {
        this.setDocument(this.document);
        this.endPosition = this.document.getEndPosition();
        StyleConstants.setFontFamily(this.defaultStyle, "Monospaced");
        this.stdOutStyle = this.addStyle("stdOut", this.defaultStyle);
        this.stdErrStyle = this.addStyle("stdErr", this.defaultStyle);
        StyleConstants.setForeground(this.stdErrStyle, AuthoringToolResources.getColor("stdErrTextColor"));
        this.defaultStream = this.getNewStyleStream(this.defaultStyle);
        this.setDropTarget(new DropTarget(this, new OutputDropTargetListener()));
        this.addMouseListener(this.mouseListener);
    }

    public StyleStream getNewStyleStream(Style style) {
        return new StyleStream(this, style);
    }

    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent != null) {
            int preferredWidth = this.getUI().getPreferredSize((JComponent)this).width;
            int parentWidth = parent.getSize().width;
            return preferredWidth < parentWidth;
        }
        return false;
    }

    class OutputDropTargetListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dtde) {
        }

        public void dragOver(DropTargetDragEvent dtde) {
        }

        public void drop(DropTargetDropEvent dtde) {
            Object transferredObject;
            Transferable transferable = dtde.getTransferable();
            transferable.getTransferDataFlavors();
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor)) {
                try {
                    dtde.acceptDrop(0x40000000);
                    ElementPrototype elementPrototype = (ElementPrototype)transferable.getTransferData(ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor);
                    if (elementPrototype.getDesiredProperties().length > 0) {
                        PopupItemFactory factory = new PopupItemFactory(){

                            public Object createItem(Object object) {
                                return new Runnable(this, object){
                                    final /* synthetic */ 1 this$2;
                                    private final /* synthetic */ Object val$object;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$object = object;
                                    }

                                    public void run() {
                                        if (this.val$object instanceof ElementPrototype) {
                                            Element e = ((ElementPrototype)this.val$object).createNewElement();
                                            if (e instanceof Question) {
                                                OutputDropTargetListener.access$0((OutputDropTargetListener)1.access$0(this.this$2)).defaultStream.println(((Question)e).getValue());
                                            } else {
                                                OutputDropTargetListener.access$0((OutputDropTargetListener)1.access$0(this.this$2)).defaultStream.println(e);
                                            }
                                        } else {
                                            OutputDropTargetListener.access$0((OutputDropTargetListener)1.access$0(this.this$2)).defaultStream.println(this.val$object);
                                        }
                                    }
                                };
                            }

                            static /* synthetic */ OutputDropTargetListener access$0(1 var0) {
                                return var0.OutputDropTargetListener.this;
                            }
                        };
                        Vector structure = PopupMenuUtilities.makePrototypeStructure(elementPrototype, factory, null);
                        JPopupMenu popup = PopupMenuUtilities.makePopupMenu(structure);
                        popup.show(StyledStreamTextPane.this, (int)dtde.getLocation().getX(), (int)dtde.getLocation().getY());
                        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
                    } else {
                        Element e = elementPrototype.createNewElement();
                        if (e instanceof Question) {
                            StyledStreamTextPane.this.defaultStream.println(((Question)e).getValue());
                        } else {
                            StyledStreamTextPane.this.defaultStream.println(e);
                        }
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                }
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.stringFlavor)) {
                try {
                    dtde.acceptDrop(1);
                    transferredObject = transferable.getTransferData(DataFlavor.stringFlavor);
                    StyledStreamTextPane.this.defaultStream.println(transferredObject);
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                }
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.getTextPlainUnicodeFlavor())) {
                try {
                    dtde.acceptDrop(1);
                    transferredObject = DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable);
                    StyledStreamTextPane.this.defaultStream.println(transferredObject);
                    final BufferedReader fileReader = new BufferedReader((Reader)transferredObject);
                    Thread fileReaderThread = new Thread(){

                        public void run() {
                            try {
                                String line;
                                while ((line = fileReader.readLine()) != null) {
                                    ((OutputDropTargetListener)OutputDropTargetListener.this).StyledStreamTextPane.this.defaultStream.println(line);
                                }
                                fileReader.close();
                            }
                            catch (IOException e) {
                                AuthoringTool.showErrorDialog("Error reading file.", e);
                            }
                        }
                    };
                    fileReaderThread.start();
                    dtde.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                }
                catch (IOException e) {
                    AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                }
            }
            dtde.rejectDrop();
            dtde.getDropTargetContext().dropComplete(true);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
        }

        public void dragExit(DropTargetEvent dte) {
        }
    }
}

