/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceMenuItemUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceMenuUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceMenuWithDelayedPopup;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.DelayedBindingPopupItem;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.InAppropriateObjectArrayPropertyCriterion;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemWithIcon;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuItemActionListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.ResponsePrototype;
import edu.cmu.cs.stage3.alice.core.Array;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Collection;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Style;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.And;
import edu.cmu.cs.stage3.alice.core.question.BinaryObjectResultingInBooleanQuestion;
import edu.cmu.cs.stage3.alice.core.question.IsEqualTo;
import edu.cmu.cs.stage3.alice.core.question.IsNotEqualTo;
import edu.cmu.cs.stage3.alice.core.question.Not;
import edu.cmu.cs.stage3.alice.core.question.NumberAddition;
import edu.cmu.cs.stage3.alice.core.question.NumberDivision;
import edu.cmu.cs.stage3.alice.core.question.NumberIsGreaterThan;
import edu.cmu.cs.stage3.alice.core.question.NumberIsGreaterThanOrEqualTo;
import edu.cmu.cs.stage3.alice.core.question.NumberIsLessThan;
import edu.cmu.cs.stage3.alice.core.question.NumberIsLessThanOrEqualTo;
import edu.cmu.cs.stage3.alice.core.question.NumberMultiplication;
import edu.cmu.cs.stage3.alice.core.question.NumberSubtraction;
import edu.cmu.cs.stage3.alice.core.question.Or;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.array.ArrayNumberQuestion;
import edu.cmu.cs.stage3.alice.core.question.array.ArrayObjectQuestion;
import edu.cmu.cs.stage3.alice.core.question.array.ItemAtIndex;
import edu.cmu.cs.stage3.alice.core.question.list.Contains;
import edu.cmu.cs.stage3.alice.core.question.list.FirstIndexOfItem;
import edu.cmu.cs.stage3.alice.core.question.list.IsEmpty;
import edu.cmu.cs.stage3.alice.core.question.list.ItemAtBeginning;
import edu.cmu.cs.stage3.alice.core.question.list.ItemAtEnd;
import edu.cmu.cs.stage3.alice.core.question.list.ItemAtRandomIndex;
import edu.cmu.cs.stage3.alice.core.question.list.LastIndexOfItem;
import edu.cmu.cs.stage3.alice.core.question.list.ListBooleanQuestion;
import edu.cmu.cs.stage3.alice.core.question.list.ListNumberQuestion;
import edu.cmu.cs.stage3.alice.core.question.list.ListObjectQuestion;
import edu.cmu.cs.stage3.alice.core.question.list.Size;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Print;
import edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.PropertyAnimation;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.array.ArrayResponse;
import edu.cmu.cs.stage3.alice.core.response.list.ListResponse;
import edu.cmu.cs.stage3.alice.core.style.TraditionalAnimationStyle;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.Enumerable;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import edu.cmu.cs.stage3.util.criterion.MatchesAllCriterion;
import edu.cmu.cs.stage3.util.criterion.NotCriterion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class PopupMenuUtilities {
    protected static HashMap recentlyUsedValues = new HashMap();
    protected static Hashtable runnablesToActionListeners = new Hashtable();
    public static final PopupItemFactory oneShotFactory = new PopupItemFactory(){

        public Object createItem(final Object o) {
            return new Runnable(){

                public void run() {
                    if (o instanceof ResponsePrototype) {
                        Response response = ((ResponsePrototype)o).createNewResponse();
                        Response undoResponse = AuthoringToolResources.createUndoResponse(response);
                        Property[] properties = AuthoringToolResources.getAffectedProperties(response);
                        AuthoringTool.getHack().performOneShot(response, undoResponse, properties);
                    }
                }
            };
        }
    };
    public static final Icon currentValueIcon = AuthoringToolResources.getIconForValue("currentValue");
    public static final Object NO_CURRENT_VALUE = new Object();
    protected static Criterion isNamedElement = new Criterion(){

        public boolean accept(Object o) {
            return o instanceof Element && ((Element)o).name.get() != null;
        }
    };
    protected static Criterion isNotActualParameter = new Criterion(){

        public boolean accept(Object o) {
            if (o instanceof Variable) {
                Variable variable = (Variable)o;
                if (variable.getParent() instanceof CallToUserDefinedResponse) {
                    CallToUserDefinedResponse callToUserDefinedResponse = (CallToUserDefinedResponse)variable.getParent();
                    if (callToUserDefinedResponse.requiredActualParameters.contains(variable)) {
                        return false;
                    }
                    if (callToUserDefinedResponse.keywordActualParameters.contains(variable)) {
                        return false;
                    }
                } else if (variable.getParent() instanceof CallToUserDefinedQuestion) {
                    CallToUserDefinedQuestion callToUserDefinedQuestion = (CallToUserDefinedQuestion)variable.getParent();
                    if (callToUserDefinedQuestion.requiredActualParameters.contains(variable)) {
                        return false;
                    }
                    if (callToUserDefinedQuestion.keywordActualParameters.contains(variable)) {
                        return false;
                    }
                }
            }
            return true;
        }
    };
    protected static HashMap specialStringMap = new HashMap();

    static {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        specialStringMap.put("<keyCode>", "a key");
        specialStringMap.put("<keyCode>", "a key");
        specialStringMap.put("<mouse>", "the mouse");
        specialStringMap.put("<onWhat>", "something");
        specialStringMap.put("<condition>", "something");
        specialStringMap.put("<variable>", "a variable");
        specialStringMap.put("<arrowKeys>", "the arrow keys");
        specialStringMap.put("<button>", "");
    }

    public static void addRecentlyUsedValue(Class valueClass, Object value) {
        if (!recentlyUsedValues.containsKey(valueClass)) {
            recentlyUsedValues.put(valueClass, new ArrayList());
        }
        List recentList = (List)recentlyUsedValues.get(valueClass);
        while (recentList.contains(value)) {
            recentList.remove(value);
        }
        recentList.add(0, value);
    }

    public static void createAndShowPopupMenu(Vector structure, Component component, int x, int y) {
        JPopupMenu popup = PopupMenuUtilities.makePopupMenu(structure);
        popup.show(component, x, y);
        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
    }

    public static JPopupMenu makePopupMenu(Vector structure) {
        AliceMenuWithDelayedPopup menu = PopupMenuUtilities.makeMenu("", structure);
        if (menu != null) {
            return menu.getPopupMenu();
        }
        return null;
    }

    public static AliceMenuWithDelayedPopup makeMenu(String title, Vector structure) {
        if (structure == null || structure.isEmpty()) {
            return null;
        }
        AliceMenuWithDelayedPopup menu = new AliceMenuWithDelayedPopup(title, structure);
        menu.setUI(new AliceMenuUI());
        menu.setDelay(0);
        return menu;
    }

    public static void populateDelayedMenu(AliceMenuWithDelayedPopup menu, Vector structure) {
        Enumeration enu = structure.elements();
        while (enu.hasMoreElements()) {
            JMenuItem menuItem;
            Object content;
            Object o = enu.nextElement();
            if (!(o instanceof StringObjectPair)) {
                throw new IllegalArgumentException("structure must be made only of StringObjectPairs, found: " + o);
            }
            StringObjectPair pair = (StringObjectPair)o;
            String name = pair.getString();
            if (name != null) {
                for (String s : specialStringMap.keySet()) {
                    if (name.indexOf(s) <= -1) continue;
                    StringBuffer sb = new StringBuffer(name);
                    sb.replace(name.indexOf(s), name.indexOf(s) + s.length(), (String)specialStringMap.get(s));
                    name = sb.toString();
                }
            }
            if ((content = pair.getObject()) instanceof DelayedBindingPopupItem) {
                content = ((DelayedBindingPopupItem)content).createItem();
            }
            Icon icon = null;
            if (content instanceof PopupItemWithIcon) {
                icon = ((PopupItemWithIcon)content).getIcon();
                content = ((PopupItemWithIcon)content).getItem();
            }
            if (content instanceof Vector) {
                AliceMenuWithDelayedPopup submenu = PopupMenuUtilities.makeMenu(name, (Vector)content);
                if (submenu == null) continue;
                menu.add(submenu);
                continue;
            }
            if (content instanceof ActionListener) {
                menuItem = PopupMenuUtilities.makeMenuItem(name, icon);
                menuItem.addActionListener((ActionListener)content);
                menu.add(menuItem);
                continue;
            }
            if (content instanceof Runnable) {
                menuItem = PopupMenuUtilities.makeMenuItem(name, icon);
                ActionListener listener = (ActionListener)runnablesToActionListeners.get(content);
                if (listener == null) {
                    listener = new PopupMenuItemActionListener((Runnable)content, menu);
                }
                menuItem.addActionListener(listener);
                menu.add(menuItem);
                continue;
            }
            if (content == JSeparator.class) {
                menu.addSeparator();
                continue;
            }
            if (content instanceof Component) {
                menu.add((Component)content);
                continue;
            }
            if (content != null) continue;
            JLabel label = new JLabel(name);
            label.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            menu.add(label);
        }
    }

    public static JMenuItem makeMenuItem(String text, Icon icon) {
        JMenuItem item = icon != null ? new JMenuItem(text, icon) : new JMenuItem(text);
        item.setUI(new AliceMenuItemUI());
        return item;
    }

    public static boolean isStringInStructure(String s, Vector structure) {
        Enumeration enu = structure.elements();
        while (enu.hasMoreElements()) {
            StringObjectPair pair = (StringObjectPair)enu.nextElement();
            String string = pair.getString();
            Object content = pair.getObject();
            if (string == s) {
                return true;
            }
            if (!(content instanceof Vector) || !PopupMenuUtilities.isStringInStructure(s, (Vector)content)) continue;
            return true;
        }
        return false;
    }

    public static boolean isObjectInStructure(Object o, Vector structure) {
        Enumeration enu = structure.elements();
        while (enu.hasMoreElements()) {
            StringObjectPair pair = (StringObjectPair)enu.nextElement();
            Object content = pair.getObject();
            if (content == o) {
                return true;
            }
            if (!(content instanceof Vector) || !PopupMenuUtilities.isObjectInStructure(o, (Vector)content)) continue;
            return true;
        }
        return false;
    }

    public static Vector makeFlatElementStructure(Element root, Criterion criterion, PopupItemFactory factory, Element context, Object currentValue) {
        Element[] elements;
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        Element[] elementArray = elements = root.search(criterion);
        int n = 0;
        int n2 = elementArray.length;
        while (n < n2) {
            Element element = elementArray[n];
            String text = AuthoringToolResources.getReprForValue(element);
            if (context != null) {
                text = AuthoringToolResources.getNameInContext(element, context);
            }
            if (element.equals(currentValue)) {
                structure.addElement(new StringObjectPair(text, new PopupItemWithIcon(factory.createItem(element), currentValueIcon)));
            } else {
                structure.addElement(new StringObjectPair(text, factory.createItem(element)));
            }
            ++n;
        }
        return structure;
    }

    public static Vector makeFlatExpressionStructure(Class valueClass, PopupItemFactory factory, Element context, Object currentValue) {
        return PopupMenuUtilities.makeFlatExpressionStructure(valueClass, null, factory, context, currentValue);
    }

    public static Vector makeFlatExpressionStructure(Class valueClass, Criterion criterion, PopupItemFactory factory, Element context, Object currentValue) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (context != null) {
            Expression[] expressions;
            Expression[] expressionArray = expressions = context.findAccessibleExpressions(valueClass);
            int n = 0;
            int n2 = expressionArray.length;
            while (n < n2) {
                Expression expression = expressionArray[n];
                if (criterion == null || criterion.accept(expression)) {
                    String text = AuthoringToolResources.getReprForValue(expression);
                    if (context != null) {
                        text = AuthoringToolResources.getNameInContext(expression, context);
                    }
                    if (expression instanceof UserDefinedQuestion) {
                        CallToUserDefinedQuestionPrototype prototype = new CallToUserDefinedQuestionPrototype((UserDefinedQuestion)expression);
                        if (prototype.getDesiredProperties().length > 0) {
                            structure.addElement(new StringObjectPair(text, PopupMenuUtilities.makePrototypeStructure(prototype, factory, context)));
                        } else {
                            structure.addElement(new StringObjectPair(text, factory.createItem(prototype.createNewElement())));
                        }
                    } else if (expression.equals(currentValue)) {
                        structure.addElement(new StringObjectPair(text, new PopupItemWithIcon(factory.createItem(expression), currentValueIcon)));
                    } else {
                        structure.addElement(new StringObjectPair(text, factory.createItem(expression)));
                    }
                }
                ++n;
            }
        }
        return structure;
    }

    public static Vector makeResponseStructure(Element element, PopupItemFactory factory, Element context) {
        Vector structure = new Vector();
        return structure;
    }

    public static Vector makeExpressionResponseStructure(final Expression expression, final PopupItemFactory factory, final Element context) {
        String[] desired;
        StringObjectPair[] known;
        ResponsePrototype rp;
        Vector setValueStructure;
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (expression instanceof Variable && (setValueStructure = PopupMenuUtilities.makePrototypeStructure(rp = new ResponsePrototype(PropertyAnimation.class, known = new StringObjectPair[]{new StringObjectPair("element", expression), new StringObjectPair("propertyName", "value"), new StringObjectPair("duration", new Integer(0))}, desired = new String[]{"value"}), factory, context)) != null && !setValueStructure.isEmpty()) {
            structure.add(new StringObjectPair("set value", setValueStructure));
        }
        if (expression instanceof Variable) {
            Collection collection;
            Variable variable = (Variable)expression;
            if (Collection.class.isAssignableFrom(expression.getValueClass()) && ((collection = (Collection)variable.value.get()) instanceof edu.cmu.cs.stage3.alice.core.List || collection instanceof Array) && collection.values.size() > 0 && Model.class.isAssignableFrom(collection.valueClass.getClassValue())) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                DelayedBindingPopupItem delayedBindingPopupItem = new DelayedBindingPopupItem(){

                    public Object createItem() {
                        Vector<StringObjectPair> subStructure = new Vector<StringObjectPair>();
                        Object[] items = collection.values.getArrayValue();
                        int i = 0;
                        while (i < items.length) {
                            Question question = null;
                            if (collection instanceof edu.cmu.cs.stage3.alice.core.List) {
                                question = new edu.cmu.cs.stage3.alice.core.question.list.ItemAtIndex();
                                question.list.set(expression);
                                question.index.set(new Double(i));
                            } else if (collection instanceof Array) {
                                question = new ItemAtIndex();
                                ((ItemAtIndex)question).array.set(expression);
                                ((ItemAtIndex)question).index.set(new Double(i));
                            }
                            Vector responseStructure = PopupMenuUtilities.makeResponseStructure(question, factory, context);
                            subStructure.add(new StringObjectPair("item" + i, responseStructure));
                            ++i;
                        }
                        return subStructure;
                    }
                };
                structure.add(new StringObjectPair("item responses", delayedBindingPopupItem));
            }
        }
        return structure;
    }

    public static Vector makeOneShotStructure(Vector responseNames, Element element, PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (responseNames != null) {
            for (Object item : responseNames) {
                if (item instanceof String) {
                    String className = (String)item;
                    try {
                        if (className.startsWith("edu.cmu.cs.stage3.alice.core.response.PropertyAnimation")) {
                            String propertyName = AuthoringToolResources.getSpecifier(className);
                            StringObjectPair[] knownPropertyValues = new StringObjectPair[]{new StringObjectPair("element", element), new StringObjectPair("propertyName", propertyName)};
                            String[] desiredProperties = new String[]{"value"};
                            ResponsePrototype responsePrototype = new ResponsePrototype(PropertyAnimation.class, knownPropertyValues, desiredProperties);
                            String responseName = AuthoringToolResources.getFormattedReprForValue(PropertyAnimation.class, knownPropertyValues);
                            Vector subStructure = PopupMenuUtilities.makePrototypeStructure(responsePrototype, factory, context);
                            structure.add(new StringObjectPair(responseName, subStructure));
                            continue;
                        }
                        Class<?> responseClass = Class.forName(className);
                        LinkedList<StringObjectPair> known = new LinkedList<StringObjectPair>();
                        String format = AuthoringToolResources.getFormat(responseClass);
                        FormatTokenizer tokenizer = new FormatTokenizer(format);
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken();
                            if (!token.startsWith("<<<") || !token.endsWith(">>>")) continue;
                            String propertyName = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                            known.add(new StringObjectPair(propertyName, element));
                        }
                        StringObjectPair[] knownPropertyValues = known.toArray(new StringObjectPair[0]);
                        String[] desiredProperties = AuthoringToolResources.getDesiredProperties(responseClass);
                        ResponsePrototype responsePrototype = new ResponsePrototype(responseClass, knownPropertyValues, desiredProperties);
                        String responseName = AuthoringToolResources.getFormattedReprForValue(responseClass, knownPropertyValues);
                        if (responsePrototype.getDesiredProperties().length > 0) {
                            Vector subStructure = PopupMenuUtilities.makePrototypeStructure(responsePrototype, factory, context);
                            structure.add(new StringObjectPair(responseName, subStructure));
                            continue;
                        }
                        structure.add(new StringObjectPair(responseName, factory.createItem(responsePrototype)));
                    }
                    catch (Throwable t) {
                        AuthoringTool.showErrorDialog("Error creating popup item.", t);
                    }
                    continue;
                }
                if (!(item instanceof StringObjectPair)) continue;
                try {
                    String label = ((StringObjectPair)item).getString();
                    Vector subResponseNames = (Vector)((StringObjectPair)item).getObject();
                    Vector subStructure = PopupMenuUtilities.makeOneShotStructure(subResponseNames, element, factory, context);
                    structure.add(new StringObjectPair(label, subStructure));
                }
                catch (Throwable t) {
                    AuthoringTool.showErrorDialog("Error creating popup item.", t);
                }
            }
        }
        return structure;
    }

    public static Vector makePropertyAssignmentForUserDefinedQuestionStructure(Property property, PopupItemFactory factory, Element context) {
        String[] desired;
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("element", property.getOwner()), new StringObjectPair("propertyName", property.getName())};
        ElementPrototype ep = new ElementPrototype(PropertyAssignment.class, known, desired = new String[]{"value"});
        Vector setValueStructure = PopupMenuUtilities.makePrototypeStructure(ep, factory, context);
        if (setValueStructure != null && !setValueStructure.isEmpty()) {
            structure.add(new StringObjectPair("set value", setValueStructure));
        }
        return structure;
    }

    public static Vector makePrototypeStructure(final ElementPrototype elementPrototype, final PopupItemFactory factory, final Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        final String[] desiredProperties = elementPrototype.getDesiredProperties();
        if (desiredProperties == null || desiredProperties.length == 0) {
            structure.add(new StringObjectPair("no properties to set on " + elementPrototype.getElementClass().getName() + "; please report this bug", factory.createItem(elementPrototype)));
        } else if (desiredProperties.length > 0) {
            Object param;
            int n;
            int n2;
            Object[] objectArray;
            Object[] params;
            String preRepr = String.valueOf(elementPrototype.getElementClass().getName()) + "." + desiredProperties[0];
            String propertyRepr = AuthoringToolResources.getReprForValue(preRepr);
            if (propertyRepr.equals(preRepr)) {
                propertyRepr = desiredProperties[0];
            }
            structure.add(new StringObjectPair(propertyRepr, null));
            Class preValueClass = null;
            Vector preDefaultStructure = null;
            if (PropertyAnimation.class.isAssignableFrom(elementPrototype.getElementClass())) {
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForPropertyAnimation(elementPrototype.getKnownPropertyValues());
                preValueClass = PopupMenuUtilities.getValueClassForPropertyAnimation(elementPrototype.getKnownPropertyValues());
            } else if (PropertyAssignment.class.isAssignableFrom(elementPrototype.getElementClass())) {
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForPropertyAnimation(elementPrototype.getKnownPropertyValues());
                preValueClass = PopupMenuUtilities.getValueClassForPropertyAnimation(elementPrototype.getKnownPropertyValues());
            } else if (ListBooleanQuestion.class.isAssignableFrom(elementPrototype.getElementClass()) || ListNumberQuestion.class.isAssignableFrom(elementPrototype.getElementClass()) || ListObjectQuestion.class.isAssignableFrom(elementPrototype.getElementClass()) || ListResponse.class.isAssignableFrom(elementPrototype.getElementClass())) {
                if (desiredProperties[0].equals("item")) {
                    preValueClass = PopupMenuUtilities.getValueClassForList(elementPrototype.getKnownPropertyValues());
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForClass(preValueClass);
                } else if (desiredProperties[0].equals("index")) {
                    preValueClass = Element.getValueClassForPropertyNamed(elementPrototype.getElementClass(), desiredProperties[0]);
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForCollectionIndexProperty(elementPrototype.getKnownPropertyValues());
                } else {
                    preValueClass = Element.getValueClassForPropertyNamed(elementPrototype.getElementClass(), desiredProperties[0]);
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForProperty(elementPrototype.getElementClass(), desiredProperties[0]);
                }
            } else if (ArrayNumberQuestion.class.isAssignableFrom(elementPrototype.getElementClass()) || ArrayObjectQuestion.class.isAssignableFrom(elementPrototype.getElementClass()) || ArrayResponse.class.isAssignableFrom(elementPrototype.getElementClass())) {
                if (desiredProperties[0].equals("item")) {
                    preValueClass = PopupMenuUtilities.getValueClassForArray(elementPrototype.getKnownPropertyValues());
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForClass(preValueClass);
                } else if (desiredProperties[0].equals("index")) {
                    preValueClass = Element.getValueClassForPropertyNamed(elementPrototype.getElementClass(), desiredProperties[0]);
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForCollectionIndexProperty(elementPrototype.getKnownPropertyValues());
                } else {
                    preValueClass = Element.getValueClassForPropertyNamed(elementPrototype.getElementClass(), desiredProperties[0]);
                    preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForProperty(elementPrototype.getElementClass(), desiredProperties[0]);
                }
            } else if (elementPrototype instanceof CallToUserDefinedResponsePrototype) {
                UserDefinedResponse actualResponse = ((CallToUserDefinedResponsePrototype)elementPrototype).getActualResponse();
                objectArray = params = actualResponse.requiredFormalParameters.getArrayValue();
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    param = objectArray[n2];
                    if (((Variable)param).name.getStringValue().equals(desiredProperties[0])) {
                        preValueClass = (Class)((Variable)param).valueClass.getValue();
                        break;
                    }
                    ++n2;
                }
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForClass(preValueClass);
            } else if (elementPrototype instanceof CallToUserDefinedQuestionPrototype) {
                UserDefinedQuestion actualQuestion = ((CallToUserDefinedQuestionPrototype)elementPrototype).getActualQuestion();
                objectArray = params = actualQuestion.requiredFormalParameters.getArrayValue();
                n2 = 0;
                n = objectArray.length;
                while (n2 < n) {
                    param = objectArray[n2];
                    if (((Variable)param).name.getStringValue().equals(desiredProperties[0])) {
                        preValueClass = (Class)((Variable)param).valueClass.getValue();
                        break;
                    }
                    ++n2;
                }
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForClass(preValueClass);
            } else if (IsEqualTo.class.isAssignableFrom(elementPrototype.getElementClass()) || IsNotEqualTo.class.isAssignableFrom(elementPrototype.getElementClass())) {
                preValueClass = PopupMenuUtilities.getValueClassForComparator(elementPrototype.knownPropertyValues);
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForClass(preValueClass);
            } else {
                preValueClass = Element.getValueClassForPropertyNamed(elementPrototype.getElementClass(), desiredProperties[0]);
                preDefaultStructure = PopupMenuUtilities.getDefaultValueStructureForProperty(elementPrototype.getElementClass(), desiredProperties[0]);
            }
            final Class valueClass = preValueClass;
            PopupItemFactory recursiveFactory = new PopupItemFactory(){

                public Object createItem(Object o) {
                    if (desiredProperties.length == 1) {
                        return factory.createItem(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], o)));
                    }
                    return PopupMenuUtilities.makePrototypeStructure(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], o)), factory, context);
                }
            };
            Vector defaultStructure = PopupMenuUtilities.processStructure(preDefaultStructure, recursiveFactory, NO_CURRENT_VALUE);
            Vector recentlyUsedStructure = new Vector();
            if (recentlyUsedValues.containsKey(preValueClass)) {
                List recentList = (List)recentlyUsedValues.get(preValueClass);
                int count = 0;
                for (Object value : recentList) {
                    if (PopupMenuUtilities.structureContains(preDefaultStructure, value)) continue;
                    recentlyUsedStructure.add(value);
                    ++count;
                }
            }
            if (!defaultStructure.isEmpty()) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                structure.addAll(defaultStructure);
            }
            if (!recentlyUsedStructure.isEmpty()) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                PopupMenuUtilities.addLabelsToValueStructure(recentlyUsedStructure, elementPrototype.getElementClass(), desiredProperties[0]);
                structure.addAll(PopupMenuUtilities.processStructure(recentlyUsedStructure, recursiveFactory, NO_CURRENT_VALUE));
            }
            Class elementClass = elementPrototype.getElementClass();
            Vector expressionStructure = PopupMenuUtilities.makeFlatExpressionStructure(valueClass, recursiveFactory, context, NO_CURRENT_VALUE);
            if (expressionStructure != null && expressionStructure.size() > 0) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                structure.add(new StringObjectPair("expressions", expressionStructure));
            }
            boolean nullValid = false;
            if (elementPrototype instanceof CallToUserDefinedResponsePrototype) {
                nullValid = true;
            } else if (elementPrototype instanceof CallToUserDefinedQuestionPrototype) {
                nullValid = true;
            }
            if (nullValid) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                String nullRepr = AuthoringToolResources.getReprForValue(null, elementClass, desiredProperties[0], "menuContext");
                if (desiredProperties.length == 1) {
                    structure.add(new StringObjectPair(nullRepr, factory.createItem(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], null)))));
                } else {
                    structure.add(new StringObjectPair(nullRepr, PopupMenuUtilities.makePrototypeStructure(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], null)), factory, context)));
                }
            }
            final PopupItemFactory otherFactory = new PopupItemFactory(){

                public Object createItem(final Object o) {
                    return new Runnable(){

                        public void run() {
                            ((Runnable)factory.createItem(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], o)))).run();
                        }
                    };
                }
            };
            if (desiredProperties.length == 1 && GUIFactory.isOtherDialogSupportedForClass(valueClass)) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                Runnable runnable = new Runnable(){

                    public void run() {
                        GUIFactory.showOtherDialog(valueClass, null, otherFactory, context);
                    }
                };
                structure.add(new StringObjectPair("other...", runnable));
            }
            if (edu.cmu.cs.stage3.alice.core.List.class.isAssignableFrom(valueClass) && desiredProperties.length == 1) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                Runnable createNewListRunnable = new Runnable(){

                    public void run() {
                        AuthoringTool authoringTool = AuthoringTool.getHack();
                        ElementArrayProperty variables = context.getSandbox().variables;
                        Variable variable = authoringTool.showNewVariableDialog("Create new list", context.getRoot(), true, true);
                        if (variable != null) {
                            if (variables != null) {
                                authoringTool.getUndoRedoStack().startCompound();
                                try {
                                    variables.getOwner().addChild(variable);
                                    variables.add(variable);
                                }
                                finally {
                                    authoringTool.getUndoRedoStack().stopCompound();
                                }
                            }
                            ((Runnable)factory.createItem(elementPrototype.createCopy(new StringObjectPair(desiredProperties[0], variable)))).run();
                        }
                    }
                };
                structure.add(new StringObjectPair("create new list...", createNewListRunnable));
            }
        }
        return structure;
    }

    public static Vector makePropertyStructure(final Property property, final PopupItemFactory factory, boolean includeDefaults, boolean includeExpressions, boolean includeOther, Element root) {
        Element parent;
        if (root == null) {
            root = property.getOwner().getRoot();
        }
        Vector structure = new Vector();
        Class targetValueClass = PopupMenuUtilities.getDesiredValueClass(property);
        if (edu.cmu.cs.stage3.alice.core.List.class.isAssignableFrom(targetValueClass)) {
            parent = property.getOwner().getParent();
            PropertyReference[] references = parent.getPropertyReferencesTo(property.getOwner(), HowMuch.INSTANCE, false);
            if (property.getOwner() instanceof ListObjectQuestion && references.length > 0) {
                final Class itemValueClass = references[0].getProperty().getValueClass();
                Criterion criterion = new Criterion(){

                    public boolean accept(Object o) {
                        edu.cmu.cs.stage3.alice.core.List list;
                        return o instanceof Variable && (list = (edu.cmu.cs.stage3.alice.core.List)((Variable)o).getValue()) != null && itemValueClass.isAssignableFrom(list.valueClass.getClassValue());
                    }
                };
                structure = PopupMenuUtilities.makeFlatExpressionStructure(targetValueClass, criterion, factory, property.getOwner(), property.get());
            } else {
                structure = PopupMenuUtilities.makeFlatExpressionStructure(targetValueClass, factory, property.getOwner(), property.get());
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                Runnable createNewListRunnable = new Runnable(){

                    public void run() {
                        AuthoringTool authoringTool = AuthoringTool.getHack();
                        ElementArrayProperty variables = property.getOwner().getSandbox().variables;
                        Variable variable = authoringTool.showNewVariableDialog("Create new list", property.getOwner().getRoot(), true, true);
                        if (variable != null) {
                            if (variables != null) {
                                variables.getOwner().addChild(variable);
                                variables.add(variable);
                            }
                            ((Runnable)factory.createItem(variable)).run();
                        }
                    }
                };
                structure.add(new StringObjectPair("create new list...", createNewListRunnable));
            }
        } else if (Array.class.isAssignableFrom(targetValueClass)) {
            parent = property.getOwner().getParent();
            PropertyReference[] references = parent.getPropertyReferencesTo(property.getOwner(), HowMuch.INSTANCE, false);
            if (property.getOwner() instanceof ArrayObjectQuestion && references.length > 0) {
                final Class itemValueClass = references[0].getProperty().getValueClass();
                Criterion criterion = new Criterion(){

                    public boolean accept(Object o) {
                        Array array;
                        return o instanceof Variable && (array = (Array)((Variable)o).getValue()) != null && itemValueClass.isAssignableFrom(array.valueClass.getClassValue());
                    }
                };
                structure = PopupMenuUtilities.makeFlatExpressionStructure(targetValueClass, criterion, factory, property.getOwner(), property.get());
            } else {
                structure = PopupMenuUtilities.makeFlatExpressionStructure(targetValueClass, factory, property.getOwner(), property.get());
            }
        } else {
            Vector mathStructure;
            Vector booleanLogicStructure;
            if (includeDefaults && !Response.class.isAssignableFrom(targetValueClass)) {
                Vector defaultStructure = PopupMenuUtilities.getDefaultValueStructureForProperty(property);
                Vector<Object> recentlyUsedStructure = new Vector<Object>();
                if (recentlyUsedValues.containsKey(targetValueClass)) {
                    List recentList = (List)recentlyUsedValues.get(targetValueClass);
                    int count = 0;
                    for (Object value : recentList) {
                        if (PopupMenuUtilities.structureContains(defaultStructure, value)) continue;
                        recentlyUsedStructure.add(value);
                        ++count;
                    }
                }
                Object currentValue = property.get();
                Vector unlabeledDefaultValueStructure = PopupMenuUtilities.getUnlabeledDefaultValueStructureForProperty(property.getOwner().getClass(), property.getName(), property);
                if (!(unlabeledDefaultValueStructure.contains(currentValue) || recentlyUsedStructure.contains(currentValue) || currentValue instanceof Expression)) {
                    recentlyUsedStructure.add(0, currentValue);
                }
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                structure.addAll(PopupMenuUtilities.processStructure(defaultStructure, factory, property.get()));
                if (!recentlyUsedStructure.isEmpty() && !property.getName().equalsIgnoreCase("keyCode")) {
                    if (structure.size() > 0) {
                        structure.add(new StringObjectPair("Separator", JSeparator.class));
                    }
                    PopupMenuUtilities.addLabelsToValueStructure(recentlyUsedStructure, property.getOwner().getClass(), property.getName());
                    structure.addAll(PopupMenuUtilities.processStructure(recentlyUsedStructure, factory, property.get()));
                }
                if (Element.class.isAssignableFrom(targetValueClass) || targetValueClass.isAssignableFrom(Element.class)) {
                    Criterion criterion;
                    if (property.getOwner() instanceof Behavior && Response.class.isAssignableFrom(targetValueClass)) {
                        criterion = new Criterion(){

                            public boolean accept(Object o) {
                                return o instanceof Response && !(((Response)o).getParent() instanceof Response);
                            }
                        };
                    } else if (property.getOwner() instanceof PropertyAnimation && property.getName().equals("element")) {
                        PropertyAnimation propertyAnimation = (PropertyAnimation)property.getOwner();
                        final String propertyName = propertyAnimation.propertyName.getStringValue();
                        Criterion hasProperty = new Criterion(){

                            public boolean accept(Object o) {
                                return o instanceof Element && ((Element)o).getPropertyNamed(propertyName) != null;
                            }
                        };
                        criterion = new MatchesAllCriterion(new Criterion[]{hasProperty, isNamedElement});
                    } else {
                        InstanceOfCriterion instanceOf = new InstanceOfCriterion(targetValueClass);
                        if (Expression.class.isAssignableFrom(targetValueClass)) {
                            criterion = new MatchesAllCriterion(new Criterion[]{instanceOf, isNamedElement});
                        } else {
                            NotCriterion notExpression = new NotCriterion(new InstanceOfCriterion(Expression.class));
                            InAppropriateObjectArrayPropertyCriterion inAppropriateOAPCriterion = new InAppropriateObjectArrayPropertyCriterion();
                            criterion = new MatchesAllCriterion(new Criterion[]{instanceOf, notExpression, isNamedElement, inAppropriateOAPCriterion});
                        }
                    }
                    Element[] elements = root.search(criterion);
                    if (structure.size() > 0 && elements.length > 0) {
                        structure.add(new StringObjectPair("Separator", JSeparator.class));
                    }
                    if (elements.length < 10) {
                        structure.addAll(PopupMenuUtilities.makeFlatElementStructure(root, criterion, factory, root, property.get()));
                    }
                }
            }
            if (includeExpressions) {
                Vector expressionStructure = PopupMenuUtilities.makeFlatExpressionStructure(targetValueClass, factory, property.getOwner(), property.get());
                if (expressionStructure != null && expressionStructure.size() > 0) {
                    if (structure.size() > 0) {
                        structure.add(new StringObjectPair("Separator", JSeparator.class));
                    }
                    structure.add(new StringObjectPair("expressions", expressionStructure));
                } else if (structure.size() == 0) {
                    JLabel label = new JLabel("no expressions for this type");
                    label.setForeground(Color.gray);
                    label.setBorder(BorderFactory.createEmptyBorder(2, 8, 2, 2));
                    structure.add(new StringObjectPair("", label));
                }
            }
            if (Boolean.class.isAssignableFrom(targetValueClass) && includeExpressions && (booleanLogicStructure = PopupMenuUtilities.makeBooleanLogicStructure(property.get(), factory, property.getOwner())) != null) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                structure.add(new StringObjectPair("logic", booleanLogicStructure));
            }
            if (Number.class.isAssignableFrom(targetValueClass) && includeExpressions && (mathStructure = PopupMenuUtilities.makeCommonMathQuestionStructure(property.get(), factory, property.getOwner())) != null) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                structure.add(new StringObjectPair("math", mathStructure));
            }
            if (includeOther && GUIFactory.isOtherDialogSupportedForClass(targetValueClass)) {
                if (structure.size() > 0) {
                    structure.add(new StringObjectPair("Separator", JSeparator.class));
                }
                final Class finalOtherValueClass = targetValueClass;
                Runnable runnable = new Runnable(){

                    public void run() {
                        GUIFactory.showOtherPropertyDialog(property, factory, null, finalOtherValueClass);
                    }
                };
                structure.add(new StringObjectPair("other...", runnable));
            }
        }
        if (structure.size() == 0) {
            JLabel label = new JLabel("nothing to choose");
            label.setForeground(Color.gray);
            label.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            structure.add(new StringObjectPair("", label));
        }
        return structure;
    }

    public static Vector makeListQuestionStructure(final Variable listVariable, final PopupItemFactory factory, Class returnValueClass, Element context) {
        String[] desired;
        StringObjectPair[] known;
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        edu.cmu.cs.stage3.alice.core.List list = (edu.cmu.cs.stage3.alice.core.List)listVariable.getValue();
        PopupItemFactory prototypeToItemFactory = new PopupItemFactory(){

            public Object createItem(Object object) {
                ElementPrototype ep = (ElementPrototype)object;
                return factory.createItem(ep.createNewElement());
            }
        };
        if (returnValueClass.isAssignableFrom(list.valueClass.getClassValue())) {
            Runnable firstItemRunnable = new Runnable(){

                public void run() {
                    ItemAtBeginning itemAtBeginning = new ItemAtBeginning();
                    itemAtBeginning.list.set(listVariable);
                    ((Runnable)factory.createItem(itemAtBeginning)).run();
                }
            };
            Runnable lastItemRunnable = new Runnable(){

                public void run() {
                    ItemAtEnd itemAtEnd = new ItemAtEnd();
                    itemAtEnd.list.set(listVariable);
                    ((Runnable)factory.createItem(itemAtEnd)).run();
                }
            };
            Runnable randomItemRunnable = new Runnable(){

                public void run() {
                    ItemAtRandomIndex itemAtRandomIndex = new ItemAtRandomIndex();
                    itemAtRandomIndex.list.set(listVariable);
                    ((Runnable)factory.createItem(itemAtRandomIndex)).run();
                }
            };
            StringObjectPair[] known2 = new StringObjectPair[]{new StringObjectPair("list", listVariable)};
            String[] desired2 = new String[]{"index"};
            ElementPrototype ithPrototype = new ElementPrototype(edu.cmu.cs.stage3.alice.core.question.list.ItemAtIndex.class, known2, desired2);
            Vector ithStructure = PopupMenuUtilities.makePrototypeStructure(ithPrototype, prototypeToItemFactory, context);
            structure.add(new StringObjectPair("first item from list", firstItemRunnable));
            structure.add(new StringObjectPair("last item from list", lastItemRunnable));
            structure.add(new StringObjectPair("random item from list", randomItemRunnable));
            structure.add(new StringObjectPair("ith item from list", ithStructure));
        }
        if (returnValueClass.isAssignableFrom(Boolean.class)) {
            Runnable isEmptyRunnable = new Runnable(){

                public void run() {
                    IsEmpty isEmpty = new IsEmpty();
                    isEmpty.list.set(listVariable);
                    ((Runnable)factory.createItem(isEmpty)).run();
                }
            };
            known = new StringObjectPair[]{new StringObjectPair("list", listVariable)};
            desired = new String[]{"item"};
            ElementPrototype containsPrototype = new ElementPrototype(Contains.class, known, desired);
            Vector containsStructure = PopupMenuUtilities.makePrototypeStructure(containsPrototype, prototypeToItemFactory, context);
            if (structure.size() > 0) {
                structure.add(new StringObjectPair("Separator", JSeparator.class));
            }
            structure.add(new StringObjectPair("is list empty", isEmptyRunnable));
            structure.add(new StringObjectPair("list contains", containsStructure));
        }
        if (returnValueClass.isAssignableFrom(Number.class)) {
            Runnable sizeRunnable = new Runnable(){

                public void run() {
                    Size size = new Size();
                    size.list.set(listVariable);
                    ((Runnable)factory.createItem(size)).run();
                }
            };
            known = new StringObjectPair[]{new StringObjectPair("list", listVariable)};
            desired = new String[]{"item"};
            ElementPrototype firstIndexOfItemPrototype = new ElementPrototype(FirstIndexOfItem.class, known, desired);
            Vector firstIndexOfItemStructure = PopupMenuUtilities.makePrototypeStructure(firstIndexOfItemPrototype, prototypeToItemFactory, context);
            ElementPrototype lastIndexOfItemPrototype = new ElementPrototype(LastIndexOfItem.class, known, desired);
            Vector lastIndexOfItemStructure = PopupMenuUtilities.makePrototypeStructure(lastIndexOfItemPrototype, prototypeToItemFactory, context);
            if (structure.size() > 0) {
                structure.add(new StringObjectPair("Separator", JSeparator.class));
            }
            structure.add(new StringObjectPair("size of list", sizeRunnable));
            structure.add(new StringObjectPair("first index of", firstIndexOfItemStructure));
            structure.add(new StringObjectPair("last index of", lastIndexOfItemStructure));
        }
        return structure;
    }

    public static Vector makeArrayQuestionStructure(final Variable arrayVariable, final PopupItemFactory factory, Class returnValueClass, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        Array array = (Array)arrayVariable.getValue();
        PopupItemFactory prototypeToItemFactory = new PopupItemFactory(){

            public Object createItem(Object object) {
                ElementPrototype ep = (ElementPrototype)object;
                return factory.createItem(ep.createNewElement());
            }
        };
        if (returnValueClass.isAssignableFrom(array.valueClass.getClassValue())) {
            StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("array", arrayVariable)};
            String[] desired = new String[]{"index"};
            ElementPrototype ithPrototype = new ElementPrototype(ItemAtIndex.class, known, desired);
            Vector ithStructure = PopupMenuUtilities.makePrototypeStructure(ithPrototype, prototypeToItemFactory, context);
            structure.add(new StringObjectPair("ith item from array", ithStructure));
        }
        if (returnValueClass.isAssignableFrom(Number.class)) {
            Runnable sizeRunnable = new Runnable(){

                public void run() {
                    edu.cmu.cs.stage3.alice.core.question.array.Size size = new edu.cmu.cs.stage3.alice.core.question.array.Size();
                    size.array.set(arrayVariable);
                    ((Runnable)factory.createItem(size)).run();
                }
            };
            if (structure.size() > 0) {
                structure.add(new StringObjectPair("Separator", JSeparator.class));
            }
            structure.add(new StringObjectPair("size of array", sizeRunnable));
        }
        return structure;
    }

    public static Vector makeCommonMathQuestionStructure(Object firstOperand, PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (!(firstOperand instanceof Number || firstOperand instanceof Expression && Number.class.isAssignableFrom(((Expression)firstOperand).getValueClass()) || firstOperand == null)) {
            throw new IllegalArgumentException("firstOperand must represent a Number");
        }
        String firstOperandRepr = AuthoringToolResources.getReprForValue(firstOperand, false);
        StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("a", firstOperand)};
        String[] desired = new String[]{"b"};
        ElementPrototype addPrototype = new ElementPrototype(NumberAddition.class, known, desired);
        Vector addStructure = PopupMenuUtilities.makePrototypeStructure(addPrototype, factory, context);
        ElementPrototype subtractPrototype = new ElementPrototype(NumberSubtraction.class, known, desired);
        Vector subtractStructure = PopupMenuUtilities.makePrototypeStructure(subtractPrototype, factory, context);
        ElementPrototype multiplyPrototype = new ElementPrototype(NumberMultiplication.class, known, desired);
        Vector multiplyStructure = PopupMenuUtilities.makePrototypeStructure(multiplyPrototype, factory, context);
        ElementPrototype dividePrototype = new ElementPrototype(NumberDivision.class, known, desired);
        Vector divideStructure = PopupMenuUtilities.makePrototypeStructure(dividePrototype, factory, context);
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " +", addStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " -", subtractStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " *", multiplyStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " /", divideStructure));
        return structure;
    }

    public static Vector makeBooleanLogicStructure(Object firstOperand, PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (!(firstOperand instanceof Boolean || firstOperand instanceof Expression && Boolean.class.isAssignableFrom(((Expression)firstOperand).getValueClass()))) {
            if (firstOperand == null) {
                return null;
            }
            throw new IllegalArgumentException("firstOperand must represent a Boolean");
        }
        String firstOperandRepr = AuthoringToolResources.getReprForValue(firstOperand, false);
        StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("a", firstOperand)};
        String[] desired = new String[]{"b"};
        ElementPrototype andPrototype = new ElementPrototype(And.class, known, desired);
        Vector andStructure = PopupMenuUtilities.makePrototypeStructure(andPrototype, factory, context);
        ElementPrototype orPrototype = new ElementPrototype(Or.class, known, desired);
        Vector orStructure = PopupMenuUtilities.makePrototypeStructure(orPrototype, factory, context);
        ElementPrototype notPrototype = new ElementPrototype(Not.class, known, new String[0]);
        Object notItem = factory.createItem(notPrototype);
        ElementPrototype equalPrototype = new ElementPrototype(IsEqualTo.class, known, desired);
        Vector equalStructure = PopupMenuUtilities.makePrototypeStructure(equalPrototype, factory, context);
        ElementPrototype notEqualPrototype = new ElementPrototype(IsNotEqualTo.class, known, desired);
        Vector notEqualStructure = PopupMenuUtilities.makePrototypeStructure(notEqualPrototype, factory, context);
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " and", andStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " or", orStructure));
        structure.add(new StringObjectPair("not " + firstOperandRepr, notItem));
        structure.add(new StringObjectPair("Separator", JSeparator.class));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " ==", equalStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " !=", notEqualStructure));
        return structure;
    }

    public static Vector makeComparatorStructure(Object firstOperand, PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        String firstOperandRepr = AuthoringToolResources.getReprForValue(firstOperand, false);
        StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("a", firstOperand)};
        String[] desired = new String[]{"b"};
        ElementPrototype equalPrototype = new ElementPrototype(IsEqualTo.class, known, desired);
        Vector equalStructure = PopupMenuUtilities.makePrototypeStructure(equalPrototype, factory, context);
        ElementPrototype notEqualPrototype = new ElementPrototype(IsNotEqualTo.class, known, desired);
        Vector notEqualStructure = PopupMenuUtilities.makePrototypeStructure(notEqualPrototype, factory, context);
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " ==", equalStructure));
        structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " !=", notEqualStructure));
        if (firstOperand instanceof Number || firstOperand instanceof Expression && Number.class.isAssignableFrom(((Expression)firstOperand).getValueClass())) {
            ElementPrototype lessThanPrototype = new ElementPrototype(NumberIsLessThan.class, known, desired);
            Vector lessThanStructure = PopupMenuUtilities.makePrototypeStructure(lessThanPrototype, factory, context);
            ElementPrototype greaterThanPrototype = new ElementPrototype(NumberIsGreaterThan.class, known, desired);
            Vector greaterThanStructure = PopupMenuUtilities.makePrototypeStructure(greaterThanPrototype, factory, context);
            ElementPrototype lessThanOrEqualPrototype = new ElementPrototype(NumberIsLessThanOrEqualTo.class, known, desired);
            Vector lessThanOrEqualStructure = PopupMenuUtilities.makePrototypeStructure(lessThanOrEqualPrototype, factory, context);
            ElementPrototype greaterThanOrEqualPrototype = new ElementPrototype(NumberIsGreaterThanOrEqualTo.class, known, desired);
            Vector greaterThanOrEqualStructure = PopupMenuUtilities.makePrototypeStructure(greaterThanOrEqualPrototype, factory, context);
            structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " <", lessThanStructure));
            structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " >", greaterThanStructure));
            structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " <=", lessThanOrEqualStructure));
            structure.add(new StringObjectPair(String.valueOf(firstOperandRepr) + " >=", greaterThanOrEqualStructure));
        }
        return structure;
    }

    public static Vector makeResponsePrintStructure(final PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        final StringObjectPair[] known = new StringObjectPair[]{};
        Runnable textStringRunnable = new Runnable(){

            public void run() {
                ElementPrototype elementPrototype = new ElementPrototype(edu.cmu.cs.stage3.alice.core.response.Print.class, known, new String[]{"text"});
                String text = DialogManager.showInputDialog("Enter text to print:", "Enter Text String", -1);
                if (text != null) {
                    ((Runnable)factory.createItem(elementPrototype.createCopy(new StringObjectPair("text", text)))).run();
                }
            }
        };
        structure.add(new StringObjectPair("text string...", textStringRunnable));
        ElementPrototype elementPrototype = new ElementPrototype(edu.cmu.cs.stage3.alice.core.response.Print.class, known, new String[]{"object"});
        structure.add(new StringObjectPair("object", PopupMenuUtilities.makePrototypeStructure(elementPrototype, factory, context)));
        return structure;
    }

    public static Vector makeQuestionPrintStructure(final PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        final StringObjectPair[] known = new StringObjectPair[]{};
        Runnable textStringRunnable = new Runnable(){

            public void run() {
                ElementPrototype elementPrototype = new ElementPrototype(Print.class, known, new String[]{"text"});
                String text = DialogManager.showInputDialog("Enter text to print:", "Enter Text String", -1);
                if (text != null) {
                    ((Runnable)factory.createItem(elementPrototype.createCopy(new StringObjectPair("text", text)))).run();
                }
            }
        };
        structure.add(new StringObjectPair("text string...", textStringRunnable));
        ElementPrototype elementPrototype = new ElementPrototype(Print.class, known, new String[]{"object"});
        structure.add(new StringObjectPair("object", PopupMenuUtilities.makePrototypeStructure(elementPrototype, factory, context)));
        return structure;
    }

    public static Vector makePropertyValueStructure(Element element, Class valueClass, PopupItemFactory factory, Element context) {
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        Class elementClass = null;
        elementClass = element instanceof Expression ? ((Expression)element).getValueClass() : element.getClass();
        StringObjectPair[] known = new StringObjectPair[]{new StringObjectPair("element", element)};
        String[] desired = new String[]{"propertyName"};
        ElementPrototype prototype = new ElementPrototype(PropertyValue.class, known, desired);
        String[] propertyNames = PopupMenuUtilities.getPropertyNames(elementClass, valueClass);
        String prefix = String.valueOf(AuthoringToolResources.getReprForValue((Object)element, false)) + ".";
        int i = 0;
        while (i < propertyNames.length) {
            if (!propertyNames[i].equals("visualization") && !propertyNames[i].equals("isFirstClass")) {
                String propertyName = AuthoringToolResources.getReprForValue((Object)propertyNames[i], false);
                structure.add(new StringObjectPair(String.valueOf(prefix) + propertyName, factory.createItem(prototype.createCopy(new StringObjectPair("propertyName", propertyName)))));
            }
            ++i;
        }
        return structure;
    }

    private static String[] getPropertyNames(Class elementClass, Class valueClass) {
        try {
            Element element = (Element)elementClass.newInstance();
            Property[] properties = element.getProperties();
            Vector<String> propertyNames = new Vector<String>();
            Property[] propertyArray = properties;
            int n = 0;
            int n2 = propertyArray.length;
            while (n < n2) {
                Property propertie = propertyArray[n];
                if (valueClass.isAssignableFrom(propertie.getValueClass())) {
                    propertyNames.add(propertie.getName());
                }
                ++n;
            }
            return propertyNames.toArray(new String[0]);
        }
        catch (InstantiationException ie) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
    }

    public static Vector getDefaultValueStructureForProperty(Class elementClass, String propertyName) {
        return PopupMenuUtilities.getDefaultValueStructureForProperty(elementClass, propertyName, null);
    }

    public static Vector getDefaultValueStructureForProperty(Property property) {
        return PopupMenuUtilities.getDefaultValueStructureForProperty(property.getOwner().getClass(), property.getName(), property);
    }

    public static Vector getDefaultValueStructureForProperty(Class elementClass, String propertyName, Property property) {
        Vector structure = new Vector(PopupMenuUtilities.getUnlabeledDefaultValueStructureForProperty(elementClass, propertyName, property));
        PopupMenuUtilities.addLabelsToValueStructure(structure, elementClass, propertyName);
        return structure;
    }

    public static Vector getUnlabeledDefaultValueStructureForProperty(Class elementClass, String propertyName, Property property) {
        Vector structure;
        if (property != null) {
            Variable var;
            if (property.getOwner() instanceof PropertyAnimation && property.getName().equals("value")) {
                PropertyAnimation propertyAnimation = (PropertyAnimation)property.getOwner();
                elementClass = propertyAnimation.element.getElementValue().getClass();
                if (propertyAnimation.element.getElementValue() instanceof Variable) {
                    var = (Variable)propertyAnimation.element.getElementValue();
                    elementClass = var.getValueClass();
                }
                propertyName = propertyAnimation.propertyName.getStringValue();
            } else if (property.getOwner() instanceof PropertyAssignment && property.getName().equals("value")) {
                PropertyAssignment propertyAssignment = (PropertyAssignment)property.getOwner();
                elementClass = propertyAssignment.element.getElementValue().getClass();
                if (propertyAssignment.element.getElementValue() instanceof Variable) {
                    var = (Variable)propertyAssignment.element.getElementValue();
                    elementClass = var.getValueClass();
                }
                propertyName = propertyAssignment.propertyName.getStringValue();
            }
        }
        if ((structure = AuthoringToolResources.getDefaultPropertyValues(elementClass, propertyName)) == null) {
            structure = new Vector();
        }
        if (structure.size() < 1) {
            Object otherValue;
            Class valueClass = property != null ? (property.getOwner() instanceof BinaryObjectResultingInBooleanQuestion && (property.getName().equals("a") || property.getName().equals("b")) ? ((otherValue = property.getName().equals("a") ? ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).b.get() : ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).a.get()) instanceof Expression ? ((Expression)otherValue).getValueClass() : (otherValue != null ? otherValue.getClass() : property.getValueClass())) : property.getValueClass()) : Element.getValueClassForPropertyNamed(elementClass, propertyName);
            structure.addAll(PopupMenuUtilities.getUnlabeledDefaultValueStructureForClass(valueClass));
        }
        return structure;
    }

    public static Vector getDefaultValueStructureForCollectionIndexProperty(StringObjectPair[] knownPropertyValues) {
        Object collection = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            StringObjectPair knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("list")) {
                collection = knownPropertyValue.getObject();
                break;
            }
            if (knownPropertyValue.getString().equals("array")) {
                collection = knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        Collection realCollection = null;
        if (collection instanceof Variable) {
            realCollection = (Collection)((Variable)collection).getValue();
        } else if (collection instanceof Collection) {
            realCollection = (Collection)collection;
        }
        Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
        if (realCollection != null) {
            int size = realCollection.values.size();
            int i = 0;
            while (i < size && i < 10) {
                structure.add(new StringObjectPair(Integer.toString(i), new Double(i)));
                ++i;
            }
        }
        if (structure.size() < 1) {
            structure.add(new StringObjectPair("0", new Double(0.0)));
        }
        return structure;
    }

    public static Vector getDefaultValueStructureForClass(Class valueClass) {
        Vector structure = PopupMenuUtilities.getUnlabeledDefaultValueStructureForClass(valueClass);
        PopupMenuUtilities.addLabelsToValueStructure(structure);
        return structure;
    }

    public static Vector getUnlabeledDefaultValueStructureForClass(Class valueClass) {
        Vector<Object> structure = new Vector<Object>();
        if (Boolean.class.isAssignableFrom(valueClass)) {
            structure.add(Boolean.TRUE);
            structure.add(Boolean.FALSE);
        } else if (Number.class.isAssignableFrom(valueClass)) {
            structure.add(new Double(0.25));
            structure.add(new Double(0.5));
            structure.add(new Double(1.0));
            structure.add(new Double(2.0));
        } else if (Enumerable.class.isAssignableFrom(valueClass)) {
            Enumerable[] enuItems;
            Enumerable[] enumerableArray = enuItems = Enumerable.getItems(valueClass);
            int n = 0;
            int n2 = enumerableArray.length;
            while (n < n2) {
                Enumerable enuItem = enumerableArray[n];
                structure.add(enuItem);
                ++n;
            }
        } else if (Style.class.isAssignableFrom(valueClass)) {
            structure.add(TraditionalAnimationStyle.BEGIN_AND_END_GENTLY);
            structure.add(TraditionalAnimationStyle.BEGIN_GENTLY_AND_END_ABRUPTLY);
            structure.add(TraditionalAnimationStyle.BEGIN_ABRUPTLY_AND_END_GENTLY);
            structure.add(TraditionalAnimationStyle.BEGIN_AND_END_ABRUPTLY);
        } else if (String.class.isAssignableFrom(valueClass)) {
            structure.add("default string");
        }
        return structure;
    }

    private static Vector getDefaultValueStructureForPropertyAnimation(StringObjectPair[] knownPropertyValues) {
        StringObjectPair knownPropertyValue;
        Vector structure = new Vector();
        Element element = null;
        String propertyName = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("element")) {
                element = (Element)knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        stringObjectPairArray = knownPropertyValues;
        n = 0;
        n2 = stringObjectPairArray.length;
        while (n < n2) {
            knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("propertyName")) {
                propertyName = (String)knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        if (element != null && propertyName != null) {
            Class elementClass = element.getClass();
            if (element instanceof Expression) {
                elementClass = ((Expression)element).getValueClass();
            }
            structure = PopupMenuUtilities.getDefaultValueStructureForProperty(elementClass, propertyName, element.getPropertyNamed(propertyName));
        }
        return structure;
    }

    private static void addLabelsToValueStructure(Vector structure) {
        ListIterator<StringObjectPair> iter = structure.listIterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof StringObjectPair) {
                StringObjectPair sop = (StringObjectPair)item;
                if (!(sop.getObject() instanceof Vector)) continue;
                PopupMenuUtilities.addLabelsToValueStructure((Vector)sop.getObject());
                continue;
            }
            if (item instanceof Vector) {
                AuthoringTool.showErrorDialog("Unexpected Vector found while processing value structure", null);
                continue;
            }
            String text = AuthoringToolResources.getReprForValue(item);
            iter.set(new StringObjectPair(text, item));
        }
    }

    private static void addLabelsToValueStructure(Vector structure, Class elementClass, String propertyName) {
        ListIterator<StringObjectPair> iter = structure.listIterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof StringObjectPair) {
                StringObjectPair sop = (StringObjectPair)item;
                if (!(sop.getObject() instanceof Vector)) continue;
                PopupMenuUtilities.addLabelsToValueStructure((Vector)sop.getObject(), elementClass, propertyName);
                continue;
            }
            if (item instanceof Vector) {
                AuthoringTool.showErrorDialog("Unexpected Vector found while processing value structure", null);
                continue;
            }
            String text = AuthoringToolResources.getReprForValue(item, elementClass, propertyName, "menuContext");
            iter.set(new StringObjectPair(text, item));
        }
    }

    private static Vector processStructure(Vector structure, PopupItemFactory factory, Object currentValue) {
        Vector<StringObjectPair> processed = new Vector<StringObjectPair>();
        for (Object item : structure) {
            if (item instanceof StringObjectPair) {
                StringObjectPair sop = (StringObjectPair)item;
                if (sop.getObject() instanceof Vector) {
                    processed.add(new StringObjectPair(sop.getString(), PopupMenuUtilities.processStructure((Vector)sop.getObject(), factory, currentValue)));
                    continue;
                }
                if (currentValue == null && sop.getObject() == null || currentValue != null && currentValue.equals(sop.getObject())) {
                    processed.add(new StringObjectPair(sop.getString(), new PopupItemWithIcon(factory.createItem(sop.getObject()), currentValueIcon)));
                    continue;
                }
                processed.add(new StringObjectPair(sop.getString(), factory.createItem(sop.getObject())));
                continue;
            }
            AuthoringTool.showErrorDialog("Unexpected Vector found while processing value structure", null);
        }
        return processed;
    }

    public static boolean structureContains(Vector structure, Object value) {
        for (Object item : structure) {
            StringObjectPair sop;
            if (!(item instanceof StringObjectPair) || !((sop = (StringObjectPair)item).getObject() instanceof Vector ? PopupMenuUtilities.structureContains((Vector)sop.getObject(), value) : (sop.getObject() == null ? value == null : sop.getObject().equals(value)))) continue;
            return true;
        }
        return false;
    }

    private static Class getValueClassForPropertyAnimation(StringObjectPair[] knownPropertyValues) {
        StringObjectPair knownPropertyValue;
        Class valueClass = null;
        Element element = null;
        String propertyName = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("element")) {
                element = (Element)knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        stringObjectPairArray = knownPropertyValues;
        n = 0;
        n2 = stringObjectPairArray.length;
        while (n < n2) {
            knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("propertyName")) {
                propertyName = (String)knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        if (element instanceof Variable && "value".equals(propertyName)) {
            valueClass = ((Variable)element).getValueClass();
        } else if (element != null && propertyName != null) {
            Class elementClass = element.getClass();
            if (element instanceof Expression) {
                elementClass = ((Expression)element).getValueClass();
            }
            valueClass = Element.getValueClassForPropertyNamed(elementClass, propertyName);
        }
        return valueClass;
    }

    private static Class getValueClassForList(StringObjectPair[] knownPropertyValues) {
        Class valueClass = null;
        Object list = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            StringObjectPair knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("list")) {
                list = knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        if (list instanceof Variable) {
            edu.cmu.cs.stage3.alice.core.List realList = (edu.cmu.cs.stage3.alice.core.List)((Variable)list).getValue();
            if (realList != null) {
                valueClass = realList.valueClass.getClassValue();
            }
        } else {
            valueClass = list instanceof edu.cmu.cs.stage3.alice.core.List ? ((edu.cmu.cs.stage3.alice.core.List)list).valueClass.getClassValue() : Object.class;
        }
        return valueClass;
    }

    private static Class getValueClassForArray(StringObjectPair[] knownPropertyValues) {
        Class valueClass = null;
        Object array = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            StringObjectPair knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("array")) {
                array = knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        if (array instanceof Variable) {
            Array realArray = (Array)((Variable)array).getValue();
            valueClass = realArray.valueClass.getClassValue();
        } else {
            valueClass = array instanceof Array ? ((Array)array).valueClass.getClassValue() : Object.class;
        }
        return valueClass;
    }

    private static Class generalizeValueClass(Class valueClass) {
        Class newValueClass = valueClass;
        if (Number.class.isAssignableFrom(valueClass)) {
            newValueClass = Number.class;
        } else if (Model.class.isAssignableFrom(valueClass)) {
            newValueClass = Model.class;
        }
        return newValueClass;
    }

    private static Class getValueClassForComparator(StringObjectPair[] knownPropertyValues) {
        Class<?> valueClass = null;
        Object operand = null;
        StringObjectPair[] stringObjectPairArray = knownPropertyValues;
        int n = 0;
        int n2 = stringObjectPairArray.length;
        while (n < n2) {
            StringObjectPair knownPropertyValue = stringObjectPairArray[n];
            if (knownPropertyValue.getString().equals("a")) {
                operand = knownPropertyValue.getObject();
                break;
            }
            ++n;
        }
        if (operand instanceof Expression) {
            valueClass = ((Expression)operand).getValueClass();
        } else if (operand != null) {
            valueClass = operand.getClass();
        }
        return PopupMenuUtilities.generalizeValueClass(valueClass);
    }

    public static Class getDesiredValueClass(Property property) {
        Class targetValueClass = property.getValueClass();
        if (property.getOwner() instanceof BinaryObjectResultingInBooleanQuestion && (property.getName().equals("a") || property.getName().equals("b"))) {
            Object ourValue;
            Object otherValue;
            if (property.getName().equals("a")) {
                otherValue = ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).b.get();
                ourValue = ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).a.get();
            } else {
                otherValue = ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).a.get();
                ourValue = ((BinaryObjectResultingInBooleanQuestion)property.getOwner()).b.get();
            }
            Class otherValueClass = otherValue instanceof Expression ? ((Expression)otherValue).getValueClass() : (otherValue != null ? otherValue.getClass() : property.getValueClass());
            targetValueClass = ourValue instanceof Expression ? ((Expression)ourValue).getValueClass() : (ourValue != null ? ourValue.getClass() : property.getValueClass());
            if (targetValueClass != otherValueClass) {
                targetValueClass = otherValueClass;
            }
            targetValueClass = PopupMenuUtilities.generalizeValueClass(targetValueClass);
        }
        return targetValueClass;
    }

    public static Vector makeDefaultOneShotStructure(Element element) {
        return PopupMenuUtilities.makeResponseStructure(element, oneShotFactory, element.getRoot());
    }

    public static void ensurePopupIsOnScreen(JPopupMenu popup) {
        Point location = popup.getLocation(null);
        Dimension size = popup.getSize(null);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        screenSize.height -= 28;
        SwingUtilities.convertPointToScreen(location, popup);
        if (location.x < 0) {
            location.x = 0;
        } else if (location.x + size.width > screenSize.width) {
            location.x -= location.x + size.width - screenSize.width;
        }
        if (location.y < 0) {
            location.y = 0;
        } else if (location.y + size.height > screenSize.height) {
            location.y -= location.y + size.height - screenSize.height;
        }
        popup.setLocation(location);
    }
}

