/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.ContextAssignableUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultUndoRedoStack;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;

public class ObjectArrayPropertyUndoableRedoable
implements ContextAssignableUndoableRedoable {
    protected ObjectArrayProperty property;
    protected int changeType;
    protected int oldIndex;
    protected int newIndex;
    protected Object value;
    protected Object context;

    public ObjectArrayPropertyUndoableRedoable(ObjectArrayProperty property, int changeType, int oldIndex, int newIndex, Object value) {
        this.property = property;
        this.changeType = changeType;
        this.oldIndex = oldIndex;
        this.newIndex = newIndex;
        this.value = value;
    }

    public void setContext(Object context) {
        this.context = context;
    }

    public void undo() {
        if (this.changeType == 1) {
            this.property.remove(this.value);
        } else if (this.changeType == 3) {
            this.property.add(this.oldIndex, this.value);
        } else if (this.changeType == 2) {
            this.property.shift(this.newIndex, this.oldIndex);
        }
    }

    public void redo() {
        if (this.changeType == 1) {
            this.property.add(this.newIndex, this.value);
        } else if (this.changeType == 3) {
            this.property.remove(this.value);
        } else if (this.changeType == 2) {
            this.property.shift(this.oldIndex, this.newIndex);
        }
    }

    public Object getAffectedObject() {
        return this.property.getOwner();
    }

    public Object getContext() {
        return this.context;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("edu.cmu.cs.stage3.alice.authoringtool.util.ObjectArrayPropertyUndoableRedoable[ ");
        s.append("property=" + this.property + "; ");
        s.append("changeType=" + this.changeType + "; ");
        s.append("oldIndex=" + this.oldIndex + "; ");
        s.append("newIndex=" + this.newIndex + "; ");
        s.append("value=" + this.value + "; ");
        if (this.context != this && !(this.context instanceof DefaultUndoRedoStack)) {
            s.append("context=" + this.context + "; ");
        } else {
            s.append("context=" + this.context.getClass() + "; ");
        }
        s.append(" ]");
        return s.toString();
    }
}

