/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.DeleteContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class ElementPopupUtilities {
    protected static Class[] elementPopupRunnableParams = new Class[]{Element.class};

    public static void createAndShowElementPopupMenu(Element element, Vector structure, Component component, int x, int y) {
        JPopupMenu popup = ElementPopupUtilities.makeElementPopupMenu(element, structure);
        popup.show(component, x, y);
        PopupMenuUtilities.ensurePopupIsOnScreen(popup);
    }

    @Deprecated
    public static JPopupMenu makeElementPopup(Element element, Vector structure) {
        return ElementPopupUtilities.makeElementPopupMenu(element, structure);
    }

    public static JPopupMenu makeElementPopupMenu(Element element, Vector structure) {
        if (element != null && structure != null) {
            Object[] initArgs = new Object[]{element};
            ElementPopupUtilities.substituteRunnables(initArgs, structure);
            return PopupMenuUtilities.makePopupMenu(structure);
        }
        return null;
    }

    public static void substituteRunnables(Object[] initArgs, Vector structure) {
        ListIterator<StringObjectPair> iter = structure.listIterator();
        while (iter.hasNext()) {
            StringObjectPair newPair;
            ElementPopupRunnable r;
            Object o = iter.next();
            if (o instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)o)) {
                try {
                    r = (ElementPopupRunnable)((Class)o).getConstructor(elementPopupRunnableParams).newInstance(initArgs);
                    newPair = new StringObjectPair(r.getDefaultLabel(), r);
                    iter.set(newPair);
                }
                catch (NoSuchMethodException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (IllegalAccessException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (InstantiationException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (InvocationTargetException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                continue;
            }
            if (o instanceof ElementPopupRunnable) {
                r = (ElementPopupRunnable)o;
                newPair = new StringObjectPair(r.getDefaultLabel(), r);
                iter.set(newPair);
                continue;
            }
            if (!(o instanceof StringObjectPair)) continue;
            StringObjectPair pair = (StringObjectPair)o;
            if (pair.getObject() instanceof Class && ElementPopupRunnable.class.isAssignableFrom((Class)pair.getObject())) {
                try {
                    newPair = new StringObjectPair(pair.getString(), ((Class)pair.getObject()).getConstructor(elementPopupRunnableParams).newInstance(initArgs));
                    iter.set(newPair);
                }
                catch (NoSuchMethodException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (IllegalAccessException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (InstantiationException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                catch (InvocationTargetException e) {
                    AuthoringTool.showErrorDialog("Error building popup.", e);
                }
                continue;
            }
            if (!(pair.getObject() instanceof Vector)) continue;
            ElementPopupUtilities.substituteRunnables(initArgs, (Vector)pair.getObject());
        }
    }

    public static Vector makeCoerceToStructure(final Element element) {
        if (element != null && element.isCoercionSupported()) {
            Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
            Vector<StringObjectPair> subStructure = new Vector<StringObjectPair>();
            Class[] classes = element.getSupportedCoercionClasses();
            if (classes != null) {
                Class[] classArray = classes;
                int n = 0;
                int n2 = classArray.length;
                while (n < n2) {
                    final Class c = classArray[n];
                    String repr = AuthoringToolResources.getReprForValue(c);
                    Runnable runnable = new Runnable(){

                        public void run() {
                            AuthoringTool.getHack().getUndoRedoStack().startCompound();
                            element.coerceTo(c);
                            AuthoringTool.getHack().getUndoRedoStack().stopCompound();
                        }
                    };
                    subStructure.add(new StringObjectPair(repr, runnable));
                    ++n;
                }
                if (subStructure.size() > 0) {
                    structure.add(new StringObjectPair("change to", subStructure));
                    return structure;
                }
                return null;
            }
        }
        return null;
    }

    public static Vector getDefaultStructure(Element element) {
        return ElementPopupUtilities.getDefaultStructure(element, true, null, null, null);
    }

    public static Vector getDefaultStructure(Element element, boolean elementEnabled, AuthoringTool authoringTool, JTree jtree, TreePath treePath) {
        if (element instanceof Response) {
            return ElementPopupUtilities.getDefaultResponseStructure((Response)element);
        }
        if (element instanceof Question) {
            return ElementPopupUtilities.getDefaultQuestionStructure((Question)element);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            return ElementPopupUtilities.getDefaultCharacterStructure(element, elementEnabled, authoringTool, jtree, treePath);
        }
        if (element instanceof World) {
            return ElementPopupUtilities.getDefaultWorldStructure((World)element);
        }
        return ElementPopupUtilities.getDefaultElementStructure(element, jtree, treePath);
    }

    public static Vector getDefaultCharacterStructure(Element element, boolean elementEnabled, AuthoringTool authoringTool, JTree jtree, TreePath treePath) {
        Vector<Object> popupStructure = new Vector<Object>();
        popupStructure.add(new StringObjectPair(AuthoringToolResources.getReprForValue(element), null));
        popupStructure.add(new StringObjectPair("separator", JSeparator.class));
        if (elementEnabled) {
            popupStructure.add(new StringObjectPair("methods", PopupMenuUtilities.makeDefaultOneShotStructure(element)));
        }
        if (jtree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jtree, treePath);
            popupStructure.add(renameRunnable);
        }
        if (AuthoringToolResources.characterCriterion.accept(element)) {
            popupStructure.add(DeleteRunnable.class);
            popupStructure.add(SaveCharacterRunnable.class);
        } else {
            popupStructure.add(DeleteRunnable.class);
        }
        return popupStructure;
    }

    public static Vector getDefaultWorldStructure(World world) {
        Vector popupStructure = new Vector();
        return popupStructure;
    }

    public static Vector getDefaultResponseStructure(Response response) {
        Vector<Class<ToggleCommentingRunnable>> structure = new Vector<Class<ToggleCommentingRunnable>>();
        structure.add(MakeCopyRunnable.class);
        structure.add(DeleteRunnable.class);
        structure.add(ToggleCommentingRunnable.class);
        Vector coerceToStructure = ElementPopupUtilities.makeCoerceToStructure(response);
        if (coerceToStructure != null) {
            structure.addAll(coerceToStructure);
        }
        return structure;
    }

    public static Vector getDefaultQuestionStructure(Question question) {
        Vector<Class> structure = new Vector<Class>();
        structure.add(MakeCopyRunnable.class);
        structure.add(DeleteRunnable.class);
        Vector coerceToStructure = ElementPopupUtilities.makeCoerceToStructure(question);
        if (coerceToStructure != null) {
            structure.addAll(coerceToStructure);
        }
        return structure;
    }

    public static Vector getDefaultElementStructure(Element element, JTree jtree, TreePath treePath) {
        Vector<Object> structure = new Vector<Object>();
        if (jtree != null && treePath != null) {
            RenameRunnable renameRunnable = new RenameRunnable(element, jtree, treePath);
            structure.add(renameRunnable);
        }
        structure.add(DeleteRunnable.class);
        return structure;
    }

    public static abstract class ElementPopupRunnable
    implements Runnable {
        protected Element element;

        protected ElementPopupRunnable(Element element) {
            this.element = element;
        }

        public Element getElement() {
            return this.element;
        }

        public abstract String getDefaultLabel();
    }

    public static class DeleteRunnable
    extends ElementPopupRunnable {
        public static final Criterion namedHeadCriterion = new Criterion(){

            public boolean accept(Object o) {
                return o instanceof Transformable && "head".equalsIgnoreCase(((Transformable)o).name.getStringValue());
            }
        };
        protected AuthoringTool authoringTool;

        public DeleteRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "delete";
        }

        public void run() {
            PropertyReference[] references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (references.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(references);
                references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (references.length > 0) {
                PropertyReference[] propertyReferenceArray = references;
                int n = 0;
                int n2 = propertyReferenceArray.length;
                while (n < n2) {
                    PropertyReference reference = propertyReferenceArray[n];
                    Element refReferenceI = reference.getReference();
                    Property refPropertyI = reference.getProperty();
                    Element refOwnerI = refPropertyI.getOwner();
                    if (reference.getProperty().isAlsoKnownAs(Model.class, "geometry") && refOwnerI instanceof Model) {
                        refReferenceI.setParent(refOwnerI);
                    }
                    ++n;
                }
                references = this.element.getRoot().getPropertyReferencesTo(this.element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            if (references.length > 0) {
                DeleteContentPane.showDeleteDialog(this, this.authoringTool);
            } else {
                Element parent;
                AuthoringTool.getHack().getUndoRedoStack().startCompound();
                if (this.element instanceof Transformable) {
                    boolean cfr_ignored_0 = this.element instanceof Model;
                }
                if ((parent = this.element.getParent()) != null) {
                    Property[] properties;
                    Property[] propertyArray = properties = parent.getProperties();
                    int n = 0;
                    int n3 = propertyArray.length;
                    while (n < n3) {
                        Property propertie = propertyArray[n];
                        if (propertie.get() == this.element) {
                            propertie.set(AuthoringToolResources.getDefaultValueForClass(propertie.getValueClass()));
                        } else if (propertie instanceof ObjectArrayProperty) {
                            ObjectArrayProperty oap = (ObjectArrayProperty)propertie;
                            int j = 0;
                            while (j < oap.size()) {
                                if (oap.get(j) == this.element) {
                                    oap.remove(j);
                                    continue;
                                }
                                ++j;
                            }
                        }
                        ++n;
                    }
                    parent.removeChild(this.element);
                }
                AuthoringTool.getHack().getUndoRedoStack().stopCompound();
            }
        }
    }

    public static class RenameRunnable
    extends ElementPopupRunnable {
        private JTree jtree;
        private TreePath treePath;

        public RenameRunnable(Element element, JTree jtree, TreePath treePath) {
            super(element);
            this.jtree = jtree;
            this.treePath = treePath;
        }

        public String getDefaultLabel() {
            return "rename";
        }

        public void run() {
            this.jtree.startEditingAtPath(this.treePath);
        }
    }

    public static class MakeCopyRunnable
    extends ElementPopupRunnable {
        public MakeCopyRunnable(Element element) {
            super(element);
        }

        public String getDefaultLabel() {
            return "make copy";
        }

        public void run() {
            AuthoringTool.getHack().getUndoRedoStack().startCompound();
            String name = AuthoringToolResources.getNameForNewChild(this.element.name.getStringValue(), this.element.getParent());
            if (this.element.getParent() instanceof CompositeResponse) {
                int index = ((CompositeResponse)this.element.getParent()).componentResponses.indexOf(this.element);
                Element copy = this.element.HACK_createCopy(name, this.element.getParent(), index + 1, null, null);
                ((CompositeResponse)this.element.getParent()).componentResponses.add(index + 1, copy);
            } else if (this.element.getParent() instanceof Composite) {
                int index = ((Composite)this.element.getParent()).components.indexOf(this.element);
                Element copy = this.element.HACK_createCopy(name, this.element.getParent(), index + 1, null, null);
                ((Composite)this.element.getParent()).components.add(index + 1, copy);
            } else {
                Element copy = this.element.createCopyNamed(name);
                AuthoringToolResources.addElementToAppropriateProperty(copy, copy.getParent());
            }
            AuthoringTool.getHack().getUndoRedoStack().stopCompound();
        }
    }

    public static class SaveCharacterRunnable
    extends ElementPopupRunnable {
        protected AuthoringTool authoringTool;

        public SaveCharacterRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "save object...";
        }

        public void run() {
        }
    }

    public static class ToggleCommentingRunnable
    extends ElementPopupRunnable {
        public ToggleCommentingRunnable(Element element) {
            super(element);
            if (!(element instanceof Code)) {
                throw new IllegalArgumentException("ToggleCommentRunnable only accepts Responses or User-Defined Questions; found: " + element);
            }
        }

        public String getDefaultLabel() {
            return "disable";
        }

        public void run() {
        }
    }

    public static class SetElementScopeRunnable
    extends ElementPopupRunnable {
        private AuthoringTool authoringTool;

        public SetElementScopeRunnable(Element element, AuthoringTool authoringTool) {
            super(element);
            this.authoringTool = authoringTool;
        }

        public String getDefaultLabel() {
            return "switch to this element's scope";
        }

        public void run() {
            this.authoringTool.setElementScope(this.element);
        }
    }

    public static class SortGroupAlphabeticallyRunnable
    extends ElementPopupRunnable {
        protected Comparator sorter = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Element && o2 instanceof Element) {
                    String name1 = ((Element)o1).name.getStringValue();
                    String name2 = ((Element)o2).name.getStringValue();
                    return name1.compareTo(name2);
                }
                return 0;
            }
        };

        public SortGroupAlphabeticallyRunnable(Element element) {
            super(element);
        }

        public String getDefaultLabel() {
            return "sort alphabetically";
        }

        public void run() {
        }
    }
}

