/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.questioneditor.QuestionEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.responseeditor.ResponseEditor;
import java.lang.reflect.Method;

public final class EditorUtilities {
    private static Class[] allEditors = new Class[]{ResponseEditor.class, QuestionEditor.class};

    public static Editor getEditorFromClass(Class editorClass) {
        try {
            return (Editor)editorClass.newInstance();
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Error creating new editor of type " + editorClass, t);
            return null;
        }
    }

    public static Method getSetMethodFromClass(Class editorClass) {
        Method[] methods;
        Method[] methodArray = methods = editorClass.getMethods();
        int n = 0;
        int n2 = methodArray.length;
        while (n < n2) {
            Class<?>[] parameterTypes;
            Method potentialMethod = methodArray[n];
            if (potentialMethod.getName().equals("setObject") && (parameterTypes = potentialMethod.getParameterTypes()).length == 1 && Object.class.isAssignableFrom(parameterTypes[0])) {
                return potentialMethod;
            }
            ++n;
        }
        return null;
    }

    public static Class getObjectParameter(Class editorClass) {
        Method setObject = EditorUtilities.getSetMethodFromClass(editorClass);
        if (setObject != null) {
            return setObject.getParameterTypes()[0];
        }
        return null;
    }

    public static Class getBestEditor(Class objectClass) {
        Class bestEditor = null;
        int bestDepth = Integer.MAX_VALUE;
        Class[] classArray = allEditors;
        int n = 0;
        int n2 = classArray.length;
        while (n < n2) {
            int depth;
            Class<?>[] parameterTypes;
            Class editorClass = classArray[n];
            Method setObject = EditorUtilities.getSetMethodFromClass(editorClass);
            if (setObject != null && (parameterTypes = setObject.getParameterTypes()).length == 1 && (depth = EditorUtilities.getObjectClassDepth(parameterTypes[0], objectClass)) < bestDepth && depth >= 0) {
                bestDepth = depth;
                bestEditor = editorClass;
            }
            ++n;
        }
        return bestEditor;
    }

    public static void editObject(Editor editor, Object object) {
        Method setObject = EditorUtilities.getSetMethodFromClass(editor.getClass());
        try {
            setObject.invoke((Object)editor, object);
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog("Error editing object: " + object, e);
        }
    }

    private static int getObjectClassDepth(Class superclass, Class subclass) {
        if (!superclass.isAssignableFrom(subclass)) {
            return -1;
        }
        Class temp = subclass;
        int i = 0;
        while (temp != superclass && superclass.isAssignableFrom(temp)) {
            ++i;
            temp = temp.getSuperclass();
        }
        return i;
    }
}

