/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementEditor;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.CompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.VariableProperty;
import edu.cmu.cs.stage3.alice.core.question.userdefined.Composite;
import edu.cmu.cs.stage3.alice.core.question.userdefined.LoopN;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class LoopNElementPanel
extends CompositeElementPanel
implements ObjectArrayPropertyListener {
    private JLabel timesLabel;
    protected JComponent endInput;
    protected JComponent countInput;
    protected JComponent startInput;
    protected JComponent incrementInput;
    protected JComponent indexTile;
    protected NumberProperty m_start;
    protected NumberProperty m_increment;
    protected NumberProperty m_end;
    protected VariableProperty m_index;
    protected JLabel fromLabel;
    protected JLabel upToLabel;
    protected JLabel incrementLabel;
    protected JPanel complicatedPanel;
    protected JPanel simplePanel;
    protected JLabel complicatedEndBrace;
    protected JButton switchButton;
    protected String toComplicatedString = "show complicated version";
    protected String toSimpleString = "show simple version";
    protected boolean isComplicated = false;
    protected static String IS_COMPLICATED_LOOP_KEY = "edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor IS_COMPLICATED_LOOP_KEY";
    protected static BufferedImage countLoopBackgroundImage;
    protected static Dimension countLoopBackgroundImageSize;

    static {
        countLoopBackgroundImageSize = new Dimension(-1, -1);
    }

    public LoopNElementPanel() {
        this.headerText = "For";
        this.backgroundColor = AuthoringToolResources.getColor("LoopNInOrder");
    }

    protected int countPreviousInstances(Component parent, Object toCheck) {
        if (parent == null) {
            return 0;
        }
        if (parent instanceof LoopNElementPanel) {
            return this.countPreviousInstances(parent.getParent(), toCheck) + 1;
        }
        return 0;
    }

    protected String getIndexName() {
        String toReturn = "index";
        int count = this.countPreviousInstances(this.getParent(), this);
        if (count > 0) {
            toReturn = String.valueOf(toReturn) + String.valueOf(count);
        }
        return toReturn;
    }

    protected void variableInit() {
        Code proxy;
        super.variableInit();
        if (this.m_element instanceof LoopNInOrder) {
            proxy = (LoopNInOrder)this.m_element;
            this.m_end = proxy.end;
            this.m_start = proxy.start;
            this.m_increment = proxy.increment;
            this.m_index = proxy.index;
            Variable v = (Variable)this.m_index.getValue();
            v.name.set(this.getIndexName());
        } else if (this.m_element instanceof LoopN) {
            proxy = (LoopN)this.m_element;
            this.m_end = ((LoopN)proxy).end;
            this.m_start = ((LoopN)proxy).start;
            this.m_increment = ((LoopN)proxy).increment;
            this.m_index = ((LoopN)proxy).index;
        }
        Object isComplicatedValue = this.m_element.data.get(IS_COMPLICATED_LOOP_KEY);
        if (isComplicatedValue instanceof Boolean) {
            this.isComplicated = (Boolean)isComplicatedValue;
        }
        if (this.isComplicated) {
            this.switchButton.setText(this.toSimpleString);
        } else {
            this.switchButton.setText(this.toComplicatedString);
        }
    }

    protected void startListening() {
        super.startListening();
        if (this.m_end != null) {
            this.m_end.addPropertyListener(this);
        }
        this.listenToChildren(this.m_components);
    }

    protected void stopListening() {
        super.stopListening();
        if (this.m_end != null) {
            this.m_end.removePropertyListener(this);
        }
        this.stopListenToChildren(this.m_components);
    }

    protected void listenToChildren(ObjectArrayProperty components) {
        if (components != null) {
            components.addObjectArrayPropertyListener(this);
            int i = 0;
            while (i < components.size()) {
                Code current;
                if (components.get(i) instanceof CompositeResponse) {
                    current = (CompositeResponse)components.get(i);
                    this.listenToChildren(current.componentResponses);
                } else if (components.get(i) instanceof Composite) {
                    current = (Composite)components.get(i);
                    this.listenToChildren(((Composite)current).components);
                }
                ++i;
            }
        }
    }

    protected void stopListenToChildren(ObjectArrayProperty components) {
        if (components != null) {
            components.removeObjectArrayPropertyListener(this);
            int i = 0;
            while (i < components.size()) {
                Code current;
                if (components.get(i) instanceof CompositeResponse) {
                    current = (CompositeResponse)components.get(i);
                    this.stopListenToChildren(current.componentResponses);
                } else if (components.get(i) instanceof Composite) {
                    current = (Composite)components.get(i);
                    this.stopListenToChildren(((Composite)current).components);
                }
                ++i;
            }
        }
    }

    protected void removeAllListening() {
        super.removeAllListening();
        this.removeDragSourceComponent(this.timesLabel);
        this.removeDragSourceComponent(this.complicatedPanel);
        this.removeDragSourceComponent(this.simplePanel);
        this.removeDragSourceComponent(this.fromLabel);
        this.removeDragSourceComponent(this.upToLabel);
        this.removeDragSourceComponent(this.incrementLabel);
        this.removeDragSourceComponent(this.complicatedEndBrace);
    }

    protected void setDropTargets() {
        super.setDropTargets();
        this.timesLabel.setDropTarget(new DropTarget(this.timesLabel, this.componentElementPanel));
        this.complicatedPanel.setDropTarget(new DropTarget(this.complicatedPanel, this.componentElementPanel));
        this.simplePanel.setDropTarget(new DropTarget(this.simplePanel, this.componentElementPanel));
        this.fromLabel.setDropTarget(new DropTarget(this.fromLabel, this.componentElementPanel));
        this.upToLabel.setDropTarget(new DropTarget(this.upToLabel, this.componentElementPanel));
        this.complicatedEndBrace.setDropTarget(new DropTarget(this.complicatedEndBrace, this.componentElementPanel));
        this.incrementLabel.setDropTarget(new DropTarget(this.incrementLabel, this.componentElementPanel));
        this.indexTile.setDropTarget(new DropTarget(this.indexTile, this.componentElementPanel));
    }

    public void setHeaderLabel() {
        if (this.headerLabel != null) {
            this.headerLabel.setText(this.headerText);
            if (CompositeElementEditor.IS_JAVA) {
                if (this.isComplicated) {
                    this.headerLabel.setText("for (int");
                } else {
                    int start = 0;
                    if (this.m_start != null) {
                        start = this.m_start.intValue();
                    }
                    this.headerLabel.setText("for (int " + this.getIndexName() + "=" + start + "; " + this.getIndexName() + "<");
                }
            }
        }
        if (this.timesLabel != null) {
            if (this.m_end.getNumberValue() != null && this.m_end.getNumberValue().intValue() == 1) {
                this.timesLabel.setText("time");
            } else {
                this.timesLabel.setText("times");
            }
            if (CompositeElementEditor.IS_JAVA) {
                int increment = 1;
                if (this.m_increment != null) {
                    increment = this.m_increment.intValue();
                }
                if (!this.isExpanded) {
                    if (increment == 1) {
                        this.timesLabel.setText("; " + this.getIndexName() + "++) { " + this.getDots() + " }");
                    } else {
                        this.timesLabel.setText("; " + this.getIndexName() + "+=" + increment + ") { " + this.getDots() + " }");
                    }
                } else if (increment == 1) {
                    this.timesLabel.setText("; " + this.getIndexName() + "++) {");
                } else {
                    this.timesLabel.setText("; " + this.getIndexName() + "+=" + increment + ") {");
                }
            }
        }
        if (this.fromLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.fromLabel.setText("=");
            } else {
                this.fromLabel.setText("from");
            }
        }
        if (this.upToLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.upToLabel.setText("; " + this.getIndexName() + "<");
            } else {
                this.upToLabel.setText("up to (but not including)");
            }
        }
        if (this.incrementLabel != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.incrementLabel.setText("; " + this.getIndexName() + " +=");
            } else {
                this.incrementLabel.setText("incrementing by");
            }
        }
        if (this.complicatedEndBrace != null) {
            if (CompositeElementEditor.IS_JAVA) {
                this.complicatedEndBrace.setText("){");
            } else {
                this.complicatedEndBrace.setText("");
            }
        }
    }

    protected void generateGUI() {
        super.generateGUI();
        this.timesLabel = new JLabel();
        this.fromLabel = new JLabel();
        this.upToLabel = new JLabel();
        this.incrementLabel = new JLabel();
        this.complicatedEndBrace = new JLabel();
        this.complicatedPanel = new JPanel();
        this.complicatedPanel.setOpaque(false);
        this.complicatedPanel.setBorder(null);
        this.complicatedPanel.setLayout(new GridBagLayout());
        this.simplePanel = new JPanel();
        this.simplePanel.setOpaque(false);
        this.simplePanel.setBorder(null);
        this.simplePanel.setLayout(new GridBagLayout());
        this.switchButton = new JButton();
        this.switchButton.setPreferredSize(new Dimension(180, 21));
        this.switchButton.setBackground(new Color(240, 240, 255));
        this.switchButton.setMargin(new Insets(2, 2, 2, 2));
        this.switchButton.setForeground(new Color(90, 110, 110));
        this.switchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LoopNElementPanel.this.isComplicated) {
                    LoopNElementPanel.this.isComplicated = false;
                    LoopNElementPanel.this.switchButton.setText(LoopNElementPanel.this.toComplicatedString);
                    LoopNElementPanel.this.m_element.data.put(IS_COMPLICATED_LOOP_KEY, Boolean.FALSE);
                } else {
                    LoopNElementPanel.this.isComplicated = true;
                    LoopNElementPanel.this.switchButton.setText(LoopNElementPanel.this.toSimpleString);
                    LoopNElementPanel.this.m_element.data.put(IS_COMPLICATED_LOOP_KEY, Boolean.TRUE);
                }
                LoopNElementPanel.this.updateGUI();
            }
        });
    }

    protected void restoreDrag() {
        super.restoreDrag();
        this.addDragSourceComponent(this.timesLabel);
        this.addDragSourceComponent(this.complicatedPanel);
        this.addDragSourceComponent(this.simplePanel);
        this.addDragSourceComponent(this.fromLabel);
        this.addDragSourceComponent(this.upToLabel);
        this.addDragSourceComponent(this.complicatedEndBrace);
        this.addDragSourceComponent(this.incrementLabel);
    }

    protected void updateName() {
        Variable v = (Variable)this.m_index.getValue();
        v.name.set(this.getIndexName());
        this.complicatedPanel.remove(this.indexTile);
        this.indexTile = GUIFactory.getVariableDnDPanel((Variable)this.m_index.get());
        this.complicatedPanel.add((Component)this.indexTile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
    }

    protected boolean isTopOccurrance(Element parent) {
        if (parent == null) {
            return true;
        }
        if (parent instanceof LoopN) {
            return false;
        }
        if (parent instanceof LoopNInOrder) {
            return false;
        }
        return this.isTopOccurrance(parent.getParent());
    }

    public void objectArrayPropertyChanging(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
    }

    protected void setAllNames(ObjectArrayProperty currentContainer, int currentLevel) {
        String baseName = "index";
        int i = 0;
        while (i < currentContainer.size()) {
            Element var = null;
            if (currentContainer.get(i) instanceof LoopNInOrder) {
                var = (Element)((LoopNInOrder)currentContainer.get((int)i)).index.get();
            } else if (currentContainer.get(i) instanceof LoopN) {
                var = (Element)((LoopN)currentContainer.get((int)i)).index.get();
            }
            if (var != null) {
                var.name.set(String.valueOf(baseName) + "_#" + currentLevel);
            }
            if (currentContainer.get(i) instanceof CompositeResponse) {
                this.setAllNames(((CompositeResponse)currentContainer.get((int)i)).componentResponses, currentLevel + 1);
            } else if (currentContainer.get(i) instanceof Composite) {
                this.setAllNames(((Composite)currentContainer.get((int)i)).components, currentLevel + 1);
            }
            ++i;
        }
    }

    public void objectArrayPropertyChanged(ObjectArrayPropertyEvent objectArrayPropertyEvent) {
        this.stopListening();
        this.startListening();
        if (this.isTopOccurrance(this.m_element.getParent())) {
            Variable v = (Variable)this.m_index.getValue();
            v.name.set("index");
            this.setAllNames(this.m_components, 2);
        }
    }

    protected void updateGUI() {
        super.updateGUI();
        SetPropertyImmediatelyFactory pifCount = new SetPropertyImmediatelyFactory(this.m_end);
        this.countInput = GUIFactory.getPropertyViewController(this.m_end, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_end), pifCount);
        SetPropertyImmediatelyFactory pifstart = new SetPropertyImmediatelyFactory(this.m_start);
        this.startInput = GUIFactory.getPropertyViewController(this.m_start, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_start), pifstart);
        SetPropertyImmediatelyFactory pifInc = new SetPropertyImmediatelyFactory(this.m_increment);
        this.incrementInput = GUIFactory.getPropertyViewController(this.m_increment, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_increment), pifInc);
        SetPropertyImmediatelyFactory pifEnd = new SetPropertyImmediatelyFactory(this.m_end);
        this.endInput = GUIFactory.getPropertyViewController(this.m_end, true, true, AuthoringToolResources.shouldGUIOmitPropertyName(this.m_end), pifEnd);
        this.indexTile = GUIFactory.getVariableDnDPanel((Variable)this.m_index.get());
        this.setHeaderLabel();
        this.complicatedPanel.removeAll();
        this.complicatedPanel.add((Component)this.indexTile, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.fromLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.startInput, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.upToLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.endInput, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.incrementLabel, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.incrementInput, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.complicatedPanel.add((Component)this.complicatedEndBrace, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.simplePanel.removeAll();
        this.simplePanel.add((Component)this.countInput, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.simplePanel.add((Component)this.timesLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
        this.headerPanel.remove(this.glue);
        if (this.isComplicated) {
            this.headerPanel.add((Component)this.complicatedPanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        } else {
            this.headerPanel.add((Component)this.simplePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 2, 0, 2), 0, 0));
        }
        this.headerPanel.add((Component)this.switchButton, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 2), 0, 0));
        this.headerPanel.add(this.glue, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createBackgroundImage(int width, int height) {
        countLoopBackgroundImageSize.setSize(width, height);
        countLoopBackgroundImage = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)countLoopBackgroundImage.getGraphics();
        g.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, width, height);
    }
}

