/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.EditorManager;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceTabbedPaneUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedEditorComponent
extends JPanel {
    protected AuthoringTool authoringTool;
    protected EditorManager editorManager;
    protected EditorDropTargetListener editorDropTargetListener = new EditorDropTargetListener();
    protected HashMap componentsToEditors = new HashMap();
    protected RightClickListener rightClickListener = new RightClickListener();
    protected NameListener nameListener = new NameListener();
    protected DeletionListener deletionListener = new DeletionListener();
    protected Runnable closeAllTabsRunnable = new Runnable(){

        public void run() {
            TabbedEditorComponent.this.closeAllTabs();
        }
    };
    JTabbedPane tabbedPane = new JTabbedPane();
    BorderLayout borderLayout1 = new BorderLayout();

    public TabbedEditorComponent(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.editorManager = authoringTool.getEditorManager();
        this.jbInit();
        this.guiInit();
    }

    private void guiInit() {
        this.tabbedPane.setUI(new AliceTabbedPaneUI());
        this.setDropTarget(new DropTarget(this, this.editorDropTargetListener));
        this.tabbedPane.setDropTarget(new DropTarget(this.tabbedPane, this.editorDropTargetListener));
        this.tabbedPane.addMouseListener(this.rightClickListener);
        int fontSize = 12;
        this.tabbedPane.setFont(new Font("SansSerif", 0, (int)(16.0 * ((double)fontSize / 12.0))));
    }

    public void setWorld(World world) {
        this.stopListeningToTree(world);
        this.closeAllTabs();
        if (world != null) {
            this.startListeningToTree(world);
        }
    }

    public void editObject(Object object, Class editorClass, boolean switchToNewTab) {
        if (object == null || editorClass == null) {
            this.closeAllTabs();
        } else if (!this.isObjectBeingEdited(object)) {
            Editor editor = this.editorManager.getEditorInstance(editorClass);
            if (editor != null) {
                this.componentsToEditors.put(editor.getJComponent(), editor);
                EditorUtilities.editObject(editor, object);
                String repr = AuthoringToolResources.getReprForValue(object, true);
                Object iconObject = object;
                if (object instanceof UserDefinedQuestion) {
                    UserDefinedQuestion udq = (UserDefinedQuestion)object;
                    if (List.class.isAssignableFrom(udq.getValueClass())) {
                        List list = (List)udq.getValue();
                        iconObject = "types/lists/" + list.valueClass.getClassValue().getName();
                    } else {
                        iconObject = "types/" + udq.getValueClass().getName();
                    }
                }
                ImageIcon icon = AuthoringToolResources.getIconForValue(iconObject);
                this.tabbedPane.addTab(repr, icon, editor.getJComponent());
                if (switchToNewTab) {
                    this.tabbedPane.setSelectedComponent(editor.getJComponent());
                    this.tabbedPane.getSelectedComponent().setVisible(true);
                }
                if (object instanceof Element) {
                    ((Element)object).name.addPropertyListener(this.nameListener);
                }
                this.authoringTool.saveTabs();
            } else {
                AuthoringTool.showErrorDialog("failed to create editor for " + object + ", " + editorClass, null);
            }
        } else if (switchToNewTab) {
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                Editor editor;
                Component component = this.tabbedPane.getComponentAt(i);
                if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null && editor.getObject() == object) {
                    this.tabbedPane.setSelectedIndex(i);
                    this.tabbedPane.getSelectedComponent().setVisible(true);
                    break;
                }
                ++i;
            }
        }
    }

    public Object getObjectBeingEdited() {
        Editor editor;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null) {
            return editor.getObject();
        }
        return null;
    }

    public Object getObjectBeingEditedAt(int index) {
        Editor editor;
        Component component = this.tabbedPane.getComponentAt(index);
        if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null) {
            return editor.getObject();
        }
        return null;
    }

    public Object[] getObjectsBeingEdited() {
        Component[] components = this.tabbedPane.getComponents();
        if (components != null) {
            ArrayList<Object> objects = new ArrayList<Object>();
            Component[] componentArray = components;
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component component2 = componentArray[n];
                Editor editor = (Editor)this.componentsToEditors.get(component2);
                if (editor != null) {
                    objects.add(editor.getObject());
                }
                ++n;
            }
            return objects.toArray();
        }
        return null;
    }

    public Editor getCurrentEditor() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null) {
            return (Editor)this.componentsToEditors.get(component);
        }
        return null;
    }

    public Editor[] getEditors() {
        Component[] components = this.tabbedPane.getComponents();
        if (components != null) {
            ArrayList<Editor> editors = new ArrayList<Editor>();
            Component[] componentArray = components;
            int n = 0;
            int n2 = componentArray.length;
            while (n < n2) {
                Component component2 = componentArray[n];
                Editor editor = (Editor)this.componentsToEditors.get(component2);
                if (editor != null) {
                    editors.add(editor);
                }
                ++n;
            }
            return editors.toArray(new Editor[0]);
        }
        return null;
    }

    public void closeTab(int index) {
        Component component = this.tabbedPane.getComponentAt(index);
        if (component != null) {
            Editor editor = (Editor)this.componentsToEditors.get(component);
            if (editor != null) {
                Object object = editor.getObject();
                this.tabbedPane.removeTabAt(index);
                EditorUtilities.editObject(editor, null);
                this.editorManager.releaseEditorInstance(editor);
                this.componentsToEditors.remove(component);
                if (object instanceof Element && !this.isObjectBeingEdited(object)) {
                    ((Element)object).name.removePropertyListener(this.nameListener);
                }
                this.authoringTool.saveTabs();
            }
        } else {
            AuthoringTool.showErrorDialog("no editor to close at " + index, null);
        }
    }

    public void closeAllTabs() {
        while (this.tabbedPane.getTabCount() > 0) {
            this.closeTab(0);
        }
    }

    public boolean isObjectBeingEdited(Object o) {
        int i = 0;
        while (i < this.tabbedPane.getTabCount()) {
            Editor editor;
            Component component = this.tabbedPane.getComponentAt(i);
            if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null && editor.getObject() == o) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void startListeningToTree(Element element) {
        if (element != null) {
            Element[] descendants;
            Element[] elementArray = descendants = element.getDescendants();
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Element descendant = elementArray[n];
                descendant.addChildrenListener(this.deletionListener);
                ++n;
            }
        }
    }

    protected void stopListeningToTree(Element element) {
        if (element != null) {
            Element[] descendants;
            Element[] elementArray = descendants = element.getDescendants();
            int n = 0;
            int n2 = elementArray.length;
            while (n < n2) {
                Element descendant = elementArray[n];
                descendant.removeChildrenListener(this.deletionListener);
                ++n;
            }
        }
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.setOpaque(false);
        this.add((Component)this.tabbedPane, "Center");
    }

    protected class RightClickListener
    extends CustomMouseAdapter {
        protected RightClickListener() {
        }

        public void popupResponse(MouseEvent ev) {
            final int index = TabbedEditorComponent.this.tabbedPane.getUI().tabForCoordinate(TabbedEditorComponent.this.tabbedPane, ev.getX(), ev.getY());
            if (index >= 0 && index < TabbedEditorComponent.this.tabbedPane.getTabCount()) {
                Runnable closeTabRunnable = new Runnable(){

                    public void run() {
                        TabbedEditorComponent.this.closeTab(index);
                    }
                };
                Vector<StringObjectPair> structure = new Vector<StringObjectPair>();
                structure.add(new StringObjectPair("Close " + TabbedEditorComponent.this.tabbedPane.getTitleAt(index), closeTabRunnable));
                structure.add(new StringObjectPair("Close All", TabbedEditorComponent.this.closeAllTabsRunnable));
                PopupMenuUtilities.createAndShowPopupMenu(structure, TabbedEditorComponent.this.tabbedPane, ev.getX(), ev.getY());
            }
        }
    }

    protected class EditorDropTargetListener
    implements DropTargetListener {
        protected EditorDropTargetListener() {
        }

        protected void checkDrag(DropTargetDragEvent dtde) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                dtde.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                dtde.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class))) {
                dtde.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class))) {
                dtde.acceptDrag(2);
                return;
            }
            DataFlavor[] flavors = AuthoringToolResources.safeGetCurrentDataFlavors(dtde);
            if (flavors != null) {
                DataFlavor[] dataFlavorArray = flavors;
                int n = 0;
                int n2 = dataFlavorArray.length;
                while (n < n2) {
                    DataFlavor flavor = dataFlavorArray[n];
                    Class<?> c = flavor.getRepresentationClass();
                    if (EditorUtilities.getBestEditor(c) != null) {
                        dtde.acceptDrag(2);
                        return;
                    }
                    ++n;
                }
            }
            dtde.rejectDrag();
        }

        public void dragEnter(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dragOver(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dropActionChanged(DropTargetDragEvent dtde) {
            this.checkDrag(dtde);
        }

        public void dragExit(DropTargetEvent dte) {
        }

        public void drop(DropTargetDropEvent dtde) {
            try {
                Transferable transferable;
                Object o = null;
                if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class))) {
                    dtde.acceptDrop(2);
                    transferable = dtde.getTransferable();
                    o = transferable.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class));
                    o = ((CallToUserDefinedResponse)o).userDefinedResponse.getUserDefinedResponseValue();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class))) {
                    dtde.acceptDrop(2);
                    transferable = dtde.getTransferable();
                    o = transferable.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class));
                    o = ((CallToUserDefinedQuestion)o).userDefinedQuestion.getUserDefinedQuestionValue();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, ElementReferenceTransferable.elementReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    transferable = dtde.getTransferable();
                    o = transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    transferable = dtde.getTransferable();
                    CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                    o = callToUserDefinedResponsePrototype.getActualResponse();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dtde, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                    dtde.acceptDrop(2);
                    transferable = dtde.getTransferable();
                    CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                    o = callToUserDefinedQuestionPrototype.getActualQuestion();
                } else {
                    DataFlavor[] flavors = AuthoringToolResources.safeGetCurrentDataFlavors(dtde);
                    if (flavors != null) {
                        DataFlavor[] dataFlavorArray = flavors;
                        int n = 0;
                        int n2 = dataFlavorArray.length;
                        while (n < n2) {
                            DataFlavor flavor = dataFlavorArray[n];
                            Class<?> c = flavor.getDefaultRepresentationClass();
                            if (EditorUtilities.getBestEditor(c) != null) {
                                dtde.acceptDrop(2);
                                Transferable transferable2 = dtde.getTransferable();
                                o = transferable2.getTransferData(flavor);
                                break;
                            }
                            ++n;
                        }
                    }
                }
                if (o != null) {
                    Class editorClass = EditorUtilities.getBestEditor(o.getClass());
                    if (editorClass != null) {
                        TabbedEditorComponent.this.editObject(o, editorClass, true);
                    }
                    dtde.dropComplete(true);
                } else {
                    dtde.rejectDrop();
                    dtde.dropComplete(false);
                }
            }
            catch (UnsupportedFlavorException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: bad flavor", e);
                dtde.dropComplete(false);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Drop didn't work: IOException", e);
                dtde.dropComplete(false);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Drop didn't work.", t);
                dtde.dropComplete(false);
            }
        }
    }

    protected class NameListener
    implements PropertyListener {
        protected NameListener() {
        }

        public void propertyChanging(PropertyEvent ev) {
        }

        public void propertyChanged(PropertyEvent ev) {
            int i = 0;
            while (i < TabbedEditorComponent.this.tabbedPane.getTabCount()) {
                Object object = TabbedEditorComponent.this.getObjectBeingEditedAt(i);
                if (object == ev.getProperty().getOwner()) {
                    TabbedEditorComponent.this.tabbedPane.setTitleAt(i, AuthoringToolResources.getReprForValue((Object)ev.getProperty().getOwner(), true));
                }
                ++i;
            }
        }
    }

    protected class DeletionListener
    implements ChildrenListener {
        protected DeletionListener() {
        }

        public void childrenChanging(ChildrenEvent ev) {
        }

        public void childrenChanged(ChildrenEvent ev) {
            if (ev.getChangeType() == 3) {
                TabbedEditorComponent.this.stopListeningToTree(ev.getChild());
                int i = 0;
                while (i < TabbedEditorComponent.this.tabbedPane.getTabCount()) {
                    Element element;
                    Object object = TabbedEditorComponent.this.getObjectBeingEditedAt(i);
                    if (object instanceof Element && ((element = (Element)object) == ev.getChild() || ev.getChild().isAncestorOf(element))) {
                        TabbedEditorComponent.this.closeTab(i);
                        --i;
                    }
                    ++i;
                }
            } else if (ev.getChangeType() == 1) {
                TabbedEditorComponent.this.startListeningToTree(ev.getChild());
            }
        }
    }
}

