/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.PropertyReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.MainCompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.py.AliceStyle;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditObjectButton;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.CollectionPropertyViewController;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.DictionaryProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.PropertyAnimation;
import edu.cmu.cs.stage3.alice.core.response.ResizeAnimation;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.alice.core.response.Wait;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.Enumerable;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class AuthoringToolResources {
    public static final long startTime = System.currentTimeMillis();
    public static final String QUESTION_STRING = "function";
    public static Criterion characterCriterion = new Criterion(){

        public boolean accept(Object o) {
            return o instanceof Sandbox;
        }
    };
    protected static Resources resources;
    protected static File resourcesCacheFile;
    static final ImageIcon modelIcon;
    static final ImageIcon subpartIcon;
    static final ImageIcon sceneIcon;
    static final ImageIcon folderIcon;
    static final ImageIcon defaultIcon;

    static {
        AuthoringToolResources.loadResourcesPy();
        modelIcon = AuthoringToolResources.getIconForString("model");
        subpartIcon = AuthoringToolResources.getIconForString("subpart");
        sceneIcon = AuthoringToolResources.getIconForString("scene");
        folderIcon = AuthoringToolResources.getIconForString("folder");
        defaultIcon = AuthoringToolResources.getIconForString("default");
    }

    public static boolean safeIsDataFlavorSupported(DropTargetDragEvent dtde, DataFlavor flavor) {
        try {
            boolean toReturn = dtde.isDataFlavorSupported(flavor);
            return toReturn;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static DataFlavor[] safeGetCurrentDataFlavors(DropTargetDropEvent dtde) {
        try {
            return dtde.getCurrentDataFlavors();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static DataFlavor[] safeGetCurrentDataFlavors(DropTargetDragEvent dtde) {
        try {
            return dtde.getCurrentDataFlavors();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static boolean safeIsDataFlavorSupported(DropTargetDropEvent dtde, DataFlavor flavor) {
        try {
            boolean toReturn = dtde.isDataFlavorSupported(flavor);
            return toReturn;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean safeIsDataFlavorSupported(Transferable transferable, DataFlavor flavor) {
        try {
            boolean toReturn = transferable.isDataFlavorSupported(flavor);
            return toReturn;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void loadResourcesPy() {
        resources = new Resources();
        AuthoringToolResources.initKeyCodesToStrings();
        AliceStyle.init();
    }

    public static void setQuestionStructure(Vector questionStructure) {
        AuthoringToolResources.resources.questionStructure = questionStructure;
    }

    public static Vector getQuestionStructure(Class elementClass) {
        if (AuthoringToolResources.resources.questionStructure != null) {
            for (Object o : AuthoringToolResources.resources.questionStructure) {
                if (o instanceof StringObjectPair) {
                    String className = ((StringObjectPair)o).getString();
                    try {
                        Class<?> c = Class.forName(className);
                        if (!c.isAssignableFrom(elementClass)) continue;
                        return (Vector)((StringObjectPair)o).getObject();
                    }
                    catch (ClassNotFoundException e) {
                        AuthoringTool.showErrorDialog("Can't find class " + className, e);
                    }
                    continue;
                }
                AuthoringTool.showErrorDialog("Unexpected object found in questionStructure: " + o, null);
            }
        }
        return null;
    }

    public static void setDefaultPropertyValuesStructure(Vector defaultPropertyValuesStructure) {
        AuthoringToolResources.resources.defaultPropertyValuesStructure = defaultPropertyValuesStructure;
    }

    public static Vector getDefaultPropertyValues(Class elementClass, String propertyName) {
        if (AuthoringToolResources.resources.defaultPropertyValuesStructure != null) {
            for (StringObjectPair classChunk : AuthoringToolResources.resources.defaultPropertyValuesStructure) {
                String className = classChunk.getString();
                try {
                    Class<?> c = Class.forName(className);
                    if (!c.isAssignableFrom(elementClass)) continue;
                    Vector properties = (Vector)classChunk.getObject();
                    for (StringObjectPair propertyChunk : properties) {
                        if (!propertyName.equals(propertyChunk.getString())) continue;
                        return (Vector)propertyChunk.getObject();
                    }
                }
                catch (ClassNotFoundException e) {
                    AuthoringTool.showErrorDialog("Can't find class " + className, e);
                }
            }
        }
        return null;
    }

    public static void putName(Object key, String prettyName) {
        AuthoringToolResources.resources.nameMap.put(key, prettyName);
    }

    public static String getName(Object key) {
        return (String)AuthoringToolResources.resources.nameMap.get(key);
    }

    public static boolean nameMapContainsKey(Object key) {
        return AuthoringToolResources.resources.nameMap.containsKey(key);
    }

    public static void putHTMLName(Object key, String prettyName) {
        AuthoringToolResources.resources.htmlNameMap.put(key, prettyName);
    }

    public static String getHTMLName(Object key) {
        return (String)AuthoringToolResources.resources.htmlNameMap.get(key);
    }

    public static void putFormat(Object key, String formatString) {
        AuthoringToolResources.resources.formatMap.put(key, formatString);
    }

    public static String getFormat(Object key) {
        return (String)AuthoringToolResources.resources.formatMap.get(key);
    }

    public static String getPlainFormat(Object key) {
        String format = (String)AuthoringToolResources.resources.formatMap.get(key);
        StringBuffer sb = new StringBuffer();
        FormatTokenizer tokenizer = new FormatTokenizer(format);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("<<") && !token.startsWith("<<<")) continue;
            while (token.indexOf("&lt;") > -1) {
                token = new StringBuffer(token).replace(token.indexOf("&lt;"), token.indexOf("&lt;") + 4, "<").toString();
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static boolean formatMapContainsKey(Object key) {
        return AuthoringToolResources.resources.formatMap.containsKey(key);
    }

    public static boolean shouldGUIOmitPropertyName(Property property) {
        return true;
    }

    public static String getReprForValue(Object value, Property property) {
        return AuthoringToolResources.getReprForValue(value, property, null);
    }

    public static String getReprForValue(Object value, Property property, Object extraContextInfo) {
        Class<Object> elementClass = property.getOwner().getClass();
        String propertyName = property.getName();
        if (property.getOwner() instanceof PropertyAnimation && property.getName().equals("value")) {
            Element elementValue;
            PropertyAnimation propertyAnimation = (PropertyAnimation)property.getOwner();
            Object e = propertyAnimation.element.get();
            elementClass = e instanceof Expression ? ((Expression)e).getValueClass() : ((elementValue = propertyAnimation.element.getElementValue()) != null ? elementValue.getClass() : null);
            propertyName = propertyAnimation.propertyName.getStringValue();
        } else if (property.getOwner() instanceof PropertyAssignment && property.getName().equals("value")) {
            PropertyAssignment propertyAssignment = (PropertyAssignment)property.getOwner();
            elementClass = propertyAssignment.element.getElementValue().getClass();
            propertyName = propertyAssignment.propertyName.getStringValue();
        }
        return AuthoringToolResources.getReprForValue(value, elementClass, propertyName, extraContextInfo);
    }

    public static String getReprForValue(Object value, Class elementClass, String propertyName, Object extraContextInfo) {
        boolean verbose = false;
        Class<Object> valueClass = null;
        try {
            valueClass = Element.getValueClassForPropertyNamed(elementClass, propertyName);
        }
        catch (Exception e) {
            valueClass = Object.class;
        }
        if (valueClass == null) {
            valueClass = Object.class;
        }
        if (elementClass == null || propertyName == null) {
            return AuthoringToolResources.getReprForValue(value);
        }
        if (CallToUserDefinedResponse.class.isAssignableFrom(elementClass) && propertyName.equals("userDefinedResponse") || CallToUserDefinedQuestion.class.isAssignableFrom(elementClass) && propertyName.equals("userDefinedQuestion")) {
            verbose = true;
        }
        if (value instanceof Variable && ((Variable)value).getParent() instanceof Sandbox) {
            verbose = true;
        }
        try {
            while (Element.class.isAssignableFrom(elementClass)) {
                String reprString;
                Object repr;
                DictionaryProperty data;
                String userRepr = null;
                if (extraContextInfo instanceof DictionaryProperty && (data = (DictionaryProperty)extraContextInfo).getName().equals("data") && (repr = data.get("edu.cmu.cs.stage3.alice.authoringtool.userRepr." + propertyName)) != null && repr instanceof String) {
                    if (Number.class.isAssignableFrom(valueClass) && value instanceof Double) {
                        Double d = AuthoringToolResources.parseDouble((String)repr);
                        if (d != null && d.equals(value)) {
                            userRepr = (String)repr;
                        } else {
                            data.remove("edu.cmu.cs.stage3.alice.authoringtool.userRepr." + propertyName);
                        }
                    } else {
                        userRepr = (String)repr;
                    }
                }
                if ((reprString = null) != null) {
                    StringBuffer sb;
                    while (reprString.indexOf("<value>") > -1) {
                        String valueString = userRepr != null ? userRepr : AuthoringToolResources.getReprForValue(value);
                        sb = new StringBuffer(reprString);
                        sb.replace(reprString.indexOf("<value>"), reprString.indexOf("<value>") + "<value>".length(), valueString);
                        reprString = sb.toString();
                    }
                    while (reprString.indexOf("<percentValue>") > -1 && value instanceof Double) {
                        double v = (Double)value * 100.0;
                        String valueString = String.valueOf(AuthoringToolResources.resources.decimalFormatter.format(v)) + "%";
                        StringBuffer sb2 = new StringBuffer(reprString);
                        sb2.replace(reprString.indexOf("<percentValue>"), reprString.indexOf("<percentValue>") + "<percentValue>".length(), valueString);
                        reprString = sb2.toString();
                    }
                    while (reprString.indexOf("<keyCodeValue>") > -1 && value instanceof Integer) {
                        String valueString = KeyEvent.getKeyText((Integer)value);
                        sb = new StringBuffer(reprString);
                        sb.replace(reprString.indexOf("<keyCodeValue>"), reprString.indexOf("<keyCodeValue>") + "<keyCodeValue>".length(), valueString);
                        reprString = sb.toString();
                    }
                    return reprString;
                }
                elementClass = elementClass.getSuperclass();
            }
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Error finding repr for " + value, t);
        }
        return AuthoringToolResources.getReprForValue(value, verbose);
    }

    public static String getReprForValue(Object value) {
        return AuthoringToolResources.getReprForValue(value, false);
    }

    protected static String stripUnnamedsFromName(Object value) {
        String toStrip = new String(value.toString());
        String toReturn = "";
        String toMatch = "__Unnamed";
        boolean notDone = true;
        while (notDone) {
            int nextIndex = toStrip.indexOf(toMatch);
            if (nextIndex >= 0) {
                String newToStrip;
                String toAdd = toStrip.substring(0, nextIndex);
                if (toAdd != null) {
                    toReturn = String.valueOf(toReturn) + toAdd;
                }
                if ((newToStrip = toStrip.substring(nextIndex, toStrip.length())) == null) {
                    notDone = false;
                    break;
                }
                toStrip = newToStrip;
                nextIndex = toStrip.indexOf(".");
                if (nextIndex >= 0) {
                    newToStrip = toStrip.substring(nextIndex + 1, toStrip.length());
                    if (newToStrip != null) {
                        toStrip = newToStrip;
                        continue;
                    }
                    notDone = false;
                    break;
                }
                notDone = false;
                break;
            }
            toReturn = String.valueOf(toReturn) + toStrip;
            notDone = false;
            break;
        }
        return toStrip;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public static String getReprForValue(Object value, boolean verbose) {
        block20: {
            if (AuthoringToolResources.nameMapContainsKey(value)) {
                value = AuthoringToolResources.getName(value);
            }
            if (AuthoringToolResources.formatMapContainsKey(value)) {
                value = AuthoringToolResources.getPlainFormat(value);
            }
            if (value instanceof Class && AuthoringToolResources.nameMapContainsKey(value = ((Class)value).getName())) {
                value = AuthoringToolResources.getName(value);
            }
            if (value instanceof Enumerable) {
                value = ((Enumerable)value).getRepr();
            }
            if (value instanceof PropertyValue) {
                propertyName = ((PropertyValue)value).propertyName.getStringValue();
                element = (Element)((PropertyValue)value).element.get();
                valueClass = element.getClass();
                if (element instanceof Expression) {
                    valueClass = ((Expression)element).getValueClass();
                }
                try {
                    declaringClass = valueClass.getField(propertyName).getDeclaringClass();
                    if (declaringClass != null && AuthoringToolResources.nameMapContainsKey(key = String.valueOf(declaringClass.getName()) + "." + propertyName)) {
                        propertyName = AuthoringToolResources.getName(key);
                    }
                }
                catch (NoSuchFieldException e) {
                    AuthoringTool.showErrorDialog("Error representing PropertyValue: can't find " + propertyName + " on " + valueClass, e);
                }
                value = String.valueOf(AuthoringToolResources.getReprForValue((Object)element, false)) + "." + propertyName;
            }
            if (!(value instanceof Question) || !AuthoringToolResources.formatMapContainsKey(value.getClass())) break block20;
            questionRepr = "";
            question = (Question)value;
            format = AuthoringToolResources.getFormat(value.getClass());
            formatTokenizer = new FormatTokenizer(format);
            while (formatTokenizer.hasMoreTokens()) {
                token = formatTokenizer.nextToken();
                if (!token.startsWith("<") || !token.endsWith(">")) ** GOTO lbl36
                property = question.getPropertyNamed(token.substring(token.lastIndexOf("<") + 1, token.indexOf(">")));
                if (property == null) continue;
                questionRepr = String.valueOf(questionRepr) + AuthoringToolResources.getReprForValue(property.get(), property);
                continue;
lbl-1000:
                // 1 sources

                {
                    token = new StringBuffer(token).replace(token.indexOf("&lt;"), token.indexOf("&lt;") + 4, "<").toString();
lbl36:
                    // 2 sources

                    ** while (token.indexOf((String)"&lt;") > -1)
                }
lbl37:
                // 1 sources

                questionRepr = String.valueOf(questionRepr) + token;
            }
            if (questionRepr.length() > 0) {
                value = questionRepr;
            }
        }
        if (value instanceof Element) {
            if (verbose) {
                ancestor /* !! */  = ((Element)value).getSandbox();
                if (ancestor /* !! */  != null) {
                    ancestor /* !! */  = ancestor /* !! */ .getParent();
                }
                value = ((Element)value).getKey(ancestor /* !! */ );
                value = AuthoringToolResources.stripUnnamedsFromName(value);
            } else {
                value = ((Element)value).name.getStringValue();
            }
        }
        if (value instanceof Number) {
            d = ((Number)value).doubleValue();
            value = AuthoringToolResources.resources.decimalFormatter.format(d);
        }
        if (value instanceof Property) {
            simpleName = ((Property)value).getName();
            if (((Property)value).getDeclaredClass() != null) {
                key = String.valueOf(((Property)value).getDeclaredClass().getName()) + "." + ((Property)value).getName();
                simpleName = AuthoringToolResources.nameMapContainsKey(key) != false ? AuthoringToolResources.getName(key) : ((Property)value).getName();
            }
            value = ((Property)value).getOwner() instanceof Variable != false ? AuthoringToolResources.getReprForValue((Object)((Property)value).getOwner(), verbose) : (verbose != false && ((Property)value).getOwner() != null ? String.valueOf(AuthoringToolResources.getReprForValue(((Property)value).getOwner())) + "." + simpleName : simpleName);
        }
        if (value == null) {
            value = "<None>";
        }
        return value.toString();
    }

    public static String getFormattedReprForValue(Object value, StringObjectPair[] knownPropertyValues) {
        String format = (String)AuthoringToolResources.resources.formatMap.get(value);
        StringBuffer sb = new StringBuffer();
        FormatTokenizer tokenizer = new FormatTokenizer(format);
        block0: while (tokenizer.hasMoreTokens()) {
            int n;
            String propertyName;
            String token = tokenizer.nextToken();
            if (token.startsWith("<<<") && token.endsWith(">>>")) {
                propertyName = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                StringObjectPair[] stringObjectPairArray = knownPropertyValues;
                int n2 = 0;
                n = stringObjectPairArray.length;
                while (n2 < n) {
                    StringObjectPair knownPropertyValue = stringObjectPairArray[n2];
                    if (knownPropertyValue.getString().equals(propertyName)) {
                        sb.append(AuthoringToolResources.getReprForValue(knownPropertyValue.getObject(), true));
                        continue block0;
                    }
                    ++n2;
                }
                continue;
            }
            if (token.startsWith("<<") && token.endsWith(">>")) continue;
            if (token.startsWith("<") && token.endsWith(">")) {
                propertyName = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                boolean appendedValue = false;
                StringObjectPair[] stringObjectPairArray = knownPropertyValues;
                n = 0;
                int n3 = stringObjectPairArray.length;
                while (n < n3) {
                    StringObjectPair knownPropertyValue = stringObjectPairArray[n];
                    if (knownPropertyValue.getString().equals(propertyName)) {
                        sb.append(AuthoringToolResources.getReprForValue(knownPropertyValue.getObject(), true));
                        appendedValue = true;
                        break;
                    }
                    ++n;
                }
                if (appendedValue) continue;
                sb.append(token);
                continue;
            }
            sb.append(token);
        }
        return sb.toString();
    }

    public static String getNameInContext(Element element, Element context) {
        Element variableRoot;
        if (element instanceof Variable && element.getParent() != null && (variableRoot = element.getParent()) instanceof Response && (context.isDescendantOf(variableRoot) || context == variableRoot)) {
            return element.name.getStringValue();
        }
        return AuthoringToolResources.getReprForValue((Object)element, true);
    }

    public static String[] getDesiredProperties(Class elementClass) {
        LinkedList<String> desired = new LinkedList<String>();
        String format = AuthoringToolResources.getFormat(elementClass);
        FormatTokenizer tokenizer = new FormatTokenizer(format);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.startsWith("<<<") && token.endsWith(">>>")) continue;
            if (token.startsWith("<<") && token.endsWith(">>")) {
                desired.add(token.substring(token.lastIndexOf("<") + 1, token.indexOf(">")));
                continue;
            }
            if (!token.startsWith("<") || !token.endsWith(">")) continue;
            desired.add(token.substring(token.lastIndexOf("<") + 1, token.indexOf(">")));
        }
        return desired.toArray(new String[0]);
    }

    public static void putColor(String key, Color color) {
        AuthoringToolResources.resources.colorMap.put(key, color);
    }

    public static Color getColor(String key) {
        Color toReturn = (Color)AuthoringToolResources.resources.colorMap.get(key);
        return toReturn;
    }

    public static Image getAliceSystemIconImage() {
        return AuthoringToolResources.getImageForString("aliceHead");
    }

    public static ImageIcon getAliceSystemIcon() {
        return AuthoringToolResources.getIconForString("aliceHead");
    }

    public static Image getImageForString(String s) {
        if (!AuthoringToolResources.resources.stringImageMap.containsKey(s)) {
            URL resource = AuthoringToolResources.class.getResource("images/" + s + ".gif");
            if (resource == null) {
                resource = AuthoringToolResources.class.getResource("images/" + s + ".png");
            }
            if (resource == null) {
                resource = AuthoringToolResources.class.getResource("images/" + s + ".jpg");
            }
            if (resource != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(resource);
                AuthoringToolResources.resources.stringImageMap.put(s, image);
            } else {
                return null;
            }
        }
        return (Image)AuthoringToolResources.resources.stringImageMap.get(s);
    }

    public static ImageIcon getIconForString(String s) {
        if (!AuthoringToolResources.resources.stringIconMap.containsKey(s)) {
            URL resource = AuthoringToolResources.class.getResource("images/" + s + ".gif");
            if (resource == null) {
                resource = AuthoringToolResources.class.getResource("images/" + s + ".png");
            }
            if (resource == null) {
                resource = AuthoringToolResources.class.getResource("images/" + s + ".jpg");
            }
            if (resource != null) {
                AuthoringToolResources.resources.stringIconMap.put(s, new ImageIcon(resource));
            } else {
                return null;
            }
        }
        return (ImageIcon)AuthoringToolResources.resources.stringIconMap.get(s);
    }

    public static ImageIcon getIconForValue(Object value) {
        if (value instanceof Transformable) {
            if (((Transformable)value).getParent() instanceof Transformable) {
                return subpartIcon;
            }
            return modelIcon;
        }
        if (value instanceof World) {
            return sceneIcon;
        }
        if (value instanceof Image) {
            return new ImageIcon((Image)value);
        }
        if (value instanceof String) {
            return AuthoringToolResources.getIconForString((String)value);
        }
        return defaultIcon;
    }

    public static ImageIcon getDisabledIcon(ImageIcon inputIcon) {
        return AuthoringToolResources.getDisabledIcon(inputIcon, 70);
    }

    public static ImageIcon getDisabledIcon(ImageIcon inputIcon, int percentGray) {
        ImageIcon disabledIcon = (ImageIcon)AuthoringToolResources.resources.disabledIconMap.get(inputIcon);
        if (disabledIcon == null) {
            GrayFilter filter = new GrayFilter(true, percentGray);
            FilteredImageSource producer = new FilteredImageSource(inputIcon.getImage().getSource(), filter);
            Image grayImage = Toolkit.getDefaultToolkit().createImage(producer);
            disabledIcon = new ImageIcon(grayImage);
            AuthoringToolResources.resources.disabledIconMap.put(inputIcon, disabledIcon);
        }
        return disabledIcon;
    }

    public static void openURL(String urlString) throws IOException {
        if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows")) {
            String[] cmdarray = new String[]{"rundll32", "url.dll,FileProtocolHandler", urlString};
            if (urlString.indexOf("&stacktrace") > -1) {
                try {
                    File tempURL = File.createTempFile("tempURLHolder", ".url");
                    tempURL = tempURL.getAbsoluteFile();
                    tempURL.deleteOnExit();
                    PrintWriter urlWriter = new PrintWriter(new BufferedWriter(new FileWriter(tempURL)));
                    urlWriter.println("[InternetShortcut]");
                    urlWriter.println("URL=" + urlString);
                    urlWriter.flush();
                    urlWriter.close();
                    cmdarray[2] = tempURL.getAbsolutePath();
                }
                catch (Throwable t) {
                    cmdarray[2] = urlString.substring(0, urlString.indexOf("&stacktrace"));
                }
            }
            Runtime.getRuntime().exec(cmdarray);
        } else {
            String[] cmd = new String[]{"netscape", urlString};
            Runtime.getRuntime().exec(cmd);
        }
    }

    public static Double parseDouble(String doubleString) {
        Double number = null;
        if (doubleString.trim().equalsIgnoreCase("infinity")) {
            number = new Double(Double.POSITIVE_INFINITY);
        } else if (doubleString.trim().equalsIgnoreCase("-infinity")) {
            number = new Double(Double.NEGATIVE_INFINITY);
        } else if (doubleString.indexOf(47) > -1) {
            if (doubleString.lastIndexOf(47) == doubleString.indexOf(47)) {
                String numeratorString = doubleString.substring(0, doubleString.indexOf(47));
                String denominatorString = doubleString.substring(doubleString.indexOf(47) + 1);
                try {
                    number = new Double(Double.parseDouble(numeratorString) / Double.parseDouble(denominatorString));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                number = Double.valueOf(doubleString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return number;
    }

    public static boolean isMethodHookedUp(Response response, World world) {
        return AuthoringToolResources.isMethodHookedUp(response, world, new Vector());
    }

    private static boolean isMethodHookedUp(Response response, World world, Vector checkedMethods) {
        PropertyReference[] references;
        PropertyReference[] propertyReferenceArray = references = response.getRoot().getPropertyReferencesTo(response, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, true);
        int n = 0;
        int n2 = propertyReferenceArray.length;
        while (n < n2) {
            PropertyReference reference = propertyReferenceArray[n];
            Element referrer = reference.getProperty().getOwner();
            if (world.behaviors.contains(referrer)) {
                return true;
            }
            if (referrer instanceof Response && !checkedMethods.contains(referrer)) {
                checkedMethods.add(referrer);
                if (AuthoringToolResources.isMethodHookedUp((Response)referrer, world, checkedMethods)) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    public static Response createUndoResponse(Response response) {
        Response undoResponse = null;
        if (response instanceof ResizeAnimation) {
            ResizeAnimation resizeResponse = (ResizeAnimation)response;
            ResizeAnimation undoResizeResponse = new ResizeAnimation();
            undoResizeResponse.amount.set(new Double(1.0 / resizeResponse.amount.doubleValue()));
            undoResizeResponse.asSeenBy.set(resizeResponse.asSeenBy.get());
            undoResizeResponse.likeRubber.set(resizeResponse.likeRubber.get());
            undoResizeResponse.subject.set(resizeResponse.subject.get());
            undoResponse = undoResizeResponse;
        } else if (response instanceof TransformAnimation) {
            undoResponse = new PropertyAnimation();
            Transformable transformable = (Transformable)((TransformAnimation)response).subject.getValue();
            undoResponse.element.set(transformable);
            undoResponse.howMuch.set(HowMuch.INSTANCE);
        } else if (response instanceof PropertyAnimation) {
            undoResponse = new PropertyAnimation();
            Element element = ((PropertyAnimation)response).element.getElementValue();
            undoResponse.element.set(element);
            undoResponse.propertyName.set(((PropertyAnimation)response).propertyName.get());
            undoResponse.value.set(element.getPropertyNamed(((PropertyAnimation)response).propertyName.getStringValue()).getValue());
            undoResponse.howMuch.set(((PropertyAnimation)response).howMuch.get());
        }
        if (undoResponse != null) {
            undoResponse.duration.set(response.duration.get());
        } else {
            undoResponse = new Wait();
            undoResponse.duration.set(new Double(0.0));
            AuthoringTool.showErrorDialog("Could not create undoResponse for " + response, null);
        }
        return undoResponse;
    }

    public static void addAffectedProperties(List affectedProperties, Element element, String propertyName, HowMuch howMuch) {
        Property property = element.getPropertyNamed(propertyName);
        if (property != null) {
            affectedProperties.add(property);
        }
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < element.getChildCount()) {
                Element child = element.getChildAt(i);
                if (!howMuch.getRespectDescendant()) {
                    AuthoringToolResources.addAffectedProperties(affectedProperties, child, propertyName, howMuch);
                }
                ++i;
            }
        }
    }

    public static Property[] getAffectedProperties(Response response) {
        Property[] properties = null;
        if (response instanceof ResizeAnimation) {
            Vector pVector = new Vector();
            properties = pVector.toArray(new Property[0]);
        } else if (response instanceof PropertyAnimation) {
            Element element = ((PropertyAnimation)response).element.getElementValue();
            String propertyName = ((PropertyAnimation)response).propertyName.getStringValue();
            HowMuch howMuch = (HowMuch)((PropertyAnimation)response).howMuch.getValue();
            LinkedList propertyList = new LinkedList();
            AuthoringToolResources.addAffectedProperties(propertyList, element, propertyName, howMuch);
            properties = propertyList.toArray(new Property[0]);
        }
        if (properties == null) {
            properties = new Property[]{};
        }
        return properties;
    }

    public static String getNameForNewChild(String baseName, Element parent) {
        String name = baseName;
        if (name == null || parent == null) {
            return name;
        }
        if (parent.getChildNamedIgnoreCase(name) == null && parent.getChildNamedIgnoreCase(String.valueOf(name) + 1) == null) {
            return name;
        }
        if (baseName.length() < 1) {
            baseName = "copy";
        }
        int end = baseName.length();
        int endDigit = 2;
        for (int begin = baseName.length() - 1; begin >= 0; --begin) {
            try {
                endDigit = Integer.parseInt(baseName.substring(begin, end));
                name = baseName.substring(0, begin);
                continue;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        baseName = name;
        int i = endDigit;
        while (i < Integer.MAX_VALUE) {
            name = String.valueOf(baseName) + i;
            if (parent.getChildNamedIgnoreCase(name) == null) {
                return name;
            }
            ++i;
        }
        throw new RuntimeException("Unable to find a suitable new name; baseName = " + baseName + ", parent = " + parent);
    }

    public static void addElementToAppropriateProperty(Element element, Element parent) {
        ElementArrayProperty oap = null;
        if (element instanceof Transformable) {
            if (parent instanceof Transformable) {
                oap = ((Transformable)parent).parts;
            }
        } else if (element instanceof Response) {
            if (parent instanceof Sandbox) {
                oap = ((Sandbox)parent).responses;
            }
        } else if (element instanceof Behavior) {
            if (parent instanceof Sandbox) {
                oap = ((Sandbox)parent).behaviors;
            }
        } else if (element instanceof Variable) {
            if (parent instanceof Sandbox) {
                oap = ((Sandbox)parent).variables;
            }
        } else if (element instanceof Question && parent instanceof Sandbox) {
            oap = ((Sandbox)parent).questions;
        }
        if (oap != null && !oap.contains(element)) {
            oap.add(element);
        }
    }

    public static double getCurrentTime() {
        long timeMillis = System.currentTimeMillis() - startTime;
        return (double)timeMillis / 1000.0;
    }

    public static void findAssignables(Class baseClass, Set result, boolean includeInterfaces) {
        if (baseClass != null && !result.contains(baseClass)) {
            result.add(baseClass);
            if (includeInterfaces) {
                Class<?>[] interfaces;
                Class<?>[] classArray = interfaces = baseClass.getInterfaces();
                int n = 0;
                int n2 = classArray.length;
                while (n < n2) {
                    Class<?> interface1 = classArray[n];
                    AuthoringToolResources.findAssignables(interface1, result, includeInterfaces);
                    ++n;
                }
            }
            AuthoringToolResources.findAssignables(baseClass.getSuperclass(), result, includeInterfaces);
        }
    }

    public static DataFlavor getReferenceFlavorForClass(Class c) {
        if (!AuthoringToolResources.resources.flavorMap.containsKey(c)) {
            try {
                AuthoringToolResources.resources.flavorMap.put(c, new DataFlavor("application/x-java-jvm-local-objectref; class=" + c.getName()));
            }
            catch (ClassNotFoundException e) {
                AuthoringTool.showErrorDialog("Can't find class " + c.getName(), e);
            }
        }
        return (DataFlavor)AuthoringToolResources.resources.flavorMap.get(c);
    }

    public static Object getDefaultValueForClass(Class cls) {
        if (cls == Boolean.class) {
            return Boolean.TRUE;
        }
        if (cls == Number.class) {
            return new Double(1.0);
        }
        if (cls == String.class) {
            return new String("default string");
        }
        if (cls == Color.class) {
            return Color.white;
        }
        if (Enumerable.class.isAssignableFrom(cls)) {
            Enumerable[] items = Enumerable.getItems(cls);
            if (items.length > 0) {
                return items[0];
            }
            return null;
        }
        if (cls == ReferenceFrame.class) {
            return AuthoringTool.getHack().getWorld();
        }
        return null;
    }

    public static void garbageCollectIfPossible(PropertyReference[] references) {
        PropertyReference[] propertyReferenceArray = references;
        int n = 0;
        int n2 = propertyReferenceArray.length;
        while (n < n2) {
            PropertyReference reference = propertyReferenceArray[n];
            Element element = reference.getProperty().getOwner();
            PropertyReference[] metaReferences = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, true);
            if (metaReferences.length == 0) {
                element.getParent().removeChild(element);
            }
            ++n;
        }
    }

    private static void initKeyCodesToStrings() {
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(48), "0");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(49), "1");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(50), "2");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(51), "3");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(52), "4");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(53), "5");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(54), "6");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(55), "7");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(56), "8");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(57), "9");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(65), "A");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(66), "B");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(67), "C");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(68), "D");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(69), "E");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(70), "F");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(71), "G");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(72), "H");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(73), "I");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(74), "J");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(75), "K");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(76), "L");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(77), "M");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(78), "N");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(79), "O");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(80), "P");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(81), "Q");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(82), "R");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(83), "S");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(84), "T");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(85), "U");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(86), "V");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(87), "W");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(88), "X");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(89), "Y");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(90), "Z");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(10), "enter");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(32), "space");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(38), "upArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(40), "downArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(37), "leftArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(39), "rightArrow");
    }

    public static String getPrefix(String token) {
        if (token.indexOf("<") > -1 && token.indexOf(">") > token.indexOf("<")) {
            return token.substring(0, token.indexOf("<"));
        }
        return token;
    }

    public static String getSpecifier(String token) {
        if (token.indexOf("<") > -1 && token.indexOf(">") > token.indexOf("<")) {
            return token.substring(token.indexOf("<") + 1, token.indexOf(">"));
        }
        return null;
    }

    public static Component findElementDnDPanel(Container root, final Element element) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                if (o instanceof DnDGroupingPanel) {
                    try {
                        Element e;
                        Transferable transferable = ((DnDGroupingPanel)o).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor) && element.equals(e = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor))) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error finding ElementDnDPanel.", e);
                    }
                }
                return false;
            }
        };
        Component toReturn = AuthoringToolResources.findComponent(root, criterion);
        if (toReturn instanceof MainCompositeElementPanel) {
            return ((MainCompositeElementPanel)toReturn).getWorkSpace();
        }
        return toReturn;
    }

    public static Component findPropertyDnDPanel(Container root, final Element element, final String propertyName) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                if (o instanceof DnDGroupingPanel) {
                    try {
                        Property p;
                        Element e;
                        Transferable transferable = ((DnDGroupingPanel)o).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, PropertyReferenceTransferable.propertyReferenceFlavor) && element.equals(e = (p = (Property)transferable.getTransferData(PropertyReferenceTransferable.propertyReferenceFlavor)).getOwner()) && p.getName().equals(propertyName)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error finding PropertyDnDPanel.", e);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findUserDefinedResponseDnDPanel(Container root, final Response actualResponse) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                if (o instanceof DnDGroupingPanel) {
                    try {
                        CallToUserDefinedResponsePrototype p;
                        Transferable transferable = ((DnDGroupingPanel)o).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor) && (p = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)).getActualResponse().equals(actualResponse)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error finding UserDefinedResponseDnDPanel.", e);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findUserDefinedQuestionDnDPanel(Container root, final Question actualQuestion) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                if (o instanceof DnDGroupingPanel) {
                    try {
                        CallToUserDefinedQuestionPrototype p;
                        Transferable transferable = ((DnDGroupingPanel)o).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) && (p = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)).getActualQuestion().equals(actualQuestion)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error finding UserDefinedQuestionDnDPanel.", e);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findPrototypeDnDPanel(Container root, final Class elementClass) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                if (o instanceof DnDGroupingPanel) {
                    try {
                        ElementPrototype p;
                        Transferable transferable = ((DnDGroupingPanel)o).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor) && (p = (ElementPrototype)transferable.getTransferData(ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor)).getElementClass().equals(elementClass)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        AuthoringTool.showErrorDialog("Error finding PrototypeDnDPanel.", e);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findPropertyViewController(Container root, final Element element, final String propertyName) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                Property p;
                return o instanceof PropertyViewController ? (p = ((PropertyViewController)o).getProperty()).getOwner().equals(element) && p.getName().equals(propertyName) : o instanceof CollectionPropertyViewController && (p = ((CollectionPropertyViewController)o).getProperty()).getOwner().equals(element) && p.getName().equals(propertyName);
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findEditObjectButton(Container root, final Element element) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object o) {
                return o instanceof EditObjectButton && ((EditObjectButton)o).getObject().equals(element);
            }
        };
        return AuthoringToolResources.findComponent(root, criterion);
    }

    public static Component findComponent(Container root, Criterion criterion) {
        Component[] children;
        if (criterion.accept(root)) {
            return root;
        }
        Component[] componentArray = children = root.getComponents();
        int n = 0;
        int n2 = componentArray.length;
        while (n < n2) {
            Component result;
            Component element = componentArray[n];
            if (element instanceof Container && (result = AuthoringToolResources.findComponent((Container)element, criterion)) != null) {
                return result;
            }
            ++n;
        }
        return null;
    }

    public static class Resources
    implements Serializable {
        public Vector questionStructure;
        public HashMap nameMap = new HashMap();
        public HashMap htmlNameMap = new HashMap();
        public HashMap formatMap = new HashMap();
        public Vector defaultPropertyValuesStructure;
        public HashMap colorMap = new HashMap();
        public DecimalFormat decimalFormatter = new DecimalFormat("#0.##");
        public HashMap stringImageMap = new HashMap();
        public HashMap stringIconMap = new HashMap();
        public HashMap disabledIconMap = new HashMap();
        public HashMap flavorMap = new HashMap();
        public HashMap keyCodesToStrings = new HashMap();
    }
}

