/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.Actions;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.DragFromComponent;
import edu.cmu.cs.stage3.alice.authoringtool.EditorManager;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.JAliceFrame;
import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.AboutContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.ErrorContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.LoadElementProgressPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.NewVariableContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.OutputComponent;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.RenderContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.SaveErrorContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.SimulationExceptionPanel;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.StartUpContentPane;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.StoreElementProgressPane;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateChangedEvent;
import edu.cmu.cs.stage3.alice.authoringtool.event.AuthoringToolStateListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.ElementSelectionListener;
import edu.cmu.cs.stage3.alice.authoringtool.event.UndoRedoListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.DefaultScheduler;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExtensionFileFilter;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotScheduler;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotSimpleBehavior;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.RectangleAnimator;
import edu.cmu.cs.stage3.alice.authoringtool.util.TrashComponent;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.AppletWorldLoader;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.SimulationException;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.WorldStartBehavior;
import edu.cmu.cs.stage3.alice.core.clock.DefaultClock;
import edu.cmu.cs.stage3.alice.core.property.ResponseProperty;
import edu.cmu.cs.stage3.alice.core.property.UserDefinedResponseProperty;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.UserDefinedResponse;
import edu.cmu.cs.stage3.awt.AWTUtilities;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.FileSystemTreeLoader;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import edu.cmu.cs.stage3.scheduler.AbstractScheduler;
import edu.cmu.cs.stage3.scheduler.SchedulerThread;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class AuthoringTool
implements ClipboardOwner {
    public static final String WORLD_EXTENSION = "a2w";
    private World world;
    private JAliceFrame jAliceFrame;
    private EditorManager editorManager;
    private DefaultScheduler scheduler;
    private OneShotScheduler oneShotScheduler;
    private Runnable worldScheduleRunnable;
    private DefaultClock worldClock;
    private MainUndoRedoStack undoRedoStack;
    private Actions actions;
    private static OutputComponent stdOutOutputComponent;
    private OutputComponent stdErrOutputComponent;
    private WatcherPanel watcherPanel;
    private JFileChooser saveWorldFileChooser;
    private LoadElementProgressPane worldLoadProgressPane;
    private StoreElementProgressPane worldStoreProgressPane;
    private AboutContentPane aboutContentPane;
    private StartUpContentPane startUpContentPane;
    private NewVariableContentPane newVariableContentPane;
    private RenderContentPane renderContentPane;
    private JPanel renderPanel;
    private FileFilter worldFileFilter;
    private File currentWorldLocation;
    private boolean worldHasBeenModified = false;
    private long lastSaveTime;
    private WindowListener jAliceFrameWindowListener;
    private boolean saveTabsEnabled = false;
    private RectangleAnimator rectangleAnimator;
    private boolean stdOutToConsole;
    private boolean stdErrToConsole;
    private Element selectedElement;
    private HashSet selectionListeners = new HashSet();
    private HashSet stateListeners = new HashSet();
    private static AuthoringTool hack;
    protected HashMap componentMap = new HashMap();
    protected HashSet classesToStopOn = new HashSet();
    protected Timer updateTimer;

    public static AuthoringTool getHack() {
        return hack;
    }

    public AuthoringTool(boolean stdOutToConsole, boolean stdErrToConsole) {
        try {
            UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
            UIManager.put("Label.font", new Font("SansSerif", 1, 12));
            UIManager.put("Label.foreground", AuthoringToolResources.getColor("mainFontColor"));
            UIManager.put("TabbedPane.selected", new Color(255, 255, 255, 0));
            UIManager.put("TabbedPane.tabInsets", new Insets(1, 4, 1, 3));
            if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows")) {
                UIManager.put("FileChooserUI", "com.sun.java.swing.plaf.windows.WindowsFileChooserUI");
            }
        }
        catch (Exception e) {
            AuthoringTool.showErrorDialog("Error configuring Look and Feel.", e);
        }
        hack = this;
        this.filterInit();
        try {
            int fontSize = 12;
            UIManager.put("Label.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Button.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Checkbox.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ColorChooser.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ComboBox.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("EditorPane.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Menu.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("List.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("MenuBar.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("MenuItem.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("OptionPane.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Panel.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("PasswordField.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("PopupMenu.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ProgressBar.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("RadioButton.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ScrollPane.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Table.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("TableHeader.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Text.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("TextArea.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("TextField.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("TextPane.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("TitledBorder.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ToggleButton.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ToolBar.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("ToolTip.font", new Font("SansSerif", 1, fontSize));
            UIManager.put("Tree.font", new Font("SansSerif", 1, fontSize));
        }
        catch (Exception fontSize) {
            // empty catch block
        }
        this.mainInit();
        this.stdOutToConsole = stdOutToConsole;
        this.stdErrToConsole = stdErrToConsole;
        this.dialogInit();
        this.undoRedoInit();
        this.miscInit();
        this.worldInit();
        this.stencilInit();
        AbstractScheduler s = new AbstractScheduler(){

            protected void handleCaughtThowable(Runnable source, Throwable t) {
                this.markEachFrameRunnableForRemoval(source);
                AuthoringTool.showErrorDialog(source.toString(), t);
            }
        };
        s.addEachFrameRunnable(this.scheduler);
        s.addEachFrameRunnable(this.oneShotScheduler);
        SchedulerThread schedulerThread = new SchedulerThread(s);
        schedulerThread.start();
        if (!JAlice.isApplet) {
            this.jAliceFrame.setVisible(true);
        }
    }

    private void filterInit() {
        this.worldFileFilter = new ExtensionFileFilter(WORLD_EXTENSION, String.valueOf(WORLD_EXTENSION.toUpperCase()) + " (Alice World Files)");
    }

    private void mainInit() {
        this.editorManager = new EditorManager(this);
        this.scheduler = new DefaultScheduler();
        this.undoRedoStack = new MainUndoRedoStack(this);
        this.oneShotScheduler = new OneShotScheduler();
        this.jAliceFrame = new JAliceFrame(this);
        this.actions = new Actions(this, this.jAliceFrame);
        this.jAliceFrame.actionInit(this.actions);
        DialogManager.initialize(this.jAliceFrame);
        stdOutOutputComponent = new OutputComponent();
        this.stdErrOutputComponent = new OutputComponent();
        this.watcherPanel = new WatcherPanel();
    }

    private void dialogInit() {
        if (!JAlice.isApplet) {
            this.fileInit();
        }
        this.worldLoadProgressPane = new LoadElementProgressPane("Loading World...", "Loading: ");
        this.worldStoreProgressPane = new StoreElementProgressPane("Saving World...", "Saving: ");
        this.renderContentPane = new RenderContentPane(this);
        this.renderPanel = new JPanel();
        this.aboutContentPane = new AboutContentPane();
        this.renderPanel.setLayout(new BorderLayout());
        this.newVariableContentPane = new NewVariableContentPane();
    }

    private void fileInit() {
        this.saveWorldFileChooser = new JFileChooser(){

            public void approveSelection() {
                File desiredFile = this.getSelectedFile();
                if (AuthoringTool.this.currentWorldLocation == null || AuthoringTool.this.currentWorldLocation.equals(desiredFile) || !desiredFile.exists()) {
                    if (AuthoringTool.this.shouldAllowOverwrite(desiredFile)) {
                        super.approveSelection();
                    } else {
                        DialogManager.showMessageDialog("That is protected Alice file and you can not overwrite it. Please choose another file.");
                    }
                } else if (desiredFile.exists()) {
                    if (AuthoringTool.this.shouldAllowOverwrite(desiredFile)) {
                        int n = DialogManager.showConfirmDialog("You are about to save over an existing file. Are you sure you want to?", "Save Over Warning", 0);
                        if (n == 0) {
                            super.approveSelection();
                        }
                    } else {
                        DialogManager.showMessageDialog("That is protected Alice file and you can not overwrite it. Please choose another file.");
                    }
                }
            }
        };
        this.saveWorldFileChooser.setApproveButtonText("Save As");
        this.saveWorldFileChooser.setDialogTitle("Save As...");
        this.saveWorldFileChooser.setFileSelectionMode(0);
        this.saveWorldFileChooser.setDialogType(1);
        this.saveWorldFileChooser.setFileFilter(this.worldFileFilter);
        this.saveWorldFileChooser.setPreferredSize(new Dimension(500, 300));
        this.startUpContentPane = new StartUpContentPane(this);
    }

    private void undoRedoInit() {
        this.addAuthoringToolStateListener(this.undoRedoStack);
        this.undoRedoStack.addUndoRedoListener(new UndoRedoListener(){

            public void onChange() {
                int currentIndex = AuthoringTool.this.undoRedoStack.getCurrentUndoableRedoableIndex();
                if (currentIndex == -1) {
                    ((AuthoringTool)AuthoringTool.this).actions.undoAction.setEnabled(false);
                } else {
                    ((AuthoringTool)AuthoringTool.this).actions.undoAction.setEnabled(true);
                }
                if (currentIndex == AuthoringTool.this.undoRedoStack.size() - 1) {
                    ((AuthoringTool)AuthoringTool.this).actions.redoAction.setEnabled(false);
                } else {
                    ((AuthoringTool)AuthoringTool.this).actions.redoAction.setEnabled(true);
                }
                AuthoringTool.this.worldHasBeenModified = currentIndex != AuthoringTool.this.undoRedoStack.getUnmodifiedIndex();
                AuthoringTool.this.updateTitle();
            }
        });
    }

    private void miscInit() {
        this.scheduler.addEachFrameRunnable(this.oneShotScheduler);
        this.jAliceFrameWindowListener = new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                AuthoringTool.this.quit();
            }
        };
        this.jAliceFrame.addWindowListener(this.jAliceFrameWindowListener);
        this.worldClock = new DefaultClock();
        this.worldScheduleRunnable = new Runnable(){

            public void run() {
                try {
                    AuthoringTool.this.worldClock.schedule();
                }
                catch (Throwable t) {
                    AuthoringTool.this.stopWorldAndShowDialog(t);
                }
            }
        };
        Timer fpsTimer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        fpsTimer.start();
        this.lastSaveTime = System.currentTimeMillis();
        Timer promptToSaveTimer = new Timer(60000, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int interval;
                long intervalMillis;
                long time;
                long dt;
                Window[] ownedWindows;
                boolean modalShowing = false;
                Window[] windowArray = ownedWindows = AuthoringTool.this.jAliceFrame.getOwnedWindows();
                int n = 0;
                int n2 = windowArray.length;
                while (n < n2) {
                    Window ownedWindow = windowArray[n];
                    if (ownedWindow.isShowing()) {
                        modalShowing = true;
                        break;
                    }
                    ++n;
                }
                boolean skipThisWorld = false;
                if (!AuthoringTool.this.worldHasBeenModified) {
                    skipThisWorld = true;
                }
                if (!modalShowing && !skipThisWorld && (dt = (time = System.currentTimeMillis()) - AuthoringTool.this.lastSaveTime) > (intervalMillis = (long)(interval = 15) * 60000L)) {
                    int result = DialogManager.showOptionDialog("You have not saved in more than" + interval + " minutes.\nIt is recommended that you save early and often to avoid losing work.", "Save?", 0, 2, null, new Object[]{"Save right now", "Remind me later"}, "Save right now");
                    if (result == 0) {
                        AuthoringTool.this.getActions().saveWorldAction.actionPerformed(null);
                    }
                    AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
                }
            }
        });
        promptToSaveTimer.start();
        this.addAuthoringToolStateListener(new AuthoringToolStateAdapter(){

            public void worldLoaded(AuthoringToolStateChangedEvent ev) {
                AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
            }

            public void worldSaved(AuthoringToolStateChangedEvent ev) {
                AuthoringTool.this.lastSaveTime = System.currentTimeMillis();
            }
        });
        if (AWTUtilities.mouseListenersAreSupported() || AWTUtilities.mouseMotionListenersAreSupported()) {
            this.scheduler.addEachFrameRunnable(new Runnable(){

                public void run() {
                    AWTUtilities.fireMouseAndMouseMotionListenersIfNecessary();
                }
            });
        }
        this.rectangleAnimator = new RectangleAnimator(this);
        this.watcherPanel.setMinimumSize(new Dimension(0, 0));
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
    }

    private void worldInit() {
        this.leaveWorld(false);
        this.world = new World();
        this.world.name.set("main");
        UserDefinedResponse play = new UserDefinedResponse();
        play.name.set("play");
        this.world.responses.add(play);
        this.world.addChild(play);
        this.world.m_children.add(play);
        CallToUserDefinedResponse call = new CallToUserDefinedResponse();
        UserDefinedResponseProperty udrp = new UserDefinedResponseProperty((Element)call, "userDefinedResponse", play);
        call.setUserDefinedResponse(udrp);
        WorldStartBehavior behavior = new WorldStartBehavior();
        behavior.addChild(call);
        behavior.m_children.add(call);
        ResponseProperty triggerResponse = new ResponseProperty((Element)behavior, "triggerResponse", call);
        behavior.setTriggerResponse(triggerResponse);
        behavior.name.set("behavior0");
        behavior.isEnabled.set(true);
        this.world.addChild(behavior);
        this.world.behaviors.add(behavior);
        this.worldClock.setWorld(this.world);
        this.world.setClock(this.worldClock);
        this.jAliceFrame.setWorld(this.world);
        Element[] elements = this.world.getDescendants(RenderTarget.class);
        if (elements.length > 0) {
            this.renderPanel.removeAll();
            this.renderPanel.revalidate();
            this.renderPanel.repaint();
        }
        this.setSelectedElement(this.world);
        this.loadTabs();
        if (!this.world.responses.isEmpty()) {
            this.editObject(this.world.responses.get(0), true);
        }
        this.undoRedoStack.setUnmodified();
        this.fireWorldLoaded(this.world);
    }

    public JAliceFrame getJAliceFrame() {
        return this.jAliceFrame;
    }

    public DefaultScheduler getScheduler() {
        return this.scheduler;
    }

    public OneShotScheduler getOneShotScheduler() {
        return this.oneShotScheduler;
    }

    public MainUndoRedoStack getUndoRedoStack() {
        return this.undoRedoStack;
    }

    public Actions getActions() {
        return this.actions;
    }

    public Object getContext() {
        return null;
    }

    public void setContext(Object context) {
    }

    public static OutputComponent getStdOutOutputComponent() {
        return stdOutOutputComponent;
    }

    public OutputComponent getStdErrOutputComponent() {
        return this.stdErrOutputComponent;
    }

    public boolean isStdOutToConsole() {
        return this.stdOutToConsole;
    }

    public boolean isStdErrToConsole() {
        return this.stdErrToConsole;
    }

    public WatcherPanel getWatcherPanel() {
        return this.watcherPanel;
    }

    public EditorManager getEditorManager() {
        return this.editorManager;
    }

    public void setSelectedElement(Element element) {
        if (element == null) {
            element = this.getWorld();
        }
        if (this.selectedElement != element) {
            this.selectedElement = element;
            this.fireElementSelected(element);
        }
    }

    public Element getSelectedElement() {
        return this.selectedElement;
    }

    public void addElementSelectionListener(ElementSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    protected void fireElementSelected(Element element) {
        Iterator iter = this.selectionListeners.iterator();
        while (iter.hasNext()) {
            ((ElementSelectionListener)iter.next()).elementSelected(element);
        }
    }

    public void addAuthoringToolStateListener(AuthoringToolStateListener listener) {
        this.stateListeners.add(listener);
    }

    protected void fireStateChanging(int previousState, int currentState) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, this.world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.stateChanging(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to an authoring tool state change.", t);
            }
        }
    }

    protected void fireWorldLoading(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldLoading(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world load.", t);
            }
        }
    }

    protected void fireWorldUnLoading(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldUnLoading(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world unload.", t);
            }
        }
    }

    protected void fireWorldStarting(int previousState, int currentState, World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldStarting(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world starting.", t);
            }
        }
    }

    protected void fireWorldStopping(int previousState, int currentState, World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldStopping(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world stopping.", t);
            }
        }
    }

    protected void fireWorldSaving(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldSaving(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world saving.", t);
            }
        }
    }

    protected void fireStateChanged(int previousState, int currentState) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, this.world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.stateChanged(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to authoring tool state changed.", t);
            }
        }
    }

    protected void fireWorldLoaded(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldLoaded(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world loaded.", t);
            }
        }
    }

    protected void fireWorldUnLoaded(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldUnLoaded(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world unloaded.", t);
            }
        }
    }

    protected void fireWorldStarted(int previousState, int currentState, World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldStarted(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world started.", t);
            }
        }
    }

    protected void fireWorldStopped(int previousState, int currentState, World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(previousState, currentState, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldStopped(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world stopped.", t);
            }
        }
    }

    protected void fireWorldSaved(World world) {
        AuthoringToolStateChangedEvent ev = new AuthoringToolStateChangedEvent(1, 1, world);
        for (AuthoringToolStateListener listener : this.stateListeners) {
            try {
                listener.worldSaved(ev);
            }
            catch (Throwable t) {
                AuthoringTool.showErrorDialog("Error in listener responding to world saved.", t);
            }
        }
    }

    public void editObject(Object object) {
        this.editObject(object, true);
    }

    public void editObject(Object object, boolean switchToNewTab) {
        Class editorClass = null;
        if (object != null) {
            editorClass = EditorUtilities.getBestEditor(object.getClass());
        }
        this.editObject(object, editorClass, switchToNewTab);
    }

    public void editObject(Object object, Class editorClass, boolean switchToNewTab) {
        this.jAliceFrame.getTabbedEditorComponent().editObject(object, editorClass, switchToNewTab);
        this.saveTabs();
    }

    public void editObject(Object object, JComponent componentToAnimateFrom) {
        if (!this.isObjectBeingEdited(object)) {
            this.animateEditOpen(componentToAnimateFrom);
        }
        this.editObject(object);
    }

    protected void animateEditOpen(JComponent componentToAnimateFrom) {
        Rectangle sourceBounds = componentToAnimateFrom.getBounds();
        Point sourceLocation = sourceBounds.getLocation();
        SwingUtilities.convertPointToScreen(sourceLocation, componentToAnimateFrom);
        sourceBounds.setLocation(sourceLocation);
        Rectangle targetBounds = this.jAliceFrame.getTabbedEditorComponent().getBounds();
        Point targetLocation = targetBounds.getLocation();
        SwingUtilities.convertPointToScreen(targetLocation, this.jAliceFrame.getTabbedEditorComponent());
        targetBounds.setLocation(targetLocation);
        Color color = componentToAnimateFrom.getBackground();
        this.rectangleAnimator.animate(sourceBounds, targetBounds, color);
    }

    public Object getObjectBeingEdited() {
        return this.jAliceFrame.getTabbedEditorComponent().getObjectBeingEdited();
    }

    public Object[] getObjectsBeingEdited() {
        return this.jAliceFrame.getTabbedEditorComponent().getObjectsBeingEdited();
    }

    public boolean isObjectBeingEdited(Object object) {
        return this.jAliceFrame.getTabbedEditorComponent().isObjectBeingEdited(object);
    }

    private int showStartUpDialog(int tabID) {
        int retVal = this.askForSaveIfNecessary();
        if (retVal != 3) {
            this.startUpContentPane.setTabID(tabID);
            if (DialogManager.showDialog(this.startUpContentPane) == 0) {
                File file = this.startUpContentPane.getFile();
                this.loadWorld(file, false);
            }
            return 1;
        }
        return retVal;
    }

    public int newWorld() {
        int retVal = this.askForSaveIfNecessary();
        if (retVal != 3) {
            this.worldInit();
            return 1;
        }
        return retVal;
    }

    public int openWorld() {
        return this.showStartUpDialog(1);
    }

    public int saveWorld() {
        if (this.currentWorldLocation != null && this.shouldAllowOverwrite(this.currentWorldLocation) && this.currentWorldLocation.canWrite()) {
            try {
                return this.saveWorldToFile(this.currentWorldLocation);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Unable to save world: " + this.currentWorldLocation.getAbsolutePath(), e);
                return 2;
            }
        }
        return this.saveWorldAs();
    }

    public int saveWorldAs() {
        int returnVal = DialogManager.showSaveDialog(this.saveWorldFileChooser);
        if (returnVal == 0) {
            File file = this.saveWorldFileChooser.getSelectedFile();
            if (!file.getName().endsWith(".a2w")) {
                file = new File(file.getParent(), String.valueOf(file.getName()) + "." + WORLD_EXTENSION);
            }
            try {
                return this.saveWorldToFile(file);
            }
            catch (IOException e) {
                AuthoringTool.showErrorDialog("Unable to save world: " + file, e);
                file.delete();
                return 2;
            }
        }
        if (returnVal == 0) {
            return 3;
        }
        return 2;
    }

    private void finalCleanUp() {
    }

    public int quit() {
        int retVal;
        block9: {
            block8: {
                retVal = this.leaveWorld(true);
                if (retVal != 1) break block8;
                this.finalCleanUp();
                System.exit(0);
                return 1;
            }
            if (retVal != 3) break block9;
            return 3;
        }
        try {
            int result;
            if (retVal == 2 && (result = DialogManager.showConfirmDialog("Alice failed to correctly save and/or close the current world.  Would you still like to quit?")) == 0) {
                this.finalCleanUp();
                System.exit(1);
            }
        }
        catch (Throwable t) {
            try {
                int result = DialogManager.showConfirmDialog("Error encountered while attempting to close Alice.  Would you like to force the close?");
                if (result == 0) {
                    this.finalCleanUp();
                    System.exit(1);
                }
            }
            catch (Throwable t2) {
                this.finalCleanUp();
                System.exit(1);
            }
        }
        return 2;
    }

    public int askForSaveIfNecessary() {
        if (this.worldHasBeenModified) {
            if (this.currentWorldLocation == null || !this.shouldAllowOverwrite(this.currentWorldLocation)) {
                String question = "The world has not been saved.  Would you like to save it?";
                int n = DialogManager.showConfirmDialog(question, "Save?", 1);
                if (n == 0) {
                    int retVal = this.saveWorldAs();
                    if (retVal == 3) {
                        return this.askForSaveIfNecessary();
                    }
                    if (retVal == 2) {
                        return 2;
                    }
                } else {
                    if (n == 1) {
                        return 1;
                    }
                    if (n == 2) {
                        return 3;
                    }
                    if (n == -1) {
                        return 3;
                    }
                }
            } else {
                String question = "The world has been modified.  Would you like to save it?";
                int n = DialogManager.showConfirmDialog(question, "Save?", 1);
                if (n == 0) {
                    int retVal = this.saveWorld();
                    if (retVal == 3) {
                        return 3;
                    }
                    if (retVal == 2) {
                        return 2;
                    }
                } else {
                    if (n == 1) {
                        return 1;
                    }
                    if (n == 2) {
                        return 3;
                    }
                    if (n == -1) {
                        return 3;
                    }
                }
            }
            this.worldHasBeenModified = false;
            this.undoRedoStack.setUnmodified();
        }
        return 1;
    }

    public int leaveWorld(boolean askForSaveIfNecessary) {
        block5: {
            int retVal;
            block6: {
                try {
                    if (!askForSaveIfNecessary) break block5;
                    retVal = this.askForSaveIfNecessary();
                    if (retVal != 3) break block6;
                    return 3;
                }
                catch (Exception e) {
                    AuthoringTool.showErrorDialog("Error encountered while leaving current world.", e);
                    return 2;
                }
            }
            if (retVal != 2) break block5;
            return 2;
        }
        this.fireWorldUnLoading(this.world);
        this.saveTabsEnabled = false;
        this.undoRedoStack.clear();
        this.jAliceFrame.setWorld(null);
        this.setCurrentWorldLocation(null);
        this.editObject(null);
        if (this.world != null) {
            this.world.release();
            this.fireWorldUnLoaded(this.world);
        }
        this.world = null;
        return 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int saveWorldToFile(File file) throws IOException {
        boolean tempListening;
        block10: {
            block11: {
                if (file.exists() && !file.canWrite()) {
                    DialogManager.showMessageDialog("Cannot save world.  " + file.getAbsolutePath() + " is read-only.", "Cannot Save", 0);
                    return 2;
                }
                if (file.exists()) {
                    this.worldStoreProgressPane.setIsCancelEnabled(false);
                } else {
                    this.worldStoreProgressPane.setIsCancelEnabled(true);
                }
                this.fireWorldSaving(this.world);
                tempListening = this.getUndoRedoStack().getIsListening();
                this.undoRedoStack.setIsListening(false);
                this.saveTabsEnabled = true;
                this.saveTabs();
                Hashtable map = new Hashtable();
                this.worldStoreProgressPane.setElement(this.world);
                this.worldStoreProgressPane.setFile(file);
                this.worldStoreProgressPane.setFilnameToByteArrayMap(map);
                int result = DialogManager.showDialog(this.worldStoreProgressPane);
                if (result != 0) break block10;
                if (!this.worldStoreProgressPane.wasSuccessful()) break block11;
                this.jAliceFrame.HACK_standDownFromRedAlert();
                this.worldHasBeenModified = false;
                this.undoRedoStack.setUnmodified();
                this.setCurrentWorldLocation(file);
                this.fireWorldSaved(this.world);
                this.undoRedoStack.setIsListening(tempListening);
                return 1;
            }
            return 2;
        }
        try {
            file.delete();
            this.undoRedoStack.setIsListening(tempListening);
            return 3;
        }
        catch (Throwable t) {
            try {
                AuthoringTool.showErrorDialog("Unable to store world to file: " + file, t);
                return 2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                this.undoRedoStack.setIsListening(tempListening);
            }
        }
    }

    public int loadWorld(File file, boolean askForSaveIfNecessary) {
        int result;
        if (file.isFile()) {
            result = this.loadWorld(new ZipFileTreeLoader(), file, askForSaveIfNecessary);
        } else if (file.isDirectory()) {
            result = this.loadWorld(new FileSystemTreeLoader(), file, askForSaveIfNecessary);
        } else {
            AuthoringTool.showErrorDialog("not a file or directory: " + file, null);
            result = 2;
        }
        return result;
    }

    public int loadWorld(DirectoryTreeLoader loader, Object path, boolean askForSaveIfNecessary) {
        if (askForSaveIfNecessary) {
            int result;
            int retVal = this.askForSaveIfNecessary();
            if (retVal == 3) {
                return 3;
            }
            if (retVal == 2 && (result = DialogManager.showConfirmDialog("Alice failed to correctly save the current world.  Would you still like to load a new world?")) != 0) {
                return 3;
            }
        }
        this.fireWorldLoading(null);
        World tempWorld = null;
        try {
            loader.open(path);
            try {
                this.worldLoadProgressPane.setLoader(loader);
                this.worldLoadProgressPane.setExternalRoot(null);
                DialogManager.showDialog(this.worldLoadProgressPane);
                tempWorld = (World)this.worldLoadProgressPane.getLoadedElement();
            }
            finally {
                loader.close();
            }
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Unable to load world: " + path, t);
        }
        if (path instanceof File) {
            this.setCurrentWorldLocation((File)path);
            ((File)path).isDirectory();
        } else {
            this.setCurrentWorldLocation(null);
        }
        return this.populateWorldPanel(tempWorld);
    }

    public int loadAppletWorld(String exerciseString) {
        World tempWorld = null;
        try {
            tempWorld = (World)AppletWorldLoader.loadWorld(exerciseString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
        return this.populateWorldPanel(tempWorld);
    }

    private int populateWorldPanel(World tempWorld) {
        if (tempWorld != null) {
            this.leaveWorld(false);
            this.world = tempWorld;
            this.worldClock.setWorld(this.world);
            this.world.setClock(this.worldClock);
            this.jAliceFrame.setWorld(this.world);
            Element[] elements = this.world.getDescendants(RenderTarget.class);
            if (elements.length > 0) {
                this.renderPanel.removeAll();
                this.renderPanel.revalidate();
                this.renderPanel.repaint();
            }
            this.setSelectedElement(this.world);
            this.loadTabs();
            if (!this.world.responses.isEmpty()) {
                this.editObject(this.world.responses.get(0), true);
            }
            this.undoRedoStack.setUnmodified();
            this.fireWorldLoaded(this.world);
            return 1;
        }
        return 2;
    }

    protected boolean shouldAllowOverwrite(File file) {
        return true;
    }

    public void saveTabs() {
        if (this.saveTabsEnabled && this.world != null) {
            Object[] objects = this.jAliceFrame.getTabbedEditorComponent().getObjectsBeingEdited();
            String tabObjectsString = "";
            Object[] objectArray = objects;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object object = objectArray[n];
                if (object instanceof Element) {
                    tabObjectsString = String.valueOf(tabObjectsString) + ((Element)object).getKey() + ":";
                }
                ++n;
            }
            this.world.data.put("edu.cmu.cs.stage3.alice.authoringtool.tabObjects", tabObjectsString);
        }
    }

    public void loadTabs() {
        String tabObjectsString;
        if (this.world != null && (tabObjectsString = (String)this.world.data.get("edu.cmu.cs.stage3.alice.authoringtool.tabObjects")) != null) {
            StringTokenizer st = new StringTokenizer(tabObjectsString, ":");
            this.getJAliceFrame().setCursor(Cursor.getPredefinedCursor(3));
            while (st.hasMoreTokens()) {
                String key = st.nextToken();
                Element element = this.world.getDescendantKeyed(key = key.substring(this.world.getKey().length() + (key.equals(this.world.getKey()) ? 0 : 1)));
                if (element == null) continue;
                this.editObject((Object)element, false);
            }
            this.getJAliceFrame().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void performOneShot(Response response, Response undoResponse, Property[] affectedProperties) {
        OneShotSimpleBehavior oneShotBehavior = new OneShotSimpleBehavior();
        oneShotBehavior.setResponse(response);
        oneShotBehavior.setAffectedProperties(affectedProperties);
        oneShotBehavior.start(this.oneShotScheduler);
        OneShotUndoableRedoable undo = new OneShotUndoableRedoable(response, undoResponse, oneShotBehavior, this.oneShotScheduler);
        this.undoRedoStack.push(undo);
    }

    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void setElementScope(Element element) {
        if (element != null) {
            if (this.selectedElement != null) {
                if (!this.selectedElement.isDescendantOf(element)) {
                    this.setSelectedElement(element);
                }
            } else {
                this.setSelectedElement(element);
            }
        }
    }

    public void showAbout() {
        DialogManager.showDialog(this.aboutContentPane);
    }

    public void viewXml() {
        String worldXml = AppletWorldStorer.getWorldXml(this.world);
        DialogManager.showTextDialog(worldXml);
    }

    public static void showSaveErrorDialog(String message, Throwable t) {
        AuthoringTool.getHack().jAliceFrame.HACK_goToRedAlert();
        SaveErrorContentPane errorPane = new SaveErrorContentPane();
        errorPane.setMessage(message);
        errorPane.setSubmitBugButtonEnabled(true);
        errorPane.setThrowable(t);
        DialogManager.showDialog(errorPane);
        if (AuthoringTool.getHack().isStdErrToConsole() && t != null) {
            t.printStackTrace(System.err);
        }
    }

    public static void showErrorDialog(String message, Throwable t) {
        AuthoringTool.showErrorDialog(message, t, true);
    }

    public static void showErrorDialog(String message, Throwable t, boolean showSubmitBugButton) {
        ErrorContentPane errorPane = new ErrorContentPane();
        errorPane.setMessage(message);
        errorPane.setSubmitBugButtonEnabled(showSubmitBugButton);
        errorPane.setThrowable(t);
        if (AuthoringTool.getHack().isStdErrToConsole() && t != null) {
            t.printStackTrace(System.err);
        }
    }

    public static void showErrorDialogWithDetails(String message, String details, boolean showSubmitBugButton) {
        ErrorContentPane errorPane = new ErrorContentPane();
        errorPane.setMessage(message);
        errorPane.setSubmitBugButtonEnabled(showSubmitBugButton);
        DialogManager.showDialog(errorPane);
    }

    private void stopWorldAndShowDialog(Throwable throwable) {
        this.stopWorld();
        if (throwable instanceof ExceptionWrapper) {
            throwable = ((ExceptionWrapper)throwable).getWrappedException();
        }
        final Throwable t = throwable;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (t instanceof SimulationException) {
                    AuthoringTool.this.showSimulationExceptionDialog((SimulationException)t);
                } else {
                    AuthoringTool.showErrorDialog("Error during simulation.", t);
                }
            }
        });
    }

    public void showSimulationExceptionDialog(SimulationException simulationException) {
        SimulationExceptionPanel simulationExceptionPanel = new SimulationExceptionPanel(this);
        simulationExceptionPanel.setSimulationException(simulationException);
        DialogManager.showMessageDialog(simulationExceptionPanel, "Problem Detected", 0, AuthoringToolResources.getAliceSystemIcon());
    }

    public World getWorld() {
        return this.world;
    }

    public void showOnScreenHelp() {
        this.showStencils();
    }

    public void showStdErrOutDialog() {
    }

    private void setCurrentWorldLocation(File file) {
        this.currentWorldLocation = file;
        this.updateTitle();
    }

    private void updateTitle() {
        String path = "";
        if (this.currentWorldLocation != null) {
            try {
                path = this.currentWorldLocation.getCanonicalPath();
            }
            catch (IOException e) {
                path = this.currentWorldLocation.getAbsolutePath();
            }
        }
        String modifiedStatus = "";
        if (this.worldHasBeenModified) {
            modifiedStatus = " [Modified]";
        }
        this.jAliceFrame.setTitle("Alice " + path + modifiedStatus);
    }

    private void stencilInit() {
        this.classesToStopOn.add(JMenu.class);
        this.classesToStopOn.add(AbstractButton.class);
        this.classesToStopOn.add(JComboBox.class);
        this.classesToStopOn.add(JList.class);
        this.classesToStopOn.add(JMenu.class);
        this.classesToStopOn.add(JSlider.class);
        this.classesToStopOn.add(JTextComponent.class);
        this.classesToStopOn.add(JTabbedPane.class);
        this.classesToStopOn.add(JTree.class);
        this.classesToStopOn.add(JTable.class);
        this.classesToStopOn.add(DragFromComponent.class);
        this.classesToStopOn.add(DnDGroupingPanel.class);
        this.classesToStopOn.add(TrashComponent.class);
        this.classesToStopOn.add(PropertyViewController.class);
        this.componentMap.put("fileMenu", this.jAliceFrame.fileMenu);
        this.componentMap.put("helpMenu", this.jAliceFrame.helpMenu);
        this.componentMap.put("playButton", this.jAliceFrame.playButton);
        this.componentMap.put("undoButton", this.jAliceFrame.undoButton);
        this.componentMap.put("redoButton", this.jAliceFrame.redoButton);
        this.componentMap.put("trashComponent", this.jAliceFrame.trashComponent);
        this.componentMap.put("details", this.jAliceFrame.dragFromComponent);
        this.componentMap.put("editors", this.jAliceFrame.tabbedEditorComponent);
        this.updateTimer = new Timer(100, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
            }
        });
        this.updateTimer.setRepeats(false);
    }

    public void hackStencilUpdate() {
        if (this.updateTimer != null) {
            this.updateTimer.restart();
        }
    }

    public void showStencils() {
        this.setLayout();
        this.jAliceFrame.requestFocus();
    }

    protected void restoreLayout() {
        this.jAliceFrame.doLayout();
        this.jAliceFrame.setResizable(true);
    }

    protected void setLayout() {
        int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
        Dimension d = this.getScreenSize();
        int newWidth = d.width;
        int newHeight = d.height;
        if (d.width > 1032) {
            newWidth = 1032;
        } else if (d.width < 1024 && screenWidth >= 1024) {
            newWidth = 1032;
        }
        if (d.height > 776) {
            newHeight = 740;
        } else if (d.height < 740 && screenWidth >= 768) {
            newHeight = 740;
        }
        boolean shouldModifyStuff = true;
        this.renderContentPane.saveRenderBounds(new Rectangle(191, 199, 400, 300));
        if (shouldModifyStuff) {
            this.jAliceFrame.leftRightSplitPane.setDividerLocation(230);
            this.jAliceFrame.setSize(newWidth, newHeight);
        }
        this.jAliceFrame.doLayout();
        this.jAliceFrame.setResizable(false);
    }

    public void setGlassPane(Component c) {
        this.jAliceFrame.setGlassPane(c);
    }

    public void setVisible(boolean visible) {
        if (JAlice.isApplet) {
            return;
        }
        if (visible) {
            this.setLayout();
            this.jAliceFrame.requestFocus();
        } else {
            this.restoreLayout();
            this.jAliceFrame.requestFocus();
        }
    }

    public Dimension getScreenSize() {
        return this.jAliceFrame.getSize();
    }

    public FileFilter getWorldFileFilter() {
        return this.worldFileFilter;
    }

    public Variable showNewVariableDialog(String title, Element context) {
        this.newVariableContentPane.reset(context);
        this.newVariableContentPane.setTitle(title);
        this.newVariableContentPane.setListsOnly(false);
        this.newVariableContentPane.setShowValue(true);
        return this.showNewVariableDialog(this.newVariableContentPane, context);
    }

    public Variable showNewVariableDialog(String title, Element context, boolean listsOnly, boolean showValue) {
        this.newVariableContentPane.reset(context);
        this.newVariableContentPane.setListsOnly(listsOnly);
        this.newVariableContentPane.setShowValue(showValue);
        this.newVariableContentPane.setTitle(title);
        return this.showNewVariableDialog(this.newVariableContentPane, context);
    }

    protected Variable showNewVariableDialog(NewVariableContentPane newVariablePaneToShow, Element context) {
        int result = DialogManager.showDialog(newVariablePaneToShow);
        switch (result) {
            case 0: {
                return newVariablePaneToShow.getVariable();
            }
            case 2: {
                return null;
            }
        }
        return null;
    }

    public File getCurrentWorldLocation() {
        return this.currentWorldLocation;
    }

    public String getCurrentRendererText() {
        return "";
    }

    private boolean worldRun() {
        this.undoRedoStack.setIsListening(false);
        this.fireStateChanging(1, 3);
        this.fireWorldStarting(1, 3, this.world);
        this.world.preserve();
        try {
            this.worldClock.start();
            this.scheduler.addEachFrameRunnable(this.worldScheduleRunnable);
            this.actions.pauseWorldAction.setEnabled(true);
            this.actions.resumeWorldAction.setEnabled(false);
            this.fireStateChanged(1, 3);
            this.fireWorldStarted(1, 3, this.world);
        }
        catch (SimulationException e) {
            this.world.restore();
            this.showSimulationExceptionDialog(e);
            return false;
        }
        catch (ExceptionWrapper e) {
            this.world.restore();
            Exception wrappedException = e.getWrappedException();
            if (wrappedException instanceof SimulationException) {
                this.showSimulationExceptionDialog((SimulationException)wrappedException);
            } else {
                AuthoringTool.showErrorDialog("Error during world start.", wrappedException);
            }
            return false;
        }
        catch (Throwable t) {
            this.world.restore();
            AuthoringTool.showErrorDialog("Error during world start.", t);
            return false;
        }
        return true;
    }

    public void worldStopRunning() {
        this.fireStateChanging(3, 1);
        this.fireWorldStopping(3, 1, this.world);
        this.scheduler.removeEachFrameRunnable(this.worldScheduleRunnable);
        try {
            this.worldClock.stop();
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Error during world stop.", t);
        }
        this.world.restore();
        this.undoRedoStack.setIsListening(true);
        this.fireStateChanged(3, 1);
        this.fireWorldStopped(3, 1, this.world);
    }

    public double getAspectRatio() {
        double aspectRatio = 0.0;
        return aspectRatio;
    }

    private void checkForUnreferencedCurrentMethod() {
        Object object = this.getObjectBeingEdited();
        if (object instanceof UserDefinedResponse && !AuthoringToolResources.isMethodHookedUp((UserDefinedResponse)object, this.world)) {
            String objectRepr = AuthoringToolResources.getReprForValue(object, true);
            DialogManager.showMessageDialog("The current method (" + objectRepr + ") is not called by any events or by any other methods which might be called by any events.", "Warning: Current method will not be called.", 2);
        }
    }

    public void play() {
        this.jAliceFrame.playButton.setEnabled(false);
        this.checkForUnreferencedCurrentMethod();
        if (this.worldRun()) {
            double aspectRatio = this.getAspectRatio();
            this.renderContentPane.setAspectRatio(aspectRatio);
            this.renderContentPane.getRenderPanel().add((Component)this.renderPanel, "Center");
            DialogManager.showDialog(this.renderContentPane);
        }
        this.jAliceFrame.playButton.setEnabled(true);
    }

    public void pause() {
        this.worldClock.pause();
        this.actions.pauseWorldAction.setEnabled(false);
        this.actions.resumeWorldAction.setEnabled(true);
    }

    public void resume() {
        this.worldClock.resume();
        this.actions.pauseWorldAction.setEnabled(true);
        this.actions.resumeWorldAction.setEnabled(false);
    }

    public void restartWorld() {
        try {
            this.worldClock.stop();
            this.world.restore();
            this.actions.pauseWorldAction.setEnabled(true);
            this.actions.resumeWorldAction.setEnabled(false);
            this.worldClock.start();
        }
        catch (SimulationException e) {
            this.showSimulationExceptionDialog(e);
        }
        catch (ExceptionWrapper e) {
            Exception wrappedException = e.getWrappedException();
            if (wrappedException instanceof SimulationException) {
                this.showSimulationExceptionDialog((SimulationException)wrappedException);
            } else {
                AuthoringTool.showErrorDialog("Error while restarting world.", wrappedException);
            }
        }
        catch (Throwable t) {
            AuthoringTool.showErrorDialog("Error while restarting world.", t);
        }
    }

    public void stopWorld() {
        this.renderContentPane.stopWorld();
    }
}

