/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;

public abstract class TextFieldEditablePropertyViewController
extends PropertyViewController {
    protected JTextField textField = new JTextField();
    protected FocusListener focusListener = new FocusAdapter(){

        public void focusLost(FocusEvent focusEvent) {
            TextFieldEditablePropertyViewController.this.stopEditing();
        }
    };
    protected boolean allowEasyEditWithClick = true;

    public TextFieldEditablePropertyViewController() {
        this.textField.setColumns(5);
        this.textField.setMinimumSize(new Dimension(80, 18));
        this.textField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextFieldEditablePropertyViewController.this.stopEditing();
                TextFieldEditablePropertyViewController.this.popupButton.requestFocus();
            }
        });
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    TextFieldEditablePropertyViewController.this.cancelEditing();
                    TextFieldEditablePropertyViewController.this.popupButton.requestFocus();
                }
            }
        });
    }

    public String getValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return "";
    }

    public void set(Property property, boolean bl, boolean bl2, boolean bl3, boolean bl4, PopupItemFactory popupItemFactory) {
        super.set(property, bl, bl2, bl3, bl4, popupItemFactory);
    }

    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (TextFieldEditablePropertyViewController.this.allowEasyEditWithClick && (TextFieldEditablePropertyViewController.this.isAncestorOf(TextFieldEditablePropertyViewController.this.getNativeComponent()) || TextFieldEditablePropertyViewController.this.mainVariableProperty.get() == null)) {
                    TextFieldEditablePropertyViewController.this.editValue();
                } else {
                    TextFieldEditablePropertyViewController.this.popupButton.doClick();
                }
            }
        };
    }

    public void editValue() {
        if (this.editingEnabled) {
            if (this.mainVariableProperty.getValue() != null) {
                String string = "edu.cmu.cs.stage3.alice.authoringtool.userRepr." + this.mainVariableProperty.getName();
                Object object = this.mainVariableProperty.getOwner().getDictionaryProperty(string);
                if (object instanceof String) {
                    this.textField.setText((String)object);
                } else {
                    this.textField.setText(this.mainVariableProperty.getValue().toString());
                }
            }
            if (this.isAncestorOf(this.getNativeComponent())) {
                this.remove(this.getNativeComponent());
            } else if (this.isAncestorOf(this.expressionLabel)) {
                this.remove(this.expressionLabel);
            }
            if (!this.isAncestorOf(this.textField)) {
                this.add((Component)this.textField, "Center");
            }
            this.revalidate();
            this.textField.requestFocus();
            this.textField.addFocusListener(this.focusListener);
            this.textField.selectAll();
        }
    }

    public void stopEditing() {
        this.textField.removeFocusListener(this.focusListener);
        String string = this.textField.getText();
        this.remove(this.textField);
        this.add(this.getNativeComponent(), "Center");
        this.getNativeComponent().requestFocus();
        this.setValueFromString(string);
        this.refreshGUI();
    }

    public void cancelEditing() {
        this.textField.removeFocusListener(this.focusListener);
        this.remove(this.textField);
        this.add(this.getNativeComponent(), "Center");
        this.refreshGUI();
    }

    protected void refreshGUI() {
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }

    protected abstract void setValueFromString(String var1);
}

