/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElementContainerListener;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.util.StrUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class GroupingPanel
extends JPanel
implements DropTargetListener,
Releasable {
    protected Border outerBorder;
    protected Border innerBorder;
    protected Border border;
    private static int staticCont = 0;
    public int cont = staticCont++;
    public DropTarget dropTarget = null;

    public GroupingPanel() {
        this.outerBorder = new PartialLineBorder(Color.lightGray, 1, false, false, true, true);
        this.innerBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        this.border = BorderFactory.createCompoundBorder(this.outerBorder, this.innerBorder);
        this.setBorder(this.border);
        this.setDoubleBuffered(true);
        this.dropTarget = new DropTarget(this, this);
        this.setDropTarget(this.dropTarget);
        this.addContainerListener(new ContainerAdapter(){

            public void componentAdded(ContainerEvent containerEvent) {
                if (containerEvent.getChild().getDropTarget() == null) {
                    containerEvent.getChild().setDropTarget(new DropTarget(containerEvent.getChild(), GroupingPanel.this));
                }
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                if (containerEvent.getChild().getDropTarget() != null) {
                    containerEvent.getChild().getDropTarget().setActive(false);
                    containerEvent.getChild().setDropTarget(null);
                }
            }
        });
        this.addContainerListener(GUIElementContainerListener.getStaticListener());
    }

    public void release() {
        this.removeAll();
    }

    public void paintBackground(Graphics graphics) {
    }

    public void paintForeground(Graphics graphics) {
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        this.paintBackground(graphics);
    }

    public void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        this.paintForeground(graphics);
    }

    public void printComponent(Graphics graphics) {
        super.printComponent(graphics);
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragEnter(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragExit(dropTargetEvent);
        }
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dragOver(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        int n = actionEvent.getModifiers();
        String string = actionEvent.getActionCommand();
        String string2 = actionEvent.paramString();
        System.out.println("GroupingPanel.java: actionPerformed: " + n + ", actionCommand=" + string + ", paramString=" + string2 + ": " + StrUtilities.getComponentName(object));
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).drop(dropTargetDropEvent);
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        if (this.getParent() instanceof DropTargetListener) {
            ((DropTargetListener)((Object)this.getParent())).dropActionChanged(dropTargetDragEvent);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    private class PartialLineBorder
    extends AbstractBorder {
        protected Color color;
        protected int thickness;
        protected boolean includeTop;
        protected boolean includeLeft;
        protected boolean includeBottom;
        protected boolean includeRight;

        public PartialLineBorder(Color color, int n, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
            this.color = color;
            this.thickness = n;
            this.includeTop = bl;
            this.includeLeft = bl2;
            this.includeBottom = bl3;
            this.includeRight = bl4;
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            Color color = graphics.getColor();
            graphics.setColor(this.color);
            for (int i = 0; i < this.thickness; ++i) {
                if (this.includeTop) {
                    graphics.drawLine(n, n2 + i, n + n3 - 1, n2 + i);
                }
                if (this.includeLeft) {
                    graphics.drawLine(n + i, n2, n + i, n2 + n4 - 1);
                }
                if (this.includeBottom) {
                    graphics.drawLine(n, n2 - i + n4 - 1, n + n3 - 1, n2 - i + n4 - 1);
                }
                if (!this.includeRight) continue;
                graphics.drawLine(n - i + n3 - 1, n2, n - i + n3 - 1, n2 + n4 - 1);
            }
            graphics.setColor(color);
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(this.includeTop ? this.thickness : 0, this.includeLeft ? this.thickness : 0, this.includeBottom ? this.thickness : 0, this.includeRight ? this.thickness : 0);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.top = this.includeTop ? this.thickness : 0;
            insets.left = this.includeLeft ? this.thickness : 0;
            insets.bottom = this.includeBottom ? this.thickness : 0;
            insets.right = this.includeRight ? this.thickness : 0;
            return insets;
        }

        public Color getLineColor() {
            return this.color;
        }

        public int getThickness() {
            return this.thickness;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

