/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.util.StrUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public abstract class AliceAlertContentPane
extends ContentPane {
    public static final int LESS_DETAIL_MODE = 0;
    public static final int MORE_DETAIL_MODE = 1;
    protected int mode = -1;
    protected ImagePanel errorIconPanel = new ImagePanel();
    protected StyledStreamTextPane detailTextPane = new StyledStreamTextPane();
    protected StyleStream detailStream;
    protected JPanel buttonPanel = new JPanel();
    protected JPanel messagePanel = new JPanel();
    protected JPanel detailPanel = new JPanel();
    protected JScrollPane detailScrollPane = new JScrollPane();
    protected JTextArea messageLabel = new JTextArea();
    protected JButton submitBugButton = new JButton();
    protected JButton copyButton = new JButton();
    protected JButton cancelButton = new JButton();
    protected JButton detailButton = new JButton();
    protected GridBagConstraints buttonConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0);
    protected GridBagConstraints glueConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
    protected Component buttonGlue;
    static /* synthetic */ Class class$edu$cmu$cs$stage3$alice$authoringtool$JAlice;

    public AliceAlertContentPane() {
        this.init();
    }

    public void preDialogShow(JDialog jDialog) {
        super.preDialogShow(jDialog);
    }

    public void postDialogShow(JDialog jDialog) {
        super.postDialogShow(jDialog);
    }

    public String getTitle() {
        return I18n.getString("msgAlertSubmitTitle");
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    protected void init() {
        this.jbInit();
        this.setMode(0);
    }

    public void setSubmitBugButtonEnabled(boolean bl) {
        if (bl != this.buttonPanel.isAncestorOf(this.submitBugButton)) {
            if (bl) {
                this.buttonPanel.add((Component)this.submitBugButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 0), 0, 0));
            } else {
                this.buttonPanel.remove(this.submitBugButton);
            }
        }
    }

    public void setMessage(String string) {
        this.messageLabel.setText(string);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        return dimension;
    }

    protected void setLessDetail() {
        this.detailButton.setText(I18n.getString("msgAlertSubmitMore") + " >>");
        this.remove(this.detailScrollPane);
        this.add((Component)this.detailPanel, "Center");
        this.buttonPanel.removeAll();
        this.buttonConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.submitBugButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.glueConstraints.gridx = this.buttonConstraints.gridx++;
        this.buttonPanel.add(this.buttonGlue, this.glueConstraints);
        this.buttonPanel.add((Component)this.detailButton, this.buttonConstraints);
    }

    protected void setMoreDetail() {
        this.detailButton.setText(I18n.getString("msgAlertSubmitLess") + " <<");
        this.remove(this.detailPanel);
        this.add((Component)this.detailScrollPane, "Center");
        this.buttonPanel.removeAll();
        this.buttonConstraints.gridx = 0;
        this.buttonPanel.add((Component)this.submitBugButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.copyButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.buttonPanel.add((Component)this.cancelButton, this.buttonConstraints);
        ++this.buttonConstraints.gridx;
        this.glueConstraints.gridx = this.buttonConstraints.gridx++;
        this.buttonPanel.add(this.buttonGlue, this.glueConstraints);
        this.buttonPanel.add((Component)this.detailButton, this.buttonConstraints);
    }

    protected void handleModeSwitch(int n) {
        if (n == 0) {
            this.setLessDetail();
        } else if (n == 1) {
            this.setMoreDetail();
        } else {
            throw new IllegalArgumentException(I18n.getString("msgAlertSubmitIllegal") + ": " + n);
        }
    }

    public void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            this.handleModeSwitch(n);
            this.packDialog();
        }
    }

    public void toggleMode() {
        if (this.mode == 0) {
            this.setMode(1);
        } else {
            this.setMode(0);
        }
    }

    protected void writeAliceHeaderToTextPane() {
        this.detailTextPane.setText("");
        this.detailStream.println(this.messageLabel.getText() + "\n");
        this.detailStream.println();
        this.detailStream.println("");
        String[] stringArray = new String[]{"os.name", "os.version", "os.arch", "java.vm.name", "java.vm.version", "user.dir"};
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            this.detailStream.println(stringArray[i] + ": " + System.getProperty(stringArray[i]));
        }
        this.detailStream.println();
    }

    protected void submitBug() {
        String string = this.postStacktrace();
        AuthoringTool authoringTool = AuthoringTool.getInstance();
        int n = -1;
        try {
            n = StrUtilities.submitPOST(string);
        }
        catch (Throwable throwable) {
            authoringTool.showErrorDialog(I18n.getString("msgAlertSubmitFail"), throwable);
        }
        try {
            String string2 = "";
            if (n == 1) {
                string2 = "msgAlertSubmitSuccess";
            } else if (n == -1) {
                string2 = "msgAlertSubmitFail";
            } else if (n == -2) {
                string2 = "msgAlertSubmitNotCertified";
            }
            String string3 = this.messageLabel.getText();
            this.messageLabel.setText(string3 + I18n.getString(string2));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String postStacktrace() {
        try {
            String string = URLEncoder.encode(this.detailTextPane.getText());
            while (string.indexOf("%0D") > -1) {
                int n = string.indexOf("%0D");
                string = string.substring(0, n) + string.substring(n + 3);
            }
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog(I18n.getString("msgAlertSubmitErrorPost"), throwable);
            return "0";
        }
    }

    protected void copyDetailText() {
        String string = this.detailTextPane.getText();
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(string), AuthoringTool.getInstance());
    }

    void detailButton_actionPerformed(ActionEvent actionEvent) {
        this.toggleMode();
    }

    void submitBugButton_actionPerformed(ActionEvent actionEvent) {
        this.submitBug();
    }

    void copyButton_actionPerformed(ActionEvent actionEvent) {
        this.copyDetailText();
    }

    private void jbInit() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.buttonGlue = Box.createHorizontalGlue();
        this.messageLabel.setEditable(false);
        this.messageLabel.setLineWrap(true);
        this.messageLabel.setOpaque(false);
        this.messageLabel.setPreferredSize(new Dimension(402, 1));
        this.messageLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.messageLabel.setText(I18n.getString("msgAlertSubmitErrorUnknown"));
        this.cancelButton.setText(I18n.getString("msgCancel"));
        this.detailButton.setText(I18n.getString("msgAlertSubmitMore") + " >>");
        this.detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AliceAlertContentPane.this.detailButton_actionPerformed(actionEvent);
            }
        });
        this.submitBugButton.setText(I18n.getString("msgAlertSubmitBug"));
        this.submitBugButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AliceAlertContentPane.this.submitBugButton_actionPerformed(actionEvent);
            }
        });
        this.copyButton.setText(I18n.getString("msgAlertSubmitCopy"));
        this.copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AliceAlertContentPane.this.copyButton_actionPerformed(actionEvent);
            }
        });
        this.messagePanel.setLayout(new BorderLayout());
        this.messagePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.detailPanel.setLayout(new BorderLayout());
        this.detailPanel.setBorder(null);
        this.detailPanel.setPreferredSize(new Dimension(492, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.buttonPanel.setLayout(new GridBagLayout());
        URL uRL = (class$edu$cmu$cs$stage3$alice$authoringtool$JAlice == null ? (class$edu$cmu$cs$stage3$alice$authoringtool$JAlice = AliceAlertContentPane.class$("edu.cmu.cs.stage3.alice.authoringtool.JAlice")) : class$edu$cmu$cs$stage3$alice$authoringtool$JAlice).getResource("images/errorDialogueIcon.png");
        this.errorIconPanel.setImage(Toolkit.getDefaultToolkit().createImage(uRL));
        this.messagePanel.add((Component)this.errorIconPanel, "West");
        this.messagePanel.add((Component)this.messageLabel, "Center");
        this.detailTextPane.setEditable(false);
        this.detailStream = this.detailTextPane.getNewStyleStream(this.detailTextPane.stdErrStyle);
        this.detailScrollPane.setViewportView(this.detailTextPane);
        this.detailScrollPane.setPreferredSize(new Dimension(490, 400));
        this.add((Component)this.messagePanel, "North");
        this.add((Component)this.detailPanel, "Center");
        this.add((Component)this.buttonPanel, "South");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

