/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.progress;

import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.swing.ContentPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public abstract class ProgressPane
extends ContentPane
implements ProgressObserver {
    private JLabel m_descriptionLabel;
    private JProgressBar m_progressBar;
    private JButton m_cancelButton;
    private String m_title;
    private String m_preDescription;
    private Vector m_okActionListeners = new Vector();
    private Vector m_cancelActionListeners = new Vector();
    private final int UNKNOWN_TOTAL_MAX = 100;
    private int m_total;
    private boolean m_isCanceled = false;
    private boolean m_isFinished = false;

    public ProgressPane(String string, String string2) {
        this.m_title = string;
        this.m_preDescription = string2;
        this.m_descriptionLabel = new JLabel();
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setPreferredSize(new Dimension(240, 16));
        this.m_cancelButton = new JButton("Cancel");
        this.m_cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProgressPane.this.onCancel();
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.right = 10;
        this.add((Component)this.m_descriptionLabel, gridBagConstraints);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 10;
        this.add((Component)this.m_progressBar, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this.add((Component)this.m_cancelButton, gridBagConstraints);
    }

    public void handleDispose() {
        this.onCancel();
    }

    protected abstract void construct() throws ProgressCancelException;

    public void preDialogShow(JDialog jDialog) {
        super.preDialogShow(jDialog);
        new Thread(new Runnable(){

            public void run() {
                try {
                    ProgressPane.this.construct();
                    ProgressPane.this.fireOKActionListeners();
                }
                catch (ProgressCancelException progressCancelException) {
                    ProgressPane.this.fireCancelActionListeners();
                }
            }
        }).start();
    }

    public boolean isCancelEnabled() {
        return this.m_cancelButton.isEnabled();
    }

    public void setIsCancelEnabled(boolean bl) {
        this.m_cancelButton.setEnabled(bl);
    }

    public boolean isReadyToDispose(int n) {
        if (this.m_isFinished) {
            return true;
        }
        if (this.isCancelEnabled()) {
            return true;
        }
        return n != 2;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.m_okActionListeners.addElement(actionListener);
    }

    public void removeOKActionListener(ActionListener actionListener) {
        this.m_okActionListeners.removeElement(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.m_cancelActionListeners.addElement(actionListener);
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        this.m_cancelActionListeners.removeElement(actionListener);
    }

    public void progressBegin(int n) {
        this.m_descriptionLabel.setText(this.m_preDescription);
        this.progressUpdateTotal(n);
        this.m_isCanceled = false;
        this.m_isFinished = false;
    }

    public void progressUpdateTotal(int n) {
        this.m_total = n;
        if (this.m_total == -1) {
            this.m_progressBar.setMaximum(100);
        } else {
            this.m_progressBar.setMaximum(this.m_total);
        }
    }

    public void progressUpdate(final int n, final String string) throws ProgressCancelException {
        if (this.m_isCanceled) {
            this.m_isCanceled = false;
            throw new ProgressCancelException();
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (ProgressPane.this.m_preDescription != null) {
                    if (string != null) {
                        ProgressPane.this.m_descriptionLabel.setText(ProgressPane.this.m_preDescription + string);
                    } else {
                        ProgressPane.this.m_descriptionLabel.setText(ProgressPane.this.m_preDescription);
                    }
                }
                if (ProgressPane.this.m_total == -1) {
                    ProgressPane.this.m_progressBar.setValue(n % 100);
                } else {
                    ProgressPane.this.m_progressBar.setValue(n);
                }
            }
        });
    }

    public void progressEnd() {
    }

    private void onCancel() {
        this.m_isCanceled = true;
    }

    private void fireActionListeners(final Vector vector, final ActionEvent actionEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                for (int i = 0; i < vector.size(); ++i) {
                    ActionListener actionListener = (ActionListener)vector.elementAt(i);
                    actionListener.actionPerformed(actionEvent);
                }
            }
        });
    }

    protected void fireOKActionListeners() {
        this.fireActionListeners(this.m_okActionListeners, new ActionEvent(this, 1001, "OK"));
    }

    protected void fireCancelActionListeners() {
        this.fireActionListeners(this.m_cancelActionListeners, new ActionEvent(this, 1001, "Cancel"));
    }
}

