/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.io;

import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipTreeLoader
implements DirectoryTreeLoader {
    protected ZipInputStream zipIn = null;
    protected String currentDirectory = null;
    protected boolean isLoading = false;
    protected Hashtable pathnamesToByteArrays = null;
    protected Vector directories = null;
    private Object pathnameBeingWaitedOn = null;
    protected static final Object WHOLE_FILE = new Object();
    protected ZipLoaderThread loaderThread = null;
    protected InputStream currentlyOpenStream = null;

    public void open(Object object) throws IllegalArgumentException, IOException {
        if (this.zipIn != null) {
            this.close();
        }
        InputStream inputStream = null;
        if (object instanceof String) {
            inputStream = new FileInputStream((String)object);
        } else if (object instanceof File) {
            inputStream = new FileInputStream((File)object);
        } else if (object instanceof URL) {
            inputStream = ((URL)object).openStream();
        } else if (object instanceof InputStream) {
            inputStream = (InputStream)object;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("pathname is null");
            }
            throw new IllegalArgumentException("pathname must be an instance of String, java.io.File, java.net.URL, or java.io.InputStream");
        }
        this.zipIn = new ZipInputStream(new BufferedInputStream(inputStream));
        this.currentDirectory = "";
        this.pathnamesToByteArrays = new Hashtable();
        this.directories = new Vector();
        this.loaderThread = new ZipLoaderThread();
        this.loaderThread.start();
    }

    public void close() throws IOException {
        if (this.zipIn != null) {
            this.closeCurrentFile();
            if (this.isLoading) {
                this.loaderThread.stopEarly();
                this.waitFor(WHOLE_FILE);
            }
            this.zipIn.close();
            this.zipIn = null;
            this.pathnamesToByteArrays = null;
            this.directories = null;
            this.loaderThread = null;
        }
    }

    public void setCurrentDirectory(String string) throws IllegalArgumentException {
        if (string == null) {
            string = "";
        } else if (string.length() > 0) {
            if (string.charAt(0) != '/' && string.charAt(0) != '\\') {
                string = this.currentDirectory + string;
            }
            if (!(string = this.getCanonicalPathname(string)).endsWith("/")) {
                string = string + "/";
            }
            if (!string.startsWith("/")) {
                string = "/" + string + "/";
            }
        }
        this.currentDirectory = string;
    }

    public String getCurrentDirectory() {
        return this.currentDirectory;
    }

    public InputStream readFile(String string) throws IllegalArgumentException, IOException {
        this.closeCurrentFile();
        String string2 = this.getCanonicalPathname(this.currentDirectory + string);
        this.waitFor(string2);
        byte[] byArray = (byte[])this.pathnamesToByteArrays.get(string2);
        if (byArray == null) {
            throw new FileNotFoundException("Not Found: " + string2);
        }
        this.currentlyOpenStream = new ByteArrayInputStream(byArray);
        return this.currentlyOpenStream;
    }

    public void closeCurrentFile() throws IOException {
        if (this.currentlyOpenStream != null) {
            this.currentlyOpenStream.close();
            this.currentlyOpenStream = null;
        }
    }

    public String[] getFilesInCurrentDirectory() {
        this.waitFor(WHOLE_FILE);
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.pathnamesToByteArrays.keys();
        while (stringArray.hasMoreElements()) {
            String string;
            String string2 = (String)stringArray.nextElement();
            int n = string2.indexOf(this.currentDirectory);
            if (n != 0 || (string = string2.substring(this.currentDirectory.length())).indexOf(47) != -1) continue;
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    public String[] getDirectoriesInCurrentDirectory() {
        this.waitFor(WHOLE_FILE);
        Vector<String> vector = new Vector<String>();
        String[] stringArray = this.directories.elements();
        while (stringArray.hasMoreElements()) {
            String string;
            String string2 = (String)stringArray.nextElement();
            int n = string2.indexOf(this.currentDirectory);
            if (n != 0 || (string = string2.substring(this.currentDirectory.length())).length() <= 0 || string.indexOf(47) != string.lastIndexOf(47)) continue;
            vector.addElement(string);
        }
        stringArray = new String[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    protected String getCanonicalPathname(String string) {
        int n;
        string = string.replace('\\', '/');
        while ((n = string.indexOf("//")) != -1) {
            string = string.substring(0, n + 1) + string.substring(n + 2);
        }
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        return string;
    }

    protected synchronized void waitFor(Object object) {
        if (this.pathnamesToByteArrays.get(object) != null) {
            return;
        }
        if (this.directories.indexOf(object) != -1) {
            return;
        }
        if (object == WHOLE_FILE && !this.isLoading) {
            return;
        }
        this.pathnameBeingWaitedOn = object;
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    protected synchronized void finishedLoading(Object object) {
        if (object.equals(this.pathnameBeingWaitedOn) || object.equals(WHOLE_FILE)) {
            this.notifyAll();
        }
    }

    public boolean isKeepFileSupported() {
        return false;
    }

    public Object getKeepKey(String string) throws KeepFileNotSupportedException {
        throw new KeepFileNotSupportedException();
    }

    class ZipLoaderThread
    extends Thread {
        private boolean stoppedEarly = false;

        ZipLoaderThread() {
        }

        public void run() {
            this.setPriority(10);
            ZipTreeLoader.this.isLoading = true;
            String string = "";
            try {
                System.out.println(string.charAt(3));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (true) {
                try {
                    ZipEntry zipEntry;
                    while (!this.stoppedEarly && (zipEntry = ZipTreeLoader.this.zipIn.getNextEntry()) != null) {
                        String string2 = ZipTreeLoader.this.getCanonicalPathname(zipEntry.getName());
                        if (zipEntry.isDirectory()) {
                            ZipTreeLoader.this.directories.addElement(string2);
                            ZipTreeLoader.this.finishedLoading(string2);
                            continue;
                        }
                        int n = 1024;
                        int n2 = 0;
                        byte[] byArray = new byte[n];
                        while (ZipTreeLoader.this.zipIn.available() == 1) {
                            int n3;
                            if (n2 == n) {
                                byte[] byArray2 = byArray;
                                byArray = new byte[n += 1024];
                                System.arraycopy(byArray2, 0, byArray, 0, n - 1024);
                            }
                            if ((n3 = ZipTreeLoader.this.zipIn.read()) == -1) break;
                            byArray[n2++] = (byte)n3;
                        }
                        if (n2 < n) {
                            byte[] byArray3 = byArray;
                            byArray = new byte[n2];
                            System.arraycopy(byArray3, 0, byArray, 0, n2);
                        }
                        ZipTreeLoader.this.zipIn.closeEntry();
                        ZipTreeLoader.this.pathnamesToByteArrays.put(string2, byArray);
                        ZipTreeLoader.this.finishedLoading(string2);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    continue;
                }
                break;
            }
            this.stoppedEarly = false;
            ZipTreeLoader.this.isLoading = false;
            ZipTreeLoader.this.finishedLoading(WHOLE_FILE);
        }

        public void stopEarly() {
            this.stoppedEarly = true;
        }
    }
}

