/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.InternalResponseBehavior;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MouseLookingBehavior
extends InternalResponseBehavior
implements MouseListener,
MouseMotionListener {
    private RenderTarget renderTarget;
    private int lastX;
    private int lastY;
    public NumberProperty turningRate = new NumberProperty(this, "turningRate", new Double(0.001));
    public TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public BooleanProperty onlyAffectsYaw = new BooleanProperty(this, "onlyAffectsYaw", Boolean.TRUE);

    protected void disable() {
        this.renderTarget.removeMouseListener(this);
        this.renderTarget.removeMouseMotionListener(this);
    }

    protected void enable() {
        this.renderTarget.addMouseListener(this);
        this.renderTarget.addMouseMotionListener(this);
    }

    public void started(World world, double d) {
        super.started(world, d);
        if (this.isEnabled.booleanValue()) {
            this.enable();
        }
    }

    public void stopped(World world, double d) {
        super.stopped(world, d);
        if (this.isEnabled.booleanValue()) {
            this.disable();
        }
    }

    public void internalSchedule(double d, double d2) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.lastX == -1) {
            // empty if block
        }
        if (this.lastY == -1) {
            // empty if block
        }
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.lastX == -1) {
            // empty if block
        }
        if (this.lastY == -1) {
            // empty if block
        }
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }
}

