/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.KeyIsPressedBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.IntegerProperty;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyClickBehavior
extends TriggerBehavior
implements KeyListener {
    private static Class[] s_supportedCoercionClasses = new Class[]{KeyIsPressedBehavior.class};
    public final IntegerProperty keyCode = new IntegerProperty(this, "keyCode", null);
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    private RenderTarget[] m_renderTargets = null;

    public Class[] getSupportedCoercionClasses() {
        return s_supportedCoercionClasses;
    }

    public void manufactureAnyNecessaryDetails() {
        if (this.details.size() == 1) {
            Variable variable = new Variable();
            variable.name.set("code");
            variable.setParent(this);
            variable.valueClass.set(Integer.class);
            this.details.add(variable);
        }
    }

    public void manufactureDetails() {
        super.manufactureDetails();
        Variable variable = new Variable();
        variable.name.set("keyChar");
        variable.setParent(this);
        variable.valueClass.set(Character.class);
        this.details.add(variable);
        Variable variable2 = new Variable();
        variable2.name.set("code");
        variable2.setParent(this);
        variable2.valueClass.set(Integer.class);
        this.details.add(variable2);
    }

    private void updateDetails(KeyEvent keyEvent) {
        for (int i = 0; i < this.details.size(); ++i) {
            Variable variable = (Variable)this.details.get(i);
            if (variable.name.getStringValue().equals("keyChar")) {
                variable.value.set(new Character(keyEvent.getKeyChar()));
                continue;
            }
            if (!variable.name.getStringValue().equals("code")) continue;
            variable.value.set(new Integer(keyEvent.getKeyCode()));
        }
    }

    private boolean checkKeyCode(KeyEvent keyEvent) {
        int n;
        int n2 = keyEvent.getKeyCode();
        return n2 == (n = this.keyCode.intValue(n2));
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.updateDetails(keyEvent);
        if (this.checkKeyCode(keyEvent)) {
            this.trigger((double)keyEvent.getWhen() * 0.001);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void started(World world, double d) {
        super.started(world, d);
        this.m_renderTargets = (RenderTarget[])this.renderTargets.get();
        if (this.m_renderTargets == null) {
            this.m_renderTargets = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.addKeyListener(this);
        }
    }

    protected void stopped(World world, double d) {
        super.stopped(world, d);
        for (RenderTarget renderTarget : this.m_renderTargets) {
            renderTarget.removeKeyListener(this);
        }
        this.m_renderTargets = null;
    }
}

