/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;

public abstract class Response
extends Code {
    public final NumberProperty duration = new NumberProperty(this, "duration", this.getDefaultDuration());

    protected Number getDefaultDuration() {
        return new Double(1.0);
    }

    protected Class getRuntimeResponseClass() {
        Class<?>[] classArray;
        Class<?> clazz = this.getClass();
        for (Class<?> clazz2 : classArray = clazz.getDeclaredClasses()) {
            if (!RuntimeResponse.class.isAssignableFrom(clazz2)) continue;
            return clazz2;
        }
        return null;
    }

    public RuntimeResponse manufactureRuntimeResponse() {
        Constructor<?>[] constructorArray;
        Class clazz = this.getRuntimeResponseClass();
        if (clazz != null && (constructorArray = clazz.getConstructors()).length > 0) {
            try {
                Object[] objectArray = new Object[]{this};
                RuntimeResponse runtimeResponse = (RuntimeResponse)constructorArray[0].newInstance(objectArray);
                return runtimeResponse;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ExceptionWrapper(illegalAccessException, null);
            }
            catch (InstantiationException instantiationException) {
                throw new ExceptionWrapper(instantiationException, null);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new ExceptionWrapper(invocationTargetException, null);
            }
        }
        return null;
    }

    public abstract class RuntimeResponse {
        private boolean HACK_m_isMarkedForRemoval = false;
        private boolean m_isActive = false;
        private double m_t0 = Double.NaN;
        private double m_duration = Double.NaN;

        public void HACK_markForRemoval() {
            this.HACK_m_isMarkedForRemoval = true;
        }

        public boolean HACK_isMarkedForRemoval() {
            return this.HACK_m_isMarkedForRemoval;
        }

        public boolean isActive() {
            return this.m_isActive;
        }

        protected double getDuration() {
            return this.m_duration;
        }

        protected double getTimeElapsed(double d) {
            return d - this.m_t0;
        }

        public double getTimeRemaining(double d) {
            return this.m_duration - this.getTimeElapsed(d);
        }

        public void prologue(double d) {
            this.m_t0 = d;
            this.m_duration = Response.this.duration.doubleValue(Double.NaN);
            this.m_isActive = true;
        }

        public void update(double d) {
        }

        public void epilogue(double d) {
            this.m_isActive = false;
        }

        public void stop(double d) {
            if (this.isActive()) {
                this.epilogue(d);
            }
        }

        protected Behavior getCurrentBehavior() {
            Sandbox sandbox;
            World world = Response.this.getWorld();
            if (world != null && (sandbox = world.getCurrentSandbox()) != null) {
                return sandbox.getCurrentBehavior();
            }
            return null;
        }

        protected Stack getCurrentStack() {
            Behavior behavior = this.getCurrentBehavior();
            if (behavior != null) {
                return behavior.getCurrentStack();
            }
            return null;
        }
    }
}

