/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.IllegalArrayPropertyValueException;
import edu.cmu.cs.stage3.alice.core.IllegalPropertyValueException;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.applet.AppletXmlStruct;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.xml.NodeUtilities;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Property {
    private static boolean HACK_s_isListeningEnabled = true;
    private boolean m_isAcceptingOfHowMuch = false;
    private Element m_owner;
    private String m_name;
    private Object m_defaultValue;
    private Class m_valueClass;
    private Object m_value;
    private Vector m_propertyListeners = new Vector();
    private PropertyListener[] m_propertyListenerArray = null;
    private boolean m_isDeprecated = false;
    protected Object m_associatedFileKey = null;
    private static Dictionary s_ownerClassMap = new Hashtable();
    private static Behavior m_currentBehavior = null;

    public static void HACK_enableListening() {
        HACK_s_isListeningEnabled = true;
    }

    public static void HACK_disableListening() {
        HACK_s_isListeningEnabled = false;
    }

    public boolean isAcceptingOfHowMuch() {
        return this.m_isAcceptingOfHowMuch;
    }

    public void setIsAcceptingOfHowMuch(boolean bl) {
        this.m_isAcceptingOfHowMuch = bl;
    }

    protected Property(Element element, String string, Object object, Class clazz) {
        this.m_owner = element;
        this.m_name = string;
        this.m_defaultValue = object;
        this.m_valueClass = clazz;
        this.m_isAcceptingOfHowMuch = false;
        this.m_value = this.m_defaultValue;
        this.m_owner.propertyCreated(this);
    }

    public static String[] getPropertyNames(Class clazz, Class clazz2) {
        Object[] objectArray;
        Hashtable<Class, Object[]> hashtable = (Hashtable<Class, Object[]>)s_ownerClassMap.get(clazz);
        if (hashtable == null) {
            hashtable = new Hashtable<Class, Object[]>();
            s_ownerClassMap.put(clazz, hashtable);
        }
        if ((objectArray = (String[])((Dictionary)hashtable).get(clazz2)) == null) {
            Field[] fieldArray;
            Vector<String> vector = new Vector<String>();
            for (Field field : fieldArray = clazz.getFields()) {
                if (!Property.class.isAssignableFrom(field.getType())) continue;
                String string = field.getName();
                Class clazz3 = Element.getValueClassForPropertyNamed(clazz, string);
                if (clazz3 != null) {
                    if (!clazz2.isAssignableFrom(clazz3)) continue;
                    vector.addElement(string);
                    continue;
                }
                System.err.println(clazz + " " + string);
            }
            objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            ((Dictionary)hashtable).put(clazz2, objectArray);
        }
        return objectArray;
    }

    public static String[] getPropertyNames(Class clazz) {
        return Property.getPropertyNames(clazz, Object.class);
    }

    public boolean isAlsoKnownAs(Class clazz, String string) {
        if (clazz.isAssignableFrom(this.m_owner.getClass())) {
            try {
                Field field = clazz.getField(string);
                Object object = field.get(this.m_owner);
                return object == this;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public Element getOwner() {
        return this.m_owner;
    }

    @Deprecated
    public Element getElement() {
        return this.getOwner();
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    protected void setValueClass(Class clazz) {
        this.m_valueClass = clazz;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getName() {
        return this.m_name;
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!this.m_propertyListeners.contains(propertyListener)) {
            this.m_propertyListeners.addElement(propertyListener);
            this.m_propertyListenerArray = null;
        }
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.removeElement(propertyListener);
        this.m_propertyListenerArray = null;
    }

    public PropertyListener[] getPropertyListeners() {
        if (this.m_propertyListenerArray == null) {
            this.m_propertyListenerArray = new PropertyListener[this.m_propertyListeners.size()];
            this.m_propertyListeners.copyInto(this.m_propertyListenerArray);
        }
        return this.m_propertyListenerArray;
    }

    public Class getDeclaredClass() {
        if (this.m_owner != null) {
            for (Class<?> clazz = this.m_owner.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                System.err.println("Property.java: getDeclaredClass(): " + clazz.getName() + " - " + this.m_name);
                try {
                    Field field = clazz.getDeclaredField(this.m_name);
                    if (field.get(this.m_owner) == this) {
                        return clazz;
                    }
                    throw new RuntimeException(this.m_owner + " has field named " + this.m_name + " that is not " + this);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    System.err.println("Error: Property.java: getDeclaredClass(): NoSuchFieldException: " + this.m_name);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Error: Property.java: getDeclaredClass(): IllegalAccessException: " + this.m_name);
                    throw new ExceptionWrapper(illegalAccessException, null);
                }
            }
            return null;
        }
        return null;
    }

    public Object get() {
        if (this.m_value instanceof Cloneable) {
            if (this.m_value.getClass().isArray()) {
                return this.m_value;
            }
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Method method = this.m_value.getClass().getMethod("clone", classArray);
                if (method.isAccessible()) {
                    return method.invoke(this.m_value, objectArray);
                }
                return this.m_value;
            }
            catch (Exception exception) {
                return this.m_value;
            }
        }
        return this.m_value;
    }

    private boolean isValueInADifferentWorld(Object object) {
        World world = this.getElement().getWorld();
        if (world != null && object instanceof Element) {
            return world != this.getElement().getWorld();
        }
        return false;
    }

    public void checkForBadReferences(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (!this.isValueInADifferentWorld(objectArray[i])) continue;
                throw new IllegalArrayPropertyValueException(this, i, object, "value must be in world");
            }
        } else if (this.isValueInADifferentWorld(object)) {
            throw new IllegalPropertyValueException(this, object, "value must be in world");
        }
    }

    protected void checkValueType(Object object) {
        if (object != null) {
            Class clazz = this.getValueClass();
            if (object instanceof Expression) {
                Expression expression = (Expression)object;
                if (!(clazz.isAssignableFrom(Expression.class) || clazz.isAssignableFrom(Variable.class) || clazz.isAssignableFrom(Question.class) || Question.class.isAssignableFrom(clazz) || clazz.isAssignableFrom(expression.getValueClass()))) {
                    throw new IllegalPropertyValueException(this, object, "Cannot set property " + this.getName() + " on " + this.getOwner() + ".  " + clazz + " is not assignable from " + expression.getValueClass());
                }
            } else if (!clazz.isAssignableFrom(object.getClass())) {
                throw new IllegalPropertyValueException(this, object, "Cannot set property " + this.getName() + " on " + this.getOwner() + ".  " + clazz + " is not assignable from " + object.getClass());
            }
        }
    }

    protected boolean getValueOfExpression() {
        Class clazz = this.getValueClass();
        if (clazz.isAssignableFrom(Expression.class)) {
            return false;
        }
        if (clazz.isAssignableFrom(Variable.class)) {
            return false;
        }
        return !clazz.isAssignableFrom(Question.class);
    }

    protected Object evaluateIfNecessary(Object object) {
        if (object instanceof Expression) {
            Variable variable;
            Sandbox sandbox;
            World world;
            Object object2;
            Expression expression = (Expression)object;
            if (m_currentBehavior == null && !this.isDeprecated() && expression instanceof Variable && (object2 = this.getOwner()) != null && (world = ((Element)object2).getWorld()) != null && (sandbox = world.getCurrentSandbox()) != null && (m_currentBehavior = sandbox.getCurrentBehavior()) != null && (variable = m_currentBehavior.stackLookup((Variable)expression)) != null) {
                expression = variable;
            }
            object2 = this.getValueOfExpression() ? expression.getValue() : expression;
            m_currentBehavior = null;
            return object2;
        }
        return object;
    }

    public Object getValue() {
        return this.evaluateIfNecessary(this.m_value);
    }

    private void onChanging(PropertyEvent propertyEvent) {
        this.m_owner.propertyChanging(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListenerArray;
            for (PropertyListener propertyListener : propertyListenerArray = this.getPropertyListeners()) {
                propertyListener.propertyChanging(propertyEvent);
            }
        }
    }

    private void onChanged(PropertyEvent propertyEvent) {
        this.getElement().markKeepKeyDirty();
        this.m_owner.propertyChanged(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListenerArray;
            for (PropertyListener propertyListener : propertyListenerArray = this.getPropertyListeners()) {
                propertyListener.propertyChanged(propertyEvent);
            }
        }
    }

    protected void onSet(Object object) {
        this.getValueClass();
        PropertyEvent propertyEvent = new PropertyEvent(this, object);
        this.onChanging(propertyEvent);
        this.m_value = object;
        this.onChanged(propertyEvent);
        this.m_associatedFileKey = null;
    }

    public void set(Object object) throws IllegalArgumentException {
        if (this.m_value == null ? object == null : this.m_value.equals(object)) {
            return;
        }
        if (!Element.s_isLoading) {
            this.checkValueType(object);
            this.checkForBadReferences(object);
        }
        this.onSet(object);
    }

    private static void setHowMuch(Element element, String string, Object object, HowMuch howMuch) {
        Property property = element.getPropertyNamed(string);
        if (property != null) {
            property.set(object);
        }
        if (howMuch.getDescend()) {
            for (int i = 0; i < element.getChildCount(); ++i) {
                Element element2 = element.getChildAt(i);
                if (howMuch.getRespectDescendant()) continue;
                Property.setHowMuch(element2, string, object, howMuch);
            }
        }
    }

    public void set(Object object, HowMuch howMuch) throws IllegalArgumentException {
        if (this.m_owner instanceof Element) {
            Property.setHowMuch(this.m_owner, this.m_name, object, howMuch);
        }
    }

    protected Object getValueOf(Class clazz, String string) {
        if (clazz.equals(Double.class)) {
            if (string.equals("Infinity")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (string.equals("NaN")) {
                return new Double(Double.NaN);
            }
            return Double.valueOf(string);
        }
        if (clazz.equals(String.class)) {
            return string;
        }
        try {
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("valueOf", classArray);
            int n = method.getModifiers();
            if (Modifier.isPublic(n) && Modifier.isStatic(n)) {
                Object[] objectArray = new Object[]{string};
                return method.invoke(null, objectArray);
            }
            throw new RuntimeException("valueOf method not public static.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("NoSuchMethodException:" + clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("IllegalAccessException: " + clazz);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("java.lang.reflect.InvocationTargetException: " + clazz + " " + string);
        }
    }

    protected String getNodeText(Node node) {
        return NodeUtilities.getNodeText(node);
    }

    protected Node createNodeForString(Document document, String string) {
        char[] cArray;
        for (char c : cArray = new char[]{' ', '\t', '\n', '\"', '\'', '>', '<', '&'}) {
            if (string.indexOf(c) == -1) continue;
            return document.createCDATASection(string);
        }
        return document.createTextNode(string);
    }

    protected String getFilename(String string) {
        String[] stringArray = new String[]{"java.io.File[", "]"};
        int n = string.indexOf(stringArray[0]) + stringArray[0].length();
        int n2 = string.lastIndexOf(stringArray[1]);
        return string.substring(n, n2);
    }

    protected void decodeReference(org.w3c.dom.Element element, Vector vector, String string) {
        try {
            Class<ElementKeyedCriterion> clazz = Class.forName(string);
            String string2 = this.getNodeText(element);
            if (string2.equals(".")) {
                string2 = "";
            }
            Criterion criterion = clazz.isAssignableFrom(InternalReferenceKeyedCriterion.class) ? new InternalReferenceKeyedCriterion(string2) : (clazz.isAssignableFrom(ExternalReferenceKeyedCriterion.class) ? new ExternalReferenceKeyedCriterion(string2) : (Criterion)this.getValueOf(clazz, string2));
            vector.addElement(new PropertyReference(this, criterion));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(string);
        }
    }

    protected void decodeObject(org.w3c.dom.Element element, Vector vector) throws IOException {
        String string = element.getAttribute("class");
        if (string.length() > 0) {
            String string2 = this.getNodeText(element);
            try {
                Class<?> clazz = Class.forName(string);
                this.set(this.getValueOf(clazz, string2));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException(string);
            }
        } else {
            System.err.println(this);
            throw new RuntimeException();
        }
    }

    public final void decode(org.w3c.dom.Element element, Vector vector) throws IOException {
        if (element.hasChildNodes()) {
            String string = element.getAttribute("criterionClass");
            if (string.length() > 0) {
                this.decodeReference(element, vector, string);
            } else {
                this.decodeObject(element, vector);
            }
        } else {
            this.set(null);
        }
    }

    protected void encodeReference(Document document, org.w3c.dom.Element element, ReferenceGenerator referenceGenerator, Element element2) {
        Criterion criterion = referenceGenerator.generateReference(element2);
        if (criterion != null) {
            element.setAttribute("criterionClass", criterion.getClass().getName());
            String string = criterion instanceof InternalReferenceKeyedCriterion ? ((InternalReferenceKeyedCriterion)criterion).getKey() : (criterion instanceof ExternalReferenceKeyedCriterion ? ((ExternalReferenceKeyedCriterion)criterion).getKey() : criterion.toString());
            if (string.length() == 0) {
                string = ".";
            }
            element.appendChild(this.createNodeForString(document, string));
        }
    }

    protected AppletXmlStruct encodeReferenceToXml(ReferenceGenerator referenceGenerator, Element element) {
        Criterion criterion = referenceGenerator.generateReference(element);
        AppletXmlStruct appletXmlStruct = new AppletXmlStruct();
        if (criterion != null) {
            appletXmlStruct.addAtribute("criterionClass='" + criterion.getClass().getName() + "'");
            if (criterion instanceof InternalReferenceKeyedCriterion) {
                appletXmlStruct.addElement(((InternalReferenceKeyedCriterion)criterion).getKey());
            } else if (criterion instanceof ExternalReferenceKeyedCriterion) {
                appletXmlStruct.addElement(((ExternalReferenceKeyedCriterion)criterion).getKey());
            } else {
                appletXmlStruct.addElement(criterion.toString());
            }
            if (appletXmlStruct.getElements().length() == 0) {
                appletXmlStruct.addElement(".");
            }
        }
        return appletXmlStruct;
    }

    protected void encodeObject(Document document, org.w3c.dom.Element element, DirectoryTreeStorer directoryTreeStorer, ReferenceGenerator referenceGenerator) throws IOException {
        Object object = this.get();
        element.setAttribute("class", object.getClass().getName());
        element.appendChild(this.createNodeForString(document, object.toString()));
    }

    protected AppletXmlStruct encodeObjectToXml(ReferenceGenerator referenceGenerator) throws IOException {
        Object object = this.get();
        AppletXmlStruct appletXmlStruct = new AppletXmlStruct();
        if (object == null || object instanceof Element) {
            return appletXmlStruct;
        }
        appletXmlStruct.addAtribute("class='" + object.getClass().getName() + "'");
        appletXmlStruct.addElement(object.toString());
        return appletXmlStruct;
    }

    public final void encode(Document document, org.w3c.dom.Element element, DirectoryTreeStorer directoryTreeStorer, ReferenceGenerator referenceGenerator) throws IOException {
        Object object = this.get();
        if (object != null) {
            if (object instanceof Element) {
                this.encodeReference(document, element, referenceGenerator, (Element)object);
            } else {
                this.encodeObject(document, element, directoryTreeStorer, referenceGenerator);
            }
        }
    }

    public final AppletXmlStruct encodeToXml(ReferenceGenerator referenceGenerator) throws IOException {
        Object object = this.get();
        if (object != null) {
            if (object instanceof Element) {
                return this.encodeReferenceToXml(referenceGenerator, (Element)object);
            }
            return this.encodeObjectToXml(referenceGenerator);
        }
        return new AppletXmlStruct();
    }

    public void keepAnyAssociatedFiles(DirectoryTreeStorer directoryTreeStorer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
    }

    public boolean isDeprecated() {
        return this.m_isDeprecated;
    }

    public void deprecate() {
        this.m_isDeprecated = true;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.m_name + ",owner=" + this.m_owner + "]";
    }
}

