/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.WatcherPanel;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class PropertyDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected AuthoringTool authoringTool;
    protected Property property;
    protected JLabel nameLabel = new JLabel();
    protected Vector popupStructure = new Vector();

    public PropertyDnDPanel() {
        this.setBackground(AuthoringToolResources.getColor("propertyDnDPanel"));
        this.add((Component)this.nameLabel, "Center");
        this.addDragSourceComponent(this.nameLabel);
        CustomMouseAdapter customMouseAdapter = new CustomMouseAdapter(){

            public void popupResponse(MouseEvent mouseEvent) {
                PropertyDnDPanel.this.updatePopupStructure();
                PopupMenuUtilities.createAndShowPopupMenu(PropertyDnDPanel.this.popupStructure, PropertyDnDPanel.this, mouseEvent.getX(), mouseEvent.getY());
            }
        };
        this.addMouseListener(customMouseAdapter);
        this.nameLabel.addMouseListener(customMouseAdapter);
        this.grip.addMouseListener(customMouseAdapter);
    }

    public void set(AuthoringTool authoringTool, Property property) {
        this.authoringTool = authoringTool;
        this.property = property;
        this.nameLabel.setText(AuthoringToolResources.getReprForValue(property));
        String string = "types/" + property.getValueClass().getName();
        ImageIcon imageIcon = AuthoringToolResources.getIconForValue(string);
        if (imageIcon == null) {
            imageIcon = AuthoringToolResources.getIconForValue("types/other");
        }
        if (imageIcon != null) {
            // empty if block
        }
        this.setTransferable(TransferableFactory.createTransferable(property));
    }

    public void updatePopupStructure() {
        this.popupStructure.clear();
        final WatcherPanel watcherPanel = this.authoringTool.getWatcherPanel();
        if (watcherPanel.isPropertyBeingWatched(this.property)) {
            this.popupStructure.add(new StringObjectPair("stop watching this property", new Runnable(){

                public void run() {
                    watcherPanel.removePropertyBeingWatched(PropertyDnDPanel.this.property);
                }
            }));
        } else {
            this.popupStructure.add(new StringObjectPair("watch this property", new Runnable(){

                public void run() {
                    watcherPanel.addPropertyToWatch(PropertyDnDPanel.this.property);
                }
            }));
        }
    }

    public void goToSleep() {
    }

    public void wakeUp() {
    }

    public void clean() {
        this.setTransferable(null);
    }

    public void die() {
        this.clean();
    }

    public void release() {
        GUIFactory.releaseGUI(this);
    }
}

