/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.event.DnDManagerListener;
import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.util.HashSet;
import java.util.Iterator;

public class DnDManager {
    private static Transferable currentTransferable;
    private static Component currentDragComponent;
    private static HashSet listeners;
    private static DnDListener dndListener;

    public static Transferable getCurrentTransferable() {
        return currentTransferable;
    }

    public static Component getCurrentDragComponent() {
        return currentDragComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(DnDManagerListener dnDManagerListener) {
        DnDListener dnDListener = dndListener;
        synchronized (dnDListener) {
            listeners.add(dnDManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(DnDManagerListener dnDManagerListener) {
        DnDListener dnDListener = dndListener;
        synchronized (dnDListener) {
            listeners.remove(dnDManagerListener);
        }
    }

    public static DnDListener getInternalListener() {
        return dndListener;
    }

    public static void fireDragGestureRecognized(DragGestureEvent dragGestureEvent) {
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((DragGestureListener)iterator.next()).dragGestureRecognized(dragGestureEvent);
        }
    }

    public static void fireDragStarted(Transferable transferable, Component component) {
        currentTransferable = transferable;
        currentDragComponent = component;
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ((DnDManagerListener)iterator.next()).dragStarted();
        }
    }

    static {
        listeners = new HashSet();
        dndListener = new DnDListener();
    }

    public static class DnDListener
    implements DragSourceListener {
        public synchronized void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
            currentTransferable = dragSourceDragEvent.getDragSourceContext().getTransferable();
            currentDragComponent = dragSourceDragEvent.getDragSourceContext().getComponent();
            dragSourceDragEvent.getDragSourceContext();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((DragSourceListener)iterator.next()).dragEnter(dragSourceDragEvent);
            }
        }

        public synchronized void dragExit(DragSourceEvent dragSourceEvent) {
            currentTransferable = dragSourceEvent.getDragSourceContext().getTransferable();
            currentDragComponent = dragSourceEvent.getDragSourceContext().getComponent();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((DragSourceListener)iterator.next()).dragExit(dragSourceEvent);
            }
        }

        public synchronized void dragOver(DragSourceDragEvent dragSourceDragEvent) {
            currentTransferable = dragSourceDragEvent.getDragSourceContext().getTransferable();
            currentDragComponent = dragSourceDragEvent.getDragSourceContext().getComponent();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((DragSourceListener)iterator.next()).dragOver(dragSourceDragEvent);
            }
        }

        public synchronized void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
            currentTransferable = dragSourceDragEvent.getDragSourceContext().getTransferable();
            currentDragComponent = dragSourceDragEvent.getDragSourceContext().getComponent();
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((DragSourceListener)iterator.next()).dropActionChanged(dragSourceDragEvent);
            }
        }

        public synchronized void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            currentTransferable = null;
            currentDragComponent = null;
            Iterator iterator = listeners.iterator();
            while (iterator.hasNext()) {
                ((DragSourceListener)iterator.next()).dragDropEnd(dragSourceDropEvent);
            }
        }
    }
}

