/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DefaultScheduler
implements Runnable {
    private static int cont = 0;
    private double simFPS = 0.0;
    private int simFrameCount = 0;
    private long simDT = 0L;
    private long simLastTime = 0L;
    private Set doOnceRunnables = new HashSet();
    private Set eachFrameRunnables = new HashSet();
    private Set eachFrameRunnablesMarkedForRemoval = new HashSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEachFrameRunnable(Runnable runnable) {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            return this.eachFrameRunnables.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEachFrameRunnable(Runnable runnable) {
        Set set = this.eachFrameRunnablesMarkedForRemoval;
        synchronized (set) {
            return this.eachFrameRunnablesMarkedForRemoval.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Runnable[] getEachFrameRunnables() {
        Set set = this.eachFrameRunnables;
        synchronized (set) {
            Runnable[] runnableArray = new Runnable[this.eachFrameRunnables.size()];
            int n = 0;
            Iterator iterator = this.eachFrameRunnables.iterator();
            while (iterator.hasNext()) {
                runnableArray[n++] = (Runnable)iterator.next();
            }
            return runnableArray;
        }
    }

    public void run() {
        this.simulateOnce();
    }

    private synchronized void simulateOnce() {
        Iterator iterator = this.doOnceRunnables.iterator();
        while (iterator.hasNext()) {
            Runnable runnable = (Runnable)iterator.next();
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                System.err.println("Error during simulation:");
                throwable.printStackTrace();
            }
            iterator.remove();
        }
        iterator = this.eachFrameRunnablesMarkedForRemoval.iterator();
        while (iterator.hasNext()) {
            this.eachFrameRunnables.remove(iterator.next());
        }
        this.eachFrameRunnablesMarkedForRemoval.clear();
        for (Runnable runnable : this.eachFrameRunnables) {
            try {
                runnable.run();
            }
            catch (Throwable throwable) {
                System.err.println("Error during simulation:");
                throwable.printStackTrace();
            }
        }
        long l = System.currentTimeMillis();
        this.simDT += l - this.simLastTime;
        this.simLastTime = l;
        ++this.simFrameCount;
        if (this.simFrameCount == 5 || this.simDT > 500L) {
            this.simFPS = (double)this.simFrameCount / ((double)this.simDT * 0.001);
            this.simFrameCount = 0;
            this.simDT = 0L;
        }
    }

    public double getSimulationFPS() {
        return this.simFPS;
    }
}

