/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTabbedPaneUI;

public class AliceTabbedPaneUI
extends MetalTabbedPaneUI {
    protected Color defaultTabForeground;

    public AliceTabbedPaneUI() {
        this.setTabAreaInsets(new Insets(0, 0, 0, 0));
    }

    protected void installDefaults() {
        super.installDefaults();
        this.selectColor = Color.white;
        this.selectHighlight = Color.black;
        this.tabAreaBackground = Color.white;
        this.darkShadow = Color.black;
        this.focus = new Color(255, 255, 255, 0);
        this.highlight = Color.darkGray;
        this.contentBorderInsets = new Insets(1, 1, 1, 1);
        this.defaultTabForeground = UIManager.getColor("TabbedPane.foreground");
    }

    public void setTabAreaInsets(Insets insets) {
        this.tabAreaInsets = insets;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        int n = this.tabPane.getTabPlacement();
        Insets insets = jComponent.getInsets();
        Dimension dimension = jComponent.getSize();
        Component component = this.tabPane.getSelectedComponent();
        if (component != null) {
            this.selectColor = this.tabAreaBackground = component.getBackground();
        }
        graphics.setColor(this.tabAreaBackground);
        int n2 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        graphics.fillRect(insets.left, insets.top + n2, dimension.width - insets.right - insets.left, dimension.height - n2);
        this.paint(graphics, jComponent);
    }

    protected void paintTab(Graphics graphics, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        Rectangle rectangle3 = rectangleArray[n2];
        int n3 = this.tabPane.getSelectedIndex();
        boolean bl = n3 == n2;
        this.paintTabBackground(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        this.paintTabBorder(graphics, n, n2, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, bl);
        if (bl && this.tabPane.getSelectedComponent() != null) {
            object = this.tabPane.getSelectedComponent().getBackground();
            int n4 = (((Color)object).getRed() + ((Color)object).getGreen() + ((Color)object).getBlue()) / 3;
            if (n4 < 128) {
                if (!this.tabPane.getForegroundAt(n2).equals(Color.white)) {
                    this.tabPane.setForegroundAt(n2, Color.white);
                }
            } else if (!this.tabPane.getForegroundAt(n2).equals(this.defaultTabForeground)) {
                this.tabPane.setForegroundAt(n2, null);
            }
        } else if (!this.tabPane.getForegroundAt(n2).equals(this.defaultTabForeground)) {
            this.tabPane.setForegroundAt(n2, null);
        }
        object = this.tabPane.getTitleAt(n2);
        Font font = this.tabPane.getFont();
        font = bl ? font.deriveFont(1) : font.deriveFont(0, 12.0f);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Icon icon = this.getIconForTab(n2);
        this.layoutLabel(n, fontMetrics, n2, (String)object, icon, rectangle3, rectangle, rectangle2, bl);
        this.paintText(graphics, n, font, fontMetrics, n2, (String)object, rectangle2, bl);
        this.paintIcon(graphics, n, n2, icon, rectangle, bl);
        this.paintFocusIndicator(graphics, n, rectangleArray, n2, rectangle, rectangle2, bl);
    }

    public int getTabAreaHeight() {
        Insets insets = this.getTabAreaInsets(this.tabPane.getTabPlacement());
        int n = this.tabPane.getTabRunCount();
        int n2 = this.getTabRunOverlay(this.tabPane.getTabPlacement());
        return n > 0 ? n * (this.maxTabHeight - n2) + n2 + insets.top + insets.bottom : 0;
    }

    public int getTabAreaHeightIgnoringInsets() {
        int n = this.tabPane.getTabRunCount();
        int n2 = this.getTabRunOverlay(this.tabPane.getTabPlacement());
        return n > 0 ? n * (this.maxTabHeight - n2) + n2 : 0;
    }

    protected FontMetrics getFontMetrics() {
        Font font = this.tabPane.getFont().deriveFont(1);
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }
}

