/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.progress.ProgressPane;
import edu.cmu.cs.stage3.swing.DialogManager;

public class LoadElementProgressPane
extends ProgressPane {
    private DirectoryTreeLoader m_loader;
    private Element m_externalRoot;
    private Element m_loadedElement;

    public LoadElementProgressPane(String string, String string2) {
        super(string, string2);
    }

    protected void construct() throws ProgressCancelException {
        this.m_loadedElement = null;
        try {
            this.m_loadedElement = Element.load(this.m_loader, this.m_externalRoot, (ProgressObserver)this);
        }
        catch (ProgressCancelException progressCancelException) {
            throw progressCancelException;
        }
        catch (UnresolvablePropertyReferencesException unresolvablePropertyReferencesException) {
            PropertyReference[] propertyReferenceArray;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("WARNING: unable to resolve references: \n");
            for (PropertyReference propertyReference : propertyReferenceArray = unresolvablePropertyReferencesException.getPropertyReferences()) {
                Property property = propertyReference.getProperty();
                stringBuffer.append("    ");
                stringBuffer.append(property.getOwner().toString());
                stringBuffer.append('[');
                stringBuffer.append(property.getName());
                stringBuffer.append("] -> ");
                stringBuffer.append(propertyReference.getCriterion());
                stringBuffer.append('\n');
            }
            stringBuffer.append('\n');
            stringBuffer.append("Would you like to continue, setting all values to None?");
            if (DialogManager.showConfirmDialog(stringBuffer.toString(), "Unable to load world", 0) == 0) {
                this.m_loadedElement = unresolvablePropertyReferencesException.getElement();
            }
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Unable to load world", throwable);
        }
    }

    public void setLoader(DirectoryTreeLoader directoryTreeLoader) {
        this.m_loader = directoryTreeLoader;
    }

    public void setExternalRoot(Element element) {
        this.m_externalRoot = element;
    }

    public Element getLoadedElement() {
        return this.m_loadedElement;
    }
}

