/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.dialog;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.ImagePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.PropertyReferenceListCellRenderer;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.CompositeResponse;
import edu.cmu.cs.stage3.swing.ContentPane;
import edu.cmu.cs.stage3.swing.DialogManager;
import edu.cmu.cs.stage3.util.HowMuch;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DeleteContentPane
extends ContentPane
implements PropertyListener,
ChildrenListener {
    public static final int LESS_DETAIL_MODE = 0;
    public static final int MORE_DETAIL_MODE = 1;
    protected int mode = -1;
    protected static AuthoringTool authoringTool;
    protected ImagePanel errorIconPanel = new ImagePanel();
    protected ElementPopupUtilities.DeleteRunnable deleteRunnable;
    protected Element danglingElementToClear;
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel buttonPanel = new JPanel();
    JPanel mainPanel = new JPanel();
    JButton okayButton = new JButton();
    JButton removeReferenceButton = new JButton();
    JButton removeAllReferenceButton = new JButton();
    JPanel iconPanel = new JPanel();
    JPanel messagePanel = new JPanel();
    JPanel referencesPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    BorderLayout borderLayout4 = new BorderLayout();
    JScrollPane referencesScrollPane = new JScrollPane();
    JTextArea messageArea = new JTextArea();
    Border border1;
    Border border2;
    JButton cancelButton = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JList referencesList = new JList();

    public static void showDeleteDialog(ElementPopupUtilities.DeleteRunnable deleteRunnable, AuthoringTool authoringTool) {
        DeleteContentPane deleteContentPane = new DeleteContentPane(authoringTool);
        deleteContentPane.setDeleteRunnable(deleteRunnable);
        deleteContentPane.refresh();
        if (DialogManager.showDialog(deleteContentPane) == 0) {
            deleteRunnable.run();
        }
    }

    public DeleteContentPane(AuthoringTool authoringTool) {
        DeleteContentPane.authoringTool = authoringTool;
        this.jbInit();
        URL uRL = JAlice.class.getResource("images/error.gif");
        this.errorIconPanel.setImage(Toolkit.getDefaultToolkit().createImage(uRL));
        this.iconPanel.add((Component)this.errorIconPanel, "Center");
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setOpaque(false);
        this.referencesList.setCellRenderer(new PropertyReferenceListCellRenderer());
        this.referencesList.addListSelectionListener(new ReferencesSelectionListener());
        this.setPreferredSize(new Dimension(600, 300));
    }

    public String getTitle() {
        return "iVProg - Can't Delete";
    }

    public void addOKActionListener(ActionListener actionListener) {
        this.okayButton.addActionListener(actionListener);
    }

    public void removeOKActionListener(ActionListener actionListener) {
        this.okayButton.removeActionListener(actionListener);
    }

    public void addCancelActionListener(ActionListener actionListener) {
        this.cancelButton.addActionListener(actionListener);
    }

    public void removeCancelActionListener(ActionListener actionListener) {
        this.cancelButton.removeActionListener(actionListener);
    }

    public void postDialogShow(JDialog jDialog) {
        this.stopListening();
        super.postDialogShow(jDialog);
    }

    public void setDeleteRunnable(ElementPopupUtilities.DeleteRunnable deleteRunnable) {
        this.deleteRunnable = deleteRunnable;
    }

    public void startListening() {
        ListModel listModel = this.referencesList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object object;
            if (!(listModel.getElementAt(i) instanceof PropertyReference)) continue;
            PropertyReference propertyReference = (PropertyReference)listModel.getElementAt(i);
            Element element = propertyReference.getProperty().getOwner();
            this.listenUpToRootElement(element);
            if (element instanceof PropertyValue) {
                object = element.getParent().getProperties();
                for (Property property : object) {
                    if (property.get() != element) continue;
                    property.addPropertyListener(this);
                }
                continue;
            }
            if (propertyReference instanceof ObjectArrayPropertyReference) {
                object = (ObjectArrayPropertyReference)propertyReference;
                Object[] objectArray = ((ObjectArrayPropertyReference)object).getReference().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (objectArray == null || objectArray.length <= 0) continue;
                propertyReference.getProperty().addPropertyListener(this);
                continue;
            }
            propertyReference.getProperty().addPropertyListener(this);
        }
    }

    public void stopListening() {
        ListModel listModel = this.referencesList.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Object[] objectArray;
            if (!(listModel.getElementAt(i) instanceof PropertyReference)) continue;
            PropertyReference propertyReference = (PropertyReference)listModel.getElementAt(i);
            Element element = propertyReference.getProperty().getOwner();
            this.stopListeningUpToRootElement(element);
            if (element instanceof PropertyValue) {
                if (element.getParent() == null) continue;
                objectArray = element.getParent().getProperties();
                for (Property property : objectArray) {
                    if (property.get() != element) continue;
                    property.removePropertyListener(this);
                }
                continue;
            }
            if (propertyReference instanceof ObjectArrayPropertyReference) {
                objectArray = propertyReference.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (objectArray == null || objectArray.length <= 0) continue;
                propertyReference.getProperty().removePropertyListener(this);
                continue;
            }
            propertyReference.getProperty().removePropertyListener(this);
        }
    }

    public void propertyChanging(PropertyEvent propertyEvent) {
    }

    public void propertyChanged(PropertyEvent propertyEvent) {
        this.refresh();
    }

    public void childrenChanging(ChildrenEvent childrenEvent) {
        this.danglingElementToClear = childrenEvent.getParent();
    }

    public void childrenChanged(ChildrenEvent childrenEvent) {
        this.stopListeningUpToRootElement(this.danglingElementToClear);
        this.refresh();
    }

    protected void listenUpToRootElement(Element element) {
        if (element != null) {
            boolean bl = false;
            ChildrenListener[] childrenListenerArray = element.getChildrenListeners();
            Object[] objectArray = childrenListenerArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ChildrenListener childrenListener = objectArray[i];
                if (childrenListener != this) continue;
                bl = true;
            }
            if (!bl) {
                element.addChildrenListener(this);
            }
            for (Object object : objectArray = element.getProperties()) {
                PropertyListener[] propertyListenerArray = ((Property)object).getPropertyListeners();
                boolean bl2 = false;
                for (PropertyListener propertyListener : propertyListenerArray) {
                    if (propertyListener != this) continue;
                    bl2 = true;
                }
                if (bl2) continue;
                ((Property)object).addPropertyListener(this);
            }
            this.listenUpToRootElement(element.getParent());
        }
    }

    protected void stopListeningUpToRootElement(Element element) {
        if (element != null) {
            boolean bl = false;
            ChildrenListener[] childrenListenerArray = element.getChildrenListeners();
            Object[] objectArray = childrenListenerArray;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                ChildrenListener childrenListener = objectArray[i];
                if (childrenListener != this) continue;
                bl = true;
            }
            if (bl) {
                element.removeChildrenListener(this);
            }
            for (Object object : objectArray = element.getProperties()) {
                PropertyListener[] propertyListenerArray = ((Property)object).getPropertyListeners();
                boolean bl2 = false;
                for (PropertyListener propertyListener : propertyListenerArray) {
                    if (propertyListener != this) continue;
                    bl2 = true;
                }
                if (!bl2) continue;
                ((Property)object).removePropertyListener(this);
            }
            this.stopListeningUpToRootElement(element.getParent());
        }
    }

    public void refresh() {
        if (this.deleteRunnable != null) {
            Element element = this.deleteRunnable.getElement();
            String string = AuthoringToolResources.getReprForValue(element);
            PropertyReference[] propertyReferenceArray = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            if (propertyReferenceArray.length > 0) {
                AuthoringToolResources.garbageCollectIfPossible(propertyReferenceArray);
                propertyReferenceArray = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
            }
            this.stopListening();
            this.referencesList.setListData(propertyReferenceArray);
            this.startListening();
            if (propertyReferenceArray.length > 0) {
                this.okayButton.setEnabled(false);
                this.removeReferenceButton.setEnabled(true);
                this.removeAllReferenceButton.setEnabled(true);
                this.messageArea.setText(string + " cannot be deleted because other parts of the World contain references to it. You will need to remove these references in order to delete " + string + ".\n\n" + "Select each reference below, and either remove the reference manually, or click the Remove Reference button to have the reference removed by the system.");
                this.referencesList.setSelectedIndex(0);
            } else {
                this.okayButton.setEnabled(true);
                this.removeReferenceButton.setEnabled(false);
                this.removeAllReferenceButton.setEnabled(false);
                this.messageArea.setText("All references have now been deleted.  Click Okay to delete " + string + ".");
                this.setDialogTitle("iVProg - Can Delete");
            }
        }
    }

    void removeReferenceButton_actionPerformed(ActionEvent actionEvent) {
        PropertyReference propertyReference = (PropertyReference)this.referencesList.getSelectedValue();
        if (propertyReference != null) {
            Element element = propertyReference.getProperty().getOwner();
            Element element2 = element.getParent();
            if (element instanceof CallToUserDefinedResponse || element instanceof CallToUserDefinedQuestion || element instanceof PropertyValue) {
                if (element2 instanceof CompositeResponse) {
                    element.removeFromParent();
                } else {
                    Property[] propertyArray;
                    for (Property property : propertyArray = element2.getProperties()) {
                        if (property.get() != element) continue;
                        property.removePropertyListener(this);
                        property.set(AuthoringToolResources.getDefaultValueForClass(property.getValueClass()));
                    }
                }
            } else if (propertyReference instanceof ObjectArrayPropertyReference) {
                ObjectArrayPropertyReference objectArrayPropertyReference = (ObjectArrayPropertyReference)propertyReference;
                objectArrayPropertyReference.getObjectArrayProperty().set(objectArrayPropertyReference.getIndex(), (Object)null);
                PropertyReference[] propertyReferenceArray = objectArrayPropertyReference.getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (propertyReferenceArray == null || propertyReferenceArray.length < 1) {
                    propertyReference.getProperty().removePropertyListener(this);
                }
            } else {
                propertyReference.getProperty().removePropertyListener(this);
                propertyReference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(propertyReference.getProperty().getValueClass()));
            }
            this.refresh();
        }
    }

    void removeAllReferenceButton_actionPerformed(ActionEvent actionEvent) {
        this.stopListening();
        for (int i = 0; i < this.referencesList.getModel().getSize(); ++i) {
            Object object;
            PropertyReference propertyReference = (PropertyReference)this.referencesList.getModel().getElementAt(i);
            if (propertyReference == null) continue;
            Element element = propertyReference.getProperty().getOwner();
            Element element2 = element.getParent();
            if (element instanceof CallToUserDefinedResponse || element instanceof CallToUserDefinedQuestion || element instanceof PropertyValue) {
                if (element2 instanceof CompositeResponse) {
                    element.removeFromParent();
                    continue;
                }
                object = element2.getProperties();
                for (Property property : object) {
                    if (property.get() != element) continue;
                    property.removePropertyListener(this);
                    property.set(AuthoringToolResources.getDefaultValueForClass(property.getValueClass()));
                }
                continue;
            }
            if (propertyReference instanceof ObjectArrayPropertyReference) {
                object = (ObjectArrayPropertyReference)propertyReference;
                ((ObjectArrayPropertyReference)object).getObjectArrayProperty().set(((ObjectArrayPropertyReference)object).getIndex(), (Object)null);
                Object[] objectArray = ((PropertyReference)object).getProperty().getOwner().getPropertyReferencesTo(this.deleteRunnable.getElement(), HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
                if (objectArray != null && objectArray.length >= 1) continue;
                propertyReference.getProperty().removePropertyListener(this);
                continue;
            }
            propertyReference.getProperty().removePropertyListener(this);
            propertyReference.getProperty().set(AuthoringToolResources.getDefaultValueForClass(propertyReference.getProperty().getValueClass()));
        }
        this.refresh();
    }

    private void jbInit() {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border2 = BorderFactory.createEmptyBorder(0, 10, 10, 10);
        this.setLayout(this.borderLayout1);
        this.okayButton.setText("OK");
        this.removeReferenceButton.setText("Remove Reference");
        this.removeReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteContentPane.this.removeReferenceButton_actionPerformed(actionEvent);
            }
        });
        this.removeAllReferenceButton.setText("Remove All References");
        this.removeAllReferenceButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteContentPane.this.removeAllReferenceButton_actionPerformed(actionEvent);
            }
        });
        this.mainPanel.setLayout(this.gridBagLayout1);
        this.iconPanel.setLayout(this.borderLayout2);
        this.messagePanel.setLayout(this.borderLayout3);
        this.referencesPanel.setLayout(this.borderLayout4);
        this.messageArea.setText("Message goes here.");
        this.mainPanel.setBorder(this.border1);
        this.buttonPanel.setBorder(this.border2);
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.cancelButton.setText("Cancel");
        this.referencesList.setSelectionMode(0);
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.buttonPanel.add((Component)this.okayButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 8, 8, 4), 0, 0));
        this.buttonPanel.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(8, 0, 8, 0), 0, 0));
        this.buttonPanel.add((Component)this.removeReferenceButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.buttonPanel.add((Component)this.removeAllReferenceButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(8, 0, 8, 8), 0, 0));
        this.mainPanel.add((Component)this.iconPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.mainPanel.add((Component)this.messagePanel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.messagePanel.add((Component)this.messageArea, "Center");
        this.mainPanel.add((Component)this.referencesPanel, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 0, 0, 0), 0, 0));
        this.referencesPanel.add((Component)this.referencesScrollPane, "Center");
        this.referencesScrollPane.getViewport().add((Component)this.referencesList, null);
    }

    class ReferencesSelectionListener
    implements ListSelectionListener {
        ReferencesSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
        }
    }
}

