/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.Editor;
import edu.cmu.cs.stage3.alice.authoringtool.EditorManager;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.AliceTabbedPaneUI;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditorUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.UserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedEditorComponent
extends JPanel {
    protected AuthoringTool authoringTool;
    protected EditorManager editorManager;
    protected EditorDropTargetListener editorDropTargetListener = new EditorDropTargetListener();
    protected HashMap componentsToEditors = new HashMap();
    protected RightClickListener rightClickListener = new RightClickListener();
    protected NameListener nameListener = new NameListener();
    protected DeletionListener deletionListener = new DeletionListener();
    protected Runnable closeAllTabsRunnable = new Runnable(){

        public void run() {
            TabbedEditorComponent.this.closeAllTabs();
        }
    };
    JTabbedPane tabbedPane = new JTabbedPane();
    BorderLayout borderLayout1 = new BorderLayout();

    public TabbedEditorComponent(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.editorManager = authoringTool.getEditorManager();
        this.jbInit();
        this.guiInit();
    }

    private void guiInit() {
        this.tabbedPane.setUI(new AliceTabbedPaneUI());
        this.setDropTarget(new DropTarget(this, this.editorDropTargetListener));
        this.tabbedPane.setDropTarget(new DropTarget(this.tabbedPane, this.editorDropTargetListener));
        this.tabbedPane.addMouseListener(this.rightClickListener);
        int n = 12;
        this.tabbedPane.setFont(new Font("SansSerif", 0, n));
    }

    public void setWorld(World world) {
        this.stopListeningToTree(world);
        this.closeAllTabs();
        if (world != null) {
            this.startListeningToTree(world);
        }
    }

    public void editObject(Object object, Class clazz, boolean bl) {
        if (object == null || clazz == null) {
            this.closeAllTabs();
        } else if (!this.isObjectBeingEdited(object)) {
            Editor editor = this.editorManager.getEditorInstance(clazz);
            if (editor != null) {
                Object object2;
                this.componentsToEditors.put(editor.getJComponent(), editor);
                EditorUtilities.editObject(editor, object);
                String string = AuthoringToolResources.getReprForValue(object, true);
                Object object3 = object;
                if (object instanceof UserDefinedQuestion) {
                    object2 = (UserDefinedQuestion)object;
                    if (List.class.isAssignableFrom(((UserDefinedQuestion)object2).getValueClass())) {
                        List list = (List)((UserDefinedQuestion)object2).getValue();
                        object3 = "types/lists/" + list.valueClass.getClassValue().getName();
                    } else {
                        object3 = "types/" + ((UserDefinedQuestion)object2).getValueClass().getName();
                    }
                }
                object2 = AuthoringToolResources.getIconForValue(object3);
                this.tabbedPane.addTab(string, (Icon)object2, editor.getJComponent());
                if (bl) {
                    this.tabbedPane.setSelectedComponent(editor.getJComponent());
                    this.tabbedPane.getSelectedComponent().setVisible(true);
                }
                if (object instanceof Element) {
                    ((Element)object).name.addPropertyListener(this.nameListener);
                }
                this.authoringTool.saveTabs();
            } else {
                AuthoringTool.getInstance().showErrorDialog("failed to create editor for " + object + ", " + clazz, null);
            }
        } else if (bl) {
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                Editor editor;
                Component component = this.tabbedPane.getComponentAt(i);
                if (component == null || (editor = (Editor)this.componentsToEditors.get(component)) == null || editor.getObject() != object) continue;
                this.tabbedPane.setSelectedIndex(i);
                this.tabbedPane.getSelectedComponent().setVisible(true);
                break;
            }
        }
    }

    public Object getObjectBeingEdited() {
        Editor editor;
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null) {
            return editor.getObject();
        }
        return null;
    }

    public Object getObjectBeingEditedAt(int n) {
        Editor editor;
        Component component = this.tabbedPane.getComponentAt(n);
        if (component != null && (editor = (Editor)this.componentsToEditors.get(component)) != null) {
            return editor.getObject();
        }
        return null;
    }

    public Object[] getObjectsBeingEdited() {
        Component[] componentArray = this.tabbedPane.getComponents();
        if (componentArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Component component : componentArray) {
                Editor editor = (Editor)this.componentsToEditors.get(component);
                if (editor == null) continue;
                arrayList.add(editor.getObject());
            }
            return arrayList.toArray();
        }
        return null;
    }

    public Editor getCurrentEditor() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component != null) {
            return (Editor)this.componentsToEditors.get(component);
        }
        return null;
    }

    public Editor[] getEditors() {
        Component[] componentArray = this.tabbedPane.getComponents();
        if (componentArray != null) {
            ArrayList<Editor> arrayList = new ArrayList<Editor>();
            for (Component component : componentArray) {
                Editor editor = (Editor)this.componentsToEditors.get(component);
                if (editor == null) continue;
                arrayList.add(editor);
            }
            return arrayList.toArray(new Editor[0]);
        }
        return null;
    }

    public void closeTab(int n) {
        Component component = this.tabbedPane.getComponentAt(n);
        if (component != null) {
            Editor editor = (Editor)this.componentsToEditors.get(component);
            if (editor != null) {
                Object object = editor.getObject();
                this.tabbedPane.removeTabAt(n);
                EditorUtilities.editObject(editor, null);
                this.editorManager.releaseEditorInstance(editor);
                this.componentsToEditors.remove(component);
                if (object instanceof Element && !this.isObjectBeingEdited(object)) {
                    ((Element)object).name.removePropertyListener(this.nameListener);
                }
                this.authoringTool.saveTabs();
            }
        } else {
            AuthoringTool.getInstance().showErrorDialog("no editor to close at " + n, null);
        }
    }

    public void closeAllTabs() {
        while (this.tabbedPane.getTabCount() > 0) {
            this.closeTab(0);
        }
    }

    public boolean isObjectBeingEdited(Object object) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            Editor editor;
            Component component = this.tabbedPane.getComponentAt(i);
            if (component == null || (editor = (Editor)this.componentsToEditors.get(component)) == null || editor.getObject() != object) continue;
            return true;
        }
        return false;
    }

    protected void startListeningToTree(Element element) {
        if (element != null) {
            Element[] elementArray;
            for (Element element2 : elementArray = element.getDescendants()) {
                element2.addChildrenListener(this.deletionListener);
            }
        }
    }

    protected void stopListeningToTree(Element element) {
        if (element != null) {
            Element[] elementArray;
            for (Element element2 : elementArray = element.getDescendants()) {
                element2.removeChildrenListener(this.deletionListener);
            }
        }
    }

    private void jbInit() {
        this.setLayout(this.borderLayout1);
        this.setOpaque(false);
        this.add((Component)this.tabbedPane, "Center");
    }

    protected class DeletionListener
    implements ChildrenListener {
        protected DeletionListener() {
        }

        public void childrenChanging(ChildrenEvent childrenEvent) {
        }

        public void childrenChanged(ChildrenEvent childrenEvent) {
            if (childrenEvent.getChangeType() == 3) {
                TabbedEditorComponent.this.stopListeningToTree(childrenEvent.getChild());
                for (int i = 0; i < TabbedEditorComponent.this.tabbedPane.getTabCount(); ++i) {
                    Element element;
                    Object object = TabbedEditorComponent.this.getObjectBeingEditedAt(i);
                    if (!(object instanceof Element) || (element = (Element)object) != childrenEvent.getChild() && !childrenEvent.getChild().isAncestorOf(element)) continue;
                    TabbedEditorComponent.this.closeTab(i);
                    --i;
                }
            } else if (childrenEvent.getChangeType() == 1) {
                TabbedEditorComponent.this.startListeningToTree(childrenEvent.getChild());
            }
        }
    }

    protected class NameListener
    implements PropertyListener {
        protected NameListener() {
        }

        public void propertyChanging(PropertyEvent propertyEvent) {
        }

        public void propertyChanged(PropertyEvent propertyEvent) {
            for (int i = 0; i < TabbedEditorComponent.this.tabbedPane.getTabCount(); ++i) {
                Object object = TabbedEditorComponent.this.getObjectBeingEditedAt(i);
                if (object != propertyEvent.getProperty().getOwner()) continue;
                TabbedEditorComponent.this.tabbedPane.setTitleAt(i, AuthoringToolResources.getReprForValue((Object)propertyEvent.getProperty().getOwner(), true));
            }
        }
    }

    protected class EditorDropTargetListener
    implements DropTargetListener {
        protected EditorDropTargetListener() {
        }

        protected void checkDrag(DropTargetDragEvent dropTargetDragEvent) {
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                dropTargetDragEvent.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                dropTargetDragEvent.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class))) {
                dropTargetDragEvent.acceptDrag(2);
                return;
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDragEvent, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class))) {
                dropTargetDragEvent.acceptDrag(2);
                return;
            }
            DataFlavor[] dataFlavorArray = AuthoringToolResources.safeGetCurrentDataFlavors(dropTargetDragEvent);
            if (dataFlavorArray != null) {
                for (DataFlavor dataFlavor : dataFlavorArray) {
                    Class<?> clazz = dataFlavor.getRepresentationClass();
                    if (EditorUtilities.getBestEditor(clazz) == null) continue;
                    dropTargetDragEvent.acceptDrag(2);
                    return;
                }
            }
            dropTargetDragEvent.rejectDrag();
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            this.checkDrag(dropTargetDragEvent);
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Object object;
                Object object2 = null;
                if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class))) {
                    dropTargetDropEvent.acceptDrop(2);
                    object = dropTargetDropEvent.getTransferable();
                    object2 = object.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedResponse.class));
                    object2 = ((CallToUserDefinedResponse)object2).userDefinedResponse.getUserDefinedResponseValue();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class))) {
                    dropTargetDropEvent.acceptDrop(2);
                    object = dropTargetDropEvent.getTransferable();
                    object2 = object.getTransferData(AuthoringToolResources.getReferenceFlavorForClass(CallToUserDefinedQuestion.class));
                    object2 = ((CallToUserDefinedQuestion)object2).userDefinedQuestion.getUserDefinedQuestionValue();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, ElementReferenceTransferable.elementReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    object = dropTargetDropEvent.getTransferable();
                    object2 = object.getTransferData(ElementReferenceTransferable.elementReferenceFlavor);
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    object = dropTargetDropEvent.getTransferable();
                    CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)object.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor);
                    object2 = callToUserDefinedResponsePrototype.getActualResponse();
                } else if (AuthoringToolResources.safeIsDataFlavorSupported(dropTargetDropEvent, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    object = dropTargetDropEvent.getTransferable();
                    CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)object.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor);
                    object2 = callToUserDefinedQuestionPrototype.getActualQuestion();
                } else {
                    object = AuthoringToolResources.safeGetCurrentDataFlavors(dropTargetDropEvent);
                    if (object != null) {
                        for (Object object3 : object) {
                            Class<?> clazz = ((DataFlavor)object3).getDefaultRepresentationClass();
                            if (EditorUtilities.getBestEditor(clazz) == null) continue;
                            dropTargetDropEvent.acceptDrop(2);
                            Transferable transferable = dropTargetDropEvent.getTransferable();
                            object2 = transferable.getTransferData((DataFlavor)object3);
                            break;
                        }
                    }
                }
                if (object2 != null) {
                    object = EditorUtilities.getBestEditor(object2.getClass());
                    if (object != null) {
                        TabbedEditorComponent.this.editObject(object2, (Class)object, true);
                    }
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                dropTargetDropEvent.dropComplete(false);
            }
            catch (Throwable throwable) {
                AuthoringTool.getInstance().showErrorDialog("Drop didn't work.", throwable);
                dropTargetDropEvent.dropComplete(false);
            }
        }
    }

    protected class RightClickListener
    extends CustomMouseAdapter {
        protected RightClickListener() {
        }

        public void popupResponse(MouseEvent mouseEvent) {
            final int n = TabbedEditorComponent.this.tabbedPane.getUI().tabForCoordinate(TabbedEditorComponent.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY());
            if (n >= 0 && n < TabbedEditorComponent.this.tabbedPane.getTabCount()) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        TabbedEditorComponent.this.closeTab(n);
                    }
                };
                Vector<StringObjectPair> vector = new Vector<StringObjectPair>();
                vector.add(new StringObjectPair("Close " + TabbedEditorComponent.this.tabbedPane.getTitleAt(n), runnable));
                vector.add(new StringObjectPair("Close All", TabbedEditorComponent.this.closeAllTabsRunnable));
                PopupMenuUtilities.createAndShowPopupMenu(vector, TabbedEditorComponent.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

