/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.SplashScreen;
import edu.cmu.cs.stage3.alice.core.AppletWorldStorer;
import edu.cmu.cs.stage3.io.FileRead;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import javax.swing.JApplet;

public class JAlice
extends JApplet {
    public static final String version = "0.2.1";
    private static boolean parserError = false;
    private static String lang = "";
    private static String country = "";
    private File aliceHomeDirectory = null;
    private File aliceUserDirectory = null;
    private SplashScreen splashScreen;
    private AuthoringTool authoringTool;
    private boolean mainHasFinished = false;
    private boolean isApplet = false;
    private static JAlice staticInstance;

    public static boolean getParserError() {
        return parserError;
    }

    public static void setParserError(boolean bl) {
        parserError = bl;
    }

    public static JAlice getInstance() {
        if (staticInstance == null) {
            staticInstance = new JAlice();
        }
        return staticInstance;
    }

    public static AuthoringTool getAuthoringTool() {
        if (staticInstance == null) {
            staticInstance = new JAlice();
            System.err.println("Error: JAlice.java: getAuthoringTool(): instance was empty! " + JAlice.staticInstance.authoringTool);
        }
        return JAlice.staticInstance.authoringTool;
    }

    public boolean isApplet() {
        return this.isApplet;
    }

    public static void main(String[] stringArray) {
        int n;
        System.out.println(".: iVprog: version0.2.1 :.");
        I18n.setConfig(stringArray);
        I18n.defineBundle(true);
        JAlice jAlice = JAlice.getInstance();
        jAlice.isApplet = false;
        jAlice.principal();
        staticInstance = jAlice;
        File file = FileRead.getFileArg(stringArray);
        if (file != null && (n = jAlice.authoringTool.loadWorld(file, true)) == 1) {
            System.out.println("File " + FileRead.fileName() + " successfully loaded.");
        }
    }

    public void start() {
        super.start();
    }

    public void stop() {
        super.stop();
        this.authoringTool.quit();
    }

    public void init() {
        System.out.println(" .: iVprog: version 0.2.1 :.");
        staticInstance = this;
        lang = this.getParameter("lang");
        country = this.getParameter("country");
        I18n.setLanguage(lang, country);
        JAlice.getInstance().isApplet = true;
        this.principal();
        String string = this.getParameter("MA_PARAM_Proposition");
        boolean bl = true;
        if (string != null && string != "") {
            try {
                parserError = false;
                this.authoringTool.loadAppletWorld(string);
                if (!parserError) {
                    bl = false;
                }
                System.out.println(" - started content..." + parserError);
            }
            catch (Exception exception) {
                String string2 = "<>";
                int n = 0;
                if (string != null && string != "") {
                    n = string.length();
                    n = n > 30 ? 30 : n;
                    string2 = string.substring(0, n);
                }
                System.err.println("Error: JAlice.java: init(): " + string2 + ": " + exception.toString());
            }
        }
        if (bl) {
            System.out.println(" - try to clear the content..." + parserError);
            if (this.authoringTool != null) {
                this.authoringTool.newWorld();
            } else {
                System.err.println("JAlice.java: init(): Sorry, it was not possible to initiate a new program/algorithm...");
            }
        }
        try {
            this.setJMenuBar(this.authoringTool.getJAliceFrame().getJMenuBar());
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: init(): 1: " + this.authoringTool + ": " + exception.toString());
        }
        try {
            this.add(this.authoringTool.getJAliceFrame().getContentPane());
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: init(): 2: " + this.authoringTool + ": " + exception.toString());
        }
    }

    public String getAnswer() {
        String string = "";
        try {
            string = AppletWorldStorer.getWorldXml(this.authoringTool.getWorld());
            int n = string != null && string != "" ? string.length() : 0;
            String string2 = n > 30 ? string.substring(0, 30) : string;
            System.out.println("JAlice.java: #getAnswer()=" + n + ": " + string2);
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: getAnswer(): couldn't get the student's answer: " + exception.toString());
        }
        return string;
    }

    public String getEvaluation() {
        return "-1";
    }

    private void principal() {
        try {
            if (!this.isApplet()) {
                this.splashScreen = this.initSplashScreen();
            }
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 1: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            if (!this.isApplet()) {
                this.splashScreen.showSplash();
                try {
                    File file = new File(this.getAliceUserDirectory(), "aliceHasNotExited.txt");
                    if (file.exists()) {
                        file.delete();
                    }
                    file.createNewFile();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter(new FileOutputStream(file));
                    outputStreamWriter.write("iVProg has not exited propertly yet.");
                    outputStreamWriter.flush();
                    outputStreamWriter.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 2: " + exception.toString());
            exception.printStackTrace();
        }
        try {
            this.authoringTool = AuthoringTool.getInstance();
        }
        catch (Exception exception) {
            System.err.println("Error: JAlice.java: principal(): 3: " + exception.toString());
            exception.printStackTrace();
        }
        if (!this.isApplet()) {
            this.splashScreen.hideSplash();
        }
        this.mainHasFinished = true;
    }

    private SplashScreen initSplashScreen() {
        return new SplashScreen();
    }

    public boolean isMainFinished() {
        return this.mainHasFinished;
    }

    public void setAliceHomeDirectory(File file) {
        this.aliceHomeDirectory = file;
    }

    public File getAliceHomeDirectory() {
        if (this.aliceHomeDirectory == null) {
            if (System.getProperty("alice.home") != null) {
                this.setAliceHomeDirectory(new File(System.getProperty("alice.home")).getAbsoluteFile());
            } else {
                this.setAliceHomeDirectory(new File(System.getProperty("user.dir")).getAbsoluteFile());
            }
        }
        return this.aliceHomeDirectory;
    }

    public void setAliceUserDirectory(File file) {
        this.aliceUserDirectory = file;
    }

    public File getAliceUserDirectory() {
        if (this.aliceUserDirectory == null) {
            File file = null;
            if (System.getProperty("alice.userDir") != null) {
                file = new File(System.getProperty("alice.userDir")).getAbsoluteFile();
            }
            File file2 = new File(System.getProperty("user.home")).getAbsoluteFile();
            File file3 = this.getAliceHomeDirectory();
            File file4 = null;
            if (file != null) {
                file4 = file;
            } else if (file2.exists() && file2.canRead() && file2.canWrite()) {
                file4 = new File(file2, ".alice");
            } else if (file3 != null && file3.exists() && file3.canRead() && file3.canWrite()) {
                file4 = new File(file3, ".alice");
            }
            if (file4 != null) {
                if (file4.exists()) {
                    this.setAliceUserDirectory(file4);
                } else if (file4.mkdir()) {
                    this.setAliceUserDirectory(file4);
                }
            }
        }
        return this.aliceUserDirectory;
    }
}

