/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedQuestionPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.CallToUserDefinedResponsePrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.PropertyReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.editors.compositeeditor.MainCompositeElementPanel;
import edu.cmu.cs.stage3.alice.authoringtool.py.AliceStyle;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedQuestionPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.CallToUserDefinedResponsePrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.EditObjectButton;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.CollectionPropertyViewController;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.DictionaryProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.question.PropertyValue;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.question.userdefined.PropertyAssignment;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.PropertyAnimation;
import edu.cmu.cs.stage3.alice.core.response.ResizeAnimation;
import edu.cmu.cs.stage3.alice.core.response.TransformAnimation;
import edu.cmu.cs.stage3.alice.core.response.Wait;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.Enumerable;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.KeyEvent;
import java.awt.image.FilteredImageSource;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class AuthoringToolResources {
    public static final long startTime = System.currentTimeMillis();
    public static final String QUESTION_STRING = "function";
    public static Criterion characterCriterion = new Criterion(){

        public boolean accept(Object object) {
            return object instanceof Sandbox;
        }
    };
    protected static Resources resources;
    protected static File resourcesCacheFile;
    static final ImageIcon modelIcon;
    static final ImageIcon subpartIcon;
    static final ImageIcon sceneIcon;
    static final ImageIcon folderIcon;
    static final ImageIcon defaultIcon;

    public static boolean safeIsDataFlavorSupported(DropTargetDragEvent dropTargetDragEvent, DataFlavor dataFlavor) {
        try {
            boolean bl = dropTargetDragEvent.isDataFlavorSupported(dataFlavor);
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static DataFlavor[] safeGetCurrentDataFlavors(DropTargetDropEvent dropTargetDropEvent) {
        try {
            return dropTargetDropEvent.getCurrentDataFlavors();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static DataFlavor[] safeGetCurrentDataFlavors(DropTargetDragEvent dropTargetDragEvent) {
        try {
            return dropTargetDragEvent.getCurrentDataFlavors();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static boolean safeIsDataFlavorSupported(DropTargetDropEvent dropTargetDropEvent, DataFlavor dataFlavor) {
        try {
            boolean bl = dropTargetDropEvent.isDataFlavorSupported(dataFlavor);
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean safeIsDataFlavorSupported(Transferable transferable, DataFlavor dataFlavor) {
        try {
            boolean bl = transferable.isDataFlavorSupported(dataFlavor);
            return bl;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static void loadResourcesPy() {
        resources = new Resources();
        AuthoringToolResources.initKeyCodesToStrings();
        AliceStyle.init();
    }

    public static void setQuestionStructure(Vector vector) {
        AuthoringToolResources.resources.questionStructure = vector;
    }

    public static Vector getQuestionStructure(Class clazz) {
        if (AuthoringToolResources.resources.questionStructure != null) {
            for (Object e : AuthoringToolResources.resources.questionStructure) {
                if (e instanceof StringObjectPair) {
                    String string = ((StringObjectPair)e).getString();
                    try {
                        Class<?> clazz2 = Class.forName(string);
                        if (!clazz2.isAssignableFrom(clazz)) continue;
                        return (Vector)((StringObjectPair)e).getObject();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        AuthoringTool.getInstance().showErrorDialog("Can't find class " + string, classNotFoundException);
                        continue;
                    }
                }
                AuthoringTool.getInstance().showErrorDialog("Unexpected object found in questionStructure: " + e, null);
            }
        }
        return null;
    }

    public static void setDefaultPropertyValuesStructure(Vector vector) {
        AuthoringToolResources.resources.defaultPropertyValuesStructure = vector;
    }

    public static Vector getDefaultPropertyValues(Class clazz, String string) {
        if (AuthoringToolResources.resources.defaultPropertyValuesStructure != null) {
            for (StringObjectPair stringObjectPair : AuthoringToolResources.resources.defaultPropertyValuesStructure) {
                String string2 = stringObjectPair.getString();
                try {
                    Class<?> clazz2 = Class.forName(string2);
                    if (!clazz2.isAssignableFrom(clazz)) continue;
                    Vector vector = (Vector)stringObjectPair.getObject();
                    for (StringObjectPair stringObjectPair2 : vector) {
                        if (!string.equals(stringObjectPair2.getString())) continue;
                        return (Vector)stringObjectPair2.getObject();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    AuthoringTool.getInstance().showErrorDialog("Can't find class " + string2, classNotFoundException);
                }
            }
        }
        return null;
    }

    public static void putName(Object object, String string) {
        AuthoringToolResources.resources.nameMap.put(object, string);
    }

    public static String getName(Object object) {
        return (String)AuthoringToolResources.resources.nameMap.get(object);
    }

    public static boolean nameMapContainsKey(Object object) {
        return AuthoringToolResources.resources.nameMap.containsKey(object);
    }

    public static void putHTMLName(Object object, String string) {
        AuthoringToolResources.resources.htmlNameMap.put(object, string);
    }

    public static String getHTMLName(Object object) {
        return (String)AuthoringToolResources.resources.htmlNameMap.get(object);
    }

    public static void putFormat(Object object, String string) {
        AuthoringToolResources.resources.formatMap.put(object, string);
    }

    public static String getFormat(Object object) {
        return (String)AuthoringToolResources.resources.formatMap.get(object);
    }

    public static String getPlainFormat(Object object) {
        String string = (String)AuthoringToolResources.resources.formatMap.get(object);
        StringBuffer stringBuffer = new StringBuffer();
        FormatTokenizer formatTokenizer = new FormatTokenizer(string);
        while (formatTokenizer.hasMoreTokens()) {
            String string2 = formatTokenizer.nextToken();
            if (string2.startsWith("<<") && !string2.startsWith("<<<")) continue;
            while (string2.indexOf("&lt;") > -1) {
                string2 = new StringBuffer(string2).replace(string2.indexOf("&lt;"), string2.indexOf("&lt;") + 4, "<").toString();
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static boolean formatMapContainsKey(Object object) {
        return AuthoringToolResources.resources.formatMap.containsKey(object);
    }

    public static boolean shouldGUIOmitPropertyName(Property property) {
        return true;
    }

    public static String getReprForValue(Object object, Property property) {
        return AuthoringToolResources.getReprForValue(object, property, null);
    }

    public static String getReprForValue(Object object, Property property, Object object2) {
        Class<Object> clazz = property.getOwner().getClass();
        String string = property.getName();
        if (property.getOwner() instanceof PropertyAnimation && property.getName().equals("value")) {
            Element element;
            PropertyAnimation propertyAnimation = (PropertyAnimation)property.getOwner();
            Object object3 = propertyAnimation.element.get();
            clazz = object3 instanceof Expression ? ((Expression)object3).getValueClass() : ((element = propertyAnimation.element.getElementValue()) != null ? element.getClass() : null);
            string = propertyAnimation.propertyName.getStringValue();
        } else if (property.getOwner() instanceof PropertyAssignment && property.getName().equals("value")) {
            PropertyAssignment propertyAssignment = (PropertyAssignment)property.getOwner();
            clazz = propertyAssignment.element.getElementValue().getClass();
            string = propertyAssignment.propertyName.getStringValue();
        }
        return AuthoringToolResources.getReprForValue(object, clazz, string, object2);
    }

    public static String getReprForValue(Object object, Class clazz, String string, Object object2) {
        boolean bl = false;
        Class<Object> clazz2 = null;
        try {
            clazz2 = Element.getValueClassForPropertyNamed(clazz, string);
        }
        catch (Exception exception) {
            clazz2 = Object.class;
        }
        if (clazz2 == null) {
            clazz2 = Object.class;
        }
        if (clazz == null || string == null) {
            return AuthoringToolResources.getReprForValue(object);
        }
        if (CallToUserDefinedResponse.class.isAssignableFrom(clazz) && string.equals("userDefinedResponse") || CallToUserDefinedQuestion.class.isAssignableFrom(clazz) && string.equals("userDefinedQuestion")) {
            bl = true;
        }
        if (object instanceof Variable && ((Variable)object).getParent() instanceof Sandbox) {
            bl = true;
        }
        try {
            while (Element.class.isAssignableFrom(clazz)) {
                Comparable<StringBuffer> comparable;
                Object object3;
                Object object4;
                String string2 = null;
                if (object2 instanceof DictionaryProperty && ((Property)(object4 = (DictionaryProperty)object2)).getName().equals("data") && (object3 = ((DictionaryProperty)object4).get("edu.cmu.cs.stage3.alice.authoringtool.userRepr." + string)) != null && object3 instanceof String) {
                    if (Number.class.isAssignableFrom(clazz2) && object instanceof Double) {
                        comparable = AuthoringToolResources.parseDouble((String)object3);
                        if (comparable != null && ((Double)comparable).equals(object)) {
                            string2 = (String)object3;
                        } else {
                            ((DictionaryProperty)object4).remove("edu.cmu.cs.stage3.alice.authoringtool.userRepr." + string);
                        }
                    } else {
                        string2 = (String)object3;
                    }
                }
                if ((object4 = null) != null) {
                    while (((String)object4).indexOf("<value>") > -1) {
                        object3 = string2 != null ? string2 : AuthoringToolResources.getReprForValue(object);
                        comparable = new StringBuffer((String)object4);
                        ((StringBuffer)comparable).replace(((String)object4).indexOf("<value>"), ((String)object4).indexOf("<value>") + "<value>".length(), (String)object3);
                        object4 = ((StringBuffer)comparable).toString();
                    }
                    while (((String)object4).indexOf("<percentValue>") > -1 && object instanceof Double) {
                        double d = (Double)object * 100.0;
                        String string3 = AuthoringToolResources.resources.decimalFormatter.format(d) + "%";
                        StringBuffer stringBuffer = new StringBuffer((String)object4);
                        stringBuffer.replace(((String)object4).indexOf("<percentValue>"), ((String)object4).indexOf("<percentValue>") + "<percentValue>".length(), string3);
                        object4 = stringBuffer.toString();
                    }
                    while (((String)object4).indexOf("<keyCodeValue>") > -1 && object instanceof Integer) {
                        object3 = KeyEvent.getKeyText((Integer)object);
                        comparable = new StringBuffer((String)object4);
                        ((StringBuffer)comparable).replace(((String)object4).indexOf("<keyCodeValue>"), ((String)object4).indexOf("<keyCodeValue>") + "<keyCodeValue>".length(), (String)object3);
                        object4 = ((StringBuffer)comparable).toString();
                    }
                    return object4;
                }
                clazz = clazz.getSuperclass();
            }
        }
        catch (Throwable throwable) {
            AuthoringTool.getInstance().showErrorDialog("Error finding repr for " + object, throwable);
        }
        return AuthoringToolResources.getReprForValue(object, bl);
    }

    public static String getReprForValue(Object object) {
        return AuthoringToolResources.getReprForValue(object, false);
    }

    protected static String stripUnnamedsFromName(Object object) {
        String string = new String(object.toString());
        String string2 = "";
        String string3 = "__Unnamed";
        boolean bl = true;
        while (bl) {
            int n = string.indexOf(string3);
            if (n >= 0) {
                String string4;
                String string5 = string.substring(0, n);
                if (string5 != null) {
                    string2 = string2 + string5;
                }
                if ((string4 = string.substring(n, string.length())) == null) {
                    bl = false;
                    break;
                }
                string = string4;
                n = string.indexOf(".");
                if (n >= 0) {
                    string4 = string.substring(n + 1, string.length());
                    if (string4 != null) {
                        string = string4;
                        continue;
                    }
                    bl = false;
                    break;
                }
                bl = false;
                break;
            }
            string2 = string2 + string;
            bl = false;
            break;
        }
        return string;
    }

    public static String getReprForValue(Object object, boolean bl) {
        String string;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (AuthoringToolResources.nameMapContainsKey(object)) {
            object = AuthoringToolResources.getName(object);
        }
        if (AuthoringToolResources.formatMapContainsKey(object)) {
            object = AuthoringToolResources.getPlainFormat(object);
        }
        if (object instanceof Class && AuthoringToolResources.nameMapContainsKey(object = ((Class)object).getName())) {
            object = AuthoringToolResources.getName(object);
        }
        if (object instanceof Enumerable) {
            object = ((Enumerable)object).getRepr();
        }
        if (object instanceof PropertyValue) {
            object5 = ((PropertyValue)object).propertyName.getStringValue();
            object4 = (Element)((PropertyValue)object).element.get();
            object3 = object4.getClass();
            if (object4 instanceof Expression) {
                object3 = ((Expression)object4).getValueClass();
            }
            try {
                object2 = ((Class)object3).getField((String)object5).getDeclaringClass();
                if (object2 != null && AuthoringToolResources.nameMapContainsKey(string = ((Class)object2).getName() + "." + (String)object5)) {
                    object5 = AuthoringToolResources.getName(string);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                AuthoringTool.getInstance().showErrorDialog("Error representing PropertyValue: can't find " + (String)object5 + " on " + object3, noSuchFieldException);
            }
            object = AuthoringToolResources.getReprForValue(object4, false) + "." + (String)object5;
        }
        if (object instanceof Question && AuthoringToolResources.formatMapContainsKey(object.getClass())) {
            object5 = "";
            object4 = (Question)object;
            object3 = AuthoringToolResources.getFormat(object.getClass());
            object2 = new FormatTokenizer((String)object3);
            while (((FormatTokenizer)object2).hasMoreTokens()) {
                string = ((FormatTokenizer)object2).nextToken();
                if (string.startsWith("<") && string.endsWith(">")) {
                    Property property = ((Element)object4).getPropertyNamed(string.substring(string.lastIndexOf("<") + 1, string.indexOf(">")));
                    if (property == null) continue;
                    object5 = (String)object5 + AuthoringToolResources.getReprForValue(property.get(), property);
                    continue;
                }
                while (string.indexOf("&lt;") > -1) {
                    string = new StringBuffer(string).replace(string.indexOf("&lt;"), string.indexOf("&lt;") + 4, "<").toString();
                }
                object5 = (String)object5 + string;
            }
            if (((String)object5).length() > 0) {
                object = object5;
            }
        }
        if (object instanceof Element) {
            if (bl) {
                object5 = ((Element)object).getSandbox();
                if (object5 != null) {
                    object5 = ((Element)object5).getParent();
                }
                object = ((Element)object).getKey((Element)object5);
                object = AuthoringToolResources.stripUnnamedsFromName(object);
            } else {
                object = ((Element)object).name.getStringValue();
            }
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            object = AuthoringToolResources.resources.decimalFormatter.format(d);
        }
        if (object instanceof Property) {
            String string2 = ((Property)object).getName();
            if (((Property)object).getDeclaredClass() != null) {
                object4 = ((Property)object).getDeclaredClass().getName() + "." + ((Property)object).getName();
                string2 = AuthoringToolResources.nameMapContainsKey(object4) ? AuthoringToolResources.getName(object4) : ((Property)object).getName();
            }
            object = ((Property)object).getOwner() instanceof Variable ? AuthoringToolResources.getReprForValue((Object)((Property)object).getOwner(), bl) : (bl && ((Property)object).getOwner() != null ? AuthoringToolResources.getReprForValue(((Property)object).getOwner()) + "." + string2 : string2);
        }
        if (object == null) {
            object = "<None>";
        }
        return object.toString();
    }

    public static String getFormattedReprForValue(Object object, StringObjectPair[] stringObjectPairArray) {
        String string = (String)AuthoringToolResources.resources.formatMap.get(object);
        StringBuffer stringBuffer = new StringBuffer();
        FormatTokenizer formatTokenizer = new FormatTokenizer(string);
        block0: while (formatTokenizer.hasMoreTokens()) {
            String string2;
            String string3 = formatTokenizer.nextToken();
            if (string3.startsWith("<<<") && string3.endsWith(">>>")) {
                string2 = string3.substring(string3.lastIndexOf("<") + 1, string3.indexOf(">"));
                for (StringObjectPair stringObjectPair : stringObjectPairArray) {
                    if (!stringObjectPair.getString().equals(string2)) continue;
                    stringBuffer.append(AuthoringToolResources.getReprForValue(stringObjectPair.getObject(), true));
                    continue block0;
                }
                continue;
            }
            if (string3.startsWith("<<") && string3.endsWith(">>")) continue;
            if (string3.startsWith("<") && string3.endsWith(">")) {
                string2 = string3.substring(string3.lastIndexOf("<") + 1, string3.indexOf(">"));
                boolean bl = false;
                for (StringObjectPair stringObjectPair : stringObjectPairArray) {
                    if (!stringObjectPair.getString().equals(string2)) continue;
                    stringBuffer.append(AuthoringToolResources.getReprForValue(stringObjectPair.getObject(), true));
                    bl = true;
                    break;
                }
                if (bl) continue;
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public static String getNameInContext(Element element, Element element2) {
        Element element3;
        if (element instanceof Variable && element.getParent() != null && (element3 = element.getParent()) instanceof Response && (element2.isDescendantOf(element3) || element2 == element3)) {
            return element.name.getStringValue();
        }
        return AuthoringToolResources.getReprForValue((Object)element, true);
    }

    public static String[] getDesiredProperties(Class clazz) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = AuthoringToolResources.getFormat(clazz);
        FormatTokenizer formatTokenizer = new FormatTokenizer(string);
        while (formatTokenizer.hasMoreTokens()) {
            String string2 = formatTokenizer.nextToken();
            if (string2.startsWith("<<<") && string2.endsWith(">>>")) continue;
            if (string2.startsWith("<<") && string2.endsWith(">>")) {
                linkedList.add(string2.substring(string2.lastIndexOf("<") + 1, string2.indexOf(">")));
                continue;
            }
            if (!string2.startsWith("<") || !string2.endsWith(">")) continue;
            linkedList.add(string2.substring(string2.lastIndexOf("<") + 1, string2.indexOf(">")));
        }
        return linkedList.toArray(new String[0]);
    }

    public static void putColor(String string, Color color) {
        AuthoringToolResources.resources.colorMap.put(string, color);
    }

    public static Color getColor(String string) {
        Color color = (Color)AuthoringToolResources.resources.colorMap.get(string);
        return color;
    }

    public static Image getAliceSystemIconImage() {
        return AuthoringToolResources.getImageForString("aliceHead");
    }

    public static ImageIcon getAliceSystemIcon() {
        return AuthoringToolResources.getIconForString("aliceHead");
    }

    public static Image getImageForString(String string) {
        if (!AuthoringToolResources.resources.stringImageMap.containsKey(string)) {
            URL uRL = AuthoringToolResources.class.getResource("images/" + string + ".gif");
            if (uRL == null) {
                uRL = AuthoringToolResources.class.getResource("images/" + string + ".png");
            }
            if (uRL == null) {
                uRL = AuthoringToolResources.class.getResource("images/" + string + ".jpg");
            }
            if (uRL != null) {
                Image image = Toolkit.getDefaultToolkit().getImage(uRL);
                AuthoringToolResources.resources.stringImageMap.put(string, image);
            } else {
                return null;
            }
        }
        return (Image)AuthoringToolResources.resources.stringImageMap.get(string);
    }

    public static ImageIcon getIconForString(String string) {
        if (!AuthoringToolResources.resources.stringIconMap.containsKey(string)) {
            URL uRL = AuthoringToolResources.class.getResource("images/" + string + ".gif");
            if (uRL == null) {
                uRL = AuthoringToolResources.class.getResource("images/" + string + ".png");
            }
            if (uRL == null) {
                uRL = AuthoringToolResources.class.getResource("images/" + string + ".jpg");
            }
            if (uRL != null) {
                AuthoringToolResources.resources.stringIconMap.put(string, new ImageIcon(uRL));
            } else {
                return null;
            }
        }
        return (ImageIcon)AuthoringToolResources.resources.stringIconMap.get(string);
    }

    public static ImageIcon getIconForValue(Object object) {
        if (object instanceof Transformable) {
            if (((Transformable)object).getParent() instanceof Transformable) {
                return subpartIcon;
            }
            return modelIcon;
        }
        if (object instanceof World) {
            return sceneIcon;
        }
        if (object instanceof Image) {
            return new ImageIcon((Image)object);
        }
        if (object instanceof String) {
            return AuthoringToolResources.getIconForString((String)object);
        }
        return defaultIcon;
    }

    public static ImageIcon getDisabledIcon(ImageIcon imageIcon) {
        return AuthoringToolResources.getDisabledIcon(imageIcon, 70);
    }

    public static ImageIcon getDisabledIcon(ImageIcon imageIcon, int n) {
        ImageIcon imageIcon2 = (ImageIcon)AuthoringToolResources.resources.disabledIconMap.get(imageIcon);
        if (imageIcon2 == null) {
            GrayFilter grayFilter = new GrayFilter(true, n);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
            Image image = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            imageIcon2 = new ImageIcon(image);
            AuthoringToolResources.resources.disabledIconMap.put(imageIcon, imageIcon2);
        }
        return imageIcon2;
    }

    public static void openURL(String string) throws IOException {
        if (System.getProperty("os.name") != null && System.getProperty("os.name").startsWith("Windows")) {
            String[] stringArray = new String[]{"rundll32", "url.dll,FileProtocolHandler", string};
            if (string.indexOf("&stacktrace") > -1) {
                try {
                    File file = File.createTempFile("tempURLHolder", ".url");
                    file = file.getAbsoluteFile();
                    file.deleteOnExit();
                    PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    printWriter.println("[InternetShortcut]");
                    printWriter.println("URL=" + string);
                    printWriter.flush();
                    printWriter.close();
                    stringArray[2] = file.getAbsolutePath();
                }
                catch (Throwable throwable) {
                    stringArray[2] = string.substring(0, string.indexOf("&stacktrace"));
                }
            }
            Runtime.getRuntime().exec(stringArray);
        } else {
            String[] stringArray = new String[]{"netscape", string};
            Runtime.getRuntime().exec(stringArray);
        }
    }

    public static Double parseDouble(String string) {
        Double d = null;
        if (string.trim().equalsIgnoreCase("infinity")) {
            d = new Double(Double.POSITIVE_INFINITY);
        } else if (string.trim().equalsIgnoreCase("-infinity")) {
            d = new Double(Double.NEGATIVE_INFINITY);
        } else if (string.indexOf(47) > -1) {
            if (string.lastIndexOf(47) == string.indexOf(47)) {
                String string2 = string.substring(0, string.indexOf(47));
                String string3 = string.substring(string.indexOf(47) + 1);
                try {
                    d = new Double(Double.parseDouble(string2) / Double.parseDouble(string3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        } else {
            try {
                d = Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    public static boolean isMethodHookedUp(Response response, World world) {
        return AuthoringToolResources.isMethodHookedUp(response, world, new Vector());
    }

    private static boolean isMethodHookedUp(Response response, World world, Vector vector) {
        PropertyReference[] propertyReferenceArray;
        for (PropertyReference propertyReference : propertyReferenceArray = response.getRoot().getPropertyReferencesTo(response, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, true)) {
            Element element = propertyReference.getProperty().getOwner();
            if (world.behaviors.contains(element)) {
                return true;
            }
            if (!(element instanceof Response) || vector.contains(element)) continue;
            vector.add(element);
            if (!AuthoringToolResources.isMethodHookedUp((Response)element, world, vector)) continue;
            return true;
        }
        return false;
    }

    public static Response createUndoResponse(Response response) {
        Response response2 = null;
        if (response instanceof ResizeAnimation) {
            ResizeAnimation resizeAnimation = (ResizeAnimation)response;
            ResizeAnimation resizeAnimation2 = new ResizeAnimation();
            resizeAnimation2.amount.set(new Double(1.0 / resizeAnimation.amount.doubleValue()));
            resizeAnimation2.asSeenBy.set(resizeAnimation.asSeenBy.get());
            resizeAnimation2.likeRubber.set(resizeAnimation.likeRubber.get());
            resizeAnimation2.subject.set(resizeAnimation.subject.get());
            response2 = resizeAnimation2;
        } else if (response instanceof TransformAnimation) {
            response2 = new PropertyAnimation();
            Transformable transformable = (Transformable)((TransformAnimation)response).subject.getValue();
            response2.element.set(transformable);
            response2.howMuch.set(HowMuch.INSTANCE);
        } else if (response instanceof PropertyAnimation) {
            response2 = new PropertyAnimation();
            Element element = ((PropertyAnimation)response).element.getElementValue();
            response2.element.set(element);
            response2.propertyName.set(((PropertyAnimation)response).propertyName.get());
            response2.value.set(element.getPropertyNamed(((PropertyAnimation)response).propertyName.getStringValue()).getValue());
            response2.howMuch.set(((PropertyAnimation)response).howMuch.get());
        }
        if (response2 != null) {
            response2.duration.set(response.duration.get());
        } else {
            response2 = new Wait();
            response2.duration.set(new Double(0.0));
            AuthoringTool.getInstance().showErrorDialog("Could not create undoResponse for " + response, null);
        }
        return response2;
    }

    public static void addAffectedProperties(List list, Element element, String string, HowMuch howMuch) {
        Property property = element.getPropertyNamed(string);
        if (property != null) {
            list.add(property);
        }
        if (howMuch.getDescend()) {
            for (int i = 0; i < element.getChildCount(); ++i) {
                Element element2 = element.getChildAt(i);
                if (howMuch.getRespectDescendant()) continue;
                AuthoringToolResources.addAffectedProperties(list, element2, string, howMuch);
            }
        }
    }

    public static Property[] getAffectedProperties(Response response) {
        Property[] propertyArray = null;
        if (response instanceof ResizeAnimation) {
            Vector vector = new Vector();
            propertyArray = vector.toArray(new Property[0]);
        } else if (response instanceof PropertyAnimation) {
            Element element = ((PropertyAnimation)response).element.getElementValue();
            String string = ((PropertyAnimation)response).propertyName.getStringValue();
            HowMuch howMuch = (HowMuch)((PropertyAnimation)response).howMuch.getValue();
            LinkedList linkedList = new LinkedList();
            AuthoringToolResources.addAffectedProperties(linkedList, element, string, howMuch);
            propertyArray = linkedList.toArray(new Property[0]);
        }
        if (propertyArray == null) {
            propertyArray = new Property[]{};
        }
        return propertyArray;
    }

    public static String getNameForNewChild(String string, Element element) {
        String string2 = string;
        if (string2 == null || element == null) {
            return string2;
        }
        if (element.getChildNamedIgnoreCase(string2) == null && element.getChildNamedIgnoreCase(string2 + 1) == null) {
            return string2;
        }
        if (string.length() < 1) {
            string = "copy";
        }
        int n = string.length();
        int n2 = 2;
        for (int i = string.length() - 1; i >= 0; --i) {
            try {
                n2 = Integer.parseInt(string.substring(i, n));
                string2 = string.substring(0, i);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
                break;
            }
        }
        string = string2;
        for (int i = n2; i < Integer.MAX_VALUE; ++i) {
            string2 = string + i;
            if (element.getChildNamedIgnoreCase(string2) != null) continue;
            return string2;
        }
        throw new RuntimeException("Unable to find a suitable new name; baseName = " + string + ", parent = " + element);
    }

    public static void addElementToAppropriateProperty(Element element, Element element2) {
        ElementArrayProperty elementArrayProperty = null;
        if (element instanceof Transformable) {
            if (element2 instanceof Transformable) {
                elementArrayProperty = ((Transformable)element2).parts;
            }
        } else if (element instanceof Response) {
            if (element2 instanceof Sandbox) {
                elementArrayProperty = ((Sandbox)element2).responses;
            }
        } else if (element instanceof Behavior) {
            if (element2 instanceof Sandbox) {
                elementArrayProperty = ((Sandbox)element2).behaviors;
            }
        } else if (element instanceof Variable) {
            if (element2 instanceof Sandbox) {
                elementArrayProperty = ((Sandbox)element2).variables;
            }
        } else if (element instanceof Question && element2 instanceof Sandbox) {
            elementArrayProperty = ((Sandbox)element2).questions;
        }
        if (elementArrayProperty != null && !elementArrayProperty.contains(element)) {
            elementArrayProperty.add(element);
        }
    }

    public static double getCurrentTime() {
        long l = System.currentTimeMillis() - startTime;
        return (double)l / 1000.0;
    }

    public static void findAssignables(Class clazz, Set set, boolean bl) {
        if (clazz != null && !set.contains(clazz)) {
            set.add(clazz);
            if (bl) {
                Class<?>[] classArray;
                for (Class<?> clazz2 : classArray = clazz.getInterfaces()) {
                    AuthoringToolResources.findAssignables(clazz2, set, bl);
                }
            }
            AuthoringToolResources.findAssignables(clazz.getSuperclass(), set, bl);
        }
    }

    public static DataFlavor getReferenceFlavorForClass(Class clazz) {
        DataFlavor dataFlavor = null;
        if (!AuthoringToolResources.resources.flavorMap.containsKey(clazz)) {
            String string = "";
            try {
                string = clazz.getName();
                try {
                    dataFlavor = new DataFlavor(clazz, string);
                    AuthoringToolResources.resources.flavorMap.put(clazz, dataFlavor);
                }
                catch (Exception exception) {
                    System.err.println("Error: AuthoringToolResources.java: getReferenceFlavorForClass: " + exception.toString());
                }
                AuthoringToolResources.resources.flavorMap.put(clazz, dataFlavor);
                System.out.println("AuthoringToolResources.java: inserido em flavorMap '" + string + "'");
                return dataFlavor;
            }
            catch (Exception exception) {
                System.err.println("Error: src/edu/cmu/cs/stage3/alice/authoringtool/AuthoringToolResources.java: getReferenceFlavorForClass(Class): " + exception.toString());
                AuthoringTool.getInstance().showErrorDialog("Can't find class " + string, exception);
                AuthoringToolResources.resources.flavorMap.put(clazz, null);
            }
        }
        return (DataFlavor)AuthoringToolResources.resources.flavorMap.get(clazz);
    }

    public static Object getDefaultValueForClass(Class clazz) {
        if (clazz == Boolean.class) {
            return Boolean.TRUE;
        }
        if (clazz == Number.class) {
            return new Double(1.0);
        }
        if (clazz == String.class) {
            return new String("default string");
        }
        if (clazz == Color.class) {
            return Color.white;
        }
        if (Enumerable.class.isAssignableFrom(clazz)) {
            Enumerable[] enumerableArray = Enumerable.getItems(clazz);
            if (enumerableArray.length > 0) {
                return enumerableArray[0];
            }
            return null;
        }
        if (clazz == ReferenceFrame.class) {
            return AuthoringTool.getInstance().getWorld();
        }
        return null;
    }

    public static void garbageCollectIfPossible(PropertyReference[] propertyReferenceArray) {
        for (PropertyReference propertyReference : propertyReferenceArray) {
            Element element = propertyReference.getProperty().getOwner();
            PropertyReference[] propertyReferenceArray2 = element.getRoot().getPropertyReferencesTo(element, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, true);
            if (propertyReferenceArray2.length != 0) continue;
            element.getParent().removeChild(element);
        }
    }

    private static void initKeyCodesToStrings() {
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(48), "0");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(49), "1");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(50), "2");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(51), "3");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(52), "4");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(53), "5");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(54), "6");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(55), "7");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(56), "8");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(57), "9");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(65), "A");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(66), "B");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(67), "C");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(68), "D");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(69), "E");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(70), "F");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(71), "G");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(72), "H");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(73), "I");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(74), "J");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(75), "K");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(76), "L");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(77), "M");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(78), "N");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(79), "O");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(80), "P");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(81), "Q");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(82), "R");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(83), "S");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(84), "T");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(85), "U");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(86), "V");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(87), "W");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(88), "X");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(89), "Y");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(90), "Z");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(10), "enter");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(32), "space");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(38), "upArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(40), "downArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(37), "leftArrow");
        AuthoringToolResources.resources.keyCodesToStrings.put(new Integer(39), "rightArrow");
    }

    public static String getPrefix(String string) {
        if (string.indexOf("<") > -1 && string.indexOf(">") > string.indexOf("<")) {
            return string.substring(0, string.indexOf("<"));
        }
        return string;
    }

    public static String getSpecifier(String string) {
        if (string.indexOf("<") > -1 && string.indexOf(">") > string.indexOf("<")) {
            return string.substring(string.indexOf("<") + 1, string.indexOf(">"));
        }
        return null;
    }

    public static Component findElementDnDPanel(Container container, final Element element) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                if (object instanceof DnDGroupingPanel) {
                    try {
                        Element element2;
                        Transferable transferable = ((DnDGroupingPanel)object).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementReferenceTransferable.elementReferenceFlavor) && element.equals(element2 = (Element)transferable.getTransferData(ElementReferenceTransferable.elementReferenceFlavor))) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringTool.getInstance().showErrorDialog("Error finding ElementDnDPanel.", exception);
                    }
                }
                return false;
            }
        };
        Component component = AuthoringToolResources.findComponent(container, criterion);
        if (component instanceof MainCompositeElementPanel) {
            return ((MainCompositeElementPanel)component).getWorkSpace();
        }
        return component;
    }

    public static Component findPropertyDnDPanel(Container container, final Element element, final String string) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                if (object instanceof DnDGroupingPanel) {
                    try {
                        Property property;
                        Element element2;
                        Transferable transferable = ((DnDGroupingPanel)object).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, PropertyReferenceTransferable.propertyReferenceFlavor) && element.equals(element2 = (property = (Property)transferable.getTransferData(PropertyReferenceTransferable.propertyReferenceFlavor)).getOwner()) && property.getName().equals(string)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringTool.getInstance().showErrorDialog("Error finding PropertyDnDPanel.", exception);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findUserDefinedResponseDnDPanel(Container container, final Response response) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                if (object instanceof DnDGroupingPanel) {
                    try {
                        CallToUserDefinedResponsePrototype callToUserDefinedResponsePrototype;
                        Transferable transferable = ((DnDGroupingPanel)object).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor) && (callToUserDefinedResponsePrototype = (CallToUserDefinedResponsePrototype)transferable.getTransferData(CallToUserDefinedResponsePrototypeReferenceTransferable.callToUserDefinedResponsePrototypeReferenceFlavor)).getActualResponse().equals(response)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringTool.getInstance().showErrorDialog("Error finding UserDefinedResponseDnDPanel.", exception);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findUserDefinedQuestionDnDPanel(Container container, final Question question) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                if (object instanceof DnDGroupingPanel) {
                    try {
                        CallToUserDefinedQuestionPrototype callToUserDefinedQuestionPrototype;
                        Transferable transferable = ((DnDGroupingPanel)object).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor) && (callToUserDefinedQuestionPrototype = (CallToUserDefinedQuestionPrototype)transferable.getTransferData(CallToUserDefinedQuestionPrototypeReferenceTransferable.callToUserDefinedQuestionPrototypeReferenceFlavor)).getActualQuestion().equals(question)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringTool.getInstance().showErrorDialog("Error finding UserDefinedQuestionDnDPanel.", exception);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findPrototypeDnDPanel(Container container, final Class clazz) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                if (object instanceof DnDGroupingPanel) {
                    try {
                        ElementPrototype elementPrototype;
                        Transferable transferable = ((DnDGroupingPanel)object).getTransferable();
                        if (transferable != null && AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor) && (elementPrototype = (ElementPrototype)transferable.getTransferData(ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor)).getElementClass().equals(clazz)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringTool.getInstance().showErrorDialog("Error finding PrototypeDnDPanel.", exception);
                    }
                }
                return false;
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findPropertyViewController(Container container, final Element element, final String string) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                Property property;
                Property property2;
                return object instanceof PropertyViewController ? (property2 = ((PropertyViewController)object).getProperty()).getOwner().equals(element) && property2.getName().equals(string) : object instanceof CollectionPropertyViewController && (property = ((CollectionPropertyViewController)object).getProperty()).getOwner().equals(element) && property.getName().equals(string);
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findEditObjectButton(Container container, final Element element) {
        Criterion criterion = new Criterion(){

            public boolean accept(Object object) {
                return object instanceof EditObjectButton && ((EditObjectButton)object).getObject().equals(element);
            }
        };
        return AuthoringToolResources.findComponent(container, criterion);
    }

    public static Component findComponent(Container container, Criterion criterion) {
        Component[] componentArray;
        if (criterion.accept(container)) {
            return container;
        }
        for (Component component : componentArray = container.getComponents()) {
            Component component2;
            if (!(component instanceof Container) || (component2 = AuthoringToolResources.findComponent((Container)component, criterion)) == null) continue;
            return component2;
        }
        return null;
    }

    static {
        AuthoringToolResources.loadResourcesPy();
        modelIcon = AuthoringToolResources.getIconForString("model");
        subpartIcon = AuthoringToolResources.getIconForString("subpart");
        sceneIcon = AuthoringToolResources.getIconForString("scene");
        folderIcon = AuthoringToolResources.getIconForString("folder");
        defaultIcon = AuthoringToolResources.getIconForString("default");
    }

    public static class Resources
    implements Serializable {
        public Vector questionStructure;
        public HashMap nameMap = new HashMap();
        public HashMap htmlNameMap = new HashMap();
        public HashMap formatMap = new HashMap();
        public Vector defaultPropertyValuesStructure;
        public HashMap colorMap = new HashMap();
        public DecimalFormat decimalFormatter = new DecimalFormat("#0.##");
        public HashMap stringImageMap = new HashMap();
        public HashMap stringIconMap = new HashMap();
        public HashMap disabledIconMap = new HashMap();
        public HashMap flavorMap = new HashMap();
        public HashMap keyCodesToStrings = new HashMap();
    }
}

