/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.ElementPrototypeReferenceTransferable;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyleStream;
import edu.cmu.cs.stage3.alice.authoringtool.util.StyledStreamTextPane;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.resourceBundle.I18n;
import edu.cmu.cs.stage3.util.StringObjectPair;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTextPane;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Position;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class StyledStreamTextPane
extends JTextPane {
    public Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
    public Style stdOutStyle;
    public Style stdErrStyle;
    DefaultStyledDocument document = new DefaultStyledDocument();
    Position endPosition;
    StyleStream defaultStream;
    protected final MouseListener mouseListener = new CustomMouseAdapter(){

        protected void popupResponse(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = this.createPopup();
            jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            PopupMenuUtilities.ensurePopupIsOnScreen(jPopupMenu);
        }

        private JPopupMenu createPopup() {
            Runnable runnable = new Runnable(this){
                private final /* synthetic */ 1 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    1.access$000(this.this$1).setText("");
                }
            };
            Vector<StringObjectPair> vector = new Vector<StringObjectPair>();
            vector.add(new StringObjectPair(I18n.getString("stySTPclearAll"), runnable));
            return PopupMenuUtilities.makePopupMenu(vector);
        }

        static /* synthetic */ StyledStreamTextPane access$000(1 var0) {
            return var0.StyledStreamTextPane.this;
        }
    };

    public StyledStreamTextPane() {
        this.setDocument(this.document);
        this.endPosition = this.document.getEndPosition();
        StyleConstants.setFontFamily(this.defaultStyle, "Monospaced");
        this.stdOutStyle = this.addStyle("stdOut", this.defaultStyle);
        this.stdErrStyle = this.addStyle("stdErr", this.defaultStyle);
        StyleConstants.setForeground(this.stdErrStyle, AuthoringToolResources.getColor("stdErrTextColor"));
        this.defaultStream = this.getNewStyleStream(this.defaultStyle);
        this.setDropTarget(new DropTarget(this, new OutputDropTargetListener()));
        this.addMouseListener(this.mouseListener);
    }

    public StyleStream getNewStyleStream(Style style) {
        return new StyleStream(this, style);
    }

    public boolean getScrollableTracksViewportWidth() {
        Container container = this.getParent();
        if (container != null) {
            int n = this.getUI().getPreferredSize((JComponent)this).width;
            int n2 = container.getSize().width;
            return n < n2;
        }
        return false;
    }

    class OutputDropTargetListener
    implements DropTargetListener {
        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Object object;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            transferable.getTransferDataFlavors();
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor)) {
                try {
                    dropTargetDropEvent.acceptDrop(0x40000000);
                    ElementPrototype elementPrototype = (ElementPrototype)transferable.getTransferData(ElementPrototypeReferenceTransferable.elementPrototypeReferenceFlavor);
                    if (elementPrototype.getDesiredProperties().length > 0) {
                        PopupItemFactory popupItemFactory = new PopupItemFactory(this){
                            private final /* synthetic */ OutputDropTargetListener this$1;
                            {
                                this.this$1 = outputDropTargetListener;
                            }

                            public Object createItem(Object object) {
                                return new Runnable(this, object){
                                    private final /* synthetic */ Object val$object;
                                    private final /* synthetic */ 3 this$2;
                                    {
                                        this.this$2 = var1_1;
                                        this.val$object = object;
                                    }

                                    public void run() {
                                        if (this.val$object instanceof ElementPrototype) {
                                            Element element = ((ElementPrototype)this.val$object).createNewElement();
                                            if (element instanceof Question) {
                                                OutputDropTargetListener.access$200((OutputDropTargetListener)3.access$100(this.this$2)).defaultStream.println(((Question)element).getValue());
                                            } else {
                                                OutputDropTargetListener.access$200((OutputDropTargetListener)3.access$100(this.this$2)).defaultStream.println(element);
                                            }
                                        } else {
                                            OutputDropTargetListener.access$200((OutputDropTargetListener)3.access$100(this.this$2)).defaultStream.println(this.val$object);
                                        }
                                    }
                                };
                            }

                            static /* synthetic */ OutputDropTargetListener access$100(3 var0) {
                                return var0.this$1;
                            }
                        };
                        Vector vector = PopupMenuUtilities.makePrototypeStructure(elementPrototype, popupItemFactory, null);
                        JPopupMenu jPopupMenu = PopupMenuUtilities.makePopupMenu(vector);
                        jPopupMenu.show(StyledStreamTextPane.this, (int)dropTargetDropEvent.getLocation().getX(), (int)dropTargetDropEvent.getLocation().getY());
                        PopupMenuUtilities.ensurePopupIsOnScreen(jPopupMenu);
                    } else {
                        Element element = elementPrototype.createNewElement();
                        if (element instanceof Question) {
                            StyledStreamTextPane.this.defaultStream.println(((Question)element).getValue());
                        } else {
                            StyledStreamTextPane.this.defaultStream.println(element);
                        }
                    }
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                }
            }
            if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.stringFlavor)) {
                try {
                    dropTargetDropEvent.acceptDrop(1);
                    object = transferable.getTransferData(DataFlavor.stringFlavor);
                    StyledStreamTextPane.this.defaultStream.println(object);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                }
            } else if (AuthoringToolResources.safeIsDataFlavorSupported(transferable, DataFlavor.getTextPlainUnicodeFlavor())) {
                try {
                    dropTargetDropEvent.acceptDrop(1);
                    object = DataFlavor.getTextPlainUnicodeFlavor().getReaderForText(transferable);
                    StyledStreamTextPane.this.defaultStream.println(object);
                    BufferedReader bufferedReader = new BufferedReader((Reader)object);
                    Thread thread = new Thread(this, bufferedReader){
                        private final /* synthetic */ BufferedReader val$fileReader;
                        private final /* synthetic */ OutputDropTargetListener this$1;
                        {
                            this.this$1 = outputDropTargetListener;
                            this.val$fileReader = bufferedReader;
                        }

                        public void run() {
                            try {
                                String string;
                                while ((string = this.val$fileReader.readLine()) != null) {
                                    OutputDropTargetListener.access$200((OutputDropTargetListener)this.this$1).defaultStream.println(string);
                                }
                                this.val$fileReader.close();
                            }
                            catch (IOException iOException) {
                                AuthoringTool.getInstance().showErrorDialog("Error reading file.", iOException);
                            }
                        }
                    };
                    thread.start();
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                    return;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: bad flavor", unsupportedFlavorException);
                }
                catch (IOException iOException) {
                    AuthoringTool.getInstance().showErrorDialog("Drop didn't work: IOException", iOException);
                }
            }
            dropTargetDropEvent.rejectDrop();
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        static /* synthetic */ StyledStreamTextPane access$200(OutputDropTargetListener outputDropTargetListener) {
            return outputDropTargetListener.StyledStreamTextPane.this;
        }
    }
}

