/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.core.Element;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NameTextField
extends JTextField {
    private CheckForValidityCallback okButtonCallback;
    private Element m_parent;

    public NameTextField(CheckForValidityCallback checkForValidityCallback) {
        this.okButtonCallback = checkForValidityCallback;
        this.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                NameTextField.this.refresh();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                NameTextField.this.refresh();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                NameTextField.this.refresh();
            }
        });
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NameTextField.this.textFieldAction();
            }
        });
    }

    public void setParent(Element element) {
        this.m_parent = element;
        this.refresh();
    }

    private void textFieldAction() {
        this.okButtonCallback.doAction();
    }

    private boolean isNameValid() {
        String string;
        return this.m_parent != null && Element.isPotentialNameValid(string = this.getText()) && this.m_parent.getChildNamedIgnoreCase(string) == null;
    }

    private void refresh() {
        if (this.isNameValid()) {
            this.okButtonCallback.setValidity(this, true);
            this.setForeground(Color.black);
        } else {
            this.okButtonCallback.setValidity(this, false);
            this.setForeground(Color.red);
        }
    }
}

