/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;

public class GUIEffects {
    public static ImageObserver allBitsObserver = new ImageObserver(){

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 0x20) <= 0;
        }
    };
    public static ImageObserver sizeObserver = new ImageObserver(){

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return (n & 1 & 2) > 0;
        }
    };
    private static Color disabledBackgroundColor = AuthoringToolResources.getColor("guiEffectsDisabledBackground");
    private static Color disabledLineColor = AuthoringToolResources.getColor("guiEffectsDisabledLine");
    private static BufferedImage disabledImage;
    private static Dimension disabledImageSize;
    private static Color shadowColor;
    private static Color edgeColor;
    private static int shadowSteps;
    private static double dr;
    private static double dg;
    private static double db;
    private static double da;

    private static void createDisabledImage(int n, int n2) {
        disabledImageSize.setSize(n, n2);
        disabledImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = (Graphics2D)disabledImage.getGraphics();
        graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.setColor(disabledBackgroundColor);
        graphics2D.fillRect(0, 0, n, n2);
        graphics2D.setColor(disabledLineColor);
        double d = 2.0;
        int n3 = (int)((double)n2 / d);
        int n4 = 10;
        for (int i = 0; i <= n + n3; i += n4) {
            graphics2D.drawLine(i, 0, i - n3, n2);
        }
    }

    public static void paintDisabledEffect(Graphics graphics, Rectangle rectangle) {
        if (rectangle.width > GUIEffects.disabledImageSize.width || rectangle.height > GUIEffects.disabledImageSize.height) {
            GUIEffects.createDisabledImage(rectangle.width, rectangle.height);
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.drawImage(disabledImage, rectangle.x, rectangle.y, allBitsObserver);
    }

    public static BufferedImage getImageScaledAndCropped(Image image, double d, Rectangle rectangle) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(sizeObserver), image.getHeight(sizeObserver), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, allBitsObserver);
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        bufferedImage2 = bufferedImage2.getSubimage(rectangle.x, rectangle.y, Math.min(rectangle.width, bufferedImage2.getWidth() - rectangle.x), Math.min(rectangle.height, bufferedImage2.getHeight() - rectangle.y));
        BufferedImage bufferedImage3 = AuthoringTool.getInstance() != null ? AuthoringTool.getInstance().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(bufferedImage2.getWidth(sizeObserver), bufferedImage2.getHeight(sizeObserver), 3) : new BufferedImage(bufferedImage2.getWidth(sizeObserver), bufferedImage2.getHeight(sizeObserver), 2);
        graphics2D = bufferedImage3.createGraphics();
        graphics2D.drawImage((Image)bufferedImage2, 0, 0, allBitsObserver);
        return bufferedImage3;
    }

    public static BufferedImage getImageScaledToLongestDimension(Image image, int n) {
        int n2;
        int n3 = image.getWidth(sizeObserver);
        double d = n3 > (n2 = image.getHeight(sizeObserver)) ? (double)n / (double)n3 : (double)n / (double)n2;
        BufferedImage bufferedImage = new BufferedImage(n3, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, allBitsObserver);
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d), 2);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        return bufferedImage2;
    }

    public static BufferedImage getImageWithDropShadow(Image image, int n, int n2, int n3, int n4) {
        int n5 = image.getWidth(sizeObserver);
        int n6 = image.getHeight(sizeObserver);
        Rectangle rectangle = new Rectangle(n > 0 ? 0 : -n + shadowSteps, n2 > 0 ? 0 : -n2 + shadowSteps, n5, n6);
        Rectangle rectangle2 = new Rectangle(n > 0 ? n - shadowSteps : 0, n2 > 0 ? n2 - shadowSteps : 0, n5 + shadowSteps * 2, n6 + shadowSteps * 2);
        BufferedImage bufferedImage = AuthoringTool.getInstance() != null ? AuthoringTool.getInstance().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(n5 + Math.abs(n) + shadowSteps, n6 + Math.abs(n2) + shadowSteps, 3) : new BufferedImage(n5 + Math.abs(n) + shadowSteps, n6 + Math.abs(n2) + shadowSteps, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        GUIEffects.paintDropShadow(graphics2D, rectangle2, n3, n4);
        graphics2D.drawImage(image, rectangle.x, rectangle.y, allBitsObserver);
        return bufferedImage;
    }

    public static void paintDropShadow(Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Color color = new Color(edgeColor.getRed(), edgeColor.getGreen(), edgeColor.getBlue(), edgeColor.getAlpha());
        for (int i = 0; i < shadowSteps; ++i) {
            double d = (double)i / (double)shadowSteps;
            color = new Color(edgeColor.getRed() - (int)(d * dr), edgeColor.getGreen() - (int)(d * dg), edgeColor.getBlue() - (int)(d * db), edgeColor.getAlpha() - (int)(d * da));
            graphics.setColor(color);
            graphics.drawRoundRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1, n, n2);
            ++rectangle.x;
            ++rectangle.y;
            rectangle.width -= 2;
            rectangle.height -= 2;
        }
        graphics.setColor(shadowColor);
        graphics.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n, n2);
    }

    public static BufferedImage getImageWithColoredBorder(Image image, Color color) {
        int n = image.getWidth(sizeObserver);
        int n2 = image.getHeight(sizeObserver);
        BufferedImage bufferedImage = AuthoringTool.getInstance() != null ? AuthoringTool.getInstance().getJAliceFrame().getGraphicsConfiguration().createCompatibleImage(n, n2, 3) : new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, allBitsObserver);
        GUIEffects.paintColoredBorder(graphics2D, color, n, n2);
        return bufferedImage;
    }

    public static void paintColoredBorder(Graphics graphics, Color color, int n, int n2) {
        graphics.setColor(color);
        graphics.drawRect(0, 0, n - 1, n2 - 1);
        graphics.drawRect(1, 1, n - 3, n2 - 3);
    }

    public static void paintTrough(Graphics graphics, Rectangle rectangle, int n, int n2) {
        Object object = null;
        Shape shape = graphics.getClip();
        if (graphics instanceof Graphics2D) {
            object = ((Graphics2D)graphics).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            int n3 = rectangle.height / 2;
            Polygon polygon = new Polygon();
            polygon.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon.addPoint(rectangle.x + n3, rectangle.y + n3);
            polygon.addPoint(rectangle.x + rectangle.width - n3, rectangle.y + n3);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y);
            polygon.addPoint(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            Polygon polygon2 = new Polygon();
            polygon2.addPoint(rectangle.x, rectangle.y + rectangle.height);
            polygon2.addPoint(rectangle.x, rectangle.y);
            polygon2.addPoint(rectangle.x + rectangle.width, rectangle.y);
            polygon2.addPoint(rectangle.x + rectangle.width - n3, rectangle.y + n3);
            polygon2.addPoint(rectangle.x + n3, rectangle.y + n3);
            graphics.setClip(shape);
            ((Graphics2D)graphics).addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, object));
        }
    }

    static {
        disabledImageSize = new Dimension(-1, -1);
        shadowColor = AuthoringToolResources.getColor("guiEffectsShadow");
        edgeColor = AuthoringToolResources.getColor("guiEffectsEdge");
        shadowSteps = 4;
        dr = edgeColor.getRed() - shadowColor.getRed();
        dg = edgeColor.getGreen() - shadowColor.getGreen();
        db = edgeColor.getBlue() - shadowColor.getBlue();
        da = edgeColor.getAlpha() - shadowColor.getAlpha();
    }
}

