/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.animacao;

import igraf.basico.util.EsquemaVisual;
import igraf.moduloJanelasAuxiliares.controle.JanelaParametrosController;
import igraf.moduloJanelasAuxiliares.eventos.AtualizaParametroEvent;
import igraf.moduloSuperior.controle.entrada.Analisa;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class IntervaloParametro
extends JPanel
implements ItemListener,
KeyListener {
    public static final Color bgColor = EsquemaVisual.corBackground;
    public static final Color bgParam = EsquemaVisual.corBackPanel;
    public static final Color frColor = Color.black;
    private static final Font labelFont = new Font("Tahoma", 0, 11);
    public JTextField tfIni;
    public JTextField tfFim;
    private double ini = -1.0;
    private double fim = 1.0;
    private boolean checked;
    private JCheckBox cb;
    private JLabel labelItem;
    private JLabel labelPts;
    private char charParameter;
    private int index = 0;
    private boolean enviarValorFim = true;
    private boolean enviarValorIni = true;
    private JanelaParametrosController jpc;

    private static JLabel createLabel(JPanel jPanel, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setBackground(bgColor);
        jLabel.setForeground(Color.black);
        jLabel.setFont(labelFont);
        return jLabel;
    }

    private static JTextField createTextField(IntervaloParametro intervaloParametro, String string) {
        JTextField jTextField = new JTextField(string);
        jTextField.setBackground(bgColor);
        jTextField.setForeground(Color.black);
        jTextField.setFont(labelFont);
        jTextField.addKeyListener(intervaloParametro);
        return jTextField;
    }

    protected IntervaloParametro(char c, boolean bl, int n) {
        this(c, -1.0, 1.0, bl);
        this.index = n;
        this.setBackground(bgColor);
    }

    protected IntervaloParametro(char c, double d, double d2, boolean bl) {
        this.charParameter = c;
        this.ini = d;
        this.fim = d2;
        this.setLayout(new GridLayout(1, 5));
        this.cb = new JCheckBox();
        this.cb.setBackground(bgColor);
        this.cb.addItemListener(this);
        this.add(this.cb);
        this.labelItem = IntervaloParametro.createLabel(this, String.valueOf(this.charParameter));
        this.add(this.labelItem);
        this.tfIni = IntervaloParametro.createTextField(this, String.valueOf(d));
        this.add(this.tfIni);
        this.labelPts = IntervaloParametro.createLabel(this, " .. ");
        this.add(this.labelPts);
        this.tfFim = IntervaloParametro.createTextField(this, String.valueOf(d2));
        this.add(this.tfFim);
        this.enablePanel(bl);
        this.setBackground(bgColor);
        this.setBorder(BorderFactory.createBevelBorder(0, Color.black, Color.lightGray));
    }

    private void enablePanel() {
        this.tfIni.setEnabled(this.checked);
        this.tfFim.setEnabled(this.checked);
        this.checked = !this.checked;
    }

    private void enablePanel(boolean bl) {
        this.cb.setSelected(bl);
        this.enablePanel();
        this.checked = !bl;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enablePanel();
        this.notificaAlteracao();
    }

    public double getFim() {
        return this.fim;
    }

    public void setFim() {
        try {
            String string = this.tfFim.getText();
            string = Analisa.verificaConstante(string);
            this.fim = Double.valueOf(string);
            this.enviarValorFim = true;
        }
        catch (Exception exception) {
            this.enviarValorFim = false;
        }
    }

    public double getIni() {
        return this.ini;
    }

    public void setIni() {
        String string = "";
        try {
            string = this.tfIni.getText();
            string = Analisa.verificaConstante(string);
            this.ini = Double.valueOf(string);
            this.enviarValorIni = true;
        }
        catch (Exception exception) {
            this.enviarValorIni = false;
        }
    }

    public boolean isChecked() {
        return this.checked;
    }

    void insereObservador(JanelaParametrosController janelaParametrosController) {
        this.jpc = janelaParametrosController;
    }

    public int getIndex() {
        return this.index;
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.notificaAlteracao();
    }

    private void notificaAlteracao() {
        this.setIni();
        this.setFim();
        if (this.enviarValorIni && this.enviarValorFim && this.jpc != null) {
            this.jpc.enviaAtualizacaoParametro(new AtualizaParametroEvent(this));
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public boolean getState() {
        return this.cb.isSelected();
    }
}

