/*
 * Decompiled with CFR 0.152.
 */
package igraf.basico.io;

import igraf.IGraf;
import igraf.basico.util.Configuracoes;
import igraf.moduloArquivo.Sistema;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class ResourceReader {
    private static ResourceBundle resourceBundle;
    static Properties Prop;
    private static String data_cfg;
    public static String lingua;
    public static String pais;
    public static int PORTUGUESE;
    public static int ENGLISH;
    public static final String ARQUIVO_CONF = "igraf.cfg";
    private static Vector vecErros;

    public ResourceReader() {
        Locale locale = Locale.getDefault();
        resourceBundle = ResourceBundle.getBundle("igraf.basico.resource/StringsTable", locale);
    }

    public ResourceReader(String string) {
        resourceBundle = ResourceBundle.getBundle(string);
    }

    public static void setLanguage(int n) {
        Locale locale = null;
        if (n == PORTUGUESE) {
            locale = new Locale("pt", "BR");
        }
        if (n == ENGLISH) {
            locale = new Locale("en", "US");
        }
        resourceBundle = ResourceBundle.getBundle("igraf.basico.resource/StringsTable", locale);
    }

    public static String msg(String string) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Erro: falta a mensagem '" + string + "' em 'igraf/resource/StringsTable*.properties'!");
            if (string.equals("Conceitos")) {
                missingResourceException.printStackTrace();
                return string;
            }
            if (!vecErros.contains(string)) {
                vecErros.addElement(string);
                return string;
            }
            return string;
        }
        catch (Exception exception) {
            System.err.println("Error: I could not find a String in 'igraf/basico/resource/StringsTable*.properties': " + string + "': " + exception);
            return string;
        }
    }

    public static String msg(String string, String string2, String string3) {
        String[] stringArray = new String[]{string3};
        return ResourceReader.msgComVar(string, string2, stringArray);
    }

    public static String msgComVar(String string, String string2, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(ResourceReader.msg(string), "$");
        String string3 = "";
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equals(string2)) {
                String string5 = stringArray != null ? stringArray[n++] : "";
                string3 = string3 + string5;
                continue;
            }
            string3 = string3 + string4;
        }
        return string3;
    }

    public static void setConfig() {
        String string = "";
        String string2 = DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis()));
        if (data_cfg == null || data_cfg == "") {
            data_cfg = string2;
        }
        string = "# versao: " + Configuracoes.getVersion() + "\n" + "# created: " + data_cfg + "\n" + "# modified: " + string2 + "\n";
        try {
            string = string + "user.name=" + Prop.getProperty("user.name") + "\n" + "java.version=" + Prop.getProperty("java.version") + "\n" + "java.vendor=" + Prop.getProperty("java.vendor") + "\n" + "os.name=" + Prop.getProperty("os.name") + "\n";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void getConfig() {
        int n;
        int n2;
        void var1_1;
        Object var0 = null;
        if (var0 == null) {
            System.out.println("Erro: arquivo de configura\u00e7\u00f5es 'igraf.cfg' ainda est\u00e1 vazio");
            return;
        }
        try {
            var1_1 = var0[0];
            if (var1_1.trim().equals("# iGraf: http://www.matematica.br")) {
                System.err.println("Arquivo de configura\u00e7\u00f5es inv\u00e1lido: igraf.cfg");
            }
        }
        catch (Exception exception) {
            System.err.println("ResourceReader[168] => Erro: no carregamento do arquivo de configuracoes igraf.cfg: " + exception);
        }
        StringTokenizer stringTokenizer = null;
        String string = null;
        int n3 = n2 = var0 != null ? (var0).length : 0;
        if (Prop == null) {
            Prop = System.getProperties();
        }
        for (n = 1; n < 3; ++n) {
            try {
                var1_1 = var0[n];
                string = var1_1.substring(0, 9);
                if (!string.equals("# created")) continue;
                data_cfg = var1_1.substring(10, var1_1.length());
                Prop.setProperty("created", data_cfg);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Erro: configuracao: " + n + ": " + exception);
            }
        }
        for (n = 0; n < n2; ++n) {
            try {
                stringTokenizer = new StringTokenizer((String)var0[n], "=", false);
                string = stringTokenizer.nextToken().trim();
                if (string.equals("lang")) {
                    lingua = stringTokenizer.nextToken().trim();
                    Prop.setProperty("user.language", lingua);
                    continue;
                }
                if (!string.equals("background")) continue;
                string = stringTokenizer.nextToken().trim();
                Prop.setProperty("background", data_cfg);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Erro: configuracao: " + n + ": " + exception);
            }
        }
    }

    private static boolean decompoeConfig(String string) {
        if (string == null) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2 == null) {
                return false;
            }
            if (string2.equals("lang") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                int n = string2.length();
                if (n > 2) {
                    lingua = string2.substring(0, 2);
                    if (n > 4) {
                        pais = string2.substring(3, n).toUpperCase();
                    }
                    return true;
                }
                lingua = string2.substring(0, 2);
                return true;
            }
            if (string2.equals("bg") && stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2 != null && string2.equals("contrast1")) {
                    // empty if block
                }
            } else {
                return false;
            }
        }
        return false;
    }

    public static String setConfig(IGraf iGraf, String[] stringArray) {
        Object object;
        Object object2 = null;
        int n = -1;
        if (lingua == null || lingua == "") {
            lingua = "pt";
        }
        pais = "BR";
        if (stringArray != null && stringArray.length > 0) {
            for (n = 0; n < stringArray.length; ++n) {
                object = stringArray[n].toLowerCase().trim();
                try {
                    if (ResourceReader.decompoeConfig((String)object) || object2 != null || !Sistema.isFile((String)object)) continue;
                    object2 = object;
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Erro: leitura de parametros para configuracao: " + exception);
                    exception.printStackTrace();
                }
            }
        }
        try {
            object = new Locale(lingua, pais);
            Locale.setDefault((Locale)object);
            System.out.println("\n .: iGraf : " + ResourceReader.msg("igraf") + " :.\n    " + ResourceReader.msg("msgVersao") + ": " + Configuracoes.getVersion());
            int n2 = -1;
            if (object != null) {
                if (((Locale)object).toString().equals("pt_BR")) {
                    n2 = 0;
                } else if (((Locale)object).toString().equals("en_US")) {
                    n2 = 1;
                }
                if (n2 > -1) {
                    iGraf.changeLanguage(n2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }

    public static void defineBundle(boolean bl) {
        String string = "StringsTable";
        String string2 = lingua != null && lingua.length() > 0 && lingua.charAt(0) != '_' ? "_" + lingua : lingua;
        String string3 = pais != null && pais.length() > 0 && pais.charAt(0) != '_' ? "_" + pais : pais;
        String string4 = "StringsTable" + string2.toLowerCase() + string3.toUpperCase();
        System.out.println("\n .: iGraf : " + ResourceReader.msg("igraf") + " :.\n");
        try {
            try {
                resourceBundle = ResourceBundle.getBundle(string4);
                System.out.println("1: msg_nome=" + string4);
            }
            catch (Exception exception) {
                string4 = "StringsTable" + string2.toLowerCase();
                try {
                    resourceBundle = ResourceBundle.getBundle(string4);
                    System.out.println("2: msg_nome=" + string4);
                }
                catch (Exception exception2) {
                    try {
                        resourceBundle = ResourceBundle.getBundle("igraf/resource/StringsTable");
                        System.out.println("3: ResourceBundle");
                    }
                    catch (Exception exception3) {
                        System.err.println(" Tenta: tentaResourceURL: msg_nome=" + string4 + ": " + exception3);
                        exception3.printStackTrace();
                    }
                }
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Erro: RB: " + missingResourceException);
        }
    }

    static {
        Prop = null;
        data_cfg = "";
        lingua = "";
        pais = "";
        PORTUGUESE = 0;
        ENGLISH = 1;
        vecErros = new Vector();
    }
}

