/*
 * Decompiled with CFR 0.152.
 */
package igraf.moduloJanelasAuxiliares.visao.tangente;

import difusor.i18N.LanguageUpdatable;
import igraf.basico.io.ResourceReader;
import igraf.basico.util.Utilitarios;
import igraf.moduloCentral.eventos.DesenhoTangenteEvent;
import igraf.moduloJanelasAuxiliares.controle.JanelaTangenteControler;
import igraf.moduloJanelasAuxiliares.eventos.JanelaTangenteEvent;
import igraf.moduloJanelasAuxiliares.visao.ChoicePanel;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class PainelTangente
extends Panel
implements ActionListener,
TextListener,
ItemListener,
KeyListener,
FocusListener,
LanguageUpdatable {
    private Panel aux;
    private Panel p1;
    private Button plotButton = new Button(ResourceReader.msg("btFxTg"));
    private Button eraseButton = new Button(ResourceReader.msg("btErTg"));
    private Checkbox multiTangenteCheckBox = new Checkbox(ResourceReader.msg("cbVarTg"), false);
    private Checkbox animCheckBox = new Checkbox(ResourceReader.msg("cbAnimTg"), false);
    private Dimension d = new Dimension(192, 60);
    private TextField entradaX;
    private TextField saidaX;
    private Label equationLabel;
    private Label erro;
    private Label fx;
    private Color corLabel = new Color(230, 230, 230);
    private Color corLetra = Color.blue;
    private boolean variasTangentes = false;
    private double valorX;
    private final double DELTA = 0.02;
    private final int ESQUERDA = 37;
    private final int DIREITA = 39;
    private final int BAIXO = 40;
    private final int CIMA = 38;
    private ChoicePanel choice;
    private Vector listaAbscissas = new Vector();
    private Vector listaLocalDeFuncoes = new Vector();
    private String funcaoAtual;
    JanelaTangenteControler jtc;
    boolean animando = false;

    public PainelTangente(JanelaTangenteControler janelaTangenteControler) {
        this.jtc = janelaTangenteControler;
        this.aux = new Panel(new GridLayout(0, 1, 0, 2)){

            public Insets getInsets() {
                return new Insets(0, 0, 10, 0);
            }
        };
        this.linhaUm();
        this.linhaDois();
        this.linhaTres();
        this.linhaQuatro();
        this.linhaCinco();
        this.add(this.aux);
        this.setFuncaoAtual(this.choice.getSelectedItem());
        try {
            this.setValorX();
        }
        catch (RuntimeException runtimeException) {
            System.err.println("igraf/moduloJanelasAuxiliares/visao/tangente/PainelTangente.java: construtor, em 'setValorX()': " + runtimeException.toString());
        }
    }

    private void linhaUm() {
        this.choice = new ChoicePanel(ResourceReader.msg("chSelFun"));
        this.choice.addItemListener(this);
        this.aux.add(this.choice);
        this.choice.getChoice().addFocusListener(this);
    }

    private void linhaDois() {
        this.p1 = new Panel(new GridLayout(0, 1, 0, 2)){

            public Dimension getPreferredSize() {
                return PainelTangente.this.d;
            }

            public void paint(Graphics graphics) {
                graphics.setColor(Color.blue);
                graphics.drawString("x  =", 40, 20);
                graphics.drawString("f ( x ) =", 22, 48);
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            }

            public Insets getInsets() {
                return new Insets(5, 75, 5, 5);
            }
        };
        this.fx = new Label();
        this.fx.setForeground(Color.red);
        this.fx.setBackground(this.corLabel);
        this.entradaX = new TextField();
        this.entradaX.setForeground(Color.red);
        this.entradaX.addActionListener(this);
        this.entradaX.addTextListener(this);
        this.entradaX.addKeyListener(this);
        this.entradaX.addFocusListener(this);
        this.saidaX = new TextField();
        this.saidaX.setEditable(false);
        this.p1.add(this.entradaX);
        this.p1.add(this.fx);
        this.aux.add(this.p1);
    }

    private void linhaTres() {
        Panel panel = new Panel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return PainelTangente.this.d;
            }
        };
        Panel panel2 = new Panel(new GridLayout(2, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(192, 30);
            }

            public void paint(Graphics graphics) {
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            }

            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        };
        this.equationLabel = new Label();
        this.equationLabel.setForeground(Color.red);
        this.equationLabel.setBackground(this.corLabel);
        this.equationLabel.setAlignment(1);
        this.erro = new Label(ResourceReader.msg("lbEqReta"));
        this.erro.setForeground(Color.blue);
        this.erro.setAlignment(1);
        panel2.add(this.erro);
        panel2.add(this.equationLabel);
        panel.add(panel2);
        this.aux.add(panel);
    }

    private void linhaQuatro() {
        Panel panel = new Panel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return PainelTangente.this.d;
            }
        };
        Panel panel2 = new Panel(new GridLayout(2, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(192, 30);
            }

            public void paint(Graphics graphics) {
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            }

            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        };
        this.multiTangenteCheckBox.addItemListener(this);
        this.multiTangenteCheckBox.setForeground(this.corLetra);
        this.animCheckBox.addItemListener(this);
        this.animCheckBox.setForeground(this.corLetra);
        this.animCheckBox.setEnabled(false);
        panel2.add(this.animCheckBox);
        panel2.add(this.multiTangenteCheckBox);
        panel.add(panel2);
        this.aux.add(panel);
    }

    private void linhaCinco() {
        Panel panel = new Panel(new BorderLayout()){

            public Dimension getPreferredSize() {
                return PainelTangente.this.d;
            }
        };
        Panel panel2 = new Panel(new GridLayout(2, 1)){

            public Dimension getPreferredSize() {
                return new Dimension(192, 30);
            }

            public void paint(Graphics graphics) {
                graphics.setColor(Color.black);
                graphics.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
            }

            public Insets getInsets() {
                return new Insets(3, 3, 3, 3);
            }
        };
        this.plotButton.setForeground(Color.black);
        this.plotButton.addActionListener(this);
        this.eraseButton.setForeground(Color.black);
        this.eraseButton.addActionListener(this);
        panel2.add(this.plotButton);
        panel2.add(this.eraseButton);
        panel.add(panel2);
        this.aux.add(panel);
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 315);
    }

    private void registraParFuncaoAbscissa(double d) {
        int n = this.choice.getSelectedIndex();
        if (n > this.listaAbscissas.size()) {
            this.listaAbscissas.setSize(n);
        }
        try {
            this.listaAbscissas.removeElementAt(n);
        }
        catch (Exception exception) {
            System.err.println("igraf/moduloJanelasAuxiliares/visao/tangente/PainelTangente.java: registraParFuncaoAbscissa(" + d + "): " + exception.toString());
        }
        this.listaAbscissas.insertElementAt(String.valueOf(d), n);
    }

    private void registraEstadoTangentes() {
        for (int i = 0; i < this.listaAbscissas.size(); ++i) {
            String string = "";
            string = "vx:" + this.listaAbscissas.elementAt(i) + " ";
            string = string + "fx:" + this.listaLocalDeFuncoes.elementAt(i);
        }
    }

    public void recuperaEstadoTangentes(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = "";
        try {
            n = string.indexOf("vx:");
            n2 = string.indexOf(" ", n);
            string2 = string2 + string.substring(n, n2) + " ";
            this.valorX = Double.valueOf(string.substring(n + 3, n2));
            n = string.indexOf("fx:");
            string2 = string2 + string.substring(n);
            this.funcaoAtual = string.substring(n + 3);
        }
        catch (Exception exception) {
            System.err.println("igraf/moduloJanelasAuxiliares/visao/tangente/PainelTangente.java: recuperaEstadoTangentes(" + string + "): " + exception.toString());
            System.err.println("Tangent panel: recover state: the function expression is out off the standard\n");
            exception.printStackTrace();
        }
        this.desenhaTangente();
    }

    private void desenhaTangente() {
        this.jtc.enviarEvento(new JanelaTangenteEvent((Object)this, this.funcaoAtual, this.valorX));
    }

    private void apagaTangente() {
        if (!this.variasTangentes) {
            this.jtc.enviarEvento(new JanelaTangenteEvent(this));
        }
    }

    void animaTangente(boolean bl) {
        this.animando = bl;
        this.jtc.enviarEvento(new JanelaTangenteEvent((Object)this, this.funcaoAtual, bl));
        this.entradaX.setEnabled(!bl);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.eraseButton) {
            this.apagaTangente();
        } else {
            this.jtc.enviarEvento(new JanelaTangenteEvent((Object)this, true));
            this.desenhaTangente();
            this.entradaX.requestFocus();
        }
    }

    public void textValueChanged(TextEvent textEvent) {
        try {
            this.setValorX();
            this.registraParFuncaoAbscissa(this.valorX);
            this.desenhaTangente();
        }
        catch (Exception exception) {
            System.err.println("igraf/moduloJanelasAuxiliares/visao/tangente/PainelTangente.java: textValueChanged(" + textEvent + "): " + textEvent.toString());
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.animCheckBox) {
            this.animaTangente(this.animCheckBox.getState());
        }
        if (object == this.choice.getChoice()) {
            this.setFuncaoAtual(this.choice.getSelectedItem());
            this.apagaTangente();
        }
        if (object == this.multiTangenteCheckBox) {
            this.variasTangentes = !this.variasTangentes;
            this.apagaTangente();
        }
        this.entradaX.requestFocus();
    }

    private void setValorX() {
        try {
            this.valorX = Double.valueOf(this.entradaX.getText());
            this.habilitarAnimacao(true);
        }
        catch (Exception exception) {
            this.habilitarAnimacao(false);
            throw new IllegalArgumentException(ResourceReader.msg("digValX"));
        }
    }

    private void setFuncaoAtual(String string) {
        this.funcaoAtual = string;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 37 || n == 40) {
            this.entradaX.setText(Utilitarios.precisao(this.valorX -= 0.02));
        }
        if (n == 39 || n == 38) {
            this.entradaX.setText(Utilitarios.precisao(this.valorX += 0.02));
        }
    }

    private void habilitarAnimacao(boolean bl) {
        this.animCheckBox.setEnabled(bl);
    }

    public void close() {
        this.registraEstadoTangentes();
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Choice getChoice() {
        return this.choice.getChoice();
    }

    public void focusGained(FocusEvent focusEvent) {
        this.funcaoAtual = this.choice.getSelectedItem();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void atualizaLabels(DesenhoTangenteEvent desenhoTangenteEvent) {
        this.equationLabel.setText("y = " + desenhoTangenteEvent.getEquacaoReta());
        this.fx.setText(desenhoTangenteEvent.getFx());
        if (this.animando) {
            this.entradaX.setText(desenhoTangenteEvent.getValorX());
        }
    }

    public void updateLabels() {
        this.plotButton.setLabel(ResourceReader.msg("btFxTg"));
        this.eraseButton.setLabel(ResourceReader.msg("btErTg"));
        this.multiTangenteCheckBox.setLabel(ResourceReader.msg("cbVarTg"));
        this.animCheckBox.setLabel(ResourceReader.msg("cbAnimTg"));
        this.choice.setLabel(ResourceReader.msg("chSelFun"));
        this.erro.setText(ResourceReader.msg("lbEqReta"));
    }
}

